/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.phonetic;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.language.bm.Languages;
import org.apache.commons.codec.language.bm.PhoneticEngine;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;

public final class BeiderMorseFilter
extends TokenFilter {
    private final PhoneticEngine engine;
    private final Languages.LanguageSet languages;
    private static final Pattern pattern = Pattern.compile("([^()|-]+)");
    private final Matcher matcher = pattern.matcher("");
    private String encoded;
    private int startOffset;
    private int endOffset;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);

    public BeiderMorseFilter(TokenStream input, PhoneticEngine engine) {
        this(input, engine, null);
    }

    public BeiderMorseFilter(TokenStream input, PhoneticEngine engine, Languages.LanguageSet languages) {
        super(input);
        this.engine = engine;
        this.languages = languages;
    }

    public boolean incrementToken() throws IOException {
        if (this.matcher.find()) {
            this.clearAttributes();
            this.termAtt.setEmpty().append((CharSequence)this.encoded, this.matcher.start(1), this.matcher.end(1));
            this.posIncAtt.setPositionIncrement(0);
            this.offsetAtt.setOffset(this.startOffset, this.endOffset);
            return true;
        }
        if (this.input.incrementToken()) {
            this.encoded = this.languages == null ? this.engine.encode(this.termAtt.toString()) : this.engine.encode(this.termAtt.toString(), this.languages);
            this.startOffset = this.offsetAtt.startOffset();
            this.endOffset = this.offsetAtt.endOffset();
            this.matcher.reset(this.encoded);
            if (this.matcher.find()) {
                this.termAtt.setEmpty().append((CharSequence)this.encoded, this.matcher.start(1), this.matcher.end(1));
            }
            return true;
        }
        return false;
    }

    public void reset() throws IOException {
        super.reset();
        this.matcher.reset("");
    }
}

