/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.HasFocus;
import com.google.gwt.user.client.ui.HasHTML;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import java.util.Vector;

public class TreeItem
extends UIObject
implements HasHTML {
    private Vector children = new Vector();
    private ContentPanel contentPanel;
    private Element itemTable;
    private Element contentElem;
    private Element imgElem;
    private Element childSpanElem;
    private boolean open;
    private TreeItem parent;
    private boolean selected;
    private Object userObject;
    private Tree tree;

    public TreeItem() {
        this.setElement(DOM.createDiv());
        this.itemTable = DOM.createTable();
        this.contentElem = DOM.createSpan();
        this.childSpanElem = DOM.createSpan();
        this.imgElem = DOM.createImg();
        Element tbody = DOM.createTBody();
        Element tr = DOM.createTR();
        Element tdImg = DOM.createTD();
        Element tdContent = DOM.createTD();
        DOM.appendChild(this.itemTable, tbody);
        DOM.appendChild(tbody, tr);
        DOM.appendChild(tr, tdImg);
        DOM.appendChild(tr, tdContent);
        DOM.setStyleAttribute(tdImg, "verticalAlign", "middle");
        DOM.setStyleAttribute(tdContent, "verticalAlign", "middle");
        DOM.appendChild(this.getElement(), this.itemTable);
        DOM.appendChild(this.getElement(), this.childSpanElem);
        DOM.appendChild(tdImg, this.imgElem);
        DOM.appendChild(tdContent, this.contentElem);
        DOM.setAttribute(this.getElement(), "position", "relative");
        DOM.setStyleAttribute(this.contentElem, "display", "inline");
        DOM.setStyleAttribute(this.getElement(), "whiteSpace", "nowrap");
        DOM.setAttribute(this.itemTable, "whiteSpace", "nowrap");
        DOM.setStyleAttribute(this.childSpanElem, "whiteSpace", "nowrap");
        TreeItem.setStyleName(this.contentElem, "gwt-TreeItem", true);
    }

    public TreeItem(String html) {
        this();
        this.setHTML(html);
    }

    public TreeItem(Widget widget) {
        this();
        this.setWidget(widget);
    }

    public TreeItem addItem(String itemText) {
        TreeItem ret = new TreeItem(itemText);
        this.addItem(ret);
        return ret;
    }

    public void addItem(TreeItem item) {
        if (item.getParentItem() != null || item.getTree() != null) {
            item.remove();
        }
        item.setTree(this.tree);
        item.setParentItem(this);
        this.children.add(item);
        DOM.setStyleAttribute(item.getElement(), "marginLeft", "16px");
        DOM.appendChild(this.childSpanElem, item.getElement());
        if (this.children.size() == 1) {
            this.updateState();
        }
    }

    public TreeItem addItem(Widget widget) {
        TreeItem ret = new TreeItem(widget);
        this.addItem(ret);
        return ret;
    }

    public TreeItem getChild(int index) {
        if (index < 0 || index >= this.children.size()) {
            return null;
        }
        return (TreeItem)this.children.get(index);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getChildIndex(TreeItem child) {
        return this.children.indexOf(child);
    }

    public String getHTML() {
        return DOM.getInnerHTML(this.contentElem);
    }

    public TreeItem getParentItem() {
        return this.parent;
    }

    public boolean getState() {
        return this.open;
    }

    public String getText() {
        return DOM.getInnerText(this.contentElem);
    }

    public Tree getTree() {
        return this.tree;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public Widget getWidget() {
        if (this.contentPanel == null) {
            return null;
        }
        return this.contentPanel.getWidget();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void remove() {
        if (this.parent != null) {
            this.parent.removeItem(this);
        } else if (this.tree != null) {
            this.tree.removeItem(this);
        }
    }

    public void removeItem(TreeItem item) {
        if (!this.children.contains(item)) {
            return;
        }
        item.setTree(null);
        item.setParentItem(null);
        this.children.remove(item);
        DOM.removeChild(this.childSpanElem, item.getElement());
        if (this.children.size() == 0) {
            this.updateState();
        }
    }

    public void removeItems() {
        while (this.getChildCount() > 0) {
            this.removeItem(this.getChild(0));
        }
    }

    public void setHTML(String html) {
        this.clearContentPanel();
        DOM.setInnerHTML(this.contentElem, html);
    }

    public void setSelected(boolean selected) {
        if (this.selected == selected) {
            return;
        }
        this.selected = selected;
        TreeItem.setStyleName(this.contentElem, "gwt-TreeItem-selected", selected);
    }

    public void setState(boolean open) {
        this.setState(open, true);
    }

    public void setState(boolean open, boolean fireEvents) {
        if (open && this.children.size() == 0) {
            return;
        }
        this.open = open;
        this.updateState();
        if (fireEvents) {
            this.tree.fireStateChanged(this);
        }
    }

    public void setText(String text) {
        this.clearContentPanel();
        DOM.setInnerText(this.contentElem, text);
    }

    public void setUserObject(Object userObj) {
        this.userObject = userObj;
    }

    public void setWidget(Widget widget) {
        this.ensureContentPanel();
        this.contentPanel.setWidget(widget);
    }

    protected HasFocus getFocusableWidget() {
        Widget widget = this.getWidget();
        if (widget instanceof HasFocus) {
            return (HasFocus)((Object)widget);
        }
        return null;
    }

    void addTreeItems(List accum) {
        for (int i = 0; i < this.children.size(); ++i) {
            TreeItem item = (TreeItem)this.children.get(i);
            accum.add(item);
            item.addTreeItems(accum);
        }
    }

    Vector getChildren() {
        return this.children;
    }

    Element getContentElem() {
        return this.contentElem;
    }

    int getContentHeight() {
        return DOM.getIntAttribute(this.itemTable, "offsetHeight");
    }

    Element getImageElement() {
        return this.imgElem;
    }

    int getTreeTop() {
        int ret = 0;
        for (TreeItem item = this; item != null; item = item.getParentItem()) {
            ret += DOM.getIntAttribute(item.getElement(), "offsetTop");
        }
        return ret;
    }

    String imgSrc(String img) {
        if (this.tree == null) {
            return img;
        }
        String src = this.tree.getImageBase() + img;
        return src;
    }

    void setParentItem(TreeItem parent) {
        this.parent = parent;
    }

    void setTree(Tree tree) {
        if (this.tree == tree) {
            return;
        }
        if (this.tree != null) {
            if (this.tree.getSelectedItem() == this) {
                this.tree.setSelectedItem(null);
            }
            if (this.contentPanel != null) {
                this.tree.disown(this.contentPanel);
            }
        }
        this.tree = tree;
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            ((TreeItem)this.children.get(i)).setTree(tree);
        }
        this.updateState();
        if (tree != null && this.contentPanel != null) {
            tree.adopt(this.contentPanel);
        }
    }

    void updateState() {
        if (this.children.size() == 0) {
            UIObject.setVisible(this.childSpanElem, false);
            DOM.setAttribute(this.imgElem, "src", this.imgSrc("tree_white.gif"));
            return;
        }
        if (this.open) {
            UIObject.setVisible(this.childSpanElem, true);
            DOM.setAttribute(this.imgElem, "src", this.imgSrc("tree_open.gif"));
        } else {
            UIObject.setVisible(this.childSpanElem, false);
            DOM.setAttribute(this.imgElem, "src", this.imgSrc("tree_closed.gif"));
        }
    }

    void updateStateRecursive() {
        this.updateState();
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            ((TreeItem)this.children.get(i)).updateStateRecursive();
        }
    }

    private void clearContentPanel() {
        if (this.contentPanel != null) {
            Widget child = this.contentPanel.getWidget();
            if (this.contentPanel.getWidget() != null) {
                this.contentPanel.remove(child);
            }
            if (this.tree != null) {
                this.tree.disown(this.contentPanel);
                this.contentPanel = null;
            }
        }
    }

    private void ensureContentPanel() {
        if (this.contentPanel == null) {
            DOM.setInnerHTML(this.contentElem, "");
            this.contentPanel = new ContentPanel(this.contentElem);
            if (this.getTree() != null) {
                this.tree.adopt(this.contentPanel);
            }
        }
    }

    class ContentPanel
    extends SimplePanel {
        private ContentPanel(Element e) {
            super(e);
        }

        TreeItem getTreeItem() {
            return TreeItem.this;
        }

        void setParent(Widget widget) {
            throw new UnsupportedOperationException("Cannot directly setParent on a WidgetTreeItem's ContentPanel");
        }

        void treeSetParent(Widget widget) {
            super.setParent(widget);
        }
    }
}

