/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.drivers;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.KeyGenerator;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.util.Messages;

public final class IdentityKeyGenerator
implements KeyGenerator {
    private final int _sqlType;
    private final String _fName;

    public IdentityKeyGenerator(PersistenceFactory factory, int sqlType) throws MappingException {
        String fName = factory.getFactoryName();
        if (!(fName.equals("sybase") || fName.equals("sql-server") || fName.equals("hsql") || fName.equals("mysql") || fName.equals("informix") || fName.equals("db2"))) {
            throw new MappingException(Messages.format("mapping.keyGenNotCompatible", this.getClass().getName(), fName));
        }
        this._fName = fName;
        this._sqlType = sqlType;
        if (sqlType != 4 && sqlType != 2 && sqlType != 3 && sqlType != -5) {
            throw new MappingException(Messages.format("mapping.keyGenSQLType", this.getClass().getName(), new Integer(sqlType)));
        }
        if (sqlType != 4 && this._fName.equals("hsql")) {
            throw new MappingException(Messages.format("mapping.keyGenSQLType", this.getClass().getName(), new Integer(sqlType)));
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object generateKey(Connection conn, String tableName, String primKeyName, Properties props) throws PersistenceException {
        block21: {
            block20: {
                block19: {
                    stmt = null;
                    try {
                        try {
                            if (this._fName.equals("hsql")) {
                                cstmt = conn.prepareCall("{call IDENTITY()}");
                                stmt = cstmt;
                                cstmt.execute();
                                rs = cstmt.getResultSet();
                            } else if (this._fName.equals("mysql")) {
                                stmt = conn.prepareStatement("SELECT LAST_INSERT_ID()");
                                rs = stmt.executeQuery();
                            } else if (this._fName.equals("informix")) {
                                stmt = conn.prepareStatement("select dbinfo('sqlca.sqlerrd1') from systables where tabid = 1");
                                rs = stmt.executeQuery();
                            } else if (this._fName.equals("db2")) {
                                stmt = conn.prepareStatement("SELECT IDENTITY_VAL_LOCAL() FROM " + tableName + " FETCH FIRST ROW ONLY");
                                rs = stmt.executeQuery();
                            } else {
                                stmt = conn.prepareStatement("SELECT @@identity");
                                rs = stmt.executeQuery();
                            }
                            if (rs.next() == false) throw new PersistenceException(Messages.message("persist.keyGenFailed"));
                            value = rs.getInt(1);
                            if (this._sqlType == 4) {
                                var8_10 = new Integer(value);
                                var12_11 = null;
                                if (stmt == null) return var8_10;
                                break block19;
                            }
                            if (this._sqlType == -5) {
                                var9_19 = new Long(value);
                                break block20;
                            }
                            var10_20 = new BigDecimal((double)value);
                            break block21;
                        }
                        catch (SQLException ex) {
                            throw new PersistenceException(Messages.format("persist.keyGenSQL", ex.toString()));
                        }
                    }
                    catch (Throwable var11_21) {
                        var12_14 = null;
                        if (stmt == null) throw var11_21;
                        try {
                            stmt.close();
                            throw var11_21;
                        }
                        catch (SQLException ex) {
                            throw var11_21;
                        }
                    }
                }
                ** try [egrp 2[TRYBLOCK] [2 : 330->340)] { 
lbl53:
                // 1 sources

                stmt.close();
                return var8_10;
lbl55:
                // 1 sources

                catch (SQLException ex) {
                    // empty catch block
                }
                return var8_10;
            }
            var12_12 = null;
            if (stmt == null) return var9_19;
            ** try [egrp 2[TRYBLOCK] [2 : 330->340)] { 
lbl62:
            // 1 sources

            stmt.close();
            return var9_19;
lbl64:
            // 1 sources

            catch (SQLException ex) {
                // empty catch block
            }
            return var9_19;
        }
        var12_13 = null;
        if (stmt == null) return var10_20;
        ** try [egrp 2[TRYBLOCK] [2 : 330->340)] { 
lbl71:
        // 1 sources

        stmt.close();
        return var10_20;
lbl73:
        // 1 sources

        catch (SQLException ex) {
            // empty catch block
        }
        return var10_20;
    }

    public final byte getStyle() {
        return 1;
    }

    public final String patchSQL(String insert, String primKeyName) throws MappingException {
        return insert;
    }

    public boolean isInSameConnection() {
        return true;
    }
}

