/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.client.conf;

import com.ibm.lsid.LSID;
import com.ibm.lsid.LSIDException;
import com.ibm.lsid.MalformedLSIDException;
import com.ibm.lsid.client.LSIDAuthority;
import com.ibm.lsid.client.cache.LSIDCache;
import com.ibm.lsid.client.cache.LSIDCacheException;
import com.ibm.lsid.client.conf.castor.AcceptedFormats;
import com.ibm.lsid.client.conf.castor.Caching;
import com.ibm.lsid.client.conf.castor.ForeignAuthorities;
import com.ibm.lsid.client.conf.castor.ForeignAuthoritiesItem;
import com.ibm.lsid.client.conf.castor.HostMapping;
import com.ibm.lsid.client.conf.castor.HostMappings;
import com.ibm.lsid.client.conf.castor.ImportMap;
import com.ibm.lsid.client.conf.castor.ImportMapChoice;
import com.ibm.lsid.client.conf.castor.Lsid;
import com.ibm.lsid.client.conf.castor.LsidClient;
import com.ibm.lsid.client.conf.castor.MetadataStore;
import com.ibm.lsid.client.conf.castor.MetadataStores;
import com.ibm.lsid.client.conf.castor.Param;
import com.ibm.lsid.client.conf.castor.Pattern;
import com.ibm.lsid.client.conf.castor.PortFactory;
import com.ibm.lsid.client.conf.castor.PortMap;
import com.ibm.lsid.client.conf.castor.Property;
import com.ibm.lsid.client.conf.castor.WsdlExtensions;
import com.ibm.lsid.client.metadata.LSIDMetadataException;
import com.ibm.lsid.client.metadata.LSIDMetadataFactory;
import com.ibm.lsid.client.metadata.rdf.xslt.XSLTMetadataFactory;
import com.ibm.lsid.wsdl.LSIDPortFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import javax.wsdl.PortType;
import org.exolab.castor.xml.CastorException;
import org.exolab.castor.xml.Unmarshaller;

public class LSIDResolverConfig {
    public static final String LSID_CLIENT_HOME = "LSID_CLIENT_HOME";
    private static final String CONFIG_FILE_NAME = "lsid-client.xml";
    private static final String SCHEMA_FILE_NAME = "lsid-client.xsd";
    private static final String CREDENTIAL_FILE_NAME = "lsid-client.credentials";
    private static final String LSID_CLIENT_HOME_DEFAULT_WIN32 = "/lsid-client";
    private static final String LSID_CLIENT_HOME_DEFAULT_UNIX = ".lsid-client";
    private static final boolean USE_CACHE_DEFAULT = false;
    private static final String LSID_CACHE_DIR_DEFAULT = "/cache";
    private static final Hashtable DEFAULT_METADATA_FACTORIES = new Hashtable();
    private static final String[] DEFAULT_METADATA_FORMATS;
    private File lsidHome = null;
    private boolean useCache = false;
    private String lsidCacheDir = null;
    private LSIDCache cache = null;
    private String[] acceptedFormats = null;
    private Hashtable hostMappings = new Hashtable();
    private Hashtable metadataFactories = new Hashtable();
    private Hashtable foreignAuthorities = new Hashtable();
    private Hashtable portFactories = new Hashtable();
    private Hashtable importMaps = new Hashtable();
    static /* synthetic */ Class class$com$ibm$lsid$client$conf$castor$LsidClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LSIDResolverConfig() {
        String lsidHomeStr = System.getProperty(LSID_CLIENT_HOME);
        if (lsidHomeStr == null) {
            char sep = File.separatorChar;
            lsidHomeStr = sep == '/' ? LSID_CLIENT_HOME_DEFAULT_UNIX : LSID_CLIENT_HOME_DEFAULT_WIN32;
            System.err.println("No LSID_CLIENT_HOME specified, using default: " + lsidHomeStr);
        }
        this.lsidHome = new File(lsidHomeStr);
        File config = new File(this.lsidHome, CONFIG_FILE_NAME);
        if (config.exists()) {
            FileReader reader = null;
            reader = new FileReader(config);
            LsidClient conf = (LsidClient)Unmarshaller.unmarshal((Class)(class$com$ibm$lsid$client$conf$castor$LsidClient == null ? (class$com$ibm$lsid$client$conf$castor$LsidClient = LSIDResolverConfig.class$("com.ibm.lsid.client.conf.castor.LsidClient")) : class$com$ibm$lsid$client$conf$castor$LsidClient), (Reader)reader);
            this.loadConfig(conf);
            Object var7_7 = null;
            if (reader == null) return;
            try {
                ((Reader)reader).close();
                return;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            return;
            {
                catch (CastorException e) {
                    System.err.println("Castor Error loading config file, using default settings, exception trace follows");
                    e.printStackTrace();
                    this.loadConfig(null);
                    Object var7_8 = null;
                    if (reader == null) return;
                    try {
                        ((Reader)reader).close();
                        return;
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    return;
                }
                catch (IOException e) {
                    System.err.println("IO Error loading config file, using default settings, exception trace follows");
                    e.printStackTrace();
                    this.loadConfig(null);
                    Object var7_9 = null;
                    if (reader == null) return;
                    try {
                        ((Reader)reader).close();
                        return;
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                if (reader == null) throw throwable;
                try {
                    ((Reader)reader).close();
                    throw throwable;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
        }
        System.err.println("Config file: " + config + " does not exist, using default settings");
        this.loadConfig(null);
    }

    public LSIDCache getCache() {
        return this.cache;
    }

    public Hashtable getHostMappings() {
        return this.hostMappings;
    }

    public LSIDAuthority[] getForeignAuthorities(LSID lsid) {
        String[] lookup = new String[]{lsid.toString(), lsid.getAuthority().toString() + ":" + lsid.getNamespace(), lsid.getAuthority().toString() + ":*", "*:" + lsid.getNamespace(), "*:*"};
        LSIDAuthority[] auths = null;
        int i = 0;
        while (i < lookup.length) {
            auths = (LSIDAuthority[])this.foreignAuthorities.get(lookup[i]);
            if (auths != null) {
                return auths;
            }
            ++i;
        }
        return null;
    }

    public File getLsidHome() {
        return this.lsidHome;
    }

    public String[] getAcceptedFormats() {
        if (this.acceptedFormats == null) {
            return DEFAULT_METADATA_FORMATS;
        }
        return this.acceptedFormats;
    }

    public LSIDMetadataFactory getMetadataFactory(String format) {
        LSIDMetadataFactory factory = (LSIDMetadataFactory)this.metadataFactories.get(format);
        if (factory == null) {
            factory = (LSIDMetadataFactory)DEFAULT_METADATA_FACTORIES.get(format);
        }
        return factory;
    }

    public LSIDPortFactory getLSIDPortFactory(PortType portType) throws LSIDException {
        String key = portType.getQName().getNamespaceURI() + ":" + portType.getQName().getLocalPart();
        Object fact = this.portFactories.get(key);
        if (fact == null) {
            return null;
        }
        if (fact instanceof LSIDPortFactory) {
            return (LSIDPortFactory)fact;
        }
        try {
            PortFactory pf = (PortFactory)fact;
            LSIDPortFactory newFact = (LSIDPortFactory)Class.forName(pf.getClassname()).newInstance();
            HashMap<String, String> params = new HashMap<String, String>();
            int i = 0;
            while (i < pf.getParamCount()) {
                Param param = pf.getParam(i);
                params.put(param.getName(), param.getValue());
                ++i;
            }
            newFact.init(params);
            this.portFactories.put(key, newFact);
            return newFact;
        }
        catch (ClassNotFoundException e) {
            throw new LSIDException(e, "Error loading lsid port factory for port: " + portType);
        }
        catch (InstantiationException e) {
            throw new LSIDException(e, "Error loading lsid port factory for port: " + portType);
        }
        catch (IllegalAccessException e) {
            throw new LSIDException(e, "Error loading lsid port factory for port: " + portType);
        }
    }

    public ImportMapChoice getImportMap(String url) {
        return (ImportMapChoice)this.importMaps.get(url);
    }

    public boolean useCache() {
        return this.useCache;
    }

    public void setUseCache(boolean useCache) {
        if (this.useCache == useCache) {
            return;
        }
        if (!useCache) {
            this.useCache = false;
        } else {
            if (this.cache == null) {
                File cacheDir = null;
                String cacheDirStr = this.lsidCacheDir;
                cacheDir = cacheDirStr != null ? new File(cacheDirStr) : new File(this.lsidHome, LSID_CACHE_DIR_DEFAULT);
                try {
                    System.setProperty("LSID_CACHE_DIR", cacheDir.getCanonicalPath());
                }
                catch (IOException e) {
                    System.err.println("Error setting cache dir path: " + cacheDir + ", stack trace follows, will use default");
                    e.printStackTrace();
                }
                try {
                    this.cache = LSIDCache.load();
                }
                catch (LSIDCacheException e) {
                    System.err.println("Error loading LSID Cache, will continue without caching, stack trace follows");
                    e.printStackTrace();
                }
            }
            this.useCache = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDefaultConfig() {
        InputStream in = null;
        OutputStream out = null;
        try {
            in = this.getClass().getResourceAsStream(CONFIG_FILE_NAME);
            if (in == null) {
                System.err.println("Non fatal error: no default config exists in client installation");
                return;
            }
            out = new FileOutputStream(new File(this.lsidHome, CONFIG_FILE_NAME));
            byte[] bytes = new byte[1024];
            int numbytes = in.read(bytes);
            while (numbytes != -1) {
                out.write(bytes, 0, numbytes);
                numbytes = in.read(bytes);
            }
            out.flush();
        }
        catch (IOException e) {
            System.err.println("No fatal error: could not write default config file, stack trace follows");
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void loadConfig(LsidClient conf) {
        block34: {
            this.useCache = false;
            File cacheDir = new File(this.lsidHome, LSID_CACHE_DIR_DEFAULT);
            if (conf != null) {
                WsdlExtensions wsdlExts;
                ForeignAuthorities fa;
                MetadataStores mds;
                AcceptedFormats formats;
                Caching c = conf.getCaching();
                if (c != null) {
                    String cacheDirStr;
                    String useCacheStr = c.getUseCache();
                    if (useCacheStr != null) {
                        this.useCache = new Boolean(useCacheStr);
                    }
                    if ((cacheDirStr = c.getLsidCacheDir()) != null) {
                        cacheDir = new File(cacheDirStr);
                    }
                }
                if ((formats = conf.getAcceptedFormats()) != null) {
                    this.acceptedFormats = formats.getFormat();
                }
                if ((mds = conf.getMetadataStores()) != null) {
                    int count = mds.getMetadataStoreCount();
                    int i = 0;
                    while (i < count) {
                        MetadataStore ms = mds.getMetadataStore(i);
                        if (ms != null) {
                            String mdfc = ms.getMetadataFactory();
                            String type = ms.getFormat();
                            try {
                                LSIDMetadataFactory metadataFactory = (LSIDMetadataFactory)Class.forName(mdfc).newInstance();
                                Hashtable<String, String> factoryProps = new Hashtable<String, String>();
                                Enumeration props = ms.getProperties().enumerateProperty();
                                while (props.hasMoreElements()) {
                                    Property prop = (Property)props.nextElement();
                                    String propname = prop.getName();
                                    String propvalue = prop.getValue();
                                    factoryProps.put(propname, propvalue);
                                }
                                try {
                                    metadataFactory.setProperties(factoryProps);
                                }
                                catch (LSIDMetadataException e) {
                                    System.err.println("Error setting properties on meta data factory, stack trace follows: " + e.getMessage());
                                    e.printStackTrace();
                                }
                                this.metadataFactories.put(type, metadataFactory);
                            }
                            catch (Exception e) {
                                System.err.println("Error instantiating class: " + mdfc + ", using default");
                                e.printStackTrace();
                            }
                        }
                        ++i;
                    }
                }
                this.hostMappings = new Hashtable();
                HostMappings hm = conf.getHostMappings();
                if (hm != null) {
                    Enumeration mappings = hm.enumerateHostMapping();
                    while (mappings.hasMoreElements()) {
                        HostMapping mapping = (HostMapping)mappings.nextElement();
                        String auth = mapping.getAuthority();
                        String endpoint = mapping.getEndpoint();
                        this.hostMappings.put(auth, endpoint);
                    }
                }
                if ((fa = conf.getForeignAuthorities()) != null) {
                    Enumeration foreign = fa.enumerateForeignAuthoritiesItem();
                    while (foreign.hasMoreElements()) {
                        ForeignAuthoritiesItem item = (ForeignAuthoritiesItem)foreign.nextElement();
                        Enumeration lsids = item.enumerateLsid();
                        while (lsids.hasMoreElements()) {
                            Lsid lsid = (Lsid)lsids.nextElement();
                            LSID theLsid = null;
                            try {
                                theLsid = new LSID(lsid.getLsid());
                            }
                            catch (MalformedLSIDException e) {
                                System.err.println("Bad lsid for foreign authority: " + lsid.getLsid() + ", ignoring");
                                e.printStackTrace();
                                continue;
                            }
                            String[] auths = lsid.getAuthority();
                            LSIDAuthority[] lsidAuths = new LSIDAuthority[auths.length];
                            int i = 0;
                            while (i < lsidAuths.length) {
                                try {
                                    lsidAuths[i] = new LSIDAuthority(auths[i]);
                                }
                                catch (MalformedLSIDException e) {
                                    System.err.println("Bad foreign authority: " + auths[i] + ", ignoring");
                                    e.printStackTrace();
                                }
                                ++i;
                            }
                            this.foreignAuthorities.put(theLsid.toString(), lsidAuths);
                        }
                        Enumeration patterns = item.enumeratePattern();
                        while (patterns.hasMoreElements()) {
                            Pattern pattern = (Pattern)patterns.nextElement();
                            String patStr = pattern.getAuth() + ":" + pattern.getNs();
                            String[] auths = pattern.getAuthority();
                            LSIDAuthority[] lsidAuths = new LSIDAuthority[auths.length];
                            int i = 0;
                            while (i < lsidAuths.length) {
                                try {
                                    lsidAuths[i] = new LSIDAuthority(auths[i]);
                                }
                                catch (MalformedLSIDException e) {
                                    System.err.println("Bad foreign authority: " + auths[i] + ", ignoring");
                                    e.printStackTrace();
                                }
                                ++i;
                            }
                            this.foreignAuthorities.put(patStr, lsidAuths);
                        }
                    }
                }
                if ((wsdlExts = conf.getWsdlExtensions()) != null) {
                    ImportMap[] ims = wsdlExts.getImportMap();
                    int i = 0;
                    while (i < ims.length) {
                        ImportMap im = ims[i];
                        this.importMaps.put(im.getLocation(), im.getImportMapChoice());
                        ++i;
                    }
                    PortMap[] pms = wsdlExts.getPortMap();
                    int i2 = 0;
                    while (i2 < pms.length) {
                        PortMap pm = pms[i2];
                        this.portFactories.put(pm.getPortType(), pm.getPortFactory());
                        ++i2;
                    }
                }
            }
            if (!this.useCache) break block34;
            try {
                System.setProperty("LSID_CACHE_DIR", cacheDir.getCanonicalPath());
            }
            catch (IOException e) {
                System.err.println("Error setting cache dir path: " + cacheDir + ", stack trace follows, will use default");
                e.printStackTrace();
            }
            try {
                this.cache = LSIDCache.load();
            }
            catch (LSIDCacheException e) {
                System.err.println("Error loading LSID Cache, will continue without caching, stack trace follows");
                e.printStackTrace();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DEFAULT_METADATA_FACTORIES.put("application/xml+rdf", new XSLTMetadataFactory());
        DEFAULT_METADATA_FORMATS = new String[]{"application/xml+rdf"};
    }
}

