# Editor Use Cases

The following is a list of use cases to be addressed by the design and implementation of a new web-based metadata editor.  Many of the use cases are only listed in this table and have yet to be fleshed out.   Others are linked to their full use case description.

| Use Case Name | Category | Ticket |
|---------------|----------|--------|
| [View public metadata](view-public-metadata.rst) | MUST |
| [Add metadata](add-metadata.rst) | MUST |
| [Update metadata](update-metadata.rst) | MUST |
| [Upload data files](upload-data.rst) | MUST |
| [Remove a file](remove-a-file.rst) | MUST |
| [Rename a file](rename-a-file.rst) | MUST |
| [Move a data file across levels](move-dataset-levels.rst) | MUST |
| [Add a nested dataset](add-a-nested-dataset.rst) | MUST |
| Link ORCIDs in creator and other party roles | MUST | [209](https://github.nceas.ucsb.edu/KNB/arctic-data/issues/209) |
| Save partially complete submissions before submitting | MUST | [187](https://github.nceas.ucsb.edu/KNB/arctic-data/issues/187) |
| Support paleo temporal coverage | MUST | [175](https://github.nceas.ucsb.edu/KNB/arctic-data/issues/175) |
| Improve handling of keyword thesauri | MUST | [205](https://github.nceas.ucsb.edu/KNB/arctic-data/issues/205) |
