/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.DBSAXHandler;
import edu.ucsb.nceas.metacat.accesscontrol.AccessControlList;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DBEntityResolver
implements EntityResolver {
    private DBConnection connection = null;
    private DefaultHandler handler = null;
    private String docname = null;
    private String doctype = null;
    private String systemid = null;
    private Reader dtdtext = null;
    private static Logger logMetacat = Logger.getLogger(DBEntityResolver.class);

    public DBEntityResolver(DBConnection conn) {
        this.connection = conn;
    }

    public DBEntityResolver(DBConnection conn, DefaultHandler handler, Reader dtd) {
        this.connection = conn;
        this.handler = handler;
        this.dtdtext = dtd;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputSource dtdSource = null;
        logMetacat.debug((Object)("DBEntityResolver.resolveEntity - in resolveEntity  the public id is " + publicId + " and systemId is " + systemId));
        String doctype = null;
        if (this.handler != null) {
            String message = "Metacat can't determine the public id or the name of the root element of the document, so the validation can't be applied and the document is rejected";
            logMetacat.debug((Object)("DBEntityResolver.resolveEntity - the handler class is " + this.handler.getClass().getCanonicalName()));
            if (this.handler instanceof DBSAXHandler) {
                DBSAXHandler dhandler = null;
                dhandler = (DBSAXHandler)this.handler;
                if (dhandler.processingDTD()) {
                    logMetacat.debug((Object)"DBEntityResolver.resolveEntity - in the branch of the handler class is  DBSAXHandler");
                    if (publicId != null) {
                        doctype = publicId;
                        logMetacat.debug((Object)("DBEntityResolver.resolveEntity - the publicId is not null, so the publicId is the doctype. The doctype is: " + doctype));
                    } else {
                        doctype = dhandler.getDocname();
                        logMetacat.debug((Object)("DBEntityResolver.resolveEntity - the publicId is null and we treat the doc name(the root element name) as the doc type. The doctype is: " + doctype));
                    }
                    if (doctype == null || doctype.trim().equals("")) {
                        logMetacat.error((Object)("DBEntityResolver.resolveEntity - " + message));
                        throw new SAXException(message);
                    }
                    logMetacat.debug((Object)("DBEntityResolver.resolveEntity - the final doctype for DBSAXHandler " + doctype));
                }
            } else if (this.handler instanceof AccessControlList) {
                logMetacat.debug((Object)"DBEntityResolver.resolveEntity - in the branch of the handler class is AccessControlList");
                AccessControlList ahandler = null;
                ahandler = (AccessControlList)this.handler;
                if (ahandler.processingDTD()) {
                    if (publicId != null) {
                        doctype = publicId;
                        logMetacat.debug((Object)("DBEntityResolver.resolveEntity - the publicId is not null, so the publicId is the doctype. The doctype in AccessControlList is: " + doctype));
                    } else {
                        doctype = ahandler.getDocname();
                        logMetacat.debug((Object)("DBEntityResolver.resolveEntity - the publicId is null and we treat the doc name(the root element name) as the doc type. The doctype in AccessControlList is: " + doctype));
                    }
                    if (doctype == null || doctype.trim().equals("")) {
                        logMetacat.error((Object)("DBEntityResolver.resolveEntity - " + message));
                        throw new SAXException(message);
                    }
                    logMetacat.debug((Object)("DBEntityResolver.resolveEntity - the final doctype for AccessControList " + doctype));
                } else {
                    logMetacat.debug((Object)"DBEntityResolver.resolveEntity - the method resolverEntity for the AccessControList class is not processing a dtd");
                }
            } else {
                logMetacat.debug((Object)"DBEntityResolver.resolveEntity - in the branch of the other handler class");
            }
        } else {
            logMetacat.debug((Object)"DBEntityResolver.resolveEntity - the xml handler is null. So we can't find the doctype.");
        }
        if (doctype != null) {
            logMetacat.info((Object)("DBEntityResolver.resolveEntity - get systemId from doctype: " + doctype));
            String dbSystemID = DBEntityResolver.getDTDSystemID(doctype);
            logMetacat.info((Object)("DBEntityResolver.resolveEntity - The Systemid from xml_catalog table is: " + dbSystemID));
            if (dbSystemID == null) {
                logMetacat.error((Object)("DBEntityResolver.resolveEntity - The doctype: " + doctype + " , which was defined by a DTD document, isn't registered in Metacat. Please contact the operator of the Metacat"));
                throw new SAXException("The doctype: " + doctype + " , which was defined by a DTD document, isn't registered in Metacat. Please contact the operator of the Metacat");
            }
            try {
                InputStream in = DBEntityResolver.checkURLConnection(dbSystemID);
                dtdSource = new InputSource(in);
            }
            catch (SAXException se) {
                se.printStackTrace();
                throw se;
            }
        }
        return dtdSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getDTDSystemID(String doctype) throws SAXException {
        String systemid = null;
        Statement pstmt = null;
        DBConnection conn = null;
        int serialNumber = -1;
        ResultSet rs = null;
        try {
            conn = DBConnectionPool.getDBConnection("DBEntityResolver.getDTDSystemID");
            serialNumber = conn.getCheckOutSerialNumber();
            String sql = "SELECT system_id FROM xml_catalog WHERE entry_type = 'DTD' AND public_id = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, doctype);
            pstmt.execute();
            rs = pstmt.getResultSet();
            boolean tableHasRows = rs.next();
            if (!tableHasRows) return systemid;
            systemid = rs.getString(1);
            if (systemid.startsWith("http://")) return systemid;
            systemid = SystemUtil.getContextURL() + systemid;
            return systemid;
        }
        catch (SQLException e) {
            throw new SAXException("DBEntityResolver.getDTDSystemID - SQL error when getting DTD system ID: " + e.getMessage());
        }
        catch (PropertyNotFoundException pnfe) {
            throw new SAXException("DBEntityResolver.getDTDSystemID - Property error when getting DTD system ID:  " + pnfe.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (SQLException sqlE) {
                logMetacat.error((Object)("DBEntityResolver.getDTDSystemId - SQL error: " + sqlE.getMessage()));
            }
            finally {
                DBConnectionPool.returnDBConnection(conn, serialNumber);
            }
        }
    }

    private void registerDTD(String doctype, String systemId) throws SAXException {
        String existingSystemId = DBEntityResolver.getDTDSystemID(doctype);
        if (existingSystemId != null && existingSystemId.equals(systemId)) {
            logMetacat.warn((Object)("DBEntityResolver.registerDTD - doctype/systemId already registered in DB: " + doctype));
            return;
        }
        PreparedStatement pstmt = null;
        try {
            pstmt = this.connection.prepareStatement("INSERT INTO xml_catalog (entry_type, public_id, system_id) VALUES ('DTD', ?, ?)");
            this.connection.increaseUsageCount(1);
            pstmt.setString(1, doctype);
            pstmt.setString(2, systemId);
            pstmt.execute();
            int updateCnt = pstmt.getUpdateCount();
            logMetacat.debug((Object)("DBEntityReolver.registerDTD - DTDs registered: " + updateCnt));
            pstmt.close();
        }
        catch (SQLException e) {
            throw new SAXException("DBEntityResolver.registerDTD - SQL issue when registering DTD: " + e.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            catch (SQLException sqlE) {
                logMetacat.error((Object)("DBEntityResolver.registerDTD - SQL error: " + sqlE.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String uploadDTD(String systemId) throws SAXException {
        String dtdPath = null;
        String dtdURL = null;
        try {
            dtdPath = SystemUtil.getContextDir() + "/dtd/";
            dtdURL = SystemUtil.getContextURL() + "/dtd/";
        }
        catch (PropertyNotFoundException pnfe) {
            throw new SAXException("DBEntityResolver.uploadDTD: " + pnfe.getMessage());
        }
        String filename = systemId;
        int slash = Math.max(filename.lastIndexOf(47), filename.lastIndexOf(92));
        if (slash > -1) {
            filename = filename.substring(slash + 1);
        }
        try {
            File f;
            BufferedReader in = new BufferedReader(this.dtdtext);
            File file = f = new File(dtdPath, filename);
            synchronized (file) {
                String inputLine;
                if (f.exists()) {
                    throw new IOException("File already exist: " + f.getCanonicalFile());
                }
                FileWriter fw = new FileWriter(f);
                BufferedWriter out = new BufferedWriter(fw);
                while ((inputLine = in.readLine()) != null) {
                    out.write(inputLine, 0, inputLine.length());
                    out.newLine();
                }
                in.close();
                out.flush();
                out.close();
                fw.close();
            }
        }
        catch (MalformedURLException e) {
            throw new SAXException("DBEntityResolver.uploadDTD() - Malformed URL when uploading DTD: " + e.getMessage());
        }
        catch (IOException e) {
            throw new SAXException("DBEntityResolver.uploadDTD - I/O issue when uploading DTD: " + e.getMessage());
        }
        catch (SecurityException e) {
            throw new SAXException("DBEntityResolver.uploadDTD() - Security issue when uploading DTD: " + e.getMessage());
        }
        return dtdURL + filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String uploadDTDFromURL(InputStream istream, String systemId) throws SAXException {
        String dtdPath = null;
        String dtdURL = null;
        try {
            dtdPath = SystemUtil.getContextDir() + "/dtd/";
            dtdURL = SystemUtil.getContextURL() + "/dtd/";
        }
        catch (PropertyNotFoundException pnfe) {
            throw new SAXException("DBEntityResolver.uploadDTDFromURL - Property issue when uploading DTD from URL: " + pnfe.getMessage());
        }
        String filename = systemId;
        int slash = Math.max(filename.lastIndexOf(47), filename.lastIndexOf(92));
        if (slash > -1) {
            filename = filename.substring(slash + 1);
        }
        try {
            File f;
            BufferedInputStream in = new BufferedInputStream(istream);
            File file = f = new File(dtdPath, filename);
            synchronized (file) {
                int inputByte;
                if (f.exists()) {
                    logMetacat.warn((Object)("DBEntityResolver.uploadDTDFromURL - File already exists: " + f.getCanonicalFile()));
                }
                FileWriter fw = new FileWriter(f);
                BufferedWriter out = new BufferedWriter(fw);
                while ((inputByte = in.read()) != -1) {
                    out.write(inputByte);
                }
                in.close();
                out.flush();
                out.close();
                fw.close();
            }
        }
        catch (MalformedURLException e) {
            throw new SAXException("DBEntityResolver.uploadDTDFromURL - Malformed URL when uploading DTD from URL: " + e.getMessage());
        }
        catch (IOException e) {
            throw new SAXException("DBEntityResolver.uploadDTDFromURL - I/O issue when uploading DTD from URL:  " + e.getMessage());
        }
        catch (SecurityException e) {
            throw new SAXException("DBEntityResolver.uploadDTDFromURL - Security issue when uploading DTD from URL:  " + e.getMessage());
        }
        return dtdURL + filename;
    }

    public static InputStream checkURLConnection(String systemId) throws SAXException {
        try {
            return new URL(systemId).openStream();
        }
        catch (MalformedURLException e) {
            throw new SAXException("DBEntityResolver.checkURLConnection - Malformed URL when checking URL Connection: " + e.getMessage());
        }
        catch (IOException e) {
            throw new SAXException("DBEntityResolver.checkURLConnection - I/O issue when checking URL Connection: " + e.getMessage());
        }
    }
}

