/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.AccessionNumberException;
import edu.ucsb.nceas.metacat.McdbException;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.util.DocumentUtil;
import edu.ucsb.nceas.metacat.util.MetacatUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.triple.Triple;
import edu.ucsb.nceas.utilities.triple.TripleCollection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.apache.log4j.Logger;

public class RelationHandler {
    private DBConnection connection = null;
    private String docid = null;
    private String docType = null;
    private static Logger logMetacat = Logger.getLogger(RelationHandler.class);
    TripleCollection tripleForPackage = null;

    public RelationHandler(String docid, String doctype, DBConnection conn, TripleCollection list) throws McdbException, SQLException, AccessionNumberException {
        this.connection = conn;
        this.docid = docid;
        this.docType = doctype;
        this.tripleForPackage = list;
        this.createRelations();
    }

    private void createRelations() throws McdbException, SQLException, AccessionNumberException {
        String packagetype = this.docType;
        String subject = null;
        Object subjectParentId = null;
        String subDoctype = null;
        String relationship = null;
        Object relationshipParentId = null;
        String object = null;
        String objDoctype = null;
        Statement tstmt = null;
        logMetacat.info((Object)"Running relation handler!");
        this.deleteRelations(this.docid);
        Vector tripleList = new Vector();
        if (this.tripleForPackage != null) {
            tripleList = this.tripleForPackage.getCollection();
        }
        if (tripleList != null && tripleList.size() > 0) {
            tstmt = this.connection.prepareStatement("INSERT INTO xml_relation (docid,packagetype,subject,subdoctype,relationship, object, objdoctype) VALUES (?, ?, ?, ?, ?, ?, ?)");
            for (int i = 0; i < tripleList.size(); ++i) {
                this.connection.increaseUsageCount(1);
                Triple triple = (Triple)tripleList.elementAt(i);
                logMetacat.info((Object)"Info from triple: ");
                logMetacat.info((Object)("subject from triple:" + triple.getSubject()));
                logMetacat.info((Object)("relationship from triple:" + triple.getRelationship()));
                logMetacat.info((Object)("object from triple: " + triple.getObject()));
                subject = DocumentUtil.getDocIdFromString(triple.getSubject());
                relationship = triple.getRelationship();
                object = DocumentUtil.getDocIdFromString(triple.getObject());
                if (subject == null || relationship == null || object == null) continue;
                logMetacat.info((Object)"Insert into xml_relation table");
                tstmt.setString(1, this.docid);
                logMetacat.info((Object)("Insert docid into xml_relation table" + this.docid));
                tstmt.setString(2, packagetype);
                tstmt.setString(3, subject);
                logMetacat.info((Object)("Insert subject into xml_relation table" + subject));
                tstmt.setString(4, subDoctype);
                tstmt.setString(5, relationship);
                logMetacat.info((Object)("Insert relationship into xml_relation table" + relationship));
                tstmt.setString(6, object);
                logMetacat.info((Object)("Insert object into xml_relation table" + object));
                tstmt.setString(7, objDoctype);
                tstmt.execute();
            }
        }
        if (tstmt != null) {
            tstmt.close();
        }
    }

    public void deleteRelations(String docid) throws SQLException {
        try {
            PreparedStatement pstmt = this.connection.prepareStatement("DELETE FROM xml_relation WHERE docid = ?");
            pstmt.setString(1, docid);
            this.connection.increaseUsageCount(1);
            pstmt.execute();
            pstmt.close();
        }
        catch (SQLException e) {
            logMetacat.error((Object)("error in RelationHandler.deleteRelations(): " + e.getMessage()));
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAccessFileIDWithRevision(String docid) throws SQLException {
        Vector<String> accessdoctypes;
        String aclid = null;
        Statement pstmt = null;
        DBConnection dbConn = null;
        int serialNumber = -1;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT docid, rev FROM xml_documents WHERE docid in (SELECT subject ");
        sql.append("FROM xml_relation WHERE docid = ? ");
        sql.append(" AND (");
        try {
            accessdoctypes = MetacatUtil.getOptionList(PropertyService.getProperty("xml.accessdoctype"));
        }
        catch (PropertyNotFoundException pnfe) {
            throw new SQLException("Could not find access doctype: " + pnfe.getMessage());
        }
        for (int i = 0; i < accessdoctypes.size(); ++i) {
            String atype = accessdoctypes.elementAt(i);
            sql.append("doctype='").append(atype).append("'");
            if (i >= accessdoctypes.size() - 1) continue;
            sql.append(" OR ");
        }
        sql.append("))");
        try {
            dbConn = DBConnectionPool.getDBConnection("RelationHandler.getAccessFileID");
            serialNumber = dbConn.getCheckOutSerialNumber();
            pstmt = dbConn.prepareStatement(sql.toString());
            pstmt.setString(1, docid);
            pstmt.execute();
            ResultSet rs = pstmt.getResultSet();
            boolean hasRow = rs.next();
            if (hasRow) {
                aclid = rs.getString(1);
                int rev = rs.getInt(2);
                String sep = ".";
                try {
                    sep = PropertyService.getProperty("document.accNumSeparator");
                }
                catch (PropertyNotFoundException pnfe) {
                    logMetacat.error((Object)("Could not find account separator.  Setting to '.': " + pnfe.getMessage()));
                }
                aclid = sep + rev;
            }
            pstmt.close();
        }
        finally {
            try {
                pstmt.close();
            }
            finally {
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            }
        }
        logMetacat.info((Object)("The access docid get from xml_relation is: " + aclid));
        return aclid;
    }
}

