/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.admin;

import edu.ucsb.nceas.metacat.admin.AdminException;
import edu.ucsb.nceas.metacat.admin.MetacatAdmin;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.properties.SkinPropertyService;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.metacat.util.RequestUtil;
import edu.ucsb.nceas.metacat.util.SkinUtil;
import edu.ucsb.nceas.utilities.GeneralPropertyException;
import edu.ucsb.nceas.utilities.MetaDataProperty;
import edu.ucsb.nceas.utilities.PropertiesMetaData;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.SortedProperties;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class SkinsAdmin
extends MetacatAdmin {
    private static SkinsAdmin skinsAdmin = null;
    private static Logger logMetacat = Logger.getLogger(SkinsAdmin.class);

    private SkinsAdmin() {
    }

    public static SkinsAdmin getInstance() {
        if (skinsAdmin == null) {
            skinsAdmin = new SkinsAdmin();
        }
        return skinsAdmin;
    }

    public void configureSkins(HttpServletRequest request, HttpServletResponse response) throws AdminException {
        String errorMessage;
        String processForm = request.getParameter("processForm");
        String formErrors = (String)request.getAttribute("formErrors");
        if (processForm == null || !processForm.equals("true") || formErrors != null) {
            try {
                Vector<String> skinNames = SkinUtil.getSkinNames();
                String defaultStyle = PropertyService.getProperty("application.default-style");
                request.setAttribute("defaultStyle", (Object)defaultStyle);
                HashMap<String, PropertiesMetaData> propertyMetaData = SkinPropertyService.getMetaData();
                request.setAttribute("metadataMap", propertyMetaData);
                HashMap<String, SortedProperties> originalPropertyMap = SkinPropertyService.getProperties();
                HashMap localPropertyMap = new HashMap();
                HashMap<String, SortedProperties> backupPropertiesMap = SkinPropertyService.getBackupProperties();
                Vector<String> removeSkins = new Vector<String>();
                for (String skinName : skinNames) {
                    SortedProperties skinProperties = originalPropertyMap.get(skinName);
                    if (skinProperties == null) {
                        logMetacat.error((Object)("SkinsAdmin.configureSkins - Could not find properties for skin: " + skinName));
                        removeSkins.add(skinName);
                        continue;
                    }
                    LinkedHashMap originalSkinProperties = skinProperties.getProperties();
                    HashMap<String, String> localSkinProperties = new HashMap<String, String>(originalSkinProperties);
                    SortedProperties backupProperties = backupPropertiesMap.get(skinName);
                    if (backupProperties == null) {
                        logMetacat.warn((Object)("SkinsAdmin.configureSkins - Could not find backup properties for skin: " + skinName));
                    } else {
                        for (String propertyName : backupProperties.getPropertyNames()) {
                            localSkinProperties.put(propertyName, backupProperties.getProperty(propertyName));
                        }
                    }
                    localPropertyMap.put(skinName, localSkinProperties);
                }
                for (String skinName : removeSkins) {
                    skinNames.remove(skinName);
                }
                request.setAttribute("skinNameList", skinNames);
                request.setAttribute("skinProperties", localPropertyMap);
                RequestUtil.forwardRequest(request, response, "/admin/skins-configuration.jsp", null);
            }
            catch (GeneralPropertyException pnfe) {
                throw new AdminException("SkinsAdmin.configureSkins - Problem getting property while initializing skins properties page: " + pnfe.getMessage());
            }
            catch (MetacatUtilException mue) {
                throw new AdminException("SkinsAdmin.configureSkins - utility problem while initializing skins properties page:" + mue.getMessage());
            }
        }
        Vector<String> processingSuccess = new Vector<String>();
        Vector<String> processingErrors = new Vector<String>();
        Vector<String> validationErrors = new Vector<String>();
        try {
            String defaultStyle = request.getParameter("application.default-style");
            PropertyService.setProperty("application.default-style", defaultStyle);
            Vector<String> skinNames = SkinUtil.getSkinNames();
            for (String skinName : skinNames) {
                PropertiesMetaData skinMetaData = SkinPropertyService.getMetaData(skinName);
                if (skinMetaData == null) {
                    logMetacat.error((Object)("SkinsAdmin.configureSkins - Could not find metadata for skin: " + skinName));
                    continue;
                }
                Set metaDataKeySet = skinMetaData.getKeys();
                for (String metaDataKey : metaDataKeySet) {
                    MetaDataProperty metaDataProperty = (MetaDataProperty)skinMetaData.getProperties().get(metaDataKey);
                    String fieldType = metaDataProperty.getFieldType();
                    String newValue = request.getParameter(skinName + "." + metaDataKey);
                    if (fieldType != null && fieldType.equals("checkbox")) {
                        if (newValue != null && newValue.equals("on")) {
                            SkinPropertyService.checkAndSetProperty("true", skinName, metaDataKey);
                            continue;
                        }
                        SkinPropertyService.checkAndSetProperty("false", skinName, metaDataKey);
                        continue;
                    }
                    SkinPropertyService.checkAndSetProperty(request, skinName, metaDataKey);
                }
                SkinPropertyService.persistProperties(skinName);
                validationErrors.addAll(this.validateOptions(request, skinName));
                SkinPropertyService.persistBackupProperties(skinName);
                PropertyService.persistMainBackupProperties();
            }
            PropertyService.setProperty("configutil.skinsConfigured", "true");
        }
        catch (GeneralPropertyException gpe) {
            errorMessage = "SkinsAdmin.configureSkins - problem setting property while processing skins properties page: " + gpe.getMessage();
            logMetacat.error((Object)errorMessage);
            processingErrors.add(errorMessage);
        }
        catch (IOException ioe) {
            errorMessage = "SkinsAdmin.configureSkins - IO problem while processing skins properties page: " + ioe.getMessage();
            logMetacat.error((Object)errorMessage);
            processingErrors.add(errorMessage);
        }
        try {
            if (validationErrors.size() > 0 || processingErrors.size() > 0) {
                RequestUtil.clearRequestMessages(request);
                RequestUtil.setRequestFormErrors(request, validationErrors);
                RequestUtil.setRequestErrors(request, processingErrors);
                RequestUtil.forwardRequest(request, response, "/admin", null);
            } else {
                PropertyService.setProperty("configutil.skinsConfigured", "true");
                processingSuccess.add("Skins successfully configured");
                RequestUtil.clearRequestMessages(request);
                RequestUtil.setRequestSuccess(request, processingSuccess);
                RequestUtil.forwardRequest(request, response, "/admin?configureType=configure&processForm=false", null);
            }
        }
        catch (MetacatUtilException mue) {
            throw new AdminException("SkinsAdmin.configureSkins - utility problem while processing skins properties page: " + mue.getMessage());
        }
        catch (GeneralPropertyException gpe) {
            errorMessage = "SkinsAdmin.configureSkins - problem setting property while processing skins properties page: " + gpe.getMessage();
            logMetacat.error((Object)errorMessage);
            processingErrors.add(errorMessage);
        }
    }

    @Override
    protected Vector<String> validateOptions(HttpServletRequest request) {
        Vector<String> errorVector = new Vector<String>();
        Vector<String> skinNames = null;
        try {
            skinNames = SkinUtil.getSkinNames();
        }
        catch (PropertyNotFoundException pnfe) {
            errorVector.add("Could not find skin names: " + pnfe.getMessage());
        }
        for (String skinName : skinNames) {
            errorVector.addAll(this.validateOptions(request, skinName));
        }
        return errorVector;
    }

    protected Vector<String> validateOptions(HttpServletRequest request, String skinName) {
        Vector<String> errorVector = new Vector<String>();
        return errorVector;
    }
}

