/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.dataone;

import edu.ucsb.nceas.metacat.DBUtil;
import edu.ucsb.nceas.metacat.DocumentImpl;
import edu.ucsb.nceas.metacat.McdbException;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.dataone.exceptions.MarshallingException;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v2.ObjectFormat;
import org.dataone.service.types.v2.ObjectFormatList;
import org.dataone.service.util.TypeMarshaller;

public class ObjectFormatService {
    private Logger logMetacat = Logger.getLogger(ObjectFormatService.class);
    public static final String OBJECT_FORMAT_DOCID = "OBJECT_FORMAT_LIST.1";
    private int rev;
    private String separator = ".";
    private String accNumber = null;
    private ObjectFormatList objectFormatList = null;
    private static HashMap<String, ObjectFormat> objectFormatMap;
    private static ObjectFormatService instance;

    public static ObjectFormatService getInstance() {
        if (instance == null) {
            instance = new ObjectFormatService();
        }
        return instance;
    }

    private ObjectFormatService() {
    }

    public ObjectFormat getFormat(ObjectFormatIdentifier fmtid) throws ServiceFailure, NotFound, NotImplemented {
        this.logMetacat.debug((Object)"CNCoreImpl.getFormat() called.");
        ObjectFormat objectFormat = null;
        objectFormat = this.getObjectFormatMap().get(fmtid.getValue());
        if (objectFormat == null) {
            this.getCachedList();
            objectFormat = this.getObjectFormatMap().get(fmtid.getValue());
            if (objectFormat == null) {
                throw new NotFound("4848", "The format specified by " + fmtid.getValue() + " does not exist at this node.");
            }
        }
        return objectFormat;
    }

    public ObjectFormatList listFormats() throws ServiceFailure, NotImplemented {
        this.objectFormatList = this.getCachedList();
        return this.objectFormatList;
    }

    private HashMap<String, ObjectFormat> getObjectFormatMap() {
        if (objectFormatMap == null) {
            objectFormatMap = new HashMap();
        }
        return objectFormatMap;
    }

    private ObjectFormatList getCachedList() throws ServiceFailure {
        ObjectFormatList objectFormatList;
        block13: {
            objectFormatList = null;
            try {
                try {
                    this.separator = PropertyService.getProperty("document.accNumSeparator");
                }
                catch (PropertyNotFoundException pnfe) {
                    this.logMetacat.debug((Object)("There was a problem finding the document separator property. The error message was: " + pnfe.getMessage()));
                }
                this.rev = DBUtil.getLatestRevisionInDocumentTable(OBJECT_FORMAT_DOCID);
                if (this.rev != -1) {
                    this.accNumber = OBJECT_FORMAT_DOCID + this.separator + this.rev;
                    DocumentImpl objectFormatsDocument = new DocumentImpl(this.accNumber, false);
                    ByteArrayInputStream bais = new ByteArrayInputStream(objectFormatsDocument.getBytes());
                    try {
                        objectFormatList = (ObjectFormatList)TypeMarshaller.unmarshalTypeFromStream(ObjectFormatList.class, (InputStream)bais);
                        break block13;
                    }
                    catch (IOException e) {
                        throw new ServiceFailure("4841", "Unexpected exception from the service - " + e.getClass() + ": " + e.getMessage());
                    }
                    catch (InstantiationException e) {
                        throw new ServiceFailure("4841", "Unexpected exception from the service - " + e.getClass() + ": " + e.getMessage());
                    }
                    catch (IllegalAccessException e) {
                        throw new ServiceFailure("4841", "Unexpected exception from the service - " + e.getClass() + ": " + e.getMessage());
                    }
                    catch (MarshallingException e) {
                        throw new ServiceFailure("4841", "Unexpected exception from the service - " + ((Object)((Object)e)).getClass() + ": " + e.getMessage());
                    }
                }
                throw new ServiceFailure("4841", "The object formats collection could not be found at this node.");
            }
            catch (SQLException sqle) {
                throw new ServiceFailure("4841", "Unexpected exception from the service - " + sqle.getClass() + ": " + sqle.getMessage());
            }
            catch (McdbException mcdbe) {
                throw new ServiceFailure("4841", "Unexpected exception from the service - " + mcdbe.getClass() + ": " + mcdbe.getMessage());
            }
        }
        int listSize = objectFormatList.sizeObjectFormatList();
        for (int i = 0; i < listSize; ++i) {
            ObjectFormat objectFormat = objectFormatList.getObjectFormat(i);
            String identifier = objectFormat.getFormatId().getValue();
            this.getObjectFormatMap().put(identifier, objectFormat);
        }
        return objectFormatList;
    }

    static {
        instance = null;
    }
}

