/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.dataone;

import edu.ucsb.nceas.metacat.AccessionNumberException;
import edu.ucsb.nceas.metacat.IdentifierManager;
import edu.ucsb.nceas.metacat.McdbDocNotFoundException;
import edu.ucsb.nceas.metacat.accesscontrol.AccessControlException;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.utilities.GeneralPropertyException;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.SortedProperties;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;
import org.dataone.client.v2.CNode;
import org.dataone.client.v2.itk.D1Client;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.exceptions.VersionMismatch;
import org.dataone.service.types.v1.AccessPolicy;
import org.dataone.service.types.v1.AccessRule;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.ObjectInfo;
import org.dataone.service.types.v1.ObjectList;
import org.dataone.service.types.v1.Permission;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v2.SystemMetadata;

public class SyncAccessPolicy {
    private static Logger logMetacat = Logger.getLogger(SyncAccessPolicy.class);

    private List<Identifier> sync(ObjectList objList) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented, McdbDocNotFoundException, InvalidRequest, VersionMismatch, NumberFormatException, AccessionNumberException, SQLException, Exception {
        AccessPolicy cnAccessPolicy = null;
        AccessPolicy mnAccessPolicy = null;
        Identifier pid = new Identifier();
        ObjectInfo objInfo = null;
        Session session = null;
        ArrayList<Identifier> syncedIds = new ArrayList<Identifier>();
        SystemMetadata cnSysMeta = null;
        SystemMetadata mnSysMeta = null;
        CNode cn = null;
        try {
            cn = D1Client.getCN();
            logMetacat.debug((Object)("Will sync access policies to CN id: " + cn.getNodeId() + " with info: " + cn.toString()));
        }
        catch (ServiceFailure sf) {
            logMetacat.error((Object)"Unable to get Coordinating node name for this MN");
            throw new AccessControlException("Unable to get Coordinating node name for this MN");
        }
        for (int i = objList.getStart(); i < objList.getCount(); ++i) {
            block13: {
                objInfo = objList.getObjectInfo(i);
                pid = objInfo.getIdentifier();
                logMetacat.debug((Object)("Getting SM for pid: " + pid.getValue() + " i: " + i));
                try {
                    mnSysMeta = IdentifierManager.getInstance().getSystemMetadata(pid.getValue());
                }
                catch (McdbDocNotFoundException e) {
                    logMetacat.error((Object)("Error syncing access policy of pid: " + pid.getValue() + " pid not found: " + e.getMessage()));
                    continue;
                }
                catch (Exception e) {
                    logMetacat.error((Object)("Error syncing access policy of pid: " + pid.getValue() + ". Message: " + e.getMessage()));
                    continue;
                }
                logMetacat.debug((Object)("Getting access policy for pid: " + pid.getValue()));
                mnAccessPolicy = mnSysMeta.getAccessPolicy();
                try {
                    cnSysMeta = cn.getSystemMetadata(null, pid);
                }
                catch (Exception e) {
                    logMetacat.error((Object)("Error getting system metadata for pid: " + pid.getValue() + " from cn: " + e.getMessage()));
                    continue;
                }
                logMetacat.debug((Object)("Getting access policy from CN for pid: " + pid.getValue()));
                cnAccessPolicy = cnSysMeta.getAccessPolicy();
                logMetacat.debug((Object)("Diffing access policies (MN,CN) for pid: " + pid.getValue()));
                if (!this.isEqual(mnAccessPolicy, cnAccessPolicy)) {
                    try {
                        BigInteger serialVersion = cnSysMeta.getSerialVersion();
                        logMetacat.debug((Object)("Requesting CN to set access policy for pid: " + pid.getValue() + ", serial version: " + serialVersion.toString()));
                        cn.setAccessPolicy(session, pid, mnAccessPolicy, serialVersion.longValue());
                        logMetacat.debug((Object)("Successfully set access policy for pid: " + pid.getValue()));
                        syncedIds.add(pid);
                        break block13;
                    }
                    catch (NotAuthorized na) {
                        logMetacat.error((Object)("Error syncing CN with access policy of pid: " + pid.getValue() + " user not authorized: " + na.getMessage()));
                        continue;
                    }
                    catch (ServiceFailure sf) {
                        logMetacat.error((Object)("Error syncing CN with access policy of pid: " + pid.getValue() + " Service failure: " + "'" + sf.getDescription() + "'"));
                        sf.printStackTrace();
                        logMetacat.debug((Object)("Cause: '" + sf.getCause() + "'"));
                        continue;
                    }
                    catch (Exception e) {
                        logMetacat.error((Object)("Error syncing CN with access policy of pid: " + pid.getValue() + e.getMessage()));
                        continue;
                    }
                }
                logMetacat.warn((Object)("Skipping pid: " + pid.getValue()));
            }
            logMetacat.debug((Object)("Done checking access policy for pid: " + pid.getValue()));
        }
        return syncedIds;
    }

    public List<Identifier> sync(List<String> guidsToSync) throws NumberFormatException, ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented, McdbDocNotFoundException, InvalidRequest, VersionMismatch, AccessionNumberException, SQLException, Exception {
        List<Identifier> syncedPids = null;
        ObjectList objList = new ObjectList();
        SystemMetadata sm = new SystemMetadata();
        int start = 0;
        int count = 0;
        objList.setStart(start);
        for (String guid : guidsToSync) {
            try {
                sm = IdentifierManager.getInstance().getSystemMetadata(guid);
                ++count;
            }
            catch (Exception e) {
                logMetacat.error((Object)("Error syncing access policy of pid: " + guid + ". Message: " + e.getMessage()));
                continue;
            }
            ObjectInfo oi = new ObjectInfo();
            Identifier id = new Identifier();
            id.setValue(guid);
            oi.setIdentifier(id);
            oi.setDateSysMetadataModified(sm.getDateSysMetadataModified());
            oi.setChecksum(sm.getChecksum());
            oi.setFormatId(sm.getFormatId());
            oi.setSize(sm.getSize());
            objList.addObjectInfo(oi);
        }
        int total = count;
        objList.setCount(count);
        objList.setTotal(total);
        syncedPids = this.sync(objList);
        return syncedPids;
    }

    public void syncAll() throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented, McdbDocNotFoundException, InvalidRequest, VersionMismatch, NumberFormatException, AccessionNumberException, SQLException, PropertyNotFoundException, ServiceException, Exception {
        SyncTask st = new SyncTask();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        logMetacat.debug((Object)"syncAll starting thread");
        executor.execute(st);
        executor.shutdown();
    }

    public boolean isEqual(AccessPolicy ap1, AccessPolicy ap2) {
        if (ap1 == null || ap2 == null) {
            return false;
        }
        List allowList1 = ap1.getAllowList();
        List allowList2 = ap2.getAllowList();
        HashMap<Subject, Set<Permission>> userPerms1 = new HashMap<Subject, Set<Permission>>();
        HashMap<Subject, Set<Permission>> userPerms2 = new HashMap<Subject, Set<Permission>>();
        Set perms = null;
        for (AccessRule accessRule : allowList1) {
            for (Subject s : accessRule.getSubjectList()) {
                perms = userPerms1.containsKey(s) ? (Set)userPerms1.get(s) : new HashSet();
                for (Permission p : accessRule.getPermissionList()) {
                    perms.add(p);
                }
                userPerms1.put(s, perms);
            }
        }
        for (AccessRule accessRule : allowList2) {
            for (Subject s : accessRule.getSubjectList()) {
                perms = userPerms2.containsKey(s) ? (Set)userPerms2.get(s) : new HashSet();
                for (Permission p : accessRule.getPermissionList()) {
                    perms.add(p);
                }
                userPerms2.put(s, perms);
            }
        }
        if (userPerms1.entrySet().size() != userPerms2.entrySet().size()) {
            return false;
        }
        logMetacat.debug((Object)"Performing comparison of access policies");
        for (Map.Entry entry : userPerms1.entrySet()) {
            Subject s1 = (Subject)entry.getKey();
            Set p1 = (Set)entry.getValue();
            logMetacat.debug((Object)("Checking access policy of user: " + s1.getValue()));
            if (userPerms2.containsKey(s1)) {
                if (p1.equals(userPerms2.get(s1))) continue;
                logMetacat.debug((Object)"User access policies not equal");
                return false;
            }
            logMetacat.debug((Object)"User access policy not found on CN");
            return false;
        }
        logMetacat.debug((Object)"Access policies are the same");
        return true;
    }

    public static void main(String[] args) throws Exception {
        SortedProperties testProperties = new SortedProperties("test/test.properties");
        testProperties.load();
        String metacatContextDir = testProperties.getProperty("metacat.contextDir");
        PropertyService.getInstance(metacatContextDir + "/WEB-INF");
        ArrayList<String> guids = null;
        SyncAccessPolicy syncAP = new SyncAccessPolicy();
        if (args.length > 0) {
            try {
                guids = new ArrayList<String>(Arrays.asList(args));
                logMetacat.warn((Object)("Trying to syncing access policy for " + args.length + " pids"));
                List<Identifier> synchedPids = syncAP.sync(guids);
                logMetacat.warn((Object)("Sunk access policies for " + synchedPids.size() + " pids"));
            }
            catch (Exception e) {
                logMetacat.error((Object)("Error syncing pids, message: " + e.getMessage()), (Throwable)e);
                System.exit(1);
            }
        }
    }

    private class SyncTask
    implements Runnable {
        private SyncTask() {
        }

        @Override
        public void run() {
            Date startTime = null;
            Date endTime = null;
            ObjectFormatIdentifier objectFormatId = null;
            NodeReference thisMN = new NodeReference();
            try {
                PropertyService.getInstance();
                String currentNodeId = PropertyService.getProperty("dataone.nodeId");
                thisMN.setValue(currentNodeId);
            }
            catch (Exception e) {
                logMetacat.error((Object)("SyncAccessPolicy.run - can't get the node id of this member node from the metacat property file since :" + e.getMessage()));
                return;
            }
            ObjectList objsToSync = null;
            Integer count = 0;
            Integer start = 0;
            Integer total = 0;
            List tmpIds = null;
            boolean syncError = false;
            ArrayList syncedIds = new ArrayList();
            try {
                count = Integer.valueOf(PropertyService.getProperty("database.webResultsetSize"));
            }
            catch (NumberFormatException e1) {
                logMetacat.error((Object)"Error in  propery file for format of database.webResultsetSize, will use 1000");
                e1.printStackTrace();
                count = 1000;
            }
            catch (PropertyNotFoundException e1) {
                logMetacat.error((Object)"Error reading propery file for database.webResultsetSize, will use 1000");
                e1.printStackTrace();
                count = 1000;
            }
            Identifier id = null;
            boolean isSid = false;
            try {
                objsToSync = IdentifierManager.getInstance().querySystemMetadata(startTime, endTime, objectFormatId, thisMN, start, count, id, isSid);
                logMetacat.debug((Object)("syncTask total # of guids: " + objsToSync.getTotal() + ", count for this page: " + objsToSync.getCount()));
            }
            catch (Exception e) {
                logMetacat.error((Object)"Error syncing ids");
            }
            total = objsToSync.getTotal();
            if (objsToSync.getCount() < count) {
                count = objsToSync.getCount();
            }
            int i = 0;
            while (i + count - 1 < total) {
                try {
                    logMetacat.debug((Object)("syncTask # requested: " + count + ", start: " + start + ", total: " + total + ", count: " + objsToSync.getCount()));
                    tmpIds = SyncAccessPolicy.this.sync(objsToSync);
                    syncedIds.addAll(tmpIds);
                    start = start + objsToSync.getCount();
                    if (start >= total) break;
                    objsToSync = IdentifierManager.getInstance().querySystemMetadata(startTime, endTime, objectFormatId, thisMN, start, count, id, isSid);
                }
                catch (Exception e) {
                    logMetacat.error((Object)"Error syncing ids");
                    syncError = true;
                    break;
                }
                i += count.intValue();
            }
            logMetacat.debug((Object)("syncTask thread completed. Number of guids synced: " + syncedIds.size()));
            if (!syncError) {
                try {
                    PropertyService.setProperty("dataone.syncaccesspolicies.synced", Boolean.TRUE.toString());
                }
                catch (GeneralPropertyException e) {
                    logMetacat.error((Object)"Unable to update property dataone.syncaccesspolicies.synced=true");
                }
            }
        }
    }
}

