/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.replication;

import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.replication.ReplicationServer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ReplicationServerList {
    private static Vector<ReplicationServer> serverList = null;
    private static Logger logMetacat = Logger.getLogger(ReplicationServerList.class);

    public ReplicationServerList() {
        serverList = new Vector();
        this.buildServerList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildServerList() {
        ReplicationServer server = null;
        DBConnection dbConn = null;
        int serialNumber = -1;
        Statement pstmt = null;
        ResultSet rs = null;
        boolean hasReplication = false;
        boolean hasDataReplication = false;
        boolean hasSystemMetadataReplication = false;
        boolean isHub = false;
        try {
            dbConn = DBConnectionPool.getDBConnection("ReplicationHandler.buildServerList");
            serialNumber = dbConn.getCheckOutSerialNumber();
            pstmt = dbConn.prepareStatement("select server, last_checked, replicate, datareplicate, hub from xml_replication");
            pstmt.execute();
            rs = pstmt.getResultSet();
            boolean tableHasRows = rs.next();
            while (tableHasRows) {
                String serverName = rs.getString(1);
                logMetacat.info((Object)("ServerName: " + serverName));
                java.sql.Date lastChecked = rs.getDate(2);
                logMetacat.info((Object)("Last checked time: " + lastChecked));
                int replication = rs.getInt(3);
                logMetacat.info((Object)("Replication value: " + replication));
                int dataReplication = rs.getInt(4);
                logMetacat.info((Object)("DataReplication value: " + dataReplication));
                int hubValue = rs.getInt(5);
                logMetacat.info((Object)("Hub value: " + hubValue));
                if (!serverName.equals("localhost")) {
                    server = new ReplicationServer();
                    server.setServerName(serverName);
                    server.setLastCheckedDate(lastChecked);
                    hasReplication = replication == 1;
                    server.setReplication(hasReplication);
                    hasDataReplication = hasReplication && dataReplication == 1;
                    server.setDataReplication(hasDataReplication);
                    isHub = hubValue == 1;
                    server.setHub(isHub);
                    serverList.add(server);
                }
                tableHasRows = rs.next();
            }
            return;
        }
        catch (Exception e) {
            logMetacat.error((Object)("Error in ReplicationServerList.buildServerList(): " + e.getMessage()));
            return;
        }
        finally {
            try {
                rs.close();
                pstmt.close();
            }
            catch (SQLException sqlE) {
                logMetacat.error((Object)("Error in ReplicationHandler.buildServerList: " + sqlE.getMessage()));
            }
            finally {
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            }
        }
    }

    public boolean isEmpty() {
        return serverList.isEmpty();
    }

    public int size() {
        return serverList.size();
    }

    private synchronized void addNewReplicationServer(ReplicationServer newReplicationServer) {
        serverList.add(newReplicationServer);
    }

    public ReplicationServer serverAt(int index) {
        return serverList.elementAt(index);
    }

    public boolean isGivenServerInList(String givenServerName) {
        boolean result = false;
        ReplicationServer server = null;
        int size = 0;
        size = serverList.size();
        if (size == 0 || givenServerName == null || givenServerName.equals("")) {
            result = false;
            return result;
        }
        for (int i = 0; i < size; ++i) {
            server = serverList.elementAt(i);
            if (!givenServerName.equalsIgnoreCase(server.getServerName())) continue;
            result = true;
            return result;
        }
        return result;
    }

    private synchronized int findIndexInServerList(String givenServerName) {
        int index = -1;
        ReplicationServer server = null;
        int size = 0;
        size = serverList.size();
        if (size == 0 || givenServerName == null || givenServerName.equals("")) {
            return index;
        }
        for (int i = 0; i < size; ++i) {
            server = serverList.elementAt(i);
            if (!givenServerName.equalsIgnoreCase(server.getServerName())) continue;
            index = i;
            return index;
        }
        return index;
    }

    public synchronized Date getLastCheckedDate(String givenServerName) {
        int index = -1;
        ReplicationServer server = null;
        index = this.findIndexInServerList(givenServerName);
        if (index == -1) {
            return null;
        }
        server = serverList.elementAt(index);
        return server.getLastCheckedDate();
    }

    public synchronized boolean getReplicationValue(String givenServerName) {
        int index = -1;
        ReplicationServer server = null;
        index = this.findIndexInServerList(givenServerName);
        if (index == -1) {
            return false;
        }
        server = serverList.elementAt(index);
        return server.getReplication();
    }

    public synchronized boolean getDataReplicationValue(String givenServerName) {
        int index = -1;
        ReplicationServer server = null;
        index = this.findIndexInServerList(givenServerName);
        if (index == -1) {
            return false;
        }
        server = serverList.elementAt(index);
        return server.getDataReplication();
    }

    public synchronized boolean getHubValue(String givenServerName) {
        int index = -1;
        ReplicationServer server = null;
        index = this.findIndexInServerList(givenServerName);
        if (index == -1) {
            return false;
        }
        server = serverList.elementAt(index);
        return server.getHub();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void addToServerListIfItIsNot(String givenServerName) {
        block18: {
            int index = -1;
            ReplicationServer newServer = null;
            Statement pStmt = null;
            DBConnection dbConn = null;
            int serialNumber = -1;
            int replicate = 0;
            int dataReplicate = 0;
            int hub = 0;
            index = this.findIndexInServerList(givenServerName);
            if (index != -1) break block18;
            newServer = new ReplicationServer();
            newServer.setServerName(givenServerName);
            this.addNewReplicationServer(newServer);
            Calendar cal = Calendar.getInstance();
            cal.set(1980, 1, 1);
            dbConn = DBConnectionPool.getDBConnection("ReplicationSErverList.addToServerListIfItIsNot");
            serialNumber = dbConn.getCheckOutSerialNumber();
            pStmt = dbConn.prepareStatement("INSERT INTO xml_replication (server, last_checked, replicate, datareplicate, hub) VALUES (?, ?, ?, ?, ?, ?)");
            pStmt.setString(1, givenServerName);
            pStmt.setTimestamp(2, new Timestamp(cal.getTimeInMillis()));
            pStmt.setInt(3, replicate);
            pStmt.setInt(4, dataReplicate);
            pStmt.setInt(5, hub);
            pStmt.execute();
            pStmt.close();
            try {
                pStmt.close();
            }
            catch (Exception ee) {
                logMetacat.error((Object)("Error in ReplicationServerList.addToServerListIfItIsNot: " + ee.getMessage()));
            }
            finally {
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            }
            catch (Exception e) {
                try {
                    logMetacat.error((Object)("Error in ReplicationServerList.addToServerListIfItIsNot: " + e.getMessage()));
                }
                catch (Throwable throwable) {
                    try {
                        pStmt.close();
                    }
                    catch (Exception ee) {
                        try {
                            logMetacat.error((Object)("Error in ReplicationServerList.addToServerListIfItIsNot: " + ee.getMessage()));
                        }
                        catch (Throwable throwable2) {
                            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
                            throw throwable2;
                        }
                        DBConnectionPool.returnDBConnection(dbConn, serialNumber);
                    }
                    DBConnectionPool.returnDBConnection(dbConn, serialNumber);
                    throw throwable;
                }
                try {
                    pStmt.close();
                }
                catch (Exception ee) {
                    logMetacat.error((Object)("Error in ReplicationServerList.addToServerListIfItIsNot: " + ee.getMessage()));
                }
                finally {
                    DBConnectionPool.returnDBConnection(dbConn, serialNumber);
                }
            }
        }
    }
}

