/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.scheduler;

import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.scheduler.ScheduledJobDAO;
import edu.ucsb.nceas.metacat.scheduler.ScheduledJobParamAccess;
import edu.ucsb.nceas.metacat.scheduler.ScheduledJobParamDAO;
import edu.ucsb.nceas.metacat.shared.AccessException;
import edu.ucsb.nceas.metacat.shared.BaseAccess;
import edu.ucsb.nceas.utilities.StatusUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.quartz.Job;

public class ScheduledJobAccess
extends BaseAccess {
    private Logger logMetacat = Logger.getLogger(ScheduledJobAccess.class);

    public ScheduledJobDAO getJob(Long jobId) throws AccessException {
        ScheduledJobDAO jobDAO = null;
        PreparedStatement pstmt = null;
        DBConnection conn = null;
        int serialNumber = -1;
        try {
            conn = DBConnectionPool.getDBConnection("ScheduledJobAccess.getJob");
            serialNumber = conn.getCheckOutSerialNumber();
            String sql = "SELECT * FROM scheduled_job WHERE id = ? AND status != 'deleted'";
            pstmt = conn.prepareStatement(sql);
            pstmt.setLong(1, jobId);
            String sqlReport = "ScheduledJobAccess.getJob - SQL: " + sql;
            sqlReport = sqlReport + " [" + jobId + "]";
            this.logMetacat.info((Object)sqlReport);
            pstmt.execute();
            ResultSet resultSet = pstmt.getResultSet();
            if (resultSet.next()) {
                jobDAO = this.populateDAO(resultSet);
            }
        }
        catch (SQLException sqle) {
            try {
                throw new AccessException("ScheduledJobAccess.getJob - SQL error when getting scheduled job: " + jobId + " : " + sqle.getMessage());
            }
            catch (Throwable throwable) {
                this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
                throw throwable;
            }
        }
        this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
        ScheduledJobParamAccess jobParamAccess = new ScheduledJobParamAccess();
        Vector<ScheduledJobParamDAO> jobParamList = jobParamAccess.getJobParamsForJobId(jobDAO.getId());
        for (ScheduledJobParamDAO jobParamDAO : jobParamList) {
            jobDAO.addJobParam(jobParamDAO);
        }
        return jobDAO;
    }

    public ScheduledJobDAO getJobByName(String jobName) throws AccessException {
        ScheduledJobDAO jobDAO = null;
        PreparedStatement pstmt = null;
        DBConnection conn = null;
        int serialNumber = -1;
        try {
            conn = DBConnectionPool.getDBConnection("ScheduledJobAccess.getJobByName");
            serialNumber = conn.getCheckOutSerialNumber();
            String sql = "SELECT * FROM scheduled_job WHERE name = ? AND status != 'deleted'";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, jobName);
            String sqlReport = "ScheduledJobAccess.getJobByName - SQL: " + sql;
            sqlReport = sqlReport + " [" + jobName + "]";
            this.logMetacat.info((Object)sqlReport);
            pstmt.execute();
            ResultSet resultSet = pstmt.getResultSet();
            if (!resultSet.next()) {
                throw new AccessException("ScheduledJobAccess.getJobByName - could not find scheduled job with name: " + jobName);
            }
            jobDAO = this.populateDAO(resultSet);
        }
        catch (SQLException sqle) {
            try {
                throw new AccessException("ScheduledJobAccess.getJobByName - SQL error when getting scheduled job by name: " + jobName + " : " + sqle.getMessage());
            }
            catch (Throwable throwable) {
                this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
                throw throwable;
            }
        }
        this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
        ScheduledJobParamAccess jobParamAccess = new ScheduledJobParamAccess();
        Vector<ScheduledJobParamDAO> jobParamList = jobParamAccess.getJobParamsForJobId(jobDAO.getId());
        for (ScheduledJobParamDAO jobParamDAO : jobParamList) {
            jobDAO.addJobParam(jobParamDAO);
        }
        return jobDAO;
    }

    public HashMap<Long, ScheduledJobDAO> getJobsWithParameter(String groupName, String paramName, String paramValue) throws AccessException {
        HashMap<Long, ScheduledJobDAO> allJobsMap = this.getAllJobs(groupName);
        HashMap<Long, ScheduledJobDAO> jobsWithParamMap = new HashMap<Long, ScheduledJobDAO>();
        for (Long jobDAOId : allJobsMap.keySet()) {
            ScheduledJobParamDAO jobParamDAO;
            ScheduledJobDAO jobDAO = allJobsMap.get(jobDAOId);
            if (paramValue == null || paramName == null || (jobParamDAO = jobDAO.getJobParam(paramName)) == null || !jobParamDAO.getValue().equals(paramValue)) continue;
            jobsWithParamMap.put(jobDAOId, jobDAO);
        }
        return jobsWithParamMap;
    }

    public HashMap<Long, ScheduledJobDAO> getAllJobs(String groupName) throws AccessException {
        HashMap<Long, ScheduledJobDAO> hashMap;
        ScheduledJobDAO jobDAO = null;
        HashMap<Long, ScheduledJobDAO> allJobDAOs = new HashMap<Long, ScheduledJobDAO>();
        PreparedStatement pstmt = null;
        DBConnection conn = null;
        int serialNumber = -1;
        try {
            conn = DBConnectionPool.getDBConnection("ScheduledJobAccess.getAllJobs");
            serialNumber = conn.getCheckOutSerialNumber();
            String sql = "SELECT * FROM scheduled_job WHERE status != 'deleted'";
            if (groupName != null) {
                sql = sql + " AND group_name = ?";
            }
            pstmt = conn.prepareStatement(sql);
            String sqlReport = "ScheduledJobAccess.getAllJobs - SQL: " + sql;
            if (groupName != null) {
                pstmt.setString(1, groupName);
                sqlReport = sqlReport + " [" + groupName + "]";
            }
            this.logMetacat.info((Object)sqlReport);
            pstmt.execute();
            ResultSet resultSet = pstmt.getResultSet();
            while (resultSet.next()) {
                jobDAO = this.populateDAO(resultSet);
                allJobDAOs.put(jobDAO.getId(), jobDAO);
            }
            ScheduledJobParamAccess jobParamAccess = new ScheduledJobParamAccess();
            Vector<ScheduledJobParamDAO> jobParamList = jobParamAccess.getAllJobParams();
            for (ScheduledJobParamDAO jobParamDAO : jobParamList) {
                Long jobId = jobParamDAO.getJobId();
                if (!allJobDAOs.containsKey(jobId)) continue;
                allJobDAOs.get(jobId).addJobParam(jobParamDAO);
            }
            hashMap = allJobDAOs;
        }
        catch (SQLException sqle) {
            try {
                throw new AccessException("ScheduledJobAccess.getJobByName - SQL error when getting all jobs : " + sqle.getMessage());
            }
            catch (Throwable throwable) {
                this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
                throw throwable;
            }
        }
        this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
        return hashMap;
    }

    public void createJob(String name, String triggerName, String groupName, Class<Job> jobClass, Calendar startTime, Calendar endTime, int intervalValue, String intervalUnit, HashMap<String, String> jobParams) throws AccessException {
        ScheduledJobDAO jobDAO = new ScheduledJobDAO();
        jobDAO.setStatus(StatusUtil.SCHEDULED);
        jobDAO.setName(name);
        jobDAO.setTriggerName(name);
        jobDAO.setGroupName(groupName);
        jobDAO.setClassName(jobClass.getName());
        jobDAO.setStartTime(new Timestamp(startTime.getTimeInMillis()));
        jobDAO.setEndTime(new Timestamp(endTime.getTimeInMillis()));
        jobDAO.setIntervalValue(intervalValue);
        jobDAO.setIntervalUnit(intervalUnit);
        this.createJob(jobDAO, jobParams);
    }

    public void createJob(ScheduledJobDAO jobDAO, HashMap<String, String> jobParams) throws AccessException {
        PreparedStatement pstmt = null;
        DBConnection conn = null;
        int serialNumber = -1;
        try {
            conn = DBConnectionPool.getDBConnection("ScheduledJobAccess.createJob");
            serialNumber = conn.getCheckOutSerialNumber();
            String sql = "INSERT INTO scheduled_job (date_created, date_updated, status, name, trigger_name, group_name, class_name, start_time, end_time, interval_value, interval_unit) VALUES(now(), now(), ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, jobDAO.getStatus());
            pstmt.setString(2, jobDAO.getName());
            pstmt.setString(3, jobDAO.getTriggerName());
            pstmt.setString(4, jobDAO.getGroupName());
            pstmt.setString(5, jobDAO.getClassName());
            pstmt.setTimestamp(6, jobDAO.getStartTime());
            pstmt.setTimestamp(7, jobDAO.getEndTime());
            pstmt.setInt(8, jobDAO.getIntervalValue());
            pstmt.setString(9, jobDAO.getIntervalUnit());
            String sqlReport = "ScheduledJobAccess.createJob - SQL: " + sql + " [" + jobDAO.getStatus() + "," + jobDAO.getName() + "," + jobDAO.getTriggerName() + "," + jobDAO.getGroupName() + "," + jobDAO.getClassName() + ",(Timestamp)" + jobDAO.getStartTime().toString() + ",";
            sqlReport = jobDAO.getEndTime() == null ? sqlReport + "null," : sqlReport + jobDAO.getEndTime().toString() + ",";
            sqlReport = sqlReport + jobDAO.getIntervalValue() + "," + jobDAO.getIntervalUnit() + "]";
            this.logMetacat.info((Object)sqlReport);
            pstmt.execute();
        }
        catch (SQLException sqle) {
            try {
                throw new AccessException("ScheduledJobAccess.createJob - SQL error when creating scheduled job " + jobDAO.getName() + " : " + sqle.getMessage());
            }
            catch (Throwable throwable) {
                this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
                throw throwable;
            }
        }
        this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
        if (jobParams.size() > 0) {
            ScheduledJobParamAccess scheduledJobParamsAccess = null;
            ScheduledJobDAO updatedJobDAO = null;
            try {
                updatedJobDAO = this.getJobByName(jobDAO.getName());
                scheduledJobParamsAccess = new ScheduledJobParamAccess();
                scheduledJobParamsAccess.createJobParams(updatedJobDAO.getId(), jobParams);
            }
            catch (AccessException ae) {
                if (updatedJobDAO != null) {
                    updatedJobDAO.setStatus(StatusUtil.DELETED);
                    this.updateJobStatus(updatedJobDAO);
                    scheduledJobParamsAccess.deleteJobParams(updatedJobDAO.getId());
                }
                this.logMetacat.warn((Object)("ScheduledJobAccess.createJob - Tried to delete non-existant scheduled job: " + jobDAO.getName()));
            }
        }
    }

    public void updateJobStatus(ScheduledJobDAO jobDAO) throws AccessException {
        if (jobDAO == null) {
            throw new AccessException("ScheduledJobAccess.updateJobStatus - job DAO cannot be null.");
        }
        PreparedStatement pstmt = null;
        DBConnection conn = null;
        int serialNumber = -1;
        try {
            conn = DBConnectionPool.getDBConnection("ScheduledJobAccess.createJob");
            serialNumber = conn.getCheckOutSerialNumber();
            String sql = "UPDATE scheduled_job SET status = ? WHERE id = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, jobDAO.getStatus());
            pstmt.setLong(2, jobDAO.getId());
            String sqlReport = "ScheduledJobAccess.deleteJob - SQL: " + sql + " [" + jobDAO.getStatus() + "," + jobDAO.getId() + "]";
            this.logMetacat.info((Object)sqlReport);
            pstmt.execute();
        }
        catch (SQLException sqle) {
            try {
                throw new AccessException("ScheduledJobAccess.deleteJob - SQL error when deleting scheduled job " + jobDAO.getName() + " : " + sqle.getMessage());
            }
            catch (Throwable throwable) {
                this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
                throw throwable;
            }
        }
        this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
    }

    @Override
    protected ScheduledJobDAO populateDAO(ResultSet resultSet) throws SQLException {
        ScheduledJobDAO jobDAO = new ScheduledJobDAO();
        jobDAO.setId(resultSet.getLong("id"));
        jobDAO.setCreateTime(resultSet.getTimestamp("date_created"));
        jobDAO.setModTime(resultSet.getTimestamp("date_updated"));
        jobDAO.setStatus(resultSet.getString("status"));
        jobDAO.setName(resultSet.getString("name"));
        jobDAO.setTriggerName(resultSet.getString("trigger_name"));
        jobDAO.setGroupName(resultSet.getString("group_name"));
        jobDAO.setClassName(resultSet.getString("class_name"));
        jobDAO.setStartTime(resultSet.getTimestamp("start_time"));
        jobDAO.setEndTime(resultSet.getTimestamp("end_time"));
        jobDAO.setIntervalValue(resultSet.getInt("interval_value"));
        jobDAO.setIntervalUnit(resultSet.getString("interval_unit"));
        return jobDAO;
    }
}

