/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.util.Arrays;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.cucadiagram.Entity;
import net.sourceforge.plantuml.graph.AbstractEntityImage;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.ColorMapper;

class EntityImageDefault
extends AbstractEntityImage {
    private final TextBlock textBlock;

    public EntityImageDefault(Entity entity) {
        super(entity);
        this.textBlock = TextBlockUtils.create(Arrays.asList(entity.getDisplay()), new FontConfiguration(this.getFont14(), HtmlColor.BLACK), HorizontalAlignement.CENTER);
    }

    public Dimension2D getDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.textBlock.calculateDimension(stringBounder);
        return new Dimension2DDouble(dimension2D.getWidth(), dimension2D.getHeight());
    }

    public void draw(ColorMapper colorMapper, Graphics2D graphics2D) {
        Dimension2D dimension2D = this.textBlock.calculateDimension(StringBounderUtils.asStringBounder(graphics2D));
        int n = (int)dimension2D.getWidth();
        int n2 = (int)dimension2D.getHeight();
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawRect(0, 0, n, n2);
        this.textBlock.drawTOBEREMOVED(colorMapper, graphics2D, 0.0, 0.0);
    }
}

