/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.awt.geom.Dimension2D;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentRoseGroupingHeader
extends AbstractTextualComponent {
    private final int cornersize = 10;
    private final int commentMargin = 0;
    private final TextBlock commentTextBlock;
    private final HtmlColor groupBackground;
    private final HtmlColor groupBorder;
    private final HtmlColor background;

    public ComponentRoseGroupingHeader(HtmlColor htmlColor, HtmlColor htmlColor2, HtmlColor htmlColor3, HtmlColor htmlColor4, UFont uFont, UFont uFont2, List<? extends CharSequence> list) {
        super(list.get(0), htmlColor, uFont, HorizontalAlignement.LEFT, 15, 30, 1);
        this.groupBackground = htmlColor3;
        this.groupBorder = htmlColor4;
        this.background = htmlColor2;
        this.commentTextBlock = list.size() == 1 || list.get(1) == null ? null : TextBlockUtils.create(Arrays.asList("[" + list.get(1) + "]"), new FontConfiguration(uFont2, htmlColor), HorizontalAlignement.LEFT);
    }

    @Override
    public double getPaddingY() {
        return 6.0;
    }

    @Override
    public final double getPreferredWidth(StringBounder stringBounder) {
        double d;
        if (this.commentTextBlock == null) {
            d = 0.0;
        } else {
            Dimension2D dimension2D = this.commentTextBlock.calculateDimension(stringBounder);
            d = (double)(this.getMarginX1() + 0) + dimension2D.getWidth();
        }
        return this.getTextWidth(stringBounder) + d;
    }

    @Override
    public final double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 2.0 * this.getPaddingY();
    }

    @Override
    protected void drawBackgroundInternalU(UGraphic uGraphic, Dimension2D dimension2D) {
        if (this.background == null) {
            return;
        }
        uGraphic.getParam().setColor(null);
        uGraphic.getParam().setBackcolor(this.background);
        uGraphic.draw(0.0, 0.0, new URectangle(dimension2D.getWidth(), dimension2D.getHeight()));
    }

    @Override
    protected void drawInternalU(UGraphic uGraphic, Dimension2D dimension2D) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        int n = (int)this.getTextWidth(stringBounder);
        int n2 = (int)this.getTextHeight(stringBounder);
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(n, 0.0);
        uPolygon.addPoint(n, n2 - 10);
        uPolygon.addPoint(n - 10, n2);
        uPolygon.addPoint(0.0, n2);
        uPolygon.addPoint(0.0, 0.0);
        uGraphic.getParam().setStroke(new UStroke(2.0));
        uGraphic.getParam().setColor(this.groupBorder);
        uGraphic.getParam().setBackcolor(this.groupBackground);
        uGraphic.draw(0.0, 0.0, uPolygon);
        double d = dimension2D.getHeight() - this.getPaddingY();
        uGraphic.draw(0.0, 0.0, new ULine(dimension2D.getWidth(), 0.0));
        uGraphic.draw(dimension2D.getWidth(), 0.0, new ULine(0.0, d));
        uGraphic.draw(0.0, n2, new ULine(0.0, d - (double)n2));
        uGraphic.getParam().setStroke(new UStroke());
        this.getTextBlock().drawU(uGraphic, this.getMarginX1(), this.getMarginY());
        if (this.commentTextBlock != null) {
            int n3 = this.getMarginX1() + n;
            int n4 = this.getMarginY() + 1;
            this.commentTextBlock.drawU(uGraphic, n3 + 0, n4);
        }
    }
}

