/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import java.awt.geom.Dimension2D;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockEmpty;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.skin.AbstractComponent;
import net.sourceforge.plantuml.ugraphic.UFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTextualComponent
extends AbstractComponent {
    private final List<? extends CharSequence> strings;
    private final int marginX1;
    private final int marginX2;
    private final int marginY;
    private final TextBlock textBlock;
    private final UFont font;
    private final HtmlColor fontColor;
    private Dimension2D size;

    public AbstractTextualComponent(CharSequence charSequence, HtmlColor htmlColor, UFont uFont, HorizontalAlignement horizontalAlignement, int n, int n2, int n3) {
        this(Arrays.asList(charSequence == null ? "" : charSequence), htmlColor, uFont, horizontalAlignement, n, n2, n3);
    }

    public AbstractTextualComponent(List<? extends CharSequence> list, HtmlColor htmlColor, UFont uFont, HorizontalAlignement horizontalAlignement, int n, int n2, int n3) {
        this.font = uFont;
        this.fontColor = htmlColor;
        this.marginX1 = n;
        this.marginX2 = n2;
        this.marginY = n3;
        this.strings = list;
        this.textBlock = list.size() == 1 && list.get(0).length() == 0 ? new TextBlockEmpty() : TextBlockUtils.create(list, new FontConfiguration(uFont, htmlColor), horizontalAlignement);
    }

    protected final TextBlock getTextBlock() {
        return this.textBlock;
    }

    protected final double getPureTextWidth(StringBounder stringBounder) {
        TextBlock textBlock = this.getTextBlock();
        Dimension2D dimension2D = this.getSize(stringBounder, textBlock);
        return dimension2D.getWidth();
    }

    public final double getTextWidth(StringBounder stringBounder) {
        return this.getPureTextWidth(stringBounder) + (double)this.marginX1 + (double)this.marginX2;
    }

    private Dimension2D getSize(StringBounder stringBounder, TextBlock textBlock) {
        if (this.size == null) {
            this.size = textBlock.calculateDimension(stringBounder);
        }
        return this.size;
    }

    protected final double getTextHeight(StringBounder stringBounder) {
        TextBlock textBlock = this.getTextBlock();
        Dimension2D dimension2D = this.getSize(stringBounder, textBlock);
        return dimension2D.getHeight() + (double)(2 * this.marginY);
    }

    protected final List<? extends CharSequence> getLabels() {
        return this.strings;
    }

    protected final int getMarginX1() {
        return this.marginX1;
    }

    protected final int getMarginX2() {
        return this.marginX2;
    }

    protected final int getMarginY() {
        return this.marginY;
    }

    protected final UFont getFont() {
        return this.font;
    }

    protected HtmlColor getFontColor() {
        return this.fontColor;
    }
}

