/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.AlignParam;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.skin.rose.ComponentRoseActiveLine;
import net.sourceforge.plantuml.skin.rose.ComponentRoseActor;
import net.sourceforge.plantuml.skin.rose.ComponentRoseArrow;
import net.sourceforge.plantuml.skin.rose.ComponentRoseDelayLine;
import net.sourceforge.plantuml.skin.rose.ComponentRoseDelayText;
import net.sourceforge.plantuml.skin.rose.ComponentRoseDestroy;
import net.sourceforge.plantuml.skin.rose.ComponentRoseDivider;
import net.sourceforge.plantuml.skin.rose.ComponentRoseEnglober;
import net.sourceforge.plantuml.skin.rose.ComponentRoseGroupingBody;
import net.sourceforge.plantuml.skin.rose.ComponentRoseGroupingElse;
import net.sourceforge.plantuml.skin.rose.ComponentRoseGroupingHeader;
import net.sourceforge.plantuml.skin.rose.ComponentRoseGroupingTail;
import net.sourceforge.plantuml.skin.rose.ComponentRoseLine;
import net.sourceforge.plantuml.skin.rose.ComponentRoseNewpage;
import net.sourceforge.plantuml.skin.rose.ComponentRoseNote;
import net.sourceforge.plantuml.skin.rose.ComponentRoseParticipant;
import net.sourceforge.plantuml.skin.rose.ComponentRoseReference;
import net.sourceforge.plantuml.skin.rose.ComponentRoseSelfArrow;
import net.sourceforge.plantuml.skin.rose.ComponentRoseTitle;
import net.sourceforge.plantuml.ugraphic.UFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rose
implements Skin {
    private final Map<ColorParam, HtmlColor> defaultsColor = new EnumMap<ColorParam, HtmlColor>(ColorParam.class);

    public Rose() {
        this.defaultsColor.put(ColorParam.background, HtmlColor.getColorIfValid("white"));
        this.defaultsColor.put(ColorParam.sequenceArrow, HtmlColor.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.usecaseArrow, HtmlColor.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.classArrow, HtmlColor.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.objectArrow, HtmlColor.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.activityArrow, HtmlColor.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.componentArrow, HtmlColor.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.stateArrow, HtmlColor.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.sequenceLifeLineBackground, HtmlColor.getColorIfValid("white"));
        this.defaultsColor.put(ColorParam.sequenceLifeLineBorder, HtmlColor.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.sequenceGroupBackground, HtmlColor.getColorIfValid("#EEEEEE"));
        this.defaultsColor.put(ColorParam.sequenceGroupBorder, HtmlColor.BLACK);
        this.defaultsColor.put(ColorParam.sequenceDividerBackground, HtmlColor.getColorIfValid("#EEEEEE"));
        this.defaultsColor.put(ColorParam.sequenceReferenceBorder, HtmlColor.BLACK);
        this.defaultsColor.put(ColorParam.sequenceReferenceBackground, HtmlColor.getColorIfValid("white"));
        this.defaultsColor.put(ColorParam.sequenceReferenceHeaderBackground, HtmlColor.getColorIfValid("#EEEEEE"));
        this.defaultsColor.put(ColorParam.sequenceBoxBorder, HtmlColor.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.sequenceBoxBackground, HtmlColor.getColorIfValid("#DDDDDD"));
        this.defaultsColor.put(ColorParam.noteBackground, HtmlColor.getColorIfValid("#FBFB77"));
        this.defaultsColor.put(ColorParam.noteBorder, HtmlColor.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.activityBackground, HtmlColor.getColorIfValid("#FEFECE"));
        this.defaultsColor.put(ColorParam.activityBorder, HtmlColor.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.activityStart, HtmlColor.BLACK);
        this.defaultsColor.put(ColorParam.activityEnd, HtmlColor.BLACK);
        this.defaultsColor.put(ColorParam.activityBar, HtmlColor.BLACK);
        this.defaultsColor.put(ColorParam.stateBackground, HtmlColor.getColorIfValid("#FEFECE"));
        this.defaultsColor.put(ColorParam.stateBorder, HtmlColor.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.stateStart, HtmlColor.BLACK);
        this.defaultsColor.put(ColorParam.stateEnd, HtmlColor.BLACK);
        this.defaultsColor.put(ColorParam.usecaseBackground, HtmlColor.getColorIfValid("#FEFECE"));
        this.defaultsColor.put(ColorParam.usecaseBorder, HtmlColor.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.componentBackground, HtmlColor.getColorIfValid("#FEFECE"));
        this.defaultsColor.put(ColorParam.componentBorder, HtmlColor.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.componentInterfaceBackground, HtmlColor.getColorIfValid("#FEFECE"));
        this.defaultsColor.put(ColorParam.componentInterfaceBorder, HtmlColor.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.usecaseActorBackground, HtmlColor.getColorIfValid("#FEFECE"));
        this.defaultsColor.put(ColorParam.usecaseActorBorder, HtmlColor.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.sequenceActorBackground, HtmlColor.getColorIfValid("#FEFECE"));
        this.defaultsColor.put(ColorParam.sequenceActorBorder, HtmlColor.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.sequenceParticipantBackground, HtmlColor.getColorIfValid("#FEFECE"));
        this.defaultsColor.put(ColorParam.sequenceParticipantBorder, HtmlColor.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.classBackground, HtmlColor.getColorIfValid("#FEFECE"));
        this.defaultsColor.put(ColorParam.classBorder, HtmlColor.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.objectBackground, HtmlColor.getColorIfValid("#FEFECE"));
        this.defaultsColor.put(ColorParam.objectBorder, HtmlColor.getColorIfValid("#A80036"));
        this.defaultsColor.put(ColorParam.stereotypeCBackground, HtmlColor.getColorIfValid("#ADD1B2"));
        this.defaultsColor.put(ColorParam.stereotypeABackground, HtmlColor.getColorIfValid("#A9DCDF"));
        this.defaultsColor.put(ColorParam.stereotypeIBackground, HtmlColor.getColorIfValid("#B4A7E5"));
        this.defaultsColor.put(ColorParam.stereotypeEBackground, HtmlColor.getColorIfValid("#EB937F"));
        this.defaultsColor.put(ColorParam.packageBackground, HtmlColor.getColorIfValid("#FEFECE"));
        this.defaultsColor.put(ColorParam.packageBorder, HtmlColor.BLACK);
        this.defaultsColor.put(ColorParam.iconPrivate, HtmlColor.getColorIfValid("#C82930"));
        this.defaultsColor.put(ColorParam.iconPrivateBackground, HtmlColor.getColorIfValid("#F24D5C"));
        this.defaultsColor.put(ColorParam.iconProtected, HtmlColor.getColorIfValid("#B38D22"));
        this.defaultsColor.put(ColorParam.iconProtectedBackground, HtmlColor.getColorIfValid("#FFFF44"));
        this.defaultsColor.put(ColorParam.iconPackage, HtmlColor.getColorIfValid("#1963A0"));
        this.defaultsColor.put(ColorParam.iconPackageBackground, HtmlColor.getColorIfValid("#4177AF"));
        this.defaultsColor.put(ColorParam.iconPublic, HtmlColor.getColorIfValid("#038048"));
        this.defaultsColor.put(ColorParam.iconPublicBackground, HtmlColor.getColorIfValid("#84BE84"));
    }

    public HtmlColor getFontColor(ISkinParam iSkinParam, FontParam fontParam) {
        return iSkinParam.getFontHtmlColor(fontParam, null);
    }

    public HtmlColor getHtmlColor(ISkinParam iSkinParam, ColorParam colorParam) {
        return this.getHtmlColor(iSkinParam, colorParam, null);
    }

    public HtmlColor getHtmlColor(ISkinParam iSkinParam, ColorParam colorParam, String string) {
        HtmlColor htmlColor = iSkinParam.getHtmlColor(colorParam, string);
        if (htmlColor == null && (htmlColor = this.defaultsColor.get((Object)colorParam)) == null) {
            throw new IllegalArgumentException();
        }
        return htmlColor;
    }

    @Override
    public Component createComponent(ComponentType componentType, ISkinParam iSkinParam, List<? extends CharSequence> list) {
        HtmlColor htmlColor = iSkinParam.getBackgroundColor();
        HtmlColor htmlColor2 = this.getHtmlColor(iSkinParam, ColorParam.sequenceGroupBorder);
        HtmlColor htmlColor3 = this.getHtmlColor(iSkinParam, ColorParam.sequenceGroupBackground);
        HtmlColor htmlColor4 = this.getHtmlColor(iSkinParam, ColorParam.sequenceDividerBackground);
        HtmlColor htmlColor5 = this.getHtmlColor(iSkinParam, ColorParam.sequenceReferenceBackground);
        HtmlColor htmlColor6 = this.getHtmlColor(iSkinParam, ColorParam.sequenceReferenceHeaderBackground);
        HtmlColor htmlColor7 = this.getHtmlColor(iSkinParam, ColorParam.sequenceReferenceBorder);
        HtmlColor htmlColor8 = this.getHtmlColor(iSkinParam, ColorParam.sequenceLifeLineBackground);
        HtmlColor htmlColor9 = this.getHtmlColor(iSkinParam, ColorParam.sequenceArrow);
        HtmlColor htmlColor10 = this.getHtmlColor(iSkinParam, ColorParam.sequenceActorBackground);
        HtmlColor htmlColor11 = this.getHtmlColor(iSkinParam, ColorParam.sequenceParticipantBackground);
        UFont uFont = iSkinParam.getFont(FontParam.SEQUENCE_ARROW, null);
        UFont uFont2 = iSkinParam.getFont(FontParam.SEQUENCE_GROUP, null);
        UFont uFont3 = iSkinParam.getFont(FontParam.SEQUENCE_PARTICIPANT, null);
        UFont uFont4 = iSkinParam.getFont(FontParam.SEQUENCE_ACTOR, null);
        if (componentType.isArrow()) {
            if (componentType.getArrowConfiguration().isSelfArrow()) {
                return new ComponentRoseSelfArrow(htmlColor9, this.getFontColor(iSkinParam, FontParam.SEQUENCE_ARROW), uFont, list, componentType.getArrowConfiguration());
            }
            return new ComponentRoseArrow(htmlColor9, this.getFontColor(iSkinParam, FontParam.SEQUENCE_ARROW), uFont, list, componentType.getArrowConfiguration(), iSkinParam.getHorizontalAlignement(AlignParam.SEQUENCE_MESSAGE_ALIGN));
        }
        if (componentType == ComponentType.PARTICIPANT_HEAD) {
            HtmlColor htmlColor12 = this.getHtmlColor(iSkinParam, ColorParam.sequenceParticipantBorder);
            return new ComponentRoseParticipant(htmlColor11, htmlColor12, this.getFontColor(iSkinParam, FontParam.SEQUENCE_PARTICIPANT), uFont3, list);
        }
        if (componentType == ComponentType.PARTICIPANT_TAIL) {
            HtmlColor htmlColor13 = this.getHtmlColor(iSkinParam, ColorParam.sequenceParticipantBorder);
            return new ComponentRoseParticipant(htmlColor11, htmlColor13, this.getFontColor(iSkinParam, FontParam.SEQUENCE_PARTICIPANT), uFont3, list);
        }
        if (componentType == ComponentType.PARTICIPANT_LINE) {
            HtmlColor htmlColor14 = this.getHtmlColor(iSkinParam, ColorParam.sequenceLifeLineBorder);
            return new ComponentRoseLine(htmlColor14, false);
        }
        if (componentType == ComponentType.CONTINUE_LINE) {
            HtmlColor htmlColor15 = this.getHtmlColor(iSkinParam, ColorParam.sequenceLifeLineBorder);
            return new ComponentRoseLine(htmlColor15, true);
        }
        if (componentType == ComponentType.ACTOR_HEAD) {
            HtmlColor htmlColor16 = this.getHtmlColor(iSkinParam, ColorParam.sequenceActorBorder);
            return new ComponentRoseActor(htmlColor10, htmlColor16, this.getFontColor(iSkinParam, FontParam.SEQUENCE_ACTOR), uFont4, list, true);
        }
        if (componentType == ComponentType.ACTOR_TAIL) {
            HtmlColor htmlColor17 = this.getHtmlColor(iSkinParam, ColorParam.sequenceActorBorder);
            return new ComponentRoseActor(htmlColor10, htmlColor17, this.getFontColor(iSkinParam, FontParam.SEQUENCE_ACTOR), uFont4, list, false);
        }
        if (componentType == ComponentType.NOTE) {
            HtmlColor htmlColor18 = this.getHtmlColor(iSkinParam, ColorParam.noteBackground);
            HtmlColor htmlColor19 = this.getHtmlColor(iSkinParam, ColorParam.noteBorder);
            UFont uFont5 = iSkinParam.getFont(FontParam.NOTE, null);
            return new ComponentRoseNote(htmlColor18, htmlColor19, this.getFontColor(iSkinParam, FontParam.NOTE), uFont5, list);
        }
        if (componentType == ComponentType.GROUPING_HEADER) {
            UFont uFont6 = iSkinParam.getFont(FontParam.SEQUENCE_GROUP_HEADER, null);
            return new ComponentRoseGroupingHeader(this.getFontColor(iSkinParam, FontParam.SEQUENCE_GROUP_HEADER), htmlColor, htmlColor3, htmlColor2, uFont6, uFont2, list);
        }
        if (componentType == ComponentType.GROUPING_BODY) {
            return new ComponentRoseGroupingBody(htmlColor, htmlColor2);
        }
        if (componentType == ComponentType.GROUPING_TAIL) {
            return new ComponentRoseGroupingTail(this.getFontColor(iSkinParam, FontParam.SEQUENCE_GROUP), htmlColor2);
        }
        if (componentType == ComponentType.GROUPING_ELSE) {
            return new ComponentRoseGroupingElse(this.getFontColor(iSkinParam, FontParam.SEQUENCE_GROUP), htmlColor2, uFont2, list.get(0));
        }
        if (componentType == ComponentType.ALIVE_BOX_CLOSE_CLOSE) {
            HtmlColor htmlColor20 = this.getHtmlColor(iSkinParam, ColorParam.sequenceLifeLineBorder);
            return new ComponentRoseActiveLine(htmlColor20, htmlColor8, true, true);
        }
        if (componentType == ComponentType.ALIVE_BOX_CLOSE_OPEN) {
            HtmlColor htmlColor21 = this.getHtmlColor(iSkinParam, ColorParam.sequenceLifeLineBorder);
            return new ComponentRoseActiveLine(htmlColor21, htmlColor8, true, false);
        }
        if (componentType == ComponentType.ALIVE_BOX_OPEN_CLOSE) {
            HtmlColor htmlColor22 = this.getHtmlColor(iSkinParam, ColorParam.sequenceLifeLineBorder);
            return new ComponentRoseActiveLine(htmlColor22, htmlColor8, false, true);
        }
        if (componentType == ComponentType.ALIVE_BOX_OPEN_OPEN) {
            HtmlColor htmlColor23 = this.getHtmlColor(iSkinParam, ColorParam.sequenceLifeLineBorder);
            return new ComponentRoseActiveLine(htmlColor23, htmlColor8, false, false);
        }
        if (componentType == ComponentType.DELAY_LINE) {
            HtmlColor htmlColor24 = this.getHtmlColor(iSkinParam, ColorParam.sequenceLifeLineBorder);
            return new ComponentRoseDelayLine(htmlColor24);
        }
        if (componentType == ComponentType.DELAY_TEXT) {
            return new ComponentRoseDelayText(this.getFontColor(iSkinParam, FontParam.SEQUENCE_DELAY), iSkinParam.getFont(FontParam.SEQUENCE_DELAY, null), list);
        }
        if (componentType == ComponentType.DESTROY) {
            HtmlColor htmlColor25 = this.getHtmlColor(iSkinParam, ColorParam.sequenceLifeLineBorder);
            return new ComponentRoseDestroy(htmlColor25);
        }
        if (componentType == ComponentType.NEWPAGE) {
            return new ComponentRoseNewpage(this.getFontColor(iSkinParam, FontParam.SEQUENCE_GROUP));
        }
        if (componentType == ComponentType.DIVIDER) {
            return new ComponentRoseDivider(this.getFontColor(iSkinParam, FontParam.SEQUENCE_DIVIDER), iSkinParam.getFont(FontParam.SEQUENCE_DIVIDER, null), htmlColor4, list);
        }
        if (componentType == ComponentType.REFERENCE) {
            HtmlColor htmlColor26 = this.getHtmlColor(iSkinParam, ColorParam.sequenceReferenceBackground);
            HtmlColor htmlColor27 = this.getHtmlColor(iSkinParam, ColorParam.sequenceReferenceHeaderBackground);
            UFont uFont7 = iSkinParam.getFont(FontParam.SEQUENCE_GROUP_HEADER, null);
            return new ComponentRoseReference(this.getFontColor(iSkinParam, FontParam.SEQUENCE_REFERENCE), this.getFontColor(iSkinParam, FontParam.SEQUENCE_GROUP), iSkinParam.getFont(FontParam.SEQUENCE_REFERENCE, null), htmlColor7, htmlColor6, htmlColor5, uFont7, list, iSkinParam.getHorizontalAlignement(AlignParam.SEQUENCE_REFERENCE_ALIGN));
        }
        if (componentType == ComponentType.TITLE) {
            return new ComponentRoseTitle(this.getFontColor(iSkinParam, FontParam.SEQUENCE_TITLE), iSkinParam.getFont(FontParam.SEQUENCE_TITLE, null), list);
        }
        if (componentType == ComponentType.SIGNATURE) {
            return new ComponentRoseTitle(HtmlColor.BLACK, uFont2, Arrays.asList("This skin was created ", "in April 2009."));
        }
        if (componentType == ComponentType.ENGLOBER) {
            HtmlColor htmlColor28 = this.getHtmlColor(iSkinParam, ColorParam.sequenceBoxBorder);
            HtmlColor htmlColor29 = this.getHtmlColor(iSkinParam, ColorParam.sequenceBoxBackground);
            return new ComponentRoseEnglober(htmlColor28, htmlColor29, list, this.getFontColor(iSkinParam, FontParam.SEQUENCE_BOX), iSkinParam.getFont(FontParam.SEQUENCE_BOX, null));
        }
        return null;
    }

    @Override
    public Object getProtocolVersion() {
        return 1;
    }
}

