/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.predicate;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import com.vividsolutions.jts.geom.util.ShortCircuitedGeometryVisitor;
import com.vividsolutions.jts.operation.predicate.SegmentIntersectionTester;
import java.util.List;

class LineIntersectsVisitor
extends ShortCircuitedGeometryVisitor {
    private Polygon rectangle;
    private CoordinateSequence rectSeq;
    private Envelope rectEnv;
    private boolean intersects = false;

    public LineIntersectsVisitor(Polygon rectangle) {
        this.rectangle = rectangle;
        this.rectSeq = rectangle.getExteriorRing().getCoordinateSequence();
        this.rectEnv = rectangle.getEnvelopeInternal();
    }

    public boolean intersects() {
        return this.intersects;
    }

    protected void visit(Geometry geom) {
        Envelope elementEnv = geom.getEnvelopeInternal();
        if (!this.rectEnv.intersects(elementEnv)) {
            return;
        }
        if (geom.getNumPoints() > 200) {
            this.intersects = this.rectangle.relate(geom).isIntersects();
            return;
        }
        this.computeSegmentIntersection(geom);
    }

    private void computeSegmentIntersection(Geometry geom) {
        SegmentIntersectionTester si = new SegmentIntersectionTester();
        List lines = LinearComponentExtracter.getLines(geom);
        boolean hasIntersection = si.hasIntersectionWithLineStrings(this.rectSeq, lines);
        if (hasIntersection) {
            this.intersects = true;
            return;
        }
    }

    protected boolean isDone() {
        return this.intersects;
    }
}

