/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.server.catalog;

import ORG.oclc.oai.server.crosswalk.Crosswalk;
import ORG.oclc.oai.server.crosswalk.CrosswalkItem;
import ORG.oclc.oai.server.crosswalk.Crosswalks;
import ORG.oclc.oai.server.verb.CannotDisseminateFormatException;
import ORG.oclc.oai.server.verb.NoMetadataFormatsException;
import ORG.oclc.oai.util.OAIUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public abstract class RecordFactory {
    public static final boolean debug = false;
    private Crosswalks crosswalks;

    public RecordFactory(Properties properties) {
        this.crosswalks = new Crosswalks(properties);
    }

    public RecordFactory(HashMap crosswalkMap) {
        this.crosswalks = new Crosswalks(crosswalkMap);
    }

    public Crosswalks getCrosswalks() {
        return this.crosswalks;
    }

    public abstract String fromOAIIdentifier(String var1);

    public Vector getSchemaLocations(Object nativeItem) throws NoMetadataFormatsException {
        if (this.isDeleted(nativeItem)) {
            throw new NoMetadataFormatsException();
        }
        Vector<String> v = new Vector<String>();
        Iterator iterator = this.getCrosswalks().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            CrosswalkItem crosswalkItem = (CrosswalkItem)entry.getValue();
            Crosswalk crosswalk = crosswalkItem.getCrosswalk();
            if (!crosswalk.isAvailableFor(nativeItem)) continue;
            v.add(crosswalk.getSchemaLocation());
        }
        return v;
    }

    public String[] createHeader(Object nativeItem) throws IllegalArgumentException {
        return RecordFactory.createHeader(this.getOAIIdentifier(nativeItem), this.getDatestamp(nativeItem), this.getSetSpecs(nativeItem), this.isDeleted(nativeItem));
    }

    public String[] createHeader(Object nativeItem, Iterator setSpecs) throws IllegalArgumentException {
        if (setSpecs == null) {
            return this.createHeader(nativeItem);
        }
        return RecordFactory.createHeader(this.getOAIIdentifier(nativeItem), this.getDatestamp(nativeItem), setSpecs, this.isDeleted(nativeItem));
    }

    public static String[] createHeader(String identifier, String datestamp, Iterator setSpecs, boolean isDeleted) throws IllegalArgumentException {
        StringBuffer xmlHeader = new StringBuffer();
        xmlHeader.append("<header");
        if (isDeleted) {
            xmlHeader.append(" status=\"deleted\"");
        }
        xmlHeader.append("><identifier>");
        xmlHeader.append(OAIUtil.xmlEncode(identifier));
        xmlHeader.append("</identifier><datestamp>");
        xmlHeader.append(datestamp);
        xmlHeader.append("</datestamp>");
        if (setSpecs != null) {
            while (setSpecs.hasNext()) {
                xmlHeader.append("<setSpec>");
                xmlHeader.append((String)setSpecs.next());
                xmlHeader.append("</setSpec>");
            }
        }
        xmlHeader.append("</header>");
        return new String[]{xmlHeader.toString(), identifier};
    }

    public String create(Object nativeItem, String schemaURL, String metadataPrefix) throws IllegalArgumentException, CannotDisseminateFormatException {
        return this.create(nativeItem, schemaURL, metadataPrefix, null, null);
    }

    public String create(Object nativeItem, String schemaURL, String metadataPrefix, Iterator setSpecs, Iterator abouts) throws IllegalArgumentException, CannotDisseminateFormatException {
        if (this.isDeleted(nativeItem)) {
            StringBuffer sb = new StringBuffer("<record>");
            sb.append(this.createHeader(nativeItem)[0]);
            sb.append("</record>");
            return sb.toString();
        }
        String result = this.quickCreate(nativeItem, schemaURL, metadataPrefix);
        if (result == null) {
            if (setSpecs == null) {
                setSpecs = this.getSetSpecs(nativeItem);
            }
            if (abouts == null) {
                abouts = this.getAbouts(nativeItem);
            }
            result = this.create(nativeItem, schemaURL, metadataPrefix, this.getOAIIdentifier(nativeItem), this.getDatestamp(nativeItem), setSpecs, abouts, this.isDeleted(nativeItem));
        }
        return result;
    }

    public abstract String quickCreate(Object var1, String var2, String var3) throws IllegalArgumentException, CannotDisseminateFormatException;

    public String create(Object nativeItem, String schemaURL, String identifier, String datestamp, Iterator setSpecs, Iterator abouts, boolean isDeleted) throws IllegalArgumentException, CannotDisseminateFormatException {
        return this.create(nativeItem, schemaURL, null, identifier, datestamp, setSpecs, abouts, isDeleted);
    }

    public String create(Object nativeItem, String schemaURL, String metadataPrefix, String identifier, String datestamp, Iterator setSpecs, Iterator abouts, boolean isDeleted) throws IllegalArgumentException, CannotDisseminateFormatException {
        StringBuffer xmlRec = new StringBuffer();
        xmlRec.append("<record><header");
        if (isDeleted) {
            xmlRec.append(" status=\"deleted\"");
        }
        xmlRec.append("><identifier>");
        xmlRec.append(OAIUtil.xmlEncode(identifier));
        xmlRec.append("</identifier><datestamp>");
        xmlRec.append(datestamp);
        xmlRec.append("</datestamp>");
        if (setSpecs != null) {
            while (setSpecs.hasNext()) {
                xmlRec.append("<setSpec>");
                xmlRec.append((String)setSpecs.next());
                xmlRec.append("</setSpec>");
            }
        }
        xmlRec.append("</header>");
        if (!isDeleted) {
            xmlRec.append("<metadata>");
            Iterator iterator = this.getCrosswalks().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String itemPrefix = (String)entry.getKey();
                CrosswalkItem crosswalkItem = (CrosswalkItem)entry.getValue();
                Crosswalk crosswalk = crosswalkItem.getCrosswalk();
                if (schemaURL != null && (metadataPrefix != null || !crosswalk.getSchemaURL().equals(schemaURL)) && (metadataPrefix == null || !itemPrefix.equals(metadataPrefix))) continue;
                xmlRec.append(crosswalk.createMetadata(nativeItem));
                break;
            }
            xmlRec.append("</metadata>");
            if (abouts != null) {
                while (abouts.hasNext()) {
                    xmlRec.append("<about>");
                    xmlRec.append((String)abouts.next());
                    xmlRec.append("</about>");
                }
            }
        }
        xmlRec.append("</record>");
        return xmlRec.toString();
    }

    public String createMetadata(Object nativeItem, String schemaURL, String metadataPrefix) throws IllegalArgumentException, CannotDisseminateFormatException {
        return this.createMetadata(nativeItem, schemaURL, metadataPrefix, null, null);
    }

    public String createMetadata(Object nativeItem, String schemaURL, String metadataPrefix, Iterator setSpecs, Iterator abouts) throws IllegalArgumentException, CannotDisseminateFormatException {
        if (this.isDeleted(nativeItem)) {
            throw new CannotDisseminateFormatException("Record is deleted.");
        }
        String result = this.quickCreateMetadata(nativeItem, schemaURL, metadataPrefix);
        if (result == null) {
            if (setSpecs == null) {
                setSpecs = this.getSetSpecs(nativeItem);
            }
            if (abouts == null) {
                abouts = this.getAbouts(nativeItem);
            }
            result = this.createMetadata(nativeItem, schemaURL, this.isDeleted(nativeItem));
        }
        return result;
    }

    public String quickCreateMetadata(Object nativeItem, String schemaURL, String metadataPrefix) throws IllegalArgumentException {
        return null;
    }

    public String createMetadata(Object nativeItem, String schemaURL, boolean isDeleted) throws IllegalArgumentException, CannotDisseminateFormatException {
        StringBuffer xmlRec = new StringBuffer();
        if (isDeleted) {
            throw new CannotDisseminateFormatException("Record is deleted");
        }
        Iterator iterator = this.getCrosswalks().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            CrosswalkItem crosswalkItem = (CrosswalkItem)entry.getValue();
            Crosswalk crosswalk = crosswalkItem.getCrosswalk();
            if (schemaURL != null && !crosswalk.getSchemaURL().equals(schemaURL)) continue;
            xmlRec.append(crosswalk.createMetadata(nativeItem));
        }
        return xmlRec.toString();
    }

    public abstract String getOAIIdentifier(Object var1);

    public String getLocalIdentifier(Object nativeItem) {
        return this.fromOAIIdentifier(this.getOAIIdentifier(nativeItem));
    }

    public abstract String getDatestamp(Object var1);

    public abstract Iterator getSetSpecs(Object var1) throws IllegalArgumentException;

    public abstract boolean isDeleted(Object var1);

    public abstract Iterator getAbouts(Object var1);
}

