/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.server.crosswalk;

import ORG.oclc.oai.server.crosswalk.Crosswalk;
import ORG.oclc.oai.server.verb.CannotDisseminateFormatException;
import ORG.oclc.oai.server.verb.OAIInternalServerError;
import java.io.FileInputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XSLTCrosswalk
extends Crosswalk {
    private boolean debug = false;
    protected Transformer transformer = null;

    public XSLTCrosswalk(Properties properties) throws OAIInternalServerError {
        this(properties, properties.getProperty("XSLTCrosswalk.schemaLocation"), (String)null);
    }

    public XSLTCrosswalk(Properties properties, String schemaLocation, String contentType) throws OAIInternalServerError {
        this(properties, schemaLocation, contentType, (String)null);
    }

    public XSLTCrosswalk(Properties properties, String schemaLocation, String contentType, String docType) throws OAIInternalServerError {
        this(properties, schemaLocation, contentType, docType, null);
    }

    public XSLTCrosswalk(Properties properties, String schemaLocation, String contentType, String docType, String encoding) throws OAIInternalServerError {
        super(schemaLocation, contentType, docType, encoding);
        if ("true".equals(properties.getProperty("XSLTCrosswalk.debug"))) {
            this.debug = true;
        }
        try {
            String xsltName = properties.getProperty("XSLTCrosswalk.xsltName");
            if (xsltName != null) {
                StreamSource xslSource = new StreamSource(new FileInputStream(xsltName));
                TransformerFactory tFactory = TransformerFactory.newInstance();
                this.transformer = tFactory.newTransformer(xslSource);
                this.transformer.setOutputProperty("omit-xml-declaration", "yes");
                this.transformer.setOutputProperty("standalone", "no");
                this.transformer.setOutputProperty("indent", "yes");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
    }

    public boolean isAvailableFor(Object nativeItem) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createMetadata(Object nativeItem) throws CannotDisseminateFormatException {
        try {
            String xmlRec = null;
            if (nativeItem instanceof HashMap) {
                HashMap recordMap = (HashMap)nativeItem;
                xmlRec = (String)recordMap.get("recordString");
                if (xmlRec == null) {
                    xmlRec = new String((byte[])recordMap.get("recordBytes"), "UTF-8");
                }
                xmlRec = xmlRec.trim();
            } else if (nativeItem instanceof String) {
                xmlRec = (String)nativeItem;
            } else {
                throw new Exception("Unrecognized nativeItem");
            }
            if (this.debug) {
                System.out.println("XSLTCrosswalk.createMetadata: xmlRec=" + xmlRec);
            }
            if (xmlRec.startsWith("<?")) {
                int offset = xmlRec.indexOf("?>");
                xmlRec = xmlRec.substring(offset + 2);
            }
            if (this.debug) {
                System.out.println("XSLTCrosswalk.createMetadata: transformer=" + this.transformer);
            }
            if (this.transformer != null) {
                StringReader stringReader = new StringReader(xmlRec);
                StreamSource streamSource = new StreamSource(stringReader);
                StringWriter stringWriter = new StringWriter();
                XSLTCrosswalk xSLTCrosswalk = this;
                synchronized (xSLTCrosswalk) {
                    this.transformer.transform(streamSource, new StreamResult(stringWriter));
                }
                if (this.debug) {
                    System.out.println("XSLTCrosswalk.createMetadata: return=" + stringWriter.toString());
                }
                return stringWriter.toString();
            }
            return xmlRec;
        }
        catch (Exception e) {
            if (this.debug) {
                e.printStackTrace();
            }
            throw new CannotDisseminateFormatException(e.getMessage());
        }
    }
}

