/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.admin;

import edu.ucsb.nceas.metacat.IdentifierManager;
import edu.ucsb.nceas.metacat.admin.AdminException;
import edu.ucsb.nceas.metacat.admin.MetacatAdmin;
import edu.ucsb.nceas.metacat.dataone.MNodeService;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.metacat.util.RequestUtil;
import edu.ucsb.nceas.utilities.GeneralPropertyException;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.SortedProperties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dataone.client.auth.CertificateManager;
import org.dataone.client.v2.CNode;
import org.dataone.client.v2.itk.D1Client;
import org.dataone.configuration.Settings;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v2.Node;
import org.dataone.service.types.v2.NodeList;

public class D1Admin
extends MetacatAdmin {
    private static D1Admin instance = null;
    private Logger logMetacat = Logger.getLogger(D1Admin.class);

    private D1Admin() throws AdminException {
    }

    public static D1Admin getInstance() throws AdminException {
        if (instance == null) {
            instance = new D1Admin();
        }
        return instance;
    }

    public void configureDataONE(HttpServletRequest request, HttpServletResponse response) throws AdminException {
        String processForm = request.getParameter("processForm");
        String bypass = request.getParameter("bypass");
        String formErrors = (String)request.getAttribute("formErrors");
        if (processForm == null || !processForm.equals("true") || formErrors != null) {
            try {
                String cnURL = PropertyService.getProperty("D1Client.CN_URL");
                String nodeName = PropertyService.getProperty("dataone.nodeName");
                String nodeDescription = PropertyService.getProperty("dataone.nodeDescription");
                String memberNodeId = PropertyService.getProperty("dataone.nodeId");
                String nodeSynchronize = PropertyService.getProperty("dataone.nodeSynchronize");
                String subject = PropertyService.getProperty("dataone.subject");
                String contactSubject = PropertyService.getProperty("dataone.contactSubject");
                String certpath = PropertyService.getProperty("D1Client.certificate.file");
                String year = PropertyService.getProperty("dataone.nodeSynchronization.schedule.year");
                String mon = PropertyService.getProperty("dataone.nodeSynchronization.schedule.mon");
                String mday = PropertyService.getProperty("dataone.nodeSynchronization.schedule.mday");
                String wday = PropertyService.getProperty("dataone.nodeSynchronization.schedule.wday");
                String hour = PropertyService.getProperty("dataone.nodeSynchronization.schedule.hour");
                String min = PropertyService.getProperty("dataone.nodeSynchronization.schedule.min");
                String sec = PropertyService.getProperty("dataone.nodeSynchronization.schedule.sec");
                String nodeReplicate = PropertyService.getProperty("dataone.nodeReplicate");
                String numReplicas = PropertyService.getProperty("dataone.replicationpolicy.default.numreplicas");
                String preferredNodeList = PropertyService.getProperty("dataone.replicationpolicy.default.preferredNodeList");
                String blockedNodeList = PropertyService.getProperty("dataone.replicationpolicy.default.blockedNodeList");
                boolean synchronize = false;
                if (nodeSynchronize != null) {
                    synchronize = Boolean.parseBoolean(nodeSynchronize);
                }
                boolean replicate = false;
                if (nodeReplicate != null) {
                    replicate = Boolean.parseBoolean(nodeReplicate);
                }
                request.setAttribute("D1Client.CN_URL", (Object)cnURL);
                request.setAttribute("dataone.nodeName", (Object)nodeName);
                request.setAttribute("dataone.nodeDescription", (Object)nodeDescription);
                request.setAttribute("dataone.nodeId", (Object)memberNodeId);
                request.setAttribute("dataone.nodeSynchronize", (Object)Boolean.toString(synchronize));
                request.setAttribute("dataone.subject", (Object)subject);
                request.setAttribute("dataone.contactSubject", (Object)contactSubject);
                request.setAttribute("D1Client.certificate.file", (Object)certpath);
                request.setAttribute("dataone.nodeSynchronization.schedule.year", (Object)year);
                request.setAttribute("dataone.nodeSynchronization.schedule.mon", (Object)mon);
                request.setAttribute("dataone.nodeSynchronization.schedule.mday", (Object)mday);
                request.setAttribute("dataone.nodeSynchronization.schedule.wday", (Object)wday);
                request.setAttribute("dataone.nodeSynchronization.schedule.hour", (Object)hour);
                request.setAttribute("dataone.nodeSynchronization.schedule.min", (Object)min);
                request.setAttribute("dataone.nodeSynchronization.schedule.sec", (Object)sec);
                request.setAttribute("dataone.nodeReplicate", (Object)Boolean.toString(replicate));
                request.setAttribute("dataone.replicationpolicy.default.numreplicas", (Object)numReplicas);
                request.setAttribute("dataone.replicationpolicy.default.preferredNodeList", (Object)preferredNodeList);
                request.setAttribute("dataone.replicationpolicy.default.blockedNodeList", (Object)blockedNodeList);
                SortedProperties backupProperties = null;
                backupProperties = PropertyService.getMainBackupProperties();
                if (backupProperties != null) {
                    Vector backupKeys = backupProperties.getPropertyNames();
                    for (String key : backupKeys) {
                        String value = backupProperties.getProperty(key);
                        if (value == null) continue;
                        request.setAttribute(key, (Object)value);
                    }
                }
                request.setAttribute("configutil.dataoneConfigured", (Object)PropertyService.getProperty("configutil.dataoneConfigured"));
                memberNodeId = (String)request.getAttribute("dataone.nodeId");
                boolean update = this.isNodeRegistered(memberNodeId);
                request.setAttribute("dataone.isUpdate", (Object)Boolean.toString(update));
                request.setAttribute("dataone.mn.registration.submitted", (Object)PropertyService.getProperty("dataone.mn.registration.submitted"));
                request.setAttribute("dataone.mn.services.enabled", (Object)PropertyService.getProperty("dataone.mn.services.enabled"));
                RequestUtil.forwardRequest(request, response, "/admin/dataone-configuration.jsp", null);
            }
            catch (GeneralPropertyException gpe) {
                throw new AdminException("D1Admin.configureDataONE - Problem getting or setting property while initializing system properties page: " + gpe.getMessage());
            }
            catch (MetacatUtilException mue) {
                throw new AdminException("D1Admin.configureDataONE - utility problem while initializing system properties page:" + mue.getMessage());
            }
        }
        if (bypass != null && bypass.equals("true")) {
            Vector<String> processingErrors = new Vector<String>();
            Vector<String> processingSuccess = new Vector<String>();
            try {
                PropertyService.setProperty("configutil.dataoneConfigured", "bypassed");
            }
            catch (GeneralPropertyException gpe) {
                String errorMessage = "D1Admin.configureDataONE - Problem getting or setting property while processing system properties page: " + gpe.getMessage();
                this.logMetacat.error((Object)errorMessage);
                processingErrors.add(errorMessage);
            }
            try {
                if (processingErrors.size() > 0) {
                    RequestUtil.clearRequestMessages(request);
                    RequestUtil.setRequestErrors(request, processingErrors);
                    RequestUtil.forwardRequest(request, response, "/admin", null);
                }
                processingSuccess.add("DataONE configuration successfully bypassed");
                RequestUtil.clearRequestMessages(request);
                RequestUtil.setRequestSuccess(request, processingSuccess);
                RequestUtil.forwardRequest(request, response, "/admin?configureType=configure&processForm=false", null);
            }
            catch (MetacatUtilException mue) {
                throw new AdminException("D1Admin.configureDataONE - utility problem while processing dataone page: " + mue.getMessage());
            }
        } else {
            Vector<String> validationErrors = new Vector<String>();
            Vector<String> processingErrors = new Vector<String>();
            Vector<String> processingSuccess = new Vector<String>();
            try {
                validationErrors.addAll(this.validateOptions(request));
                String cnURL = request.getParameter("D1Client.CN_URL");
                String nodeName = request.getParameter("dataone.nodeName");
                String nodeDescription = request.getParameter("dataone.nodeDescription");
                String memberNodeId = request.getParameter("dataone.nodeId");
                String nodeSynchronize = request.getParameter("dataone.nodeSynchronize");
                String subject = request.getParameter("dataone.subject");
                String contactSubject = request.getParameter("dataone.contactSubject");
                String certpath = request.getParameter("D1Client.certificate.file");
                String year = request.getParameter("dataone.nodeSynchronization.schedule.year");
                String mon = request.getParameter("dataone.nodeSynchronization.schedule.mon");
                String mday = request.getParameter("dataone.nodeSynchronization.schedule.mday");
                String wday = request.getParameter("dataone.nodeSynchronization.schedule.wday");
                String hour = request.getParameter("dataone.nodeSynchronization.schedule.hour");
                String min = request.getParameter("dataone.nodeSynchronization.schedule.min");
                String sec = request.getParameter("dataone.nodeSynchronization.schedule.sec");
                String nodeReplicate = request.getParameter("dataone.nodeReplicate");
                String numReplicas = request.getParameter("dataone.replicationpolicy.default.numreplicas");
                String preferredNodeList = request.getParameter("dataone.replicationpolicy.default.preferredNodeList");
                String blockedNodeList = request.getParameter("dataone.replicationpolicy.default.blockedNodeList");
                boolean synchronize = false;
                if (nodeSynchronize != null) {
                    synchronize = Boolean.parseBoolean(nodeSynchronize);
                }
                boolean replicate = false;
                if (nodeReplicate != null) {
                    replicate = Boolean.parseBoolean(nodeReplicate);
                }
                boolean servicesEnabled = false;
                String servicesEnabledString = request.getParameter("dataone.mn.services.enabled");
                if (servicesEnabledString != null) {
                    servicesEnabled = Boolean.parseBoolean(servicesEnabledString);
                }
                if (nodeName == null) {
                    validationErrors.add("nodeName cannot be null");
                } else {
                    PropertyService.setProperty("D1Client.CN_URL", cnURL);
                    Settings.getConfiguration().setProperty("D1Client.CN_URL", (Object)cnURL);
                    PropertyService.setPropertyNoPersist("dataone.nodeName", nodeName);
                    PropertyService.setPropertyNoPersist("dataone.nodeDescription", nodeDescription);
                    PropertyService.setPropertyNoPersist("dataone.nodeSynchronize", Boolean.toString(synchronize));
                    PropertyService.setPropertyNoPersist("dataone.subject", subject);
                    PropertyService.setPropertyNoPersist("dataone.contactSubject", contactSubject);
                    PropertyService.setPropertyNoPersist("D1Client.certificate.file", certpath);
                    PropertyService.setPropertyNoPersist("dataone.nodeSynchronization.schedule.year", year);
                    PropertyService.setPropertyNoPersist("dataone.nodeSynchronization.schedule.mon", mon);
                    PropertyService.setPropertyNoPersist("dataone.nodeSynchronization.schedule.mday", mday);
                    PropertyService.setPropertyNoPersist("dataone.nodeSynchronization.schedule.wday", wday);
                    PropertyService.setPropertyNoPersist("dataone.nodeSynchronization.schedule.hour", hour);
                    PropertyService.setPropertyNoPersist("dataone.nodeSynchronization.schedule.min", min);
                    PropertyService.setPropertyNoPersist("dataone.nodeSynchronization.schedule.sec", sec);
                    PropertyService.setPropertyNoPersist("dataone.nodeReplicate", Boolean.toString(replicate));
                    PropertyService.setPropertyNoPersist("dataone.replicationpolicy.default.numreplicas", numReplicas);
                    PropertyService.setPropertyNoPersist("dataone.replicationpolicy.default.preferredNodeList", preferredNodeList);
                    PropertyService.setPropertyNoPersist("dataone.replicationpolicy.default.blockedNodeList", blockedNodeList);
                    PropertyService.setPropertyNoPersist("dataone.mn.services.enabled", Boolean.toString(servicesEnabled));
                    String existingMemberNodeId = PropertyService.getProperty("dataone.nodeId");
                    PropertyService.setPropertyNoPersist("dataone.nodeId", memberNodeId);
                    PropertyService.persistProperties();
                    PropertyService.syncToSettings();
                    PropertyService.persistMainBackupProperties();
                    this.registerDataONEMemberNode();
                    if (!existingMemberNodeId.equals(memberNodeId)) {
                        IdentifierManager.getInstance().updateAuthoritativeMemberNodeId(existingMemberNodeId, memberNodeId);
                    }
                    PropertyService.persistMainBackupProperties();
                }
            }
            catch (GeneralPropertyException gpe) {
                String errorMessage = "D1Admin.configureDataONE - Problem getting or setting property while processing system properties page: " + gpe.getMessage();
                this.logMetacat.error((Object)errorMessage);
                processingErrors.add(errorMessage);
            }
            catch (Exception e) {
                String errorMessage = "D1Admin.configureDataONE error: " + e.getMessage();
                this.logMetacat.error((Object)errorMessage);
                processingErrors.add(errorMessage);
            }
            try {
                if (validationErrors.size() > 0 || processingErrors.size() > 0) {
                    RequestUtil.clearRequestMessages(request);
                    RequestUtil.setRequestFormErrors(request, validationErrors);
                    RequestUtil.setRequestErrors(request, processingErrors);
                    RequestUtil.forwardRequest(request, response, "/admin", null);
                } else {
                    PropertyService.setProperty("configutil.dataoneConfigured", "true");
                    processingSuccess.add("DataONE successfully configured");
                    RequestUtil.clearRequestMessages(request);
                    RequestUtil.setRequestSuccess(request, processingSuccess);
                    RequestUtil.forwardRequest(request, response, "/admin?configureType=configure&processForm=false", null);
                }
            }
            catch (MetacatUtilException mue) {
                throw new AdminException("D1Admin.configureDataONE - utility problem while processing dataone configuration: " + mue.getMessage());
            }
            catch (GeneralPropertyException gpe) {
                throw new AdminException("D1Admin.configureDataONE - problem with properties while processing geoservices configuration page: " + gpe.getMessage());
            }
        }
    }

    private boolean isNodeRegistered(String nodeId) {
        boolean exists = false;
        try {
            NodeList nodes = D1Client.getCN().listNodes();
            for (Node n : nodes.getNodeList()) {
                if (!n.getIdentifier().getValue().equals(nodeId)) continue;
                exists = true;
                break;
            }
        }
        catch (BaseException e) {
            this.logMetacat.error((Object)("Could not check for node with DataONE (" + e.getCode() + "/" + e.getDetail_code() + "): " + e.getDescription()));
        }
        return exists;
    }

    private void registerDataONEMemberNode() throws BaseException, PropertyNotFoundException, GeneralPropertyException {
        this.logMetacat.debug((Object)"Get the Node description.");
        Node node = MNodeService.getInstance(null).getCapabilities();
        this.logMetacat.debug((Object)"Setting client certificate location.");
        String mnCertificatePath = PropertyService.getProperty("D1Client.certificate.file");
        CertificateManager.getInstance().setCertificateLocation(mnCertificatePath);
        CNode cn = D1Client.getCN((String)PropertyService.getProperty("D1Client.CN_URL"));
        boolean update = this.isNodeRegistered(node.getIdentifier().getValue());
        Session session = null;
        if (update) {
            this.logMetacat.debug((Object)("Updating node with DataONE. " + cn.getNodeBaseServiceUrl()));
            boolean bl = cn.updateNodeCapabilities(session, node.getIdentifier(), node);
        } else {
            this.logMetacat.debug((Object)("Registering node with DataONE. " + cn.getNodeBaseServiceUrl()));
            NodeReference mnodeRef = cn.register(session, node);
            PropertyService.setPropertyNoPersist("dataone.mn.registration.submitted", Boolean.TRUE.toString());
            PropertyService.persistProperties();
        }
    }

    @Override
    protected Vector<String> validateOptions(HttpServletRequest request) {
        Vector<String> errorVector = new Vector<String>();
        return errorVector;
    }
}

