/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.admin.upgrade.dataone;

import edu.ucsb.nceas.metacat.DBUtil;
import edu.ucsb.nceas.metacat.IdentifierManager;
import edu.ucsb.nceas.metacat.admin.AdminException;
import edu.ucsb.nceas.metacat.admin.upgrade.UpgradeUtilityInterface;
import edu.ucsb.nceas.metacat.dataone.SystemMetadataFactory;
import edu.ucsb.nceas.metacat.dataone.hazelcast.HazelcastService;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.utilities.SortedProperties;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GenerateSystemMetadata
implements UpgradeUtilityInterface {
    private static Log log = LogFactory.getLog(GenerateSystemMetadata.class);
    private int serverLocation = 1;

    @Override
    public boolean upgrade() throws AdminException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Runnable command = new Runnable(){

            @Override
            public void run() {
                try {
                    boolean bl = GenerateSystemMetadata.this.multiThreadUpgrade();
                }
                catch (AdminException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        executor.execute(command);
        executor.shutdown();
        boolean wait = false;
        if (wait) {
            log.debug((Object)"Waiting for upgrade to complete");
            try {
                executor.awaitTermination(Long.MAX_VALUE, TimeUnit.HOURS);
            }
            catch (InterruptedException e) {
                AdminException ae = new AdminException(e.getMessage());
                ae.initCause(e);
                throw ae;
            }
            log.debug((Object)"Done waiting for upgrade thread");
        }
        return true;
    }

    public boolean multiThreadUpgrade() throws AdminException {
        boolean success = true;
        boolean includeOre = false;
        boolean downloadData = false;
        try {
            List<String> idList = null;
            idList = IdentifierManager.getInstance().getLocalIdsWithNoSystemMetadata(true, this.serverLocation);
            boolean test = false;
            if (test) {
                idList = DBUtil.getAllDocids("knb-lter-gce");
                Collections.sort(idList);
                int start = 0;
                int count = 100;
                int limit = Math.min(idList.size(), start + count);
                idList = idList.subList(start, limit);
                log.debug((Object)("limiting test list to: " + start + "-" + limit));
                for (String docid : idList) {
                    log.debug((Object)("GENERATING SM TEST: " + docid));
                }
            }
            Collections.sort(idList);
            int availableProcessors = Runtime.getRuntime().availableProcessors();
            int nThreads = availableProcessors * 1;
            log.debug((Object)("Using nThreads: " + nThreads));
            ExecutorService executor = Executors.newFixedThreadPool(nThreads);
            int taskCount = 0;
            log.debug((Object)"Making sure Hazelcast is up");
            HazelcastService.getInstance();
            int fromIndex = 0;
            int toIndex = 0;
            String prefix = null;
            for (String docid : idList) {
                if (prefix == null || !docid.startsWith(prefix) || ++toIndex == idList.size()) {
                    final List<String> subList = idList.subList(fromIndex, toIndex);
                    log.debug((Object)("Grouping docid prefix: " + prefix));
                    log.debug((Object)("subList.size: " + subList.size()));
                    Runnable command = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                log.debug((Object)("Processing subList.size: " + subList.size()));
                                SystemMetadataFactory.generateSystemMetadata(subList, false, false);
                                log.debug((Object)("Done processing subList.size: " + subList.size()));
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                    };
                    executor.execute(command);
                    ++taskCount;
                    fromIndex = toIndex;
                }
                log.debug((Object)("docid: " + docid));
                String previousId = docid;
                prefix = previousId.substring(0, previousId.lastIndexOf("."));
            }
            log.info((Object)("done launching threaded tasks, count: " + taskCount));
            executor.shutdown();
            log.debug((Object)"Waiting for all threads to complete");
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.HOURS);
            log.debug((Object)"Done waiting for all threads to complete");
            PropertyService.setProperty("dataone.systemmetadata.generated", Boolean.TRUE.toString());
        }
        catch (Exception e) {
            String msg = "Problem generating missing system metadata: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            success = false;
            throw new AdminException(msg);
        }
        return success;
    }

    public int getServerLocation() {
        return this.serverLocation;
    }

    public void setServerLocation(int serverLocation) {
        this.serverLocation = serverLocation;
    }

    public static void main(String[] args) {
        try {
            SortedProperties testProperties = new SortedProperties("test/test.properties");
            testProperties.load();
            String metacatContextDir = testProperties.getProperty("metacat.contextDir");
            PropertyService.getInstance(metacatContextDir + "/WEB-INF");
            GenerateSystemMetadata upgrader = new GenerateSystemMetadata();
            if (args.length > 0) {
                String serverLocation = args[0];
                upgrader.setServerLocation(Integer.parseInt(serverLocation));
            }
            upgrader.upgrade();
        }
        catch (Exception ex) {
            System.out.println("Exception:" + ex.getMessage());
            ex.printStackTrace();
        }
    }
}

