/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.admin.upgrade.solr;

import edu.ucsb.nceas.metacat.admin.AdminException;
import edu.ucsb.nceas.metacat.admin.upgrade.solr.SolrSchemaModificationException;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.service.ServiceService;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.utilities.FileUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.StringUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.log4j.Logger;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.util.ChecksumUtil;

public class SolrSchemaUpgrader {
    private static Logger logMetacat = Logger.getLogger(SolrSchemaUpgrader.class);
    private static final String SCHEMAFILERELATIVEPATH = "/conf/schema.xml";
    private static final String MD5 = "MD5";
    private Vector<String> releasedSchemaHashList = new Vector();
    private String solrHomePath = null;
    private String metacatIndexSolrHome = null;
    private String currentHash = null;

    public SolrSchemaUpgrader() throws PropertyNotFoundException, ServiceException {
        String hashString = null;
        try {
            hashString = PropertyService.getProperty("index.schema.previous.hash");
            this.currentHash = PropertyService.getProperty("index.schema.current.hash");
            logMetacat.info((Object)("the current hash is ================== " + this.currentHash));
            this.solrHomePath = PropertyService.getProperty("solr.homeDir");
            String indexContext = PropertyService.getProperty("index.context");
            String metacatWebInf = ServiceService.getRealConfigDir();
            this.metacatIndexSolrHome = metacatWebInf + "/../../" + indexContext + "/WEB-INF/classes/solr-home";
        }
        catch (PropertyNotFoundException pnfe) {
            throw new PropertyNotFoundException("SolrSchemaUpdator.Constructor - could not get a metacat property in the metacat.properties file - " + pnfe.getMessage());
        }
        this.releasedSchemaHashList = StringUtil.toVector((String)hashString, (char)';');
        logMetacat.info((Object)("the released hash is ================== " + this.releasedSchemaHashList));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void upgrade() throws AdminException, IOException, NoSuchAlgorithmException, SolrSchemaModificationException {
        boolean solrHomeExists = new File(this.solrHomePath).exists();
        if (!solrHomeExists) {
            try {
                File sourceDir = new File(this.metacatIndexSolrHome);
                if (!sourceDir.exists()) return;
                FileUtil.createDirectory((String)this.solrHomePath);
                OrFileFilter fileFilter = new OrFileFilter();
                fileFilter.addFileFilter(DirectoryFileFilter.DIRECTORY);
                fileFilter.addFileFilter((IOFileFilter)new WildcardFileFilter("*"));
                FileUtils.copyDirectory((File)new File(this.metacatIndexSolrHome), (File)new File(this.solrHomePath), (FileFilter)fileFilter);
                return;
            }
            catch (Exception ue) {
                String errorString = "SolrSchemaUpdator.update - Could not initialize directory: " + this.solrHomePath + " : " + ue.getMessage();
                throw new AdminException(errorString);
            }
        }
        if (!FileUtil.isDirectory((String)this.solrHomePath)) {
            String errorString = "SolrSchemaUpdator.update - SOLR home is not a directory: " + this.solrHomePath;
            throw new AdminException(errorString);
        }
        File metacatIndexSchemaFile = new File(this.metacatIndexSolrHome + SCHEMAFILERELATIVEPATH);
        File schemaFile = new File(this.solrHomePath + SCHEMAFILERELATIVEPATH);
        File processDateFile = new File(this.solrHomePath + "/" + "solr-last-proccessed-date");
        if (!metacatIndexSchemaFile.exists()) return;
        if (!schemaFile.exists()) {
            FileUtils.copyFile((File)metacatIndexSchemaFile, (File)schemaFile);
            if (!processDateFile.exists()) return;
            processDateFile.delete();
            return;
        }
        FileInputStream schemaInputStream = new FileInputStream(schemaFile);
        Checksum checkSum = null;
        try {
            checkSum = ChecksumUtil.checksum((InputStream)schemaInputStream, (String)MD5);
            if (schemaInputStream != null) {
                IOUtils.closeQuietly((InputStream)schemaInputStream);
            }
        }
        finally {
            if (schemaInputStream != null) {
                IOUtils.closeQuietly((InputStream)schemaInputStream);
            }
        }
        String error1 = "SolrSchemaUpdator.update - couldn't determine if the schema.xml in the " + this.solrHomePath + "/conf" + " was modified or not. If you did modify it, please manually merge the change to the file " + this.metacatIndexSolrHome + SCHEMAFILERELATIVEPATH + " and copy it to " + this.solrHomePath + "/conf; otherwise, just copy the file " + this.metacatIndexSolrHome + SCHEMAFILERELATIVEPATH + " to " + this.solrHomePath + "/conf.";
        String error3 = "Metacat determined the schema.xml in the " + this.solrHomePath + "/conf" + " was customized. You have to manually fix the issue - merge the change to the file " + this.metacatIndexSolrHome + SCHEMAFILERELATIVEPATH + " and copy it to overwrite the schema.xml in the " + this.solrHomePath + "/conf. You may click the OK button When you finish the merging. ";
        if (checkSum == null) throw new SolrSchemaModificationException(error1);
        String checksumValue = checkSum.getValue();
        logMetacat.info((Object)("the existing schema.xml in the solr home has the checksum ================== " + checksumValue));
        if (checksumValue == null) throw new SolrSchemaModificationException(error1);
        if (checksumValue.equals(this.currentHash)) {
            logMetacat.info((Object)"=====the existing schema.xml in the solr home has the same checksum as our current release, do nothing");
            return;
        } else {
            boolean found = false;
            for (String value : this.releasedSchemaHashList) {
                if (!value.equals(checksumValue)) continue;
                found = true;
                break;
            }
            if (!found) throw new SolrSchemaModificationException(error3);
            FileUtils.copyFile((File)metacatIndexSchemaFile, (File)schemaFile);
            if (!processDateFile.exists()) return;
            processDateFile.delete();
        }
    }
}

