/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.index;

import com.hazelcast.core.MapLoader;
import com.hazelcast.core.MapStore;
import edu.ucsb.nceas.metacat.common.index.event.IndexEvent;
import edu.ucsb.nceas.metacat.index.IndexEventDAO;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.dataone.service.types.v1.Identifier;

public class IndexEventMapStore
implements MapStore<Identifier, IndexEvent>,
MapLoader<Identifier, IndexEvent> {
    private Logger logMetacat = Logger.getLogger(IndexEventMapStore.class);

    public IndexEvent load(Identifier identifier) {
        try {
            return IndexEventDAO.getInstance().get(identifier);
        }
        catch (SQLException e) {
            this.logMetacat.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Map<Identifier, IndexEvent> loadAll(Collection<Identifier> identifiers) {
        TreeMap<Identifier, IndexEvent> eventMap = new TreeMap<Identifier, IndexEvent>();
        for (Identifier identifier : identifiers) {
            IndexEvent event = null;
            try {
                event = IndexEventDAO.getInstance().get(identifier);
                eventMap.put(identifier, event);
            }
            catch (SQLException e) {
                this.logMetacat.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return eventMap;
    }

    public Set<Identifier> loadAllKeys() {
        try {
            return IndexEventDAO.getInstance().getAllIdentifiers();
        }
        catch (SQLException e) {
            this.logMetacat.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void delete(Identifier identifier) {
        try {
            IndexEventDAO.getInstance().remove(identifier);
        }
        catch (SQLException e) {
            this.logMetacat.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void deleteAll(Collection<Identifier> identifiers) {
        for (Identifier identifier : identifiers) {
            try {
                IndexEventDAO.getInstance().remove(identifier);
            }
            catch (SQLException e) {
                this.logMetacat.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void store(Identifier identifier, IndexEvent event) {
        try {
            IndexEventDAO.getInstance().add(event);
        }
        catch (SQLException e) {
            this.logMetacat.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void storeAll(Map<Identifier, IndexEvent> indexEventMap) {
        for (IndexEvent event : indexEventMap.values()) {
            try {
                IndexEventDAO.getInstance().add(event);
            }
            catch (SQLException e) {
                this.logMetacat.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

