/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.oaipmh.provider.server.catalog;

import ORG.oclc.oai.server.catalog.RecordFactory;
import edu.ucsb.nceas.metacat.oaipmh.provider.server.OAIHandler;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class MetacatRecordFactory
extends RecordFactory {
    private static final Logger logger = Logger.getLogger(MetacatRecordFactory.class);
    private String repositoryIdentifier = null;
    private String context = null;
    private final String TEST_CONTEXT = "knb";
    private final String LSID_PREFIX = "urn:lsid:knb.ecoinformatics.org:";

    public MetacatRecordFactory(Properties properties) throws IllegalArgumentException {
        super(properties);
        if (OAIHandler.isIntegratedWithMetacat()) {
            try {
                this.context = PropertyService.getProperty("application.context");
            }
            catch (PropertyNotFoundException e) {
                logger.error((Object)"PropertyNotFoundException: unable to determine application.context value");
            }
        } else {
            this.context = "knb";
        }
        this.repositoryIdentifier = properties.getProperty("oaipmh.repositoryIdentifier");
        if (this.repositoryIdentifier == null) {
            String errorStr = "oaipmh.repositoryIdentifier is missing from the properties file";
            throw new IllegalArgumentException(errorStr);
        }
    }

    public String fromOAIIdentifier(String oaiIdentifier) {
        String[] oaiIdentifierArray;
        int len;
        String localIdentifier = null;
        if (oaiIdentifier != null && (len = (oaiIdentifierArray = this.splitOAIIdentifier(oaiIdentifier)).length) >= 2) {
            String scope = oaiIdentifierArray[len - 2];
            String identifier = oaiIdentifierArray[len - 1];
            localIdentifier = scope + "." + identifier;
        }
        return localIdentifier;
    }

    public String getOAIIdentifier(Object nativeItem) {
        String[] localIdentifierArray;
        String localIdentifier = this.getLocalIdentifier(nativeItem);
        StringBuffer sb = new StringBuffer();
        if (localIdentifier != null && (localIdentifierArray = this.splitLocalIdentifier(localIdentifier)).length == 2) {
            sb.append("urn:lsid:knb.ecoinformatics.org:");
            String scope = localIdentifierArray[0];
            sb.append(scope);
            sb.append(":");
            String identifier = localIdentifierArray[1];
            sb.append(identifier);
        }
        return sb.toString();
    }

    public String getOAIIdentifierOld(Object nativeItem) {
        String localIdentifier = this.getLocalIdentifier(nativeItem);
        StringBuffer sb = new StringBuffer();
        sb.append("http://");
        sb.append(this.repositoryIdentifier);
        sb.append("/" + this.context + "/metacat/");
        sb.append(localIdentifier);
        return sb.toString();
    }

    public String getLocalIdentifier(Object nativeItem) {
        HashMap nativeItemMap = (HashMap)nativeItem;
        String localIdentifier = (String)nativeItemMap.get("localIdentifier");
        return localIdentifier;
    }

    public String getDatestamp(Object nativeItem) throws IllegalArgumentException {
        return (String)((HashMap)nativeItem).get("lastModified");
    }

    public Iterator getSetSpecs(Object nativeItem) throws IllegalArgumentException {
        return null;
    }

    public Iterator getAbouts(Object nativeItem) throws IllegalArgumentException {
        return null;
    }

    public boolean isDeleted(Object nativeItem) throws IllegalArgumentException {
        return false;
    }

    public String quickCreate(Object nativeItem, String schemaLocation, String metadataPrefix) {
        return null;
    }

    public String[] createHeader(Object nativeItem) throws IllegalArgumentException {
        String oaiIdentifier = this.getOAIIdentifier(nativeItem);
        String datestamp = this.getDatestamp(nativeItem);
        Iterator setSpecs = this.getSetSpecs(nativeItem);
        boolean isDeleted = this.isDeleted(nativeItem);
        String[] headerArray = MetacatRecordFactory.createHeader((String)oaiIdentifier, (String)datestamp, (Iterator)setSpecs, (boolean)isDeleted);
        return headerArray;
    }

    private String[] splitLocalIdentifier(String s) {
        String[] tokenPair = new String[2];
        int lastDotIndex = s.lastIndexOf(46);
        String scope = s.substring(0, lastDotIndex);
        String identifier = s.substring(lastDotIndex + 1);
        tokenPair[0] = scope;
        tokenPair[1] = identifier;
        return tokenPair;
    }

    private String[] splitOAIIdentifier(String s) {
        StringTokenizer tokenizer = new StringTokenizer(s, ":");
        String[] tokens = new String[tokenizer.countTokens()];
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokenizer.nextToken();
        }
        return tokens;
    }
}

