/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.replication;

import edu.ucsb.nceas.metacat.CatalogMessageHandler;
import edu.ucsb.nceas.metacat.DBUtil;
import edu.ucsb.nceas.metacat.DocumentImpl;
import edu.ucsb.nceas.metacat.DocumentImplWrapper;
import edu.ucsb.nceas.metacat.EventLog;
import edu.ucsb.nceas.metacat.IdentifierManager;
import edu.ucsb.nceas.metacat.McdbDocNotFoundException;
import edu.ucsb.nceas.metacat.accesscontrol.AccessControlForSingleFile;
import edu.ucsb.nceas.metacat.client.InsufficientKarmaException;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.dataone.hazelcast.HazelcastService;
import edu.ucsb.nceas.metacat.index.MetacatSolrIndex;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.replication.ReplMessageHandler;
import edu.ucsb.nceas.metacat.replication.ReplicationServer;
import edu.ucsb.nceas.metacat.replication.ReplicationServerList;
import edu.ucsb.nceas.metacat.replication.ReplicationService;
import edu.ucsb.nceas.metacat.shared.HandlerException;
import edu.ucsb.nceas.metacat.util.DocumentUtil;
import edu.ucsb.nceas.metacat.util.MetacatUtil;
import edu.ucsb.nceas.metacat.util.ReplicationUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.access.DocInfoHandler;
import edu.ucsb.nceas.utilities.access.XMLAccessDAO;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TimerTask;
import java.util.Vector;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.dataone.service.types.v2.SystemMetadata;
import org.dataone.service.util.DateTimeMarshaller;
import org.dataone.service.util.TypeMarshaller;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ReplicationHandler
extends TimerTask {
    int serverCheckCode = 1;
    ReplicationServerList serverList = null;
    private static Logger logReplication = Logger.getLogger((String)"ReplicationLogging");
    private static Logger logMetacat = Logger.getLogger(ReplicationHandler.class);
    private static int DOCINSERTNUMBER = 1;
    private static int DOCERRORNUMBER = 1;
    private static int REVINSERTNUMBER = 1;
    private static int REVERRORNUMBER = 1;
    private static int _xmlDocQueryCount = 0;
    private static int _xmlRevQueryCount = 0;
    private static long _xmlDocQueryTime = 0L;
    private static long _xmlRevQueryTime = 0L;

    public ReplicationHandler() {
        this.serverList = new ReplicationServerList();
    }

    public ReplicationHandler(int serverCheckCode) {
        this.serverCheckCode = serverCheckCode;
        this.serverList = new ReplicationServerList();
    }

    @Override
    public void run() {
        if (this.serverList == null || this.serverList.isEmpty()) {
            return;
        }
        this.updateCatalog();
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        Vector<InputStream> responses = new Vector<InputStream>();
        try {
            int i;
            _xmlDocQueryCount = 0;
            _xmlRevQueryCount = 0;
            _xmlDocQueryTime = 0L;
            _xmlRevQueryTime = 0L;
            ReplicationServer replServer = null;
            String server = null;
            long replicationStartTime = System.currentTimeMillis();
            long timeToGetServerList = 0L;
            long startTimeToGetServers = System.currentTimeMillis();
            for (int i2 = 0; i2 < this.serverList.size(); ++i2) {
                replServer = this.serverList.serverAt(i2);
                server = replServer.getServerName().trim();
                InputStream result = null;
                logReplication.info((Object)("ReplicationHandler.update - full update started to: " + server));
                try {
                    URL u = new URL("https://" + server + "?server=" + MetacatUtil.getLocalReplicationServerName() + "&action=update");
                    logReplication.info((Object)("ReplicationHandler.update - Sending infomation " + u.toString()));
                    result = ReplicationService.getURLStream(u);
                }
                catch (Exception e) {
                    logMetacat.error((Object)("ReplicationHandler.update - " + ReplicationService.METACAT_REPL_ERROR_MSG));
                    logReplication.error((Object)("ReplicationHandler.update - Failed to get updated doc list for server " + server + " because " + e.getMessage()));
                    continue;
                }
                if (result == null) {
                    logMetacat.error((Object)("ReplicationHandler.update - " + ReplicationService.METACAT_REPL_ERROR_MSG));
                    logReplication.error((Object)("ReplicationHandler.update - Failed to get updated doc list for server " + server + " because " + result));
                    continue;
                }
                responses.add(result);
            }
            timeToGetServerList = System.currentTimeMillis() - startTimeToGetServers;
            if (responses == null || responses.isEmpty()) {
                logMetacat.error((Object)("ReplicationHandler.update - " + ReplicationService.METACAT_REPL_ERROR_MSG));
                logReplication.info((Object)"ReplicationHandler.update - No updated doc list for every server and failed to replicate");
                return;
            }
            long totalServerListParseTime = 0L;
            for (i = 0; i < responses.size(); ++i) {
                XMLReader parser;
                long startServerListParseTime = System.currentTimeMillis();
                ReplMessageHandler message = new ReplMessageHandler();
                try {
                    parser = ReplicationHandler.initParser(message);
                }
                catch (Exception e) {
                    logMetacat.error((Object)("ReplicationHandler.update - " + ReplicationService.METACAT_REPL_ERROR_MSG));
                    logReplication.error((Object)("ReplicationHandler.update - Failed to replicate becaue couldn't  initParser for message and " + e.getMessage()));
                    Iterator isit = responses.iterator();
                    while (isit.hasNext()) {
                        IOUtils.closeQuietly((InputStream)((InputStream)isit.next()));
                    }
                    return;
                }
                try {
                    parser.parse(new InputSource((InputStream)responses.elementAt(i)));
                }
                catch (Exception e) {
                    logMetacat.error((Object)("ReplicationHandler.update - " + ReplicationService.METACAT_REPL_ERROR_MSG));
                    logReplication.error((Object)("ReplicationHandler.update - Couldn't parse one responses because " + e.getMessage()));
                    continue;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)((InputStream)responses.elementAt(i)));
                }
                Vector<Vector<String>> updateList = new Vector<Vector<String>>(message.getUpdatesVect());
                logReplication.info((Object)("ReplicationHandler.update - The document list size is " + updateList.size() + " from " + message.getServerName()));
                Vector<Vector<String>> deleteList = new Vector<Vector<String>>(message.getDeletesVect());
                logReplication.info((Object)("ReplicationHandler.update - Update vector size: " + updateList.size() + " from " + message.getServerName()));
                logReplication.info((Object)("ReplicationHandler.update - Delete vector size: " + deleteList.size() + " from " + message.getServerName()));
                logReplication.info((Object)("ReplicationHandler.update - The delete document list size is " + deleteList.size() + " from " + message.getServerName()));
                this.handleDocList(updateList, "xml_documents");
                for (int k = 0; k < deleteList.size(); ++k) {
                    Vector w = new Vector(deleteList.elementAt(k));
                    String docId = (String)w.elementAt(0);
                    try {
                        this.handleDeleteSingleDocument(docId, server);
                        continue;
                    }
                    catch (Exception ee) {
                        // empty catch block
                    }
                }
                Vector<Vector<String>> revisionList = new Vector<Vector<String>>(message.getRevisionsVect());
                logReplication.info((Object)("ReplicationHandler.update - The revision document list size is " + revisionList.size() + " from " + message.getServerName()));
                this.handleDocList(revisionList, "xml_revisions");
                DOCINSERTNUMBER = 1;
                DOCERRORNUMBER = 1;
                REVINSERTNUMBER = 1;
                REVERRORNUMBER = 1;
                Vector<Vector<String>> systemMetadataList = message.getSystemMetadataVect();
                for (int k = 0; k < systemMetadataList.size(); ++k) {
                    Vector<String> w = systemMetadataList.elementAt(k);
                    String guid = w.elementAt(0);
                    String remoteserver = w.elementAt(1);
                    try {
                        this.handleSystemMetadata(remoteserver, guid);
                        continue;
                    }
                    catch (Exception ee) {
                        logMetacat.error((Object)("Error replicating system metedata for guid: " + guid), (Throwable)ee);
                    }
                }
                totalServerListParseTime += System.currentTimeMillis() - startServerListParseTime;
            }
            for (i = 0; i < this.serverList.size(); ++i) {
                replServer = this.serverList.serverAt(i);
                try {
                    this.updateLastCheckTimeForSingleServer(replServer);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            long replicationEndTime = System.currentTimeMillis();
            logMetacat.debug((Object)("ReplicationHandler.update - Total replication time: " + (replicationEndTime - replicationStartTime)));
            logMetacat.debug((Object)("ReplicationHandler.update - time to get server list: " + timeToGetServerList));
            logMetacat.debug((Object)("ReplicationHandler.update - server list parse time: " + totalServerListParseTime));
            logMetacat.debug((Object)("ReplicationHandler.update - 'in xml_documents' total query count: " + _xmlDocQueryCount));
            logMetacat.debug((Object)("ReplicationHandler.update - 'in xml_documents' total query time: " + _xmlDocQueryTime + " ms"));
            logMetacat.debug((Object)("ReplicationHandler.update - 'in xml_revisions' total query count: " + _xmlRevQueryCount));
            logMetacat.debug((Object)("ReplicationHandler.update - 'in xml_revisions' total query time: " + _xmlRevQueryTime + " ms"));
        }
        finally {
            Iterator isit = responses.iterator();
            while (isit.hasNext()) {
                IOUtils.closeQuietly((InputStream)((InputStream)isit.next()));
            }
        }
    }

    private void handleSingleXMLDocument(String remoteserver, String actions, String accNumber, String tableName) throws HandlerException {
        DBConnection dbConn = null;
        int serialNumber = -1;
        try {
            dbConn = DBConnectionPool.getDBConnection("ReplicationHandler.handleSingleXMLDocument");
            serialNumber = dbConn.getCheckOutSerialNumber();
            String readDocURLString = "https://" + remoteserver + "?server=" + MetacatUtil.getLocalReplicationServerName() + "&action=read&docid=" + accNumber;
            readDocURLString = MetacatUtil.replaceWhiteSpaceForURL(readDocURLString);
            URL u = new URL(readDocURLString);
            byte[] xmlBytes = ReplicationService.getURLBytes(u);
            String newxmldoc = new String(xmlBytes, "UTF-8");
            if (newxmldoc.indexOf("<error>") != -1 && newxmldoc.indexOf("</error>") != -1) {
                throw new HandlerException("ReplicationHandler.handleSingleXMLDocument - " + newxmldoc);
            }
            DocInfoHandler dih = new DocInfoHandler();
            XMLReader docinfoParser = ReplicationHandler.initParser((DefaultHandler)dih);
            String docInfoURLStr = "https://" + remoteserver + "?server=" + MetacatUtil.getLocalReplicationServerName() + "&action=getdocumentinfo&docid=" + accNumber;
            docInfoURLStr = MetacatUtil.replaceWhiteSpaceForURL(docInfoURLStr);
            URL docinfoUrl = new URL(docInfoURLStr);
            logReplication.info((Object)("ReplicationHandler.handleSingleXMLDocument - Sending message: " + docinfoUrl.toString()));
            String docInfoStr = ReplicationService.getURLContent(docinfoUrl);
            String systemMetadataXML = ReplicationUtil.getSystemMetadataContent(docInfoStr);
            docInfoStr = ReplicationUtil.getContentWithoutSystemMetadata(docInfoStr);
            SystemMetadata sysMeta = null;
            if (systemMetadataXML != null) {
                sysMeta = (SystemMetadata)TypeMarshaller.unmarshalTypeFromStream(SystemMetadata.class, (InputStream)new ByteArrayInputStream(systemMetadataXML.getBytes("UTF-8")));
                if (!IdentifierManager.getInstance().mappingExists(sysMeta.getIdentifier().getValue())) {
                    IdentifierManager.getInstance().createMapping(sysMeta.getIdentifier().getValue(), accNumber);
                }
                logReplication.debug((Object)("Saving SystemMetadata to shared map: " + sysMeta.getIdentifier().getValue()));
                HazelcastService.getInstance().getSystemMetadataMap().put((Object)sysMeta.getIdentifier(), (Object)sysMeta);
            }
            docinfoParser.parse(new InputSource(new StringReader(docInfoStr)));
            Hashtable docinfoHash = dih.getDocInfo();
            String docHomeServer = (String)docinfoHash.get("home_server");
            logReplication.info((Object)("ReplicationHandler.handleSingleXMLDocument - doc home server in repl: " + docHomeServer));
            String createdDateString = (String)docinfoHash.get("date_created");
            String updatedDateString = (String)docinfoHash.get("date_updated");
            Date createdDate = DateTimeMarshaller.deserializeDateToUTC((String)createdDateString);
            Date updatedDate = DateTimeMarshaller.deserializeDateToUTC((String)updatedDateString);
            logReplication.info((Object)("ReplicationHandler.handleSingleXMLDocument - docid in repl: " + accNumber));
            String docType = (String)docinfoHash.get("doctype");
            logReplication.info((Object)("ReplicationHandler.handleSingleXMLDocument - doctype in repl: " + docType));
            String parserBase = null;
            if (docType != null && docType.trim().equals(DocumentImpl.EML2_0_0NAMESPACE)) {
                parserBase = "eml200";
            } else if (docType != null && docType.trim().equals(DocumentImpl.EML2_0_1NAMESPACE)) {
                parserBase = "eml200";
            } else if (docType != null && docType.trim().equals(DocumentImpl.EML2_1_0NAMESPACE)) {
                parserBase = "eml210";
            } else if (docType != null && docType.trim().equals(DocumentImpl.EML2_1_1NAMESPACE)) {
                parserBase = "eml210";
            }
            DocumentImplWrapper wrapper = new DocumentImplWrapper(parserBase, false, false);
            String newDocid = wrapper.writeReplication(dbConn, newxmldoc, xmlBytes, (String)docinfoHash.get("public_access"), null, actions, accNumber, null, null, docHomeServer, remoteserver, tableName, true, createdDate, updatedDate);
            if (sysMeta != null) {
                try {
                    MetacatSolrIndex.getInstance().submit(sysMeta.getIdentifier(), sysMeta, null, true);
                }
                catch (Exception ee) {
                    logReplication.warn((Object)("ReplicationService.handleForceReplicateRequest - couldn't index the doc since " + ee.getMessage()));
                }
            }
            String user = (String)docinfoHash.get("user_owner");
            String updated = (String)docinfoHash.get("user_updated");
            ReplicationService.updateUserOwner(dbConn, accNumber, user, updated);
            try {
                String docid = DocumentUtil.getDocIdFromAccessionNumber(accNumber);
                int rev = DocumentUtil.getRevisionFromAccessionNumber(accNumber);
                IdentifierManager.getInstance().getGUID(docid, rev);
            }
            catch (McdbDocNotFoundException mcdbe) {
                IdentifierManager.getInstance().createMapping(accNumber, accNumber);
            }
            Vector xmlAccessDAOList = dih.getAccessControlList();
            if (xmlAccessDAOList != null) {
                AccessControlForSingleFile acfsf = new AccessControlForSingleFile(accNumber);
                for (XMLAccessDAO xmlAccessDAO : xmlAccessDAOList) {
                    if (acfsf.accessControlExists(xmlAccessDAO)) continue;
                    acfsf.insertPermissions(xmlAccessDAO);
                }
            }
            logReplication.info((Object)("ReplicationHandler.handleSingleXMLDocument - Successfully replicated doc " + accNumber));
            if (tableName.equals("xml_documents")) {
                logReplication.info((Object)("ReplicationHandler.handleSingleXMLDocument - " + DOCINSERTNUMBER + " Wrote xml doc " + accNumber + " into " + tableName + " from " + remoteserver));
                ++DOCINSERTNUMBER;
            } else {
                logReplication.info((Object)("ReplicationHandler.handleSingleXMLDocument - " + REVINSERTNUMBER + " Wrote xml doc " + accNumber + " into " + tableName + " from " + remoteserver));
                ++REVINSERTNUMBER;
            }
            String ip = this.getIpFromURL(u);
            EventLog.getInstance().log(ip, null, "replication", accNumber, actions);
        }
        catch (Exception e) {
            if (tableName.equals("xml_documents")) {
                logMetacat.error((Object)("ReplicationHandler.handleSingleXMLDocument - " + ReplicationService.METACAT_REPL_ERROR_MSG));
                logReplication.error((Object)("ReplicationHandler.handleSingleXMLDocument - " + DOCERRORNUMBER + " Failed to write xml doc " + accNumber + " into " + tableName + " from " + remoteserver + " because " + e.getMessage()));
                ++DOCERRORNUMBER;
            } else {
                logMetacat.error((Object)("ReplicationHandler.handleSingleXMLDocument - " + ReplicationService.METACAT_REPL_ERROR_MSG));
                logReplication.error((Object)("ReplicationHandler.handleSingleXMLDocument - " + REVERRORNUMBER + " Failed to write xml doc " + accNumber + " into " + tableName + " from " + remoteserver + " because " + e.getMessage()));
                ++REVERRORNUMBER;
            }
            logMetacat.error((Object)("ReplicationHandler.handleSingleXMLDocument - " + ReplicationService.METACAT_REPL_ERROR_MSG));
            logReplication.error((Object)("ReplicationHandler.handleSingleXMLDocument - Failed to write doc " + accNumber + " into db because " + e.getMessage()), (Throwable)e);
            throw new HandlerException("ReplicationHandler.handleSingleXMLDocument - generic exception writing Replication: " + e.getMessage());
        }
        finally {
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
        }
        logMetacat.info((Object)("replication.create localId:" + accNumber));
    }

    private void handleSingleDataFile(String remoteserver, String actions, String accNumber, String tableName) throws HandlerException {
        logReplication.info((Object)("ReplicationHandler.handleSingleDataFile - Try to replicate data file: " + accNumber));
        DBConnection dbConn = null;
        int serialNumber = -1;
        InputStream input = null;
        try {
            dbConn = DBConnectionPool.getDBConnection("ReplicationHandler.handleSinlgeDataFile");
            serialNumber = dbConn.getCheckOutSerialNumber();
            DocInfoHandler dih = new DocInfoHandler();
            XMLReader docinfoParser = ReplicationHandler.initParser((DefaultHandler)dih);
            String docInfoURLString = "https://" + remoteserver + "?server=" + MetacatUtil.getLocalReplicationServerName() + "&action=getdocumentinfo&docid=" + accNumber;
            docInfoURLString = MetacatUtil.replaceWhiteSpaceForURL(docInfoURLString);
            URL docinfoUrl = new URL(docInfoURLString);
            String docInfoStr = ReplicationService.getURLContent(docinfoUrl);
            String systemMetadataXML = ReplicationUtil.getSystemMetadataContent(docInfoStr);
            docInfoStr = ReplicationUtil.getContentWithoutSystemMetadata(docInfoStr);
            if (systemMetadataXML != null) {
                SystemMetadata sysMeta = (SystemMetadata)TypeMarshaller.unmarshalTypeFromStream(SystemMetadata.class, (InputStream)new ByteArrayInputStream(systemMetadataXML.getBytes("UTF-8")));
                if (!IdentifierManager.getInstance().mappingExists(sysMeta.getIdentifier().getValue())) {
                    IdentifierManager.getInstance().createMapping(sysMeta.getIdentifier().getValue(), accNumber);
                }
                HazelcastService.getInstance().getSystemMetadataMap().put((Object)sysMeta.getIdentifier(), (Object)sysMeta);
                MetacatSolrIndex.getInstance().submit(sysMeta.getIdentifier(), sysMeta, null, true);
            }
            docinfoParser.parse(new InputSource(new StringReader(docInfoStr)));
            Hashtable docinfoHash = dih.getDocInfo();
            String docName = (String)docinfoHash.get("docname");
            String docType = (String)docinfoHash.get("doctype");
            String docHomeServer = (String)docinfoHash.get("home_server");
            String createdDateString = (String)docinfoHash.get("date_created");
            String updatedDateString = (String)docinfoHash.get("date_updated");
            Date createdDate = DateTimeMarshaller.deserializeDateToUTC((String)createdDateString);
            Date updatedDate = DateTimeMarshaller.deserializeDateToUTC((String)updatedDateString);
            String datafilePath = PropertyService.getProperty("application.datafilepath");
            String readDataURLString = "https://" + remoteserver + "?server=" + MetacatUtil.getLocalReplicationServerName() + "&action=readdata&docid=" + accNumber;
            readDataURLString = MetacatUtil.replaceWhiteSpaceForURL(readDataURLString);
            URL u = new URL(readDataURLString);
            input = ReplicationService.getURLStream(u);
            if (input != null) {
                DocumentImpl.writeDataFileInReplication(input, datafilePath, docName, docType, accNumber, null, docHomeServer, remoteserver, tableName, true, createdDate, updatedDate);
                String user = (String)docinfoHash.get("user_owner");
                String updated = (String)docinfoHash.get("user_updated");
                ReplicationService.updateUserOwner(dbConn, accNumber, user, updated);
                try {
                    String docid = DocumentUtil.getDocIdFromAccessionNumber(accNumber);
                    int rev = DocumentUtil.getRevisionFromAccessionNumber(accNumber);
                    IdentifierManager.getInstance().getGUID(docid, rev);
                }
                catch (McdbDocNotFoundException mcdbe) {
                    IdentifierManager.getInstance().createMapping(accNumber, accNumber);
                }
                Vector xmlAccessDAOList = dih.getAccessControlList();
                if (xmlAccessDAOList != null) {
                    AccessControlForSingleFile acfsf = new AccessControlForSingleFile(accNumber);
                    for (XMLAccessDAO xmlAccessDAO : xmlAccessDAOList) {
                        if (acfsf.accessControlExists(xmlAccessDAO)) continue;
                        acfsf.insertPermissions(xmlAccessDAO);
                    }
                }
                logReplication.info((Object)("ReplicationHandler.handleSingleDataFile - Successfully to write datafile " + accNumber));
                if (tableName.equals("xml_documents")) {
                    logReplication.info((Object)("ReplicationHandler.handleSingleDataFile - " + DOCINSERTNUMBER + " Wrote data file" + accNumber + " into " + tableName + " from " + remoteserver));
                    ++DOCINSERTNUMBER;
                } else {
                    logReplication.info((Object)("ReplicationHandler.handleSingleDataFile - " + REVINSERTNUMBER + " Wrote data file" + accNumber + " into " + tableName + " from " + remoteserver));
                    ++REVINSERTNUMBER;
                }
            } else {
                logReplication.info((Object)("ReplicationHandler.handleSingleDataFile - Couldn't open the data file: " + accNumber));
                throw new HandlerException("ReplicationHandler.handleSingleDataFile - Couldn't open the data file: " + accNumber);
            }
            String ip = this.getIpFromURL(u);
            EventLog.getInstance().log(ip, null, "replication", accNumber, actions);
        }
        catch (Exception e) {
            try {
                if (tableName.equals("xml_documents")) {
                    logMetacat.error((Object)("ReplicationHandler.handleSingleDataFile - " + ReplicationService.METACAT_REPL_ERROR_MSG));
                    logReplication.error((Object)("ReplicationHandler.handleSingleDataFile - " + DOCERRORNUMBER + " Failed to write data file " + accNumber + " into " + tableName + " from " + remoteserver + " because " + e.getMessage()));
                    ++DOCERRORNUMBER;
                } else {
                    logMetacat.error((Object)("ReplicationHandler.handleSingleDataFile - " + ReplicationService.METACAT_REPL_ERROR_MSG));
                    logReplication.error((Object)("ReplicationHandler.handleSingleDataFile - " + REVERRORNUMBER + " Failed to write data file" + accNumber + " into " + tableName + " from " + remoteserver + " because " + e.getMessage()));
                    ++REVERRORNUMBER;
                }
                logMetacat.error((Object)("ReplicationHandler.handleSingleDataFile - " + ReplicationService.METACAT_REPL_ERROR_MSG));
                logReplication.error((Object)("ReplicationHandler.handleSingleDataFile - Failed to try wrote datafile " + accNumber + " because " + e.getMessage()));
                throw new HandlerException("ReplicationHandler.handleSingleDataFile - generic exception writing Replication: " + e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)input);
        DBConnectionPool.returnDBConnection(dbConn, serialNumber);
        logMetacat.info((Object)("replication.create localId:" + accNumber));
    }

    private void handleDeleteSingleDocument(String docId, String notifyServer) throws HandlerException {
        logReplication.info((Object)("ReplicationHandler.handleDeleteSingleDocument - Try delete doc: " + docId));
        DBConnection dbConn = null;
        int serialNumber = -1;
        try {
            dbConn = DBConnectionPool.getDBConnection("ReplicationHandler.handleDeleteSingleDoc");
            serialNumber = dbConn.getCheckOutSerialNumber();
            if (!ReplicationHandler.alreadyDeleted(docId)) {
                String accnum = docId + PropertyService.getProperty("document.accNumSeparator") + "1";
                DocumentImpl.delete(accnum, null, null, notifyServer, false);
                logReplication.info((Object)("ReplicationHandler.handleDeleteSingleDocument - Successfully deleted doc " + docId));
                logReplication.info((Object)("ReplicationHandler.handleDeleteSingleDocument - Doc " + docId + " deleted"));
                URL u = new URL("https://" + notifyServer);
                String ip = this.getIpFromURL(u);
                EventLog.getInstance().log(ip, null, "replication", docId, "delete");
            }
        }
        catch (McdbDocNotFoundException e) {
            logMetacat.error((Object)("ReplicationHandler.handleDeleteSingleDocument - " + ReplicationService.METACAT_REPL_ERROR_MSG));
            logReplication.error((Object)("ReplicationHandler.handleDeleteSingleDocument - Failed to delete doc " + docId + " in db because because " + e.getMessage()));
            throw new HandlerException("ReplicationHandler.handleDeleteSingleDocument - generic exception when handling document: " + e.getMessage());
        }
        catch (InsufficientKarmaException e) {
            logMetacat.error((Object)("ReplicationHandler.handleDeleteSingleDocument - " + ReplicationService.METACAT_REPL_ERROR_MSG));
            logReplication.error((Object)("ReplicationHandler.handleDeleteSingleDocument - Failed to delete doc " + docId + " in db because because " + e.getMessage()));
            throw new HandlerException("ReplicationHandler.handleDeleteSingleDocument - generic exception when handling document: " + e.getMessage());
        }
        catch (SQLException e) {
            logMetacat.error((Object)("ReplicationHandler.handleDeleteSingleDocument - " + ReplicationService.METACAT_REPL_ERROR_MSG));
            logReplication.error((Object)("ReplicationHandler.handleDeleteSingleDocument - Failed to delete doc " + docId + " in db because because " + e.getMessage()));
            throw new HandlerException("ReplicationHandler.handleDeleteSingleDocument - generic exception when handling document: " + e.getMessage());
        }
        catch (Exception e) {
            logMetacat.error((Object)("ReplicationHandler.handleDeleteSingleDocument - " + ReplicationService.METACAT_REPL_ERROR_MSG));
            logReplication.error((Object)("ReplicationHandler.handleDeleteSingleDocument - Failed to delete doc " + docId + " in db because because " + e.getMessage()));
            throw new HandlerException("ReplicationHandler.handleDeleteSingleDocument - generic exception when handling document: " + e.getMessage());
        }
        finally {
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
        }
        logMetacat.info((Object)("replication.handleDeleteSingleDocument localId:" + docId));
    }

    private void updateLastCheckTimeForSingleServer(ReplicationServer repServer) throws HandlerException {
        block6: {
            String server = repServer.getServerName();
            DBConnection dbConn = null;
            int serialNumber = -1;
            PreparedStatement pstmt = null;
            try {
                dbConn = DBConnectionPool.getDBConnection("ReplicationHandler.updateLastCheckTimeForServer");
                serialNumber = dbConn.getCheckOutSerialNumber();
                logReplication.info((Object)("ReplicationHandler.updateLastCheckTimeForSingleServer - Try to update last_check for server: " + server));
                URL dateurl = new URL("https://" + server + "?server=" + MetacatUtil.getLocalReplicationServerName() + "&action=gettime");
                String datexml = ReplicationService.getURLContent(dateurl);
                logReplication.info((Object)("ReplicationHandler.updateLastCheckTimeForSingleServer - datexml: " + datexml));
                if (datexml != null && !datexml.equals("")) {
                    String datestr = datexml.substring(11, datexml.indexOf(60, 11));
                    Date updated = DateTimeMarshaller.deserializeDateToUTC((String)datestr);
                    StringBuffer sql = new StringBuffer();
                    sql.append("update xml_replication set last_checked = ? ");
                    sql.append(" where server like ? ");
                    pstmt = dbConn.prepareStatement(sql.toString());
                    pstmt.setTimestamp(1, new Timestamp(updated.getTime()));
                    pstmt.setString(2, server);
                    pstmt.executeUpdate();
                    dbConn.commit();
                    pstmt.close();
                    logReplication.info((Object)("ReplicationHandler.updateLastCheckTimeForSingleServer - last_checked updated to " + datestr + " on " + server));
                    break block6;
                }
                logReplication.info((Object)("ReplicationHandler.updateLastCheckTimeForSingleServer - Failed to update last_checked for server " + server + " in db because couldn't get time "));
                throw new Exception("Couldn't get time for server " + server);
            }
            catch (Exception e) {
                logMetacat.error((Object)("ReplicationHandler.updateLastCheckTimeForSingleServer - " + ReplicationService.METACAT_REPL_ERROR_MSG));
                logReplication.error((Object)("ReplicationHandler.updateLastCheckTimeForSingleServer - Failed to update last_checked for server " + server + " in db because because " + e.getMessage()));
                throw new HandlerException("ReplicationHandler.updateLastCheckTimeForSingleServer - Error updating last checked time: " + e.getMessage());
            }
            finally {
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            }
        }
    }

    private void handleSystemMetadata(String remoteserver, String guid) throws HandlerException {
        try {
            String sysMetaURLStr = "https://" + remoteserver + "?server=" + MetacatUtil.getLocalReplicationServerName() + "&action=getsystemmetadata&guid=" + guid;
            sysMetaURLStr = MetacatUtil.replaceWhiteSpaceForURL(sysMetaURLStr);
            URL sysMetaUrl = new URL(sysMetaURLStr);
            logReplication.info((Object)("ReplicationHandler.handleSystemMetadata - Sending message: " + sysMetaUrl.toString()));
            String systemMetadataXML = ReplicationService.getURLContent(sysMetaUrl);
            logReplication.info((Object)("ReplicationHandler.handleSystemMetadata - guid in repl: " + guid));
            if (systemMetadataXML != null) {
                SystemMetadata sysMeta = (SystemMetadata)TypeMarshaller.unmarshalTypeFromStream(SystemMetadata.class, (InputStream)new ByteArrayInputStream(systemMetadataXML.getBytes("UTF-8")));
                HazelcastService.getInstance().getSystemMetadataMap().put((Object)sysMeta.getIdentifier(), (Object)sysMeta);
                MetacatSolrIndex.getInstance().submit(sysMeta.getIdentifier(), sysMeta, null, true);
            }
            logReplication.info((Object)("ReplicationHandler.handleSystemMetadata - Successfully replicated system metadata for guid: " + guid));
            String ip = this.getIpFromURL(sysMetaUrl);
            EventLog.getInstance().log(ip, null, "replication", guid, "systemMetadata");
        }
        catch (Exception e) {
            logMetacat.error((Object)("ReplicationHandler.handleSystemMetadata - " + ReplicationService.METACAT_REPL_ERROR_MSG));
            logReplication.error((Object)("ReplicationHandler.handleSystemMetadata - Failed to write system metadata " + guid + " into db because " + e.getMessage()));
            throw new HandlerException("ReplicationHandler.handleSystemMetadata - generic exception writing Replication: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCatalog() {
        logReplication.info((Object)"ReplicationHandler.updateCatalog - Start of updateCatalog");
        ReplicationServer replServer = null;
        Object pstmt = null;
        String server = null;
        for (int j = 0; j < this.serverList.size(); ++j) {
            Vector remoteCatalog = new Vector();
            Vector<String> publicId = new Vector<String>();
            try {
                replServer = this.serverList.serverAt(j);
                server = replServer.getServerName();
                URL u = new URL("https://" + server + "?server=" + MetacatUtil.getLocalReplicationServerName() + "&action=getcatalog");
                logReplication.info((Object)("ReplicationHandler.updateCatalog - sending message " + u.toString()));
                String catxml = ReplicationService.getURLContent(u);
                if (catxml.indexOf("error") != -1 || catxml == null || catxml.equals("")) {
                    throw new Exception("Couldn't get catalog list form server " + server);
                }
                logReplication.debug((Object)("ReplicationHandler.updateCatalog - catxml: " + catxml));
                CatalogMessageHandler cmh = new CatalogMessageHandler();
                XMLReader catparser = ReplicationHandler.initParser(cmh);
                catparser.parse(new InputSource(new StringReader(catxml)));
                remoteCatalog = cmh.getCatalogVect();
                if (remoteCatalog.isEmpty()) {
                    throw new Exception("Couldn't get catalog list form server " + server);
                }
                String localcatxml = ReplicationService.getCatalogXML();
                if (localcatxml == null || localcatxml.equals("")) {
                    throw new Exception("Couldn't get catalog list form server " + server);
                }
                cmh = new CatalogMessageHandler();
                catparser = ReplicationHandler.initParser(cmh);
                catparser.parse(new InputSource(new StringReader(localcatxml)));
                Vector localCatalog = cmh.getCatalogVect();
                publicId = new Vector();
                for (int i = 0; i < localCatalog.size(); ++i) {
                    Vector v = new Vector((Collection)localCatalog.elementAt(i));
                    logReplication.info((Object)("ReplicationHandler.updateCatalog - v1: " + v.toString()));
                    publicId.add(new String((String)v.elementAt(3)));
                }
            }
            catch (Exception e) {
                logMetacat.error((Object)("ReplicationHandler.updateCatalog - " + ReplicationService.METACAT_REPL_ERROR_MSG));
                logReplication.error((Object)("ReplicationHandler.updateCatalog - Failed to update catalog for server " + server + " because " + e.getMessage()));
            }
            for (int i = 0; i < remoteCatalog.size(); ++i) {
                DBConnection dbConn = null;
                int serialNumber = -1;
                try {
                    dbConn = DBConnectionPool.getDBConnection("ReplicationHandler.updateCatalog");
                    serialNumber = dbConn.getCheckOutSerialNumber();
                    Vector v = (Vector)remoteCatalog.elementAt(i);
                    logReplication.info((Object)("ReplicationHandler.updateCatalog - v.elementAt(3): " + (String)v.elementAt(3)));
                    continue;
                }
                catch (Exception e) {
                    logMetacat.error((Object)("ReplicationHandler.updateCatalog - " + ReplicationService.METACAT_REPL_ERROR_MSG));
                    logReplication.error((Object)("ReplicationHandler.updateCatalog - Failed to update catalog for server " + server + " because " + e.getMessage()));
                    continue;
                }
                finally {
                    DBConnectionPool.returnDBConnection(dbConn, serialNumber);
                }
            }
        }
        logReplication.info((Object)"End of updateCatalog");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean alreadyDeleted(String docid) throws HandlerException {
        DBConnection dbConn = null;
        int serialNumber = -1;
        Statement pstmt = null;
        try {
            dbConn = DBConnectionPool.getDBConnection("ReplicationHandler.alreadyDeleted");
            serialNumber = dbConn.getCheckOutSerialNumber();
            boolean xml_docs = false;
            boolean xml_revs = false;
            StringBuffer sb = new StringBuffer();
            sb.append("select docid from xml_revisions where docid like ? ");
            pstmt = dbConn.prepareStatement(sb.toString());
            pstmt.setString(1, docid);
            pstmt.execute();
            ResultSet rs = pstmt.getResultSet();
            boolean tablehasrows = rs.next();
            if (tablehasrows) {
                xml_revs = true;
            }
            sb = new StringBuffer();
            sb.append("select docid from xml_documents where docid like '");
            sb.append(docid).append("'");
            pstmt.close();
            pstmt = dbConn.prepareStatement(sb.toString());
            dbConn.increaseUsageCount(1);
            pstmt.execute();
            rs = pstmt.getResultSet();
            tablehasrows = rs.next();
            pstmt.close();
            if (tablehasrows) {
                xml_docs = true;
            }
            if (xml_docs && xml_revs) {
                boolean bl = false;
                return bl;
            }
            if (xml_docs && !xml_revs) {
                boolean bl = false;
                return bl;
            }
            if (!xml_docs && xml_revs) {
                boolean bl = true;
                return bl;
            }
            if (xml_docs) return false;
            if (xml_revs) return false;
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logMetacat.error((Object)("ReplicationHandler.alreadyDeleted - " + ReplicationService.METACAT_REPL_ERROR_MSG));
            logReplication.error((Object)("ReplicationHandler.alreadyDeleted - general error in alreadyDeleted: " + e.getMessage()));
            throw new HandlerException("ReplicationHandler.alreadyDeleted - general error: " + e.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            catch (SQLException ee) {
                logMetacat.error((Object)("ReplicationHandler.alreadyDeleted - " + ReplicationService.METACAT_REPL_ERROR_MSG));
                logReplication.error((Object)("ReplicationHandler.alreadyDeleted - Error in replicationHandler.alreadyDeleted to close pstmt: " + ee.getMessage()));
                throw new HandlerException("ReplicationHandler.alreadyDeleted - SQL error when closing prepared statement: " + ee.getMessage());
            }
            finally {
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            }
        }
    }

    public static XMLReader initParser(DefaultHandler dh) throws HandlerException {
        XMLReader parser = null;
        try {
            DefaultHandler chandler = dh;
            String parserName = PropertyService.getProperty("xml.saxparser");
            parser = XMLReaderFactory.createXMLReader(parserName);
            parser.setFeature("http://xml.org/sax/features/validation", false);
            parser.setContentHandler(chandler);
            parser.setErrorHandler(chandler);
        }
        catch (SAXException se) {
            throw new HandlerException("ReplicationHandler.initParser - Sax error when  initializing parser: " + se.getMessage());
        }
        catch (PropertyNotFoundException pnfe) {
            throw new HandlerException("ReplicationHandler.initParser - Property error when  getting parser name: " + pnfe.getMessage());
        }
        return parser;
    }

    public static Date combinateCurrentDateAndGivenTime(String givenTime) throws HandlerException {
        try {
            Date givenDate = ReplicationHandler.parseTime(givenTime);
            Date newDate = null;
            Date now = new Date();
            String currentTimeString = ReplicationHandler.getTimeString(now);
            Date currentTime = ReplicationHandler.parseTime(currentTimeString);
            if (currentTime.getTime() >= givenDate.getTime()) {
                logReplication.info((Object)"ReplicationHandler.combinateCurrentDateAndGivenTime - Today already pass the given time, we should set it as tomorrow");
                String dateAndTime = ReplicationHandler.getDateString(now) + " " + givenTime;
                Date combinationDate = ReplicationHandler.parseDateTime(dateAndTime);
                newDate = new Date(combinationDate.getTime() + 86400000L);
            } else {
                logReplication.info((Object)"ReplicationHandler.combinateCurrentDateAndGivenTime - Today haven't pass the given time, we should it as today");
                String dateAndTime = ReplicationHandler.getDateString(now) + " " + givenTime;
                newDate = ReplicationHandler.parseDateTime(dateAndTime);
            }
            logReplication.warn((Object)("ReplicationHandler.combinateCurrentDateAndGivenTime - final setting time is " + newDate.toString()));
            return newDate;
        }
        catch (ParseException pe) {
            throw new HandlerException("ReplicationHandler.combinateCurrentDateAndGivenTime - parsing error: " + pe.getMessage());
        }
    }

    private static Date parseTime(String timeString) throws ParseException {
        DateFormat format = DateFormat.getTimeInstance(3);
        Date time = format.parse(timeString);
        logReplication.info((Object)("ReplicationHandler.parseTime - Date string is after parse a time string " + time.toString()));
        return time;
    }

    private static Date parseDateTime(String timeString) throws ParseException {
        DateFormat format = DateFormat.getDateTimeInstance(1, 3);
        Date time = format.parse(timeString);
        logReplication.info((Object)("ReplicationHandler.parseDateTime - Date string is after parse a time string " + time.toString()));
        return time;
    }

    private static String getDateString(Date now) {
        DateFormat df = DateFormat.getDateInstance(1);
        String s = df.format(now);
        logReplication.info((Object)("ReplicationHandler.getDateString - Today is " + s));
        return s;
    }

    private static String getTimeString(Date now) {
        DateFormat df = DateFormat.getTimeInstance(3);
        String s = df.format(now);
        logReplication.info((Object)("ReplicationHandler.getTimeString - Time is " + s));
        return s;
    }

    private void handleDocList(Vector<Vector<String>> docList, String tableName) {
        boolean dataFile = false;
        for (int j = 0; j < docList.size(); ++j) {
            dataFile = false;
            Vector w = new Vector(docList.elementAt(j));
            try {
                if (w.contains(PropertyService.getProperty("replication.datafileflag"))) {
                    dataFile = true;
                }
            }
            catch (PropertyNotFoundException pnfe) {
                logMetacat.error((Object)("ReplicationHandler.handleDocList - " + ReplicationService.METACAT_REPL_ERROR_MSG));
                logReplication.error((Object)("ReplicationHandler.handleDocList - Could not retrieve data file flag property.  Leaving as false: " + pnfe.getMessage()));
            }
            String docid = (String)w.elementAt(0);
            logReplication.info((Object)("docid: " + docid));
            int rev = Integer.parseInt((String)w.elementAt(1));
            logReplication.info((Object)("rev: " + rev));
            String remoteServer = (String)w.elementAt(2);
            remoteServer = remoteServer.trim();
            try {
                if (tableName.equals("xml_documents")) {
                    this.handleDocInXMLDocuments(docid, rev, remoteServer, dataFile);
                } else {
                    if (!tableName.equals("xml_revisions")) continue;
                    this.handleDocInXMLRevisions(docid, rev, remoteServer, dataFile);
                }
            }
            catch (Exception e) {
                logMetacat.error((Object)("ReplicationHandler.handleDocList - " + ReplicationService.METACAT_REPL_ERROR_MSG));
                logReplication.error((Object)("ReplicationHandler.handleDocList - error to handle update doc in " + tableName + " in time replication" + e.getMessage()), (Throwable)e);
                continue;
            }
            if (_xmlDocQueryCount > 0 && _xmlDocQueryCount % 100 == 0) {
                logMetacat.debug((Object)("ReplicationHandler.update - xml_doc query count: " + _xmlDocQueryCount + ", xml_doc avg query time: " + _xmlDocQueryTime / (long)_xmlDocQueryCount));
            }
            if (_xmlRevQueryCount <= 0 || _xmlRevQueryCount % 100 != 0) continue;
            logMetacat.debug((Object)("ReplicationHandler.update - xml_rev query count: " + _xmlRevQueryCount + ", xml_rev avg query time: " + _xmlRevQueryTime / (long)_xmlRevQueryCount));
        }
    }

    private void handleDocInXMLDocuments(String docid, int rev, String remoteServer, boolean dataFile) throws HandlerException {
        int localrev = -1;
        String action = null;
        boolean flag = false;
        try {
            long docQueryStartTime = System.currentTimeMillis();
            localrev = DBUtil.getLatestRevisionInDocumentTable(docid);
            long docQueryEndTime = System.currentTimeMillis();
            _xmlDocQueryTime += docQueryEndTime - docQueryStartTime;
            ++_xmlDocQueryCount;
        }
        catch (SQLException e) {
            logMetacat.error((Object)("ReplicationHandler.handleDocInXMLDocuments - " + ReplicationService.METACAT_REPL_ERROR_MSG));
            logReplication.error((Object)("ReplicationHandler.handleDocInXMLDocuments - Local rev for docid " + docid + " could not " + " be found because " + e.getMessage()));
            logReplication.error((Object)("ReplicationHandler.handleDocInXMLDocuments - " + DOCERRORNUMBER + "Docid " + docid + " could not be " + "written because error happend to find it's local revision"));
            ++DOCERRORNUMBER;
            throw new HandlerException("ReplicationHandler.handleDocInXMLDocuments - Local rev for docid " + docid + " could not " + " be found: " + e.getMessage());
        }
        logReplication.info((Object)("ReplicationHandler.handleDocInXMLDocuments - Local rev for docid " + docid + " is " + localrev));
        if (localrev == -1) {
            Vector<Integer> localRevVector = null;
            try {
                long revQueryStartTime = System.currentTimeMillis();
                localRevVector = DBUtil.getRevListFromRevisionTable(docid);
                long revQueryEndTime = System.currentTimeMillis();
                _xmlRevQueryTime += revQueryEndTime - revQueryStartTime;
                ++_xmlRevQueryCount;
            }
            catch (SQLException sqle) {
                throw new HandlerException("ReplicationHandler.handleDocInXMLDocuments - SQL error  when getting rev list for docid: " + docid + " : " + sqle.getMessage());
            }
            if (localRevVector != null && localRevVector.contains(new Integer(rev))) {
                flag = false;
            } else {
                action = "INSERT";
                flag = true;
            }
        } else if (localrev == rev) {
            flag = false;
        } else if (localrev < rev) {
            action = "UPDATE";
            flag = true;
        }
        String accNumber = null;
        try {
            accNumber = docid + PropertyService.getProperty("document.accNumSeparator") + rev;
        }
        catch (PropertyNotFoundException pnfe) {
            throw new HandlerException("ReplicationHandler.handleDocInXMLDocuments - error getting account number separator : " + pnfe.getMessage());
        }
        if (flag && !dataFile) {
            this.handleSingleXMLDocument(remoteServer, action, accNumber, "xml_documents");
        }
        if (flag && dataFile) {
            this.handleSingleDataFile(remoteServer, action, accNumber, "xml_documents");
        }
    }

    private void handleDocInXMLRevisions(String docid, int rev, String remoteServer, boolean dataFile) throws HandlerException {
        logReplication.info((Object)"ReplicationHandler.handleDocInXMLRevisions - In handle repliation revsion table");
        logReplication.info((Object)("ReplicationHandler.handleDocInXMLRevisions - the docid is " + docid));
        logReplication.info((Object)("ReplicationHandler.handleDocInXMLRevisions - The rev is " + rev));
        Vector<Integer> localrev = null;
        String action = "INSERT";
        boolean flag = false;
        try {
            long revQueryStartTime = System.currentTimeMillis();
            localrev = DBUtil.getRevListFromRevisionTable(docid);
            long revQueryEndTime = System.currentTimeMillis();
            _xmlRevQueryTime += revQueryEndTime - revQueryStartTime;
            ++_xmlRevQueryCount;
        }
        catch (SQLException sqle) {
            logMetacat.error((Object)("ReplicationHandler.handleDocInXMLDocuments - " + ReplicationService.METACAT_REPL_ERROR_MSG));
            logReplication.error((Object)("ReplicationHandler.handleDocInXMLRevisions - Local rev for docid " + docid + " could not " + " be found because " + sqle.getMessage()));
            ++REVERRORNUMBER;
            throw new HandlerException("ReplicationHandler.handleDocInXMLRevisions - SQL exception getting rev list: " + sqle.getMessage());
        }
        logReplication.info((Object)("ReplicationHandler.handleDocInXMLRevisions - rev list in xml_revision table for docid " + docid + " is " + localrev.toString()));
        if (!localrev.contains(new Integer(rev))) {
            flag = true;
        }
        String accNumber = null;
        try {
            accNumber = docid + PropertyService.getProperty("document.accNumSeparator") + rev;
        }
        catch (PropertyNotFoundException pnfe) {
            throw new HandlerException("ReplicationHandler.handleDocInXMLRevisions - error getting account number separator : " + pnfe.getMessage());
        }
        if (flag && !dataFile) {
            this.handleSingleXMLDocument(remoteServer, action, accNumber, "xml_revisions");
        }
        if (flag && dataFile) {
            this.handleSingleDataFile(remoteServer, action, accNumber, "xml_revisions");
        }
    }

    private String getIpFromURL(URL url) {
        String ip = null;
        try {
            InetAddress address = InetAddress.getByName(url.getHost());
            ip = address.getHostAddress();
        }
        catch (UnknownHostException e) {
            logMetacat.error((Object)("ReplicationHandler.getIpFromURL - " + ReplicationService.METACAT_REPL_ERROR_MSG));
            logReplication.error((Object)("ReplicationHandler.getIpFromURL - Error in get ip address for host: " + e.getMessage()));
        }
        return ip;
    }
}

