/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.replication;

import edu.ucsb.nceas.metacat.DocumentImpl;
import edu.ucsb.nceas.metacat.EventLog;
import edu.ucsb.nceas.metacat.IdentifierManager;
import edu.ucsb.nceas.metacat.McdbDocNotFoundException;
import edu.ucsb.nceas.metacat.McdbException;
import edu.ucsb.nceas.metacat.accesscontrol.AccessControlException;
import edu.ucsb.nceas.metacat.accesscontrol.AccessControlForSingleFile;
import edu.ucsb.nceas.metacat.admin.upgrade.RemoveInvalidReplicas;
import edu.ucsb.nceas.metacat.admin.upgrade.UpdateDOI;
import edu.ucsb.nceas.metacat.admin.upgrade.dataone.GenerateORE;
import edu.ucsb.nceas.metacat.admin.upgrade.dataone.GenerateSystemMetadata;
import edu.ucsb.nceas.metacat.client.InsufficientKarmaException;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.database.DatabaseService;
import edu.ucsb.nceas.metacat.dataone.SyncAccessPolicy;
import edu.ucsb.nceas.metacat.dataone.hazelcast.HazelcastService;
import edu.ucsb.nceas.metacat.index.MetacatSolrIndex;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.replication.ReplicationHandler;
import edu.ucsb.nceas.metacat.replication.ReplicationServerList;
import edu.ucsb.nceas.metacat.shared.BaseService;
import edu.ucsb.nceas.metacat.shared.HandlerException;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.metacat.util.DocumentUtil;
import edu.ucsb.nceas.metacat.util.MetacatUtil;
import edu.ucsb.nceas.metacat.util.ReplicationUtil;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.FileUtil;
import edu.ucsb.nceas.utilities.GeneralPropertyException;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.access.DocInfoHandler;
import edu.ucsb.nceas.utilities.access.XMLAccessDAO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.log4j.Logger;
import org.dataone.client.auth.CertificateManager;
import org.dataone.client.auth.X509Session;
import org.dataone.client.rest.RestClient;
import org.dataone.client.types.AutoCloseHttpClientInputStream;
import org.dataone.client.utils.HttpUtils;
import org.dataone.exceptions.MarshallingException;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v2.SystemMetadata;
import org.dataone.service.util.DateTimeMarshaller;
import org.dataone.service.util.TypeMarshaller;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ReplicationService
extends BaseService {
    private static ReplicationService replicationService = null;
    private long timeInterval;
    private Date firstTime;
    private boolean timedReplicationIsOn = false;
    Timer replicationDaemon;
    private static Vector<String> fileLocks = new Vector();
    public static final String FORCEREPLICATEDELETE = "forcereplicatedelete";
    public static final String FORCEREPLICATEDELETEALL = "forcereplicatedeleteall";
    private static String TIMEREPLICATION = "replication.timedreplication";
    private static String TIMEREPLICATIONINTERVAl = "replication.timedreplicationinterval";
    private static String FIRSTTIME = "replication.firsttimedreplication";
    private static final int TIMEINTERVALLIMIT = 0x6DDD00;
    public static final String REPLICATIONUSER = "replication";
    private static int CLIENTTIMEOUT = 30000;
    public static final String REPLICATION_LOG_FILE_NAME = "metacatreplication.log";
    private static String DATA_FILE_FLAG = null;
    public static String METACAT_REPL_ERROR_MSG = null;
    private static Logger logReplication = Logger.getLogger((String)"ReplicationLogging");
    private static Logger logMetacat = Logger.getLogger(ReplicationService.class);

    private ReplicationService() throws ServiceException {
        this._serviceName = "ReplicationService";
        this.initialize();
    }

    private void initialize() throws ServiceException {
        this.replicationDaemon = new Timer(true);
        try {
            String replLogFile = PropertyService.getProperty("replication.logdir") + FileUtil.getFS() + REPLICATION_LOG_FILE_NAME;
            METACAT_REPL_ERROR_MSG = "An error occurred in replication.  Please see the replication log at: " + replLogFile;
            String timedRepIsOnStr = PropertyService.getProperty("replication.timedreplication");
            this.timedReplicationIsOn = new Boolean(timedRepIsOnStr);
            logReplication.info((Object)("ReplicationService.initialize - The timed replication on is" + this.timedReplicationIsOn));
            String timeIntervalStr = PropertyService.getProperty("replication.timedreplicationinterval");
            this.timeInterval = new Long(timeIntervalStr);
            logReplication.info((Object)("ReplicationService.initialize - The timed replication time Interval is " + this.timeInterval));
            String firstTimeStr = PropertyService.getProperty("replication.firsttimedreplication");
            logReplication.info((Object)("ReplicationService.initialize - first replication time form property is " + firstTimeStr));
            this.firstTime = ReplicationHandler.combinateCurrentDateAndGivenTime(firstTimeStr);
            logReplication.info((Object)("ReplicationService.initialize - After combine current time, the real first time is " + this.firstTime.toString() + " minisec"));
            if (this.timedReplicationIsOn) {
                this.replicationDaemon.scheduleAtFixedRate((TimerTask)new ReplicationHandler(), this.firstTime, this.timeInterval);
                logReplication.info((Object)("ReplicationService.initialize - deltaT handler started with rate=" + this.timeInterval + " mini seconds at " + this.firstTime.toString()));
            }
        }
        catch (PropertyNotFoundException pnfe) {
            throw new ServiceException("ReplicationService.initialize - Property error while instantiating replication service: " + pnfe.getMessage());
        }
        catch (HandlerException he) {
            throw new ServiceException("ReplicationService.initialize - Handler error while instantiating replication service" + he.getMessage());
        }
    }

    public static ReplicationService getInstance() throws ServiceException {
        if (replicationService == null) {
            replicationService = new ReplicationService();
        }
        return replicationService;
    }

    @Override
    public boolean refreshable() {
        return true;
    }

    @Override
    protected void doRefresh() throws ServiceException {
    }

    @Override
    public void stop() throws ServiceException {
    }

    public void stopReplication() throws ServiceException {
        this.replicationDaemon.cancel();
        this.replicationDaemon = new Timer(true);
        this.timedReplicationIsOn = false;
        try {
            PropertyService.setProperty("replication.timedreplication", new Boolean(this.timedReplicationIsOn).toString());
        }
        catch (GeneralPropertyException gpe) {
            logReplication.warn((Object)("ReplicationService.stopReplication - Could not set replication.timedreplication property: " + gpe.getMessage()));
        }
        logReplication.info((Object)"ReplicationService.stopReplication - deltaT handler stopped");
    }

    public void startReplication(Hashtable<String, String[]> params) throws ServiceException {
        String firstTimeStr = "";
        if (params.containsKey("rate")) {
            this.timeInterval = new Long(new String(params.get("rate")[0]));
            if (this.timeInterval < 0x6DDD00L) {
                this.timeInterval = 0x6DDD00L;
                throw new ServiceException("Replication deltaT rate cannot be less than 7200000 millisecs and system automatically setup the rate to 7200000");
            }
        } else {
            this.timeInterval = 0x6DDD00L;
        }
        logReplication.info((Object)("ReplicationService.startReplication - New rate is: " + this.timeInterval + " mini seconds."));
        if (params.containsKey("firsttime")) {
            firstTimeStr = params.get("firsttime")[0];
            try {
                this.firstTime = ReplicationHandler.combinateCurrentDateAndGivenTime(firstTimeStr);
                logReplication.info((Object)("ReplicationService.startReplication - The first time setting is " + this.firstTime.toString()));
            }
            catch (HandlerException e) {
                throw new ServiceException(e.getMessage());
            }
        } else {
            logMetacat.error((Object)("ReplicationService.startReplication - " + METACAT_REPL_ERROR_MSG));
            logReplication.error((Object)"ReplicationService.startReplication - You should specify the first time to start a time replication");
            return;
        }
        logReplication.warn((Object)("After combine current time, the real first time is " + this.firstTime.toString() + " minisec"));
        this.timedReplicationIsOn = true;
        try {
            PropertyService.setProperty(TIMEREPLICATION, new Boolean(this.timedReplicationIsOn).toString());
            PropertyService.setProperty(FIRSTTIME, firstTimeStr);
            PropertyService.setProperty(TIMEREPLICATIONINTERVAl, new Long(this.timeInterval).toString());
        }
        catch (GeneralPropertyException gpe) {
            logReplication.warn((Object)("ReplicationService.startReplication - Could not set property: " + gpe.getMessage()));
        }
        this.replicationDaemon.cancel();
        this.replicationDaemon = new Timer(true);
        this.replicationDaemon.scheduleAtFixedRate((TimerTask)new ReplicationHandler(), this.firstTime, this.timeInterval);
        logReplication.info((Object)("ReplicationService.startReplication - deltaT handler started with rate=" + this.timeInterval + " milliseconds at " + this.firstTime.toString()));
    }

    public void runOnce() throws ServiceException {
        this.replicationDaemon.schedule((TimerTask)new ReplicationHandler(), 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void handleServerControlRequest(Hashtable<String, String[]> params, HttpServletRequest request, HttpServletResponse response) {
        block61: {
            boolean showGenerateSystemMetadata;
            PrintWriter out;
            Statement pstmt;
            int serialNumber;
            DBConnection dbConn;
            block57: {
                String serverid;
                String subaction = params.get("subaction")[0];
                dbConn = null;
                serialNumber = -1;
                pstmt = null;
                String replicate = null;
                String server = null;
                String dataReplicate = null;
                String hub = null;
                out = null;
                showGenerateSystemMetadata = true;
                response.setContentType("text/xml");
                out = response.getWriter();
                dbConn = DBConnectionPool.getDBConnection("MetacatReplication.handleServerControlRequest");
                serialNumber = dbConn.getCheckOutSerialNumber();
                if (subaction.equals("add")) {
                    replicate = params.get("replicate")[0];
                    server = params.get("server")[0];
                    dataReplicate = params.get("datareplicate")[0];
                    hub = params.get("hub")[0];
                    Calendar cal = Calendar.getInstance();
                    cal.set(1980, 1, 1);
                    String sql = "INSERT INTO xml_replication (server, last_checked, replicate, datareplicate, hub) VALUES (?,?,?,?,?)";
                    pstmt = dbConn.prepareStatement(sql);
                    pstmt.setString(1, server);
                    pstmt.setTimestamp(2, new Timestamp(cal.getTimeInMillis()));
                    pstmt.setInt(3, Integer.parseInt(replicate));
                    pstmt.setInt(4, Integer.parseInt(dataReplicate));
                    pstmt.setInt(5, Integer.parseInt(hub));
                    String sqlReport = "XMLAccessAccess.getXMLAccessForDoc - SQL: " + sql;
                    sqlReport = sqlReport + " [" + server + "," + replicate + "," + dataReplicate + "," + hub + "]";
                    logMetacat.info((Object)sqlReport);
                    pstmt.execute();
                    pstmt.close();
                    dbConn.commit();
                    ((Writer)out).write("Server " + server + " added");
                    break block57;
                }
                if (subaction.equals("delete")) {
                    server = params.get("server")[0];
                    pstmt = dbConn.prepareStatement("DELETE FROM xml_replication WHERE server LIKE ?");
                    pstmt.setString(1, server);
                    pstmt.execute();
                    pstmt.close();
                    dbConn.commit();
                    ((Writer)out).write("Server " + server + " deleted");
                    break block57;
                }
                if (subaction.equals("list")) break block57;
                if (subaction.equals("generatesystemmetadata")) {
                    GenerateSystemMetadata gsm = new GenerateSystemMetadata();
                    int serverLocation = -1;
                    serverid = params.get("serverid")[0];
                    serverLocation = Integer.parseInt(serverid);
                    gsm.setServerLocation(serverLocation);
                    gsm.multiThreadUpgrade();
                    ((Writer)out).write("System Metadata generated for server " + serverid);
                    break block57;
                }
                if (subaction.equals("generateore")) {
                    GenerateORE gore = new GenerateORE();
                    int serverLocation = -1;
                    serverid = params.get("serverid")[0];
                    serverLocation = Integer.parseInt(serverid);
                    gore.setServerLocation(serverLocation);
                    gore.upgrade();
                    ((Writer)out).write("Generated ORE maps for server " + serverid);
                    break block57;
                }
                if (subaction.equals("updatedoi")) {
                    UpdateDOI udoi = new UpdateDOI();
                    int serverLocation = -1;
                    serverid = params.get("serverid")[0];
                    serverLocation = Integer.parseInt(serverid);
                    udoi.setServerLocation(serverLocation);
                    String ids = params.get("ids")[0];
                    String formatIds = params.get("formatIds")[0];
                    if (ids.length() > 0 || formatIds.length() > 0) {
                        String delimeter;
                        if (ids.length() > 0) {
                            delimeter = " ";
                            String[] idArray = ids.split(delimeter);
                            List<String> idList = Arrays.asList(idArray);
                            udoi.upgradeById(idList);
                        }
                        if (formatIds.length() > 0) {
                            delimeter = " ";
                            String[] formatIdArray = formatIds.split(delimeter);
                            List<String> formatIdList = Arrays.asList(formatIdArray);
                            udoi.upgradeByFormatId(formatIdList);
                        }
                    } else {
                        udoi.upgrade();
                    }
                    ((Writer)out).write("Updated DOI's for server " + serverid);
                    break block57;
                }
                if (subaction.equals("removeinvalidreplicas")) {
                    RemoveInvalidReplicas rir = new RemoveInvalidReplicas();
                    int serverLocation = -1;
                    serverid = params.get("serverid")[0];
                    serverLocation = Integer.parseInt(serverid);
                    rir.setServerLocation(serverLocation);
                    rir.upgrade();
                    ((Writer)out).write("Removed invalid replicas for server " + serverid);
                    break block57;
                }
                if (subaction.equals("syncaccesspolicy")) {
                    SyncAccessPolicy syncAP = new SyncAccessPolicy();
                    response.setContentType("text/html");
                    out = response.getWriter();
                    if (params.containsKey("pid")) {
                        String[] pids = params.get("pid");
                        logMetacat.debug((Object)("Attempting to sync access policies for pids: " + pids));
                        ArrayList<String> pidsToSync = new ArrayList<String>(Arrays.asList(pids));
                        try {
                            List<Identifier> syncedPids = syncAP.sync(pidsToSync);
                            ((Writer)out).write("<html><body>Syncing access policies has completed for " + syncedPids.size() + " pids.</body></html>");
                        }
                        catch (Exception e) {
                            logMetacat.error((Object)("Error syncing all access polies: " + e.getMessage()));
                            response.setContentType("text/html");
                            out = response.getWriter();
                            ((Writer)out).write("<html><body>Error syncing access policies</body></html>");
                        }
                    } else {
                        logMetacat.debug((Object)"Request to sync all access policies has been submitted.");
                        try {
                            syncAP.syncAll();
                            ((Writer)out).write("<html><body>Request to sync all access policies has been submitted.</body></html>");
                        }
                        catch (Exception e) {
                            logMetacat.error((Object)("Error syncing access policies: " + e.getMessage()));
                            ((Writer)out).write("<html><body>Error syncing access policies: " + e.getMessage() + " </body></html>");
                        }
                    }
                    break block57;
                }
                ((Writer)out).write("<error>Unkonwn subaction</error>");
                try {
                    pstmt.close();
                }
                catch (SQLException ee) {
                    logMetacat.error((Object)("ReplicationService.handleServerControlRequest - " + METACAT_REPL_ERROR_MSG));
                    logReplication.error((Object)("ReplicationService.handleServerControlRequest - Error in MetacatReplication.handleServerControlRequest to close pstmt " + ee.getMessage()));
                }
                finally {
                    DBConnectionPool.returnDBConnection(dbConn, serialNumber);
                }
                if (out != null) {
                    try {
                        ((Writer)out).close();
                    }
                    catch (IOException e) {
                        logMetacat.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                return;
            }
            response.setContentType("text/html");
            ((Writer)out).write("<html><body><table border=\"1\">");
            ((Writer)out).write("<tr><td><b>server</b></td>");
            ((Writer)out).write("<td><b>last_checked</b></td>");
            ((Writer)out).write("<td><b>replicate</b></td>");
            ((Writer)out).write("<td><b>datareplicate</b></td>");
            ((Writer)out).write("<td><b>hub</b></td>");
            if (showGenerateSystemMetadata) {
                ((Writer)out).write("<td><b>System Metadata</b></td>");
                ((Writer)out).write("<td><b>ORE Maps</b></td>");
                ((Writer)out).write("<td><b>DOI Registrations</b></td>");
                ((Writer)out).write("<td><b>Invalid Replicas</b></td>");
            }
            ((Writer)out).write("<td><b>Sync Access Policies</b></td>");
            ((Writer)out).write("</tr>");
            pstmt = dbConn.prepareStatement("SELECT serverid, server, last_checked, replicate, datareplicate, hub FROM xml_replication");
            pstmt.execute();
            ResultSet rs = pstmt.getResultSet();
            boolean tablehasrows = rs.next();
            while (tablehasrows) {
                String serverId = rs.getString(1);
                ((Writer)out).write("<tr><td>" + rs.getString(2) + "</td><td>");
                ((Writer)out).write(rs.getString(3) + "</td><td>");
                ((Writer)out).write(rs.getString(4) + "</td><td>");
                ((Writer)out).write(rs.getString(5) + "</td><td>");
                ((Writer)out).write(rs.getString(6) + "</td>");
                if (showGenerateSystemMetadata) {
                    ((Writer)out).write("<td><form action='" + request.getContextPath() + "/admin'>");
                    ((Writer)out).write("<input name='serverid' type='hidden' value='" + serverId + "'/>");
                    ((Writer)out).write("<input name='configureType' type='hidden' value='replication'/>");
                    ((Writer)out).write("<input name='action' type='hidden' value='servercontrol'/>");
                    ((Writer)out).write("<input name='subaction' type='hidden' value='generatesystemmetadata'/>");
                    ((Writer)out).write("<input type='submit' value='Generate System Metadata'/>");
                    ((Writer)out).write("</form></td>");
                    ((Writer)out).write("<td><form action='" + request.getContextPath() + "/admin'>");
                    ((Writer)out).write("<input name='serverid' type='hidden' value='" + serverId + "'/>");
                    ((Writer)out).write("<input name='configureType' type='hidden' value='replication'/>");
                    ((Writer)out).write("<input name='action' type='hidden' value='servercontrol'/>");
                    ((Writer)out).write("<input name='subaction' type='hidden' value='generateore'/>");
                    ((Writer)out).write("<input type='submit' value='Generate ORE'/>");
                    ((Writer)out).write("</form></td>");
                    ((Writer)out).write("<td><form action='" + request.getContextPath() + "/admin'>");
                    ((Writer)out).write("<input name='serverid' type='hidden' value='" + serverId + "'/>");
                    ((Writer)out).write("<input name='configureType' type='hidden' value='replication'/>");
                    ((Writer)out).write("<input name='action' type='hidden' value='servercontrol'/>");
                    ((Writer)out).write("<input name='subaction' type='hidden' value='updatedoi'/>");
                    ((Writer)out).write("<label>Update by ID:</label>");
                    ((Writer)out).write("<textarea name='ids'></textarea>");
                    ((Writer)out).write("<label>Update by formatId:</label>");
                    ((Writer)out).write("<textarea name='formatIds'></textarea>");
                    ((Writer)out).write("<input type='submit' value='Update DOIs'/>");
                    ((Writer)out).write("</form></td>");
                    ((Writer)out).write("<td><form action='" + request.getContextPath() + "/admin'>");
                    ((Writer)out).write("<input name='serverid' type='hidden' value='" + serverId + "'/>");
                    ((Writer)out).write("<input name='configureType' type='hidden' value='replication'/>");
                    ((Writer)out).write("<input name='action' type='hidden' value='servercontrol'/>");
                    ((Writer)out).write("<input name='subaction' type='hidden' value='removeinvalidreplicas'/>");
                    String disabled = "";
                    if (Integer.valueOf(serverId) == 1) {
                        disabled = "disabled='true'";
                    }
                    ((Writer)out).write("<input type='submit' value='Remove Invalid Replicas' " + disabled + " />");
                    ((Writer)out).write("</form></td>");
                }
                ((Writer)out).write("<td><form action='" + request.getContextPath() + "/admin'>");
                ((Writer)out).write("<input name='serverid' type='hidden' value='" + serverId + "'/>");
                ((Writer)out).write("<input name='configureType' type='hidden' value='replication'/>");
                ((Writer)out).write("<input name='action' type='hidden' value='servercontrol'/>");
                ((Writer)out).write("<input name='subaction' type='hidden' value='syncaccesspolicy'/>");
                ((Writer)out).write("<input type='submit' value='Sync access policies'/>");
                ((Writer)out).write("</form></td>");
                ((Writer)out).write("</tr>");
                tablehasrows = rs.next();
            }
            ((Writer)out).write("</table></body></html>");
            pstmt.close();
            try {
                pstmt.close();
            }
            catch (SQLException ee) {
                logMetacat.error((Object)("ReplicationService.handleServerControlRequest - " + METACAT_REPL_ERROR_MSG));
                logReplication.error((Object)("ReplicationService.handleServerControlRequest - Error in MetacatReplication.handleServerControlRequest to close pstmt " + ee.getMessage()));
            }
            finally {
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            }
            if (out != null) {
                try {
                    ((Writer)out).close();
                }
                catch (IOException e) {
                    logMetacat.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            break block61;
            catch (Exception e) {
                try {
                    logMetacat.error((Object)("ReplicationService.handleServerControlRequest - " + METACAT_REPL_ERROR_MSG));
                    logReplication.error((Object)("ReplicationService.handleServerControlRequest - Error in MetacatReplication.handleServerControlRequest " + e.getMessage()));
                    e.printStackTrace(System.out);
                }
                catch (Throwable throwable) {
                    try {
                        pstmt.close();
                    }
                    catch (SQLException ee) {
                        try {
                            logMetacat.error((Object)("ReplicationService.handleServerControlRequest - " + METACAT_REPL_ERROR_MSG));
                            logReplication.error((Object)("ReplicationService.handleServerControlRequest - Error in MetacatReplication.handleServerControlRequest to close pstmt " + ee.getMessage()));
                        }
                        catch (Throwable throwable2) {
                            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
                            throw throwable2;
                        }
                        DBConnectionPool.returnDBConnection(dbConn, serialNumber);
                    }
                    DBConnectionPool.returnDBConnection(dbConn, serialNumber);
                    if (out != null) {
                        try {
                            ((Writer)out).close();
                        }
                        catch (IOException e2) {
                            logMetacat.error((Object)e2.getMessage(), (Throwable)e2);
                        }
                    }
                    throw throwable;
                }
                try {
                    pstmt.close();
                }
                catch (SQLException ee) {
                    logMetacat.error((Object)("ReplicationService.handleServerControlRequest - " + METACAT_REPL_ERROR_MSG));
                    logReplication.error((Object)("ReplicationService.handleServerControlRequest - Error in MetacatReplication.handleServerControlRequest to close pstmt " + ee.getMessage()));
                }
                finally {
                    DBConnectionPool.returnDBConnection(dbConn, serialNumber);
                }
                if (out != null) {
                    try {
                        ((Writer)out).close();
                    }
                    catch (IOException e3) {
                        logMetacat.error((Object)e3.getMessage(), (Throwable)e3);
                    }
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected static void handleForceReplicateRequest(Hashtable<String, String[]> params, HttpServletResponse response, HttpServletRequest request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static void handleForceReplicateDeleteRequest(Hashtable<String, String[]> params, HttpServletResponse response, HttpServletRequest request, boolean removeAll) {
        String server = params.get("server")[0];
        String docid = params.get("docid")[0];
        try {
            logReplication.info((Object)("ReplicationService.handleForceReplicateDeleteRequest - force replication delete request from " + server));
            logReplication.info((Object)("ReplicationService.handleForceReplicateDeleteRequest - force replication delete docid " + docid));
            logReplication.info((Object)("ReplicationService.handleForceReplicateDeleteRequest - Force replication delete request from: " + server));
            logReplication.info((Object)("ReplicationService.handleForceReplicateDeleteRequest - Force replication delete docid: " + docid));
            DocumentImpl.delete(docid, null, null, server, removeAll);
            logReplication.info((Object)("ReplicationService.handleForceReplicateDeleteRequest - document " + docid + " was successfully deleted "));
            EventLog.getInstance().log(request.getRemoteAddr(), request.getHeader("User-Agent"), REPLICATIONUSER, docid, "delete");
            logReplication.info((Object)("ReplicationService.handleForceReplicateDeleteRequest - document " + docid + " was successfully deleted "));
        }
        catch (McdbDocNotFoundException e) {
            logMetacat.error((Object)("ReplicationService.handleForceReplicateDeleteRequest - " + METACAT_REPL_ERROR_MSG));
            logReplication.error((Object)("document " + docid + " failed to delete because " + e.getMessage()));
            logReplication.error((Object)("ReplicationService.handleForceReplicateDeleteRequest - error: " + e.getMessage()));
        }
        catch (InsufficientKarmaException e) {
            logMetacat.error((Object)("ReplicationService.handleForceReplicateDeleteRequest - " + METACAT_REPL_ERROR_MSG));
            logReplication.error((Object)("document " + docid + " failed to delete because " + e.getMessage()));
            logReplication.error((Object)("ReplicationService.handleForceReplicateDeleteRequest - error: " + e.getMessage()));
        }
        catch (SQLException e) {
            logMetacat.error((Object)("ReplicationService.handleForceReplicateDeleteRequest - " + METACAT_REPL_ERROR_MSG));
            logReplication.error((Object)("document " + docid + " failed to delete because " + e.getMessage()));
            logReplication.error((Object)("ReplicationService.handleForceReplicateDeleteRequest - error: " + e.getMessage()));
        }
        catch (Exception e) {
            logMetacat.error((Object)("ReplicationService.handleForceReplicateDeleteRequest - " + METACAT_REPL_ERROR_MSG));
            logReplication.error((Object)("document " + docid + " failed to delete because " + e.getMessage()));
            logReplication.error((Object)("ReplicationService.handleForceReplicateDeleteRequest - error: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void handleForceReplicateDataFileRequest(Hashtable<String, String[]> params, HttpServletRequest request) {
        if (params.isEmpty()) {
            return;
        }
        String server = params.get("server")[0];
        String docid = params.get("docid")[0];
        if (docid == null || server == null || server.equals("")) {
            logMetacat.error((Object)("ReplicationService.handleForceReplicateDataFileRequest - " + METACAT_REPL_ERROR_MSG));
            logReplication.error((Object)"ReplicationService.handleForceReplicateDataFileRequest - Didn't specify docid or server for replication");
            return;
        }
        String dbaction = null;
        try {
            dbaction = params.containsKey("dbaction") ? params.get("dbaction")[0] : null;
            logReplication.info((Object)("ReplicationService.handleForceReplicateDataFileRequest - Force replication request from: " + server));
            logReplication.info((Object)("ReplicationService.handleForceReplicateDataFileRequest - Force replication docid: " + docid));
            logReplication.info((Object)("ReplicationService.handleForceReplicateDataFileRequest - Force replication action: " + dbaction));
            URL docinfourl = new URL("https://" + server + "?server=" + MetacatUtil.getLocalReplicationServerName() + "&action=getdocumentinfo&docid=" + docid);
            String docInfoStr = ReplicationService.getURLContent(docinfourl);
            String systemMetadataXML = ReplicationUtil.getSystemMetadataContent(docInfoStr);
            docInfoStr = ReplicationUtil.getContentWithoutSystemMetadata(docInfoStr);
            DocInfoHandler dih = new DocInfoHandler();
            XMLReader docinfoParser = ReplicationHandler.initParser((DefaultHandler)dih);
            docinfoParser.parse(new InputSource(new StringReader(docInfoStr)));
            Hashtable docinfoHash = dih.getDocInfo();
            String docName = (String)docinfoHash.get("docname");
            String docType = (String)docinfoHash.get("doctype");
            String docHomeServer = (String)docinfoHash.get("home_server");
            String createdDateString = (String)docinfoHash.get("date_created");
            String updatedDateString = (String)docinfoHash.get("date_updated");
            Date createdDate = DateTimeMarshaller.deserializeDateToUTC((String)createdDateString);
            Date updatedDate = DateTimeMarshaller.deserializeDateToUTC((String)updatedDateString);
            logReplication.info((Object)("ReplicationService.handleForceReplicateDataFileRequest - docHomeServer of datafile: " + docHomeServer));
            Exception writeException = null;
            if (dbaction != null && (dbaction.equals("insert") || dbaction.equals("update"))) {
                URL url = new URL("https://" + server + "?server=" + MetacatUtil.getLocalReplicationServerName() + "&action=readdata&docid=" + docid);
                String datafilePath = PropertyService.getProperty("application.datafilepath");
                InputStream inputStream = null;
                try {
                    inputStream = ReplicationService.getURLStream(url);
                    DocumentImpl.writeDataFileInReplication(inputStream, datafilePath, docName, docType, docid, null, docHomeServer, server, "xml_documents", false, createdDate, updatedDate);
                }
                catch (Exception e) {
                    writeException = e;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
            }
            DBConnection dbConn = DBConnectionPool.getDBConnection("ReplicationService.handleForceDataFileRequest");
            int serialNumber = dbConn.getCheckOutSerialNumber();
            dbConn.setAutoCommit(false);
            String user = (String)docinfoHash.get("user_owner");
            String updated = (String)docinfoHash.get("user_updated");
            ReplicationService.updateUserOwner(dbConn, docid, user, updated);
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            if (systemMetadataXML != null) {
                SystemMetadata sysMeta = (SystemMetadata)TypeMarshaller.unmarshalTypeFromStream(SystemMetadata.class, (InputStream)new ByteArrayInputStream(systemMetadataXML.getBytes("UTF-8")));
                boolean mappingExists = true;
                mappingExists = IdentifierManager.getInstance().mappingExists(sysMeta.getIdentifier().getValue());
                if (!mappingExists) {
                    IdentifierManager.getInstance().createMapping(sysMeta.getIdentifier().getValue(), docid);
                }
                HazelcastService.getInstance().getSystemMetadataMap().put((Object)sysMeta.getIdentifier(), (Object)sysMeta);
                MetacatSolrIndex.getInstance().submit(sysMeta.getIdentifier(), sysMeta, null, true);
            }
            try {
                String docidNoRev = DocumentUtil.getDocIdFromAccessionNumber(docid);
                int rev = DocumentUtil.getRevisionFromAccessionNumber(docid);
                IdentifierManager.getInstance().getGUID(docidNoRev, rev);
            }
            catch (McdbDocNotFoundException mcdbe) {
                IdentifierManager.getInstance().createMapping(docid, docid);
            }
            Vector accessControlList = dih.getAccessControlList();
            if (accessControlList != null) {
                AccessControlForSingleFile acfsf = new AccessControlForSingleFile(docid);
                for (XMLAccessDAO xmlAccessDAO : accessControlList) {
                    if (acfsf.accessControlExists(xmlAccessDAO)) continue;
                    acfsf.insertPermissions(xmlAccessDAO);
                    logReplication.info((Object)("ReplicationService.handleForceReplicateRequest - document " + docid + " permissions added to DB"));
                }
            }
            if (writeException != null) {
                throw writeException;
            }
            logReplication.info((Object)("ReplicationService.handleForceReplicateDataFileRequest - datafile " + docid + " added to DB with " + "action " + dbaction));
            EventLog.getInstance().log(request.getRemoteAddr(), request.getHeader("User-Agent"), REPLICATIONUSER, docid, dbaction);
        }
        catch (Exception e) {
            e.printStackTrace();
            logMetacat.error((Object)("ReplicationService.handleForceReplicateDataFileRequest - " + METACAT_REPL_ERROR_MSG), (Throwable)e);
            logReplication.error((Object)("ReplicationService.handleForceReplicateDataFileRequest - Datafile " + docid + " failed to added to DB with " + "action " + dbaction + " because " + e.getMessage()));
            logReplication.error((Object)("ReplicationService.handleForceReplicateDataFileRequest - ERROR in MetacatReplication.handleForceDataFileReplicateRequest(): " + e.getMessage()));
        }
    }

    protected static void handleGetLockRequest(Hashtable<String, String[]> params, HttpServletResponse response) {
        try {
            String docid = params.get("docid")[0];
            String remoteRev = params.get("updaterev")[0];
            DocumentImpl requestDoc = new DocumentImpl(docid);
            logReplication.info((Object)("ReplicationService.handleGetLockRequest - lock request for " + docid));
            int localRevInt = requestDoc.getRev();
            int remoteRevInt = Integer.parseInt(remoteRev);
            response.setContentType("text/xml");
            PrintWriter out = response.getWriter();
            if (remoteRevInt >= localRevInt) {
                if (!fileLocks.contains(docid)) {
                    fileLocks.add(0, docid);
                    ((Writer)out).write("<lockgranted><docid>" + docid + "</docid></lockgranted>");
                    logReplication.info((Object)("ReplicationService.handleGetLockRequest - lock granted for " + docid));
                } else {
                    ((Writer)out).write("<filelocked><docid>" + docid + "</docid></filelocked>");
                    logReplication.info((Object)("ReplicationService.handleGetLockRequest - lock denied for " + docid + "reason: file already locked"));
                }
            } else {
                ((Writer)out).write("<outdatedfile><docid>" + docid + "</docid></filelocked>");
                logReplication.info((Object)("ReplicationService.handleGetLockRequest - lock denied for " + docid + "reason: client has outdated file"));
            }
            ((Writer)out).close();
        }
        catch (Exception e) {
            logMetacat.error((Object)("ReplicationService.handleGetLockRequest - " + METACAT_REPL_ERROR_MSG));
            logReplication.error((Object)("ReplicationService.handleGetLockRequest - error requesting file lock from MetacatReplication.handleGetLockRequest: " + e.getMessage()));
            e.printStackTrace(System.out);
        }
    }

    protected static void handleGetDocumentInfoRequest(Hashtable<String, String[]> params, HttpServletResponse response) {
        String docid = params.get("docid")[0];
        try {
            String docinfoXML = ReplicationService.getDocumentInfo(docid);
            response.setContentType("text/xml");
            PrintWriter out = response.getWriter();
            ((Writer)out).write(docinfoXML);
            ((Writer)out).close();
        }
        catch (Exception e) {
            logMetacat.error((Object)("ReplicationService.handleGetDocumentInfoRequest - " + METACAT_REPL_ERROR_MSG));
            logReplication.error((Object)("ReplicationService.handleGetDocumentInfoRequest - error in metacatReplication.handlegetdocumentinforequest for doc: " + docid + " : " + e.getMessage()));
        }
    }

    public static Hashtable<String, String> getDocumentInfoMap(String docid) throws HandlerException, AccessControlException, MarshallingException, IOException, McdbException, SAXException {
        DocInfoHandler dih = new DocInfoHandler();
        XMLReader docinfoParser = ReplicationHandler.initParser((DefaultHandler)dih);
        String docInfoStr = ReplicationService.getDocumentInfo(docid);
        String systemMetadataXML = ReplicationUtil.getSystemMetadataContent(docInfoStr);
        docInfoStr = ReplicationUtil.getContentWithoutSystemMetadata(docInfoStr);
        docinfoParser.parse(new InputSource(new StringReader(docInfoStr)));
        Hashtable docinfoHash = dih.getDocInfo();
        return docinfoHash;
    }

    public static String getDocumentInfo(String docid) throws AccessControlException, MarshallingException, IOException, McdbException {
        StringBuffer sb = new StringBuffer();
        DocumentImpl doc = new DocumentImpl(docid);
        sb.append("<documentinfo><docid>").append(docid);
        sb.append("</docid>");
        try {
            String guid = IdentifierManager.getInstance().getGUID(doc.getDocID(), doc.getRev());
            SystemMetadata systemMetadata = IdentifierManager.getInstance().getSystemMetadata(guid);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            TypeMarshaller.marshalTypeToOutputStream((Object)systemMetadata, (OutputStream)baos);
            String systemMetadataXML = baos.toString("UTF-8");
            sb.append("<systemMetadata>");
            sb.append(systemMetadataXML);
            sb.append("</systemMetadata>");
        }
        catch (McdbDocNotFoundException e) {
            logMetacat.warn((Object)("No SystemMetadata found for: " + docid));
        }
        Calendar created = Calendar.getInstance();
        created.setTime(doc.getCreateDate());
        Calendar updated = Calendar.getInstance();
        updated.setTime(doc.getUpdateDate());
        sb.append("<docname><![CDATA[").append(doc.getDocname());
        sb.append("]]></docname><doctype>").append(doc.getDoctype());
        sb.append("</doctype>");
        sb.append("<user_owner>").append(doc.getUserowner());
        sb.append("</user_owner><user_updated>").append(doc.getUserupdated());
        sb.append("</user_updated>");
        sb.append("<date_created>");
        sb.append(DateTimeMarshaller.serializeDateToUTC((Date)doc.getCreateDate()));
        sb.append("</date_created>");
        sb.append("<date_updated>");
        sb.append(DateTimeMarshaller.serializeDateToUTC((Date)doc.getUpdateDate()));
        sb.append("</date_updated>");
        sb.append("<home_server>");
        sb.append(doc.getDocHomeServer());
        sb.append("</home_server>");
        sb.append("<public_access>").append(doc.getPublicaccess());
        sb.append("</public_access><rev>").append(doc.getRev());
        sb.append("</rev>");
        sb.append("<accessControl>");
        AccessControlForSingleFile acfsf = new AccessControlForSingleFile(docid);
        sb.append(acfsf.getAccessString());
        sb.append("</accessControl>");
        sb.append("</documentinfo>");
        return sb.toString();
    }

    protected static void handleGetSystemMetadataRequest(Hashtable<String, String[]> params, HttpServletResponse response) {
        String guid = params.get("guid")[0];
        String systemMetadataXML = null;
        try {
            SystemMetadata systemMetadata = IdentifierManager.getInstance().getSystemMetadata(guid);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            TypeMarshaller.marshalTypeToOutputStream((Object)systemMetadata, (OutputStream)baos);
            systemMetadataXML = baos.toString("UTF-8");
            response.setContentType("text/xml");
            PrintWriter out = response.getWriter();
            ((Writer)out).write(systemMetadataXML);
            ((Writer)out).close();
        }
        catch (Exception e) {
            String msg = "ReplicationService.handleGetSystemMetadataRequest for guid: " + guid + " : " + e.getMessage();
            logMetacat.error((Object)msg);
            logReplication.error((Object)msg);
        }
    }

    protected static void handleForceReplicateSystemMetadataRequest(Hashtable<String, String[]> params, HttpServletResponse response, HttpServletRequest request) {
        String server = params.get("server")[0];
        String guid = params.get("guid")[0];
        try {
            logReplication.info((Object)("ReplicationService.handleForceReplicateSystemMetadataRequest - Force replication system metadata request from: " + server));
            URL docinfourl = new URL("https://" + server + "?server=" + MetacatUtil.getLocalReplicationServerName() + "&action=getsystemmetadata&guid=" + guid);
            String systemMetadataXML = ReplicationService.getURLContent(docinfourl);
            if (systemMetadataXML != null) {
                SystemMetadata sysMeta = (SystemMetadata)TypeMarshaller.unmarshalTypeFromStream(SystemMetadata.class, (InputStream)new ByteArrayInputStream(systemMetadataXML.getBytes("UTF-8")));
                HazelcastService.getInstance().getSystemMetadataMap().put((Object)sysMeta.getIdentifier(), (Object)sysMeta);
                MetacatSolrIndex.getInstance().submit(sysMeta.getIdentifier(), sysMeta, null, true);
            }
            logReplication.info((Object)("ReplicationService.handleForceReplicateSystemMetadataRequest - processed guid: " + guid));
            EventLog.getInstance().log(request.getRemoteAddr(), request.getHeader("User-Agent"), REPLICATIONUSER, guid, "systemMetadata");
        }
        catch (Exception e) {
            logMetacat.error((Object)("ReplicationService.handleForceReplicateRequest - " + METACAT_REPL_ERROR_MSG), (Throwable)e);
            logReplication.error((Object)("ReplicationService.handleForceReplicateRequest - General error when processing guid: " + guid), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void handleGetDataFileRequest(OutputStream outPut, Hashtable<String, String[]> params, HttpServletResponse response) {
        File f;
        String filepath;
        String docId = params.get("docid")[0];
        if (docId == null) {
            logMetacat.error((Object)("ReplicationService.handleGetDataFileRequest - " + METACAT_REPL_ERROR_MSG));
            logReplication.error((Object)"ReplicationService.handleGetDataFileRequest - Didn't specify docid for replication");
            return;
        }
        try {
            filepath = PropertyService.getProperty("application.datafilepath");
            String server = params.get("server")[0];
            URL u = new URL("https://" + server + "?server=" + MetacatUtil.getLocalReplicationServerName() + "&action=test");
            String test = ReplicationService.getURLContent(u);
            if (test.indexOf("successfully") == -1) {
                logMetacat.error((Object)("ReplicationService.handleGetDataFileRequest - " + METACAT_REPL_ERROR_MSG));
                logReplication.error((Object)"ReplicationService.handleGetDataFileRequest - Couldn't pass the trust test");
                return;
            }
        }
        catch (Exception ee) {
            return;
        }
        if (!filepath.endsWith("/")) {
            filepath = filepath + "/";
        }
        String filename = filepath + docId;
        String contentType = null;
        contentType = filename.endsWith(".xml") ? "text/xml" : (filename.endsWith(".css") ? "text/css" : (filename.endsWith(".dtd") ? "text/plain" : (filename.endsWith(".xsd") ? "text/xml" : (filename.endsWith("/") ? "text/html" : ((f = new File(filename)).isDirectory() ? "text/html" : "application/octet-stream")))));
        response.setContentType(contentType);
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(filename);
            byte[] buf = new byte[4096];
            int b = fin.read(buf);
            while (b != -1) {
                outPut.write(buf, 0, b);
                b = fin.read(buf);
            }
            fin.close();
        }
        catch (Exception e) {
            try {
                logMetacat.error((Object)("ReplicationService.handleGetDataFileRequest - " + METACAT_REPL_ERROR_MSG));
                logReplication.error((Object)("ReplicationService.handleGetDataFileRequest - error getting data file from MetacatReplication.handlGetDataFileRequest " + e.getMessage()));
                e.printStackTrace(System.out);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fin);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fin);
        }
        IOUtils.closeQuietly((InputStream)fin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void handleGetDocumentRequest(Hashtable<String, String[]> params, HttpServletResponse response) {
        String errorMsg;
        block27: {
            String urlString = null;
            String documentPath = null;
            errorMsg = null;
            FileOutputStream fos = null;
            InputStream is = null;
            ServletOutputStream outputStream = null;
            try {
                String server = params.get("server")[0];
                urlString = "https://" + server + "?server=" + MetacatUtil.getLocalReplicationServerName() + "&action=test";
                URL u = new URL(urlString);
                String test = ReplicationService.getURLContent(u);
                if (test.indexOf("successfully") == -1) {
                    response.setContentType("text/xml");
                    PrintWriter out = response.getWriter();
                    ((Writer)out).write("<error>Couldn't pass the trust test " + test + " </error>");
                    ((Writer)out).close();
                    return;
                }
                String docid = params.get("docid")[0];
                logReplication.debug((Object)("ReplicationService.handleGetDocumentRequest - MetacatReplication.handleGetDocumentRequest for docid: " + docid));
                DocumentImpl di = new DocumentImpl(docid);
                String documentDir = PropertyService.getProperty("application.documentfilepath");
                documentPath = documentDir + FileUtil.getFS() + docid;
                if (FileUtil.getFileStatus((String)documentPath) == FileUtil.DOES_NOT_EXIST || FileUtil.getFileSize((String)documentPath) == 0L) {
                    fos = new FileOutputStream(documentPath);
                    is = di.toXml(fos, null, null, true);
                    fos.close();
                    is.close();
                }
                outputStream = response.getOutputStream();
                is = di.readFromFileSystem((OutputStream)outputStream, null, null, documentPath);
                is.close();
                outputStream.close();
                logReplication.info((Object)("ReplicationService.handleGetDocumentRequest - document " + docid + " sent"));
                IOUtils.closeQuietly((OutputStream)fos);
            }
            catch (MalformedURLException mue) {
                logMetacat.error((Object)("ReplicationService.handleGetDocumentRequest - " + METACAT_REPL_ERROR_MSG));
                logReplication.error((Object)("ReplicationService.handleGetDocumentRequest - Url error when getting document from MetacatReplication.handlGetDocumentRequest for url: " + urlString + " : " + mue.getMessage()));
                break block27;
            }
            catch (IOException ioe) {
                logMetacat.error((Object)("ReplicationService.handleGetDocumentRequest - " + METACAT_REPL_ERROR_MSG));
                logReplication.error((Object)("ReplicationService.handleGetDocumentRequest - I/O error when getting document from MetacatReplication.handlGetDocumentRequest for file: " + documentPath + " : " + ioe.getMessage()));
                errorMsg = ioe.getMessage();
                break block27;
            }
            catch (PropertyNotFoundException pnfe) {
                logMetacat.error((Object)("ReplicationService.handleGetDocumentRequest - " + METACAT_REPL_ERROR_MSG));
                logReplication.error((Object)("ReplicationService.handleGetDocumentRequest - Error getting property when getting document from MetacatReplication.handlGetDocumentRequest for file: " + documentPath + " : " + pnfe.getMessage()));
                errorMsg = pnfe.getMessage();
                break block27;
            }
            catch (McdbException me) {
                logReplication.error((Object)("ReplicationService.handleGetDocumentRequest - Document implementation error  getting property when getting document from MetacatReplication.handlGetDocumentRequest for file: " + documentPath + " : " + me.getMessage()));
                errorMsg = me.getMessage();
                break block27;
            }
            catch (Exception e) {
                logReplication.error((Object)("ReplicationService.handleGetDocumentRequest - General exception encountered.handlGetDocumentRequest for file: " + documentPath + " : " + e.getMessage()));
                errorMsg = e.getMessage();
                break block27;
            }
            finally {
                IOUtils.closeQuietly(fos);
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly(outputStream);
            }
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((OutputStream)outputStream);
            return;
        }
        response.setContentType("text/xml");
        Writer out = null;
        try {
            response.getWriter();
            out = response.getWriter();
            out.write("<error>" + errorMsg + "</error>");
        }
        catch (Exception e) {
            logMetacat.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                logMetacat.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void handleUpdateRequest(Hashtable<String, String[]> params, HttpServletResponse response) {
        boolean replicateData;
        boolean tablehasrows;
        ResultSet rs;
        StringBuffer delsql;
        Vector packageFiles;
        StringBuffer revisionSql;
        PrintWriter out;
        Statement pstmt;
        int serialNumber;
        DBConnection dbConn;
        block71: {
            Vector<String> v;
            Vector<String> packagedoctypes;
            String recordDoctype;
            block69: {
                String server;
                ReplicationServerList serverList;
                block67: {
                    block65: {
                        block63: {
                            dbConn = null;
                            serialNumber = -1;
                            pstmt = null;
                            serverList = null;
                            out = null;
                            response.setContentType("text/xml");
                            out = response.getWriter();
                            dbConn = DBConnectionPool.getDBConnection("MetacatReplication.handleUpdateRequest");
                            serialNumber = dbConn.getCheckOutSerialNumber();
                            serverList = new ReplicationServerList();
                            server = params.get("server")[0];
                            if (server != null && !server.equals("")) break block63;
                            ((Writer)out).write("<error>Request didn't specify server name</error>");
                            ((Writer)out).close();
                            try {
                                pstmt.close();
                            }
                            catch (SQLException ee) {
                                logMetacat.error((Object)("ReplicationService.handleUpdateRequest - " + METACAT_REPL_ERROR_MSG));
                                logReplication.error((Object)("ReplicationService.handleUpdateRequest - Error in MetacatReplication.handleUpdaterequest to close pstmt: " + ee.getMessage()));
                            }
                            finally {
                                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
                            }
                            try {
                                ((Writer)out).close();
                                return;
                            }
                            catch (IOException e) {
                                logMetacat.error((Object)e.getMessage(), (Throwable)e);
                            }
                            return;
                        }
                        String testUrl = "https://" + server + "?server=" + MetacatUtil.getLocalReplicationServerName() + "&action=test";
                        logReplication.info((Object)("Running trust test: " + testUrl));
                        URL u = new URL(testUrl);
                        String test = ReplicationService.getURLContent(u);
                        logReplication.info((Object)("Ouput from test is '" + test + "'"));
                        if (test.indexOf("successfully") != -1) break block65;
                        logReplication.error((Object)"Trust test failed.");
                        ((Writer)out).write("<error>Couldn't pass the trust test</error>");
                        ((Writer)out).close();
                        try {
                            pstmt.close();
                        }
                        catch (SQLException ee) {
                            logMetacat.error((Object)("ReplicationService.handleUpdateRequest - " + METACAT_REPL_ERROR_MSG));
                            logReplication.error((Object)("ReplicationService.handleUpdateRequest - Error in MetacatReplication.handleUpdaterequest to close pstmt: " + ee.getMessage()));
                        }
                        finally {
                            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
                        }
                        try {
                            ((Writer)out).close();
                            return;
                        }
                        catch (IOException e) {
                            logMetacat.error((Object)e.getMessage(), (Throwable)e);
                        }
                        return;
                    }
                    logReplication.info((Object)"Trust test succeeded.");
                    if (serverList.getReplicationValue(server)) break block67;
                    ((Writer)out).write("<error>Configuration not allow to replicate document to you</error>");
                    ((Writer)out).close();
                    try {
                        pstmt.close();
                    }
                    catch (SQLException ee) {
                        logMetacat.error((Object)("ReplicationService.handleUpdateRequest - " + METACAT_REPL_ERROR_MSG));
                        logReplication.error((Object)("ReplicationService.handleUpdateRequest - Error in MetacatReplication.handleUpdaterequest to close pstmt: " + ee.getMessage()));
                    }
                    finally {
                        DBConnectionPool.returnDBConnection(dbConn, serialNumber);
                    }
                    try {
                        ((Writer)out).close();
                        return;
                    }
                    catch (IOException e) {
                        logMetacat.error((Object)e.getMessage(), (Throwable)e);
                    }
                    return;
                }
                try {
                    StringBuffer docsql = new StringBuffer();
                    revisionSql = new StringBuffer();
                    packageFiles = new Vector();
                    ((Writer)out).append("<?xml version=\"1.0\"?><replication>");
                    ((Writer)out).append("<server>").append(MetacatUtil.getLocalReplicationServerName());
                    ((Writer)out).append("</server><updates>");
                    docsql.append(DatabaseService.getInstance().getDBAdapter().getReplicationDocumentListSQL());
                    revisionSql.append("select docid, rev, doctype from xml_revisions ");
                    if (!serverList.getHubValue(server)) {
                        String serverLocationDoc = " and a.server_location = 1";
                        String serverLocationRev = "where server_location = 1";
                        docsql.append(serverLocationDoc);
                        revisionSql.append(serverLocationRev);
                    }
                    logReplication.info((Object)("ReplicationService.handleUpdateRequest - Doc sql: " + docsql.toString()));
                    delsql = new StringBuffer();
                    delsql.append("SELECT t1.docid FROM xml_revisions t1 LEFT JOIN xml_documents t2 on t1.docid = t2.docid WHERE t2.docid IS NULL ");
                    if (!serverList.getHubValue(server)) {
                        delsql.append("and t1.server_location = 1");
                    }
                    logReplication.info((Object)("ReplicationService.handleUpdateRequest - Deleted sql: " + delsql.toString()));
                    pstmt = dbConn.prepareStatement(docsql.toString());
                    pstmt.execute();
                    rs = pstmt.getResultSet();
                    tablehasrows = rs.next();
                    replicateData = serverList.getDataReplicationValue(server);
                    if (!replicateData) break block69;
                    while (tablehasrows) {
                        recordDoctype = rs.getString(3);
                        packagedoctypes = MetacatUtil.getOptionList(PropertyService.getProperty("xml.packagedoctype"));
                        if (recordDoctype != null && !packagedoctypes.contains(recordDoctype)) {
                            if (!recordDoctype.equals("BIN")) {
                                ((Writer)out).append("<updatedDocument>");
                                ((Writer)out).append("<docid>").append(rs.getString(1));
                                ((Writer)out).append("</docid><rev>" + rs.getInt(2));
                                ((Writer)out).append("</rev>");
                                ((Writer)out).append("</updatedDocument>");
                            } else {
                                ((Writer)out).append("<updatedDocument>");
                                ((Writer)out).append("<docid>").append(rs.getString(1));
                                ((Writer)out).append("</docid><rev>" + rs.getInt(2));
                                ((Writer)out).append("</rev>");
                                ((Writer)out).append("<datafile>");
                                ((Writer)out).append(DATA_FILE_FLAG);
                                ((Writer)out).append("</datafile>");
                                ((Writer)out).append("</updatedDocument>");
                            }
                        } else {
                            v = new Vector<String>();
                            v.add(rs.getString(1));
                            v.add(String.valueOf(rs.getInt(2)));
                            packageFiles.add(v);
                        }
                        tablehasrows = rs.next();
                    }
                    break block71;
                }
                catch (Exception e) {
                    try {
                        logMetacat.error((Object)("ReplicationService.handleUpdateRequest - " + METACAT_REPL_ERROR_MSG));
                        logReplication.error((Object)("ReplicationService.handleUpdateRequest - error in MetacatReplication.handleupdaterequest: " + e.getMessage()));
                        try {
                            ((Writer)out).write("<error>" + e.getMessage() + "</error>");
                        }
                        catch (IOException e1) {
                            logMetacat.error((Object)e1.getMessage(), (Throwable)e1);
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            pstmt.close();
                        }
                        catch (SQLException ee) {
                            try {
                                logMetacat.error((Object)("ReplicationService.handleUpdateRequest - " + METACAT_REPL_ERROR_MSG));
                                logReplication.error((Object)("ReplicationService.handleUpdateRequest - Error in MetacatReplication.handleUpdaterequest to close pstmt: " + ee.getMessage()));
                            }
                            catch (Throwable throwable2) {
                                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
                                throw throwable2;
                            }
                            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
                        }
                        DBConnectionPool.returnDBConnection(dbConn, serialNumber);
                        try {
                            ((Writer)out).close();
                            throw throwable;
                        }
                        catch (IOException e2) {
                            logMetacat.error((Object)e2.getMessage(), (Throwable)e2);
                        }
                        throw throwable;
                    }
                    try {
                        pstmt.close();
                    }
                    catch (SQLException ee) {
                        logMetacat.error((Object)("ReplicationService.handleUpdateRequest - " + METACAT_REPL_ERROR_MSG));
                        logReplication.error((Object)("ReplicationService.handleUpdateRequest - Error in MetacatReplication.handleUpdaterequest to close pstmt: " + ee.getMessage()));
                    }
                    finally {
                        DBConnectionPool.returnDBConnection(dbConn, serialNumber);
                    }
                    try {
                        ((Writer)out).close();
                        return;
                    }
                    catch (IOException e3) {
                        logMetacat.error((Object)e3.getMessage(), (Throwable)e3);
                        return;
                    }
                }
            }
            while (tablehasrows) {
                recordDoctype = rs.getString(3);
                if (!recordDoctype.equals("BIN")) {
                    packagedoctypes = MetacatUtil.getOptionList(PropertyService.getProperty("xml.packagedoctype"));
                    if (recordDoctype != null && !packagedoctypes.contains(recordDoctype)) {
                        ((Writer)out).append("<updatedDocument>");
                        ((Writer)out).append("<docid>" + rs.getString(1));
                        ((Writer)out).append("</docid><rev>" + rs.getInt(2));
                        ((Writer)out).append("</rev>");
                        ((Writer)out).append("</updatedDocument>");
                    } else {
                        v = new Vector();
                        v.add(rs.getString(1));
                        v.add(String.valueOf(rs.getInt(2)));
                        packageFiles.add(v);
                    }
                }
                tablehasrows = rs.next();
            }
        }
        pstmt = dbConn.prepareStatement(delsql.toString());
        dbConn.increaseUsageCount(1);
        pstmt.execute();
        rs = pstmt.getResultSet();
        tablehasrows = rs.next();
        while (tablehasrows) {
            ((Writer)out).append("<deletedDocument><docid>").append(rs.getString(1));
            ((Writer)out).append("</docid><rev></rev></deletedDocument>");
            tablehasrows = rs.next();
        }
        for (int i = 0; i < packageFiles.size(); ++i) {
            Vector v2 = (Vector)packageFiles.elementAt(i);
            ((Writer)out).append("<updatedDocument>");
            ((Writer)out).append("<docid>").append((CharSequence)v2.elementAt(0));
            ((Writer)out).append("</docid><rev>");
            ((Writer)out).append((CharSequence)v2.elementAt(1));
            ((Writer)out).append("</rev>");
            ((Writer)out).append("</updatedDocument>");
        }
        ((Writer)out).append(ReplicationService.prepareRevisionDoc(dbConn, revisionSql.toString(), replicateData));
        ((Writer)out).append("</updates></replication>");
        logReplication.info((Object)"ReplicationService.handleUpdateRequest - done writing to output stream.");
        pstmt.close();
        try {
            pstmt.close();
        }
        catch (SQLException ee) {
            logMetacat.error((Object)("ReplicationService.handleUpdateRequest - " + METACAT_REPL_ERROR_MSG));
            logReplication.error((Object)("ReplicationService.handleUpdateRequest - Error in MetacatReplication.handleUpdaterequest to close pstmt: " + ee.getMessage()));
        }
        finally {
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
        }
        try {
            ((Writer)out).close();
            return;
        }
        catch (IOException e) {
            logMetacat.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
    }

    public static void updateUserOwner(DBConnection dbConn, String docid, String owner, String updater) throws SQLException {
        String sql = "UPDATE xml_documents SET user_owner = ?, user_updated = ? WHERE docid = ?;";
        PreparedStatement pstmt = dbConn.prepareStatement(sql);
        dbConn.increaseUsageCount(1);
        docid = DocumentUtil.getSmartDocId(docid);
        pstmt.setString(1, owner);
        pstmt.setString(2, updater);
        pstmt.setString(3, docid);
        pstmt.execute();
        pstmt.close();
        dbConn.commit();
    }

    private static String prepareRevisionDoc(DBConnection dbConn, String revSql, boolean replicateData) throws Exception {
        logReplication.warn((Object)("ReplicationService.prepareRevisionDoc - The revision document sql is " + revSql));
        StringBuffer revDocList = new StringBuffer();
        PreparedStatement pstmt = dbConn.prepareStatement(revSql);
        dbConn.increaseUsageCount(1);
        pstmt.execute();
        ResultSet rs = pstmt.getResultSet();
        logReplication.warn((Object)"Processing replication revision for documents");
        while (rs.next()) {
            String recordDoctype = rs.getString(3);
            if (recordDoctype.equals("BIN") && !replicateData) {
                logMetacat.debug((Object)"SKipping data file because data replication is not configured");
                continue;
            }
            String docid = rs.getString(1);
            int rev = rs.getInt(2);
            logMetacat.debug((Object)("Processing replication revision for docid: " + docid + "." + rev));
            revDocList.append("<revisionDocument>");
            revDocList.append("<docid>").append(docid);
            revDocList.append("</docid><rev>").append(rev);
            revDocList.append("</rev>");
            if (recordDoctype.equals("BIN")) {
                revDocList.append("<datafile>");
                revDocList.append(DATA_FILE_FLAG);
                revDocList.append("</datafile>");
            }
            revDocList.append("</revisionDocument>");
        }
        return revDocList.toString();
    }

    public static String getCatalogXML() {
        return ReplicationService.handleGetCatalogRequest(null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String handleGetCatalogRequest(Hashtable<String, String[]> params, HttpServletResponse response, boolean printFlag) {
        DBConnection dbConn = null;
        int serialNumber = -1;
        Statement pstmt = null;
        PrintWriter out = null;
        try {
            if (printFlag) {
                response.setContentType("text/xml");
                out = response.getWriter();
            }
            dbConn = DBConnectionPool.getDBConnection("MetacatReplication.handleGetCatalogRequest");
            serialNumber = dbConn.getCheckOutSerialNumber();
            pstmt = dbConn.prepareStatement("select entry_type, source_doctype, target_doctype, public_id, system_id from xml_catalog");
            pstmt.execute();
            ResultSet rs = pstmt.getResultSet();
            boolean tablehasrows = rs.next();
            StringBuffer sb = new StringBuffer();
            sb.append("<?xml version=\"1.0\"?><xml_catalog>");
            while (tablehasrows) {
                sb.append("<row><entry_type>").append(rs.getString(1));
                sb.append("</entry_type><source_doctype>").append(rs.getString(2));
                sb.append("</source_doctype><target_doctype>").append(rs.getString(3));
                sb.append("</target_doctype><public_id>").append(rs.getString(4));
                String systemID = rs.getString(5);
                if (!systemID.startsWith("http://")) {
                    systemID = SystemUtil.getContextURL() + systemID;
                }
                sb.append("</public_id><system_id>").append(systemID);
                sb.append("</system_id></row>");
                tablehasrows = rs.next();
            }
            sb.append("</xml_catalog>");
            if (printFlag) {
                response.setContentType("text/xml");
                ((Writer)out).write(sb.toString());
            }
            pstmt.close();
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            logMetacat.error((Object)("ReplicationService.handleGetCatalogRequest - " + METACAT_REPL_ERROR_MSG));
            logReplication.error((Object)("ReplicationService.handleGetCatalogRequest - error in MetacatReplication.handleGetCatalogRequest:" + e.getMessage()));
            e.printStackTrace(System.out);
            if (!printFlag) return null;
            try {
                ((Writer)out).write("<error>" + e.getMessage() + "</error>");
                return null;
            }
            catch (IOException e1) {
                logMetacat.error((Object)e1.getMessage(), (Throwable)e1);
                return null;
            }
        }
        finally {
            try {
                pstmt.close();
            }
            catch (SQLException ee) {
                logMetacat.error((Object)("ReplicationService.handleGetCatalogRequest - " + METACAT_REPL_ERROR_MSG));
                logReplication.error((Object)("ReplicationService.handleGetCatalogRequest - Error in MetacatReplication.handleGetCatalogRequest: " + ee.getMessage()));
            }
            finally {
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            }
            if (out != null) {
                try {
                    ((Writer)out).close();
                }
                catch (IOException e1) {
                    logMetacat.error((Object)e1.getMessage(), (Throwable)e1);
                }
            }
        }
    }

    protected static void handleGetTimeRequest(Hashtable<String, String[]> params, HttpServletResponse response) {
        String dateString = DateTimeMarshaller.serializeDateToUTC((Date)Calendar.getInstance().getTime());
        response.setContentType("text/xml");
        PrintWriter out = null;
        try {
            out = response.getWriter();
            ((Writer)out).write("<timestamp>" + dateString + "</timestamp>");
            ((Writer)out).close();
        }
        catch (IOException e) {
            logMetacat.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void run() {
        try {
            logReplication.info((Object)("ReplicationService.run - thread started for docid: " + fileLocks.elementAt(0)));
            Thread.sleep(30000L);
            logReplication.info((Object)("thread for docid: " + fileLocks.elementAt(fileLocks.size() - 1) + " exiting."));
            fileLocks.remove(fileLocks.size() - 1);
        }
        catch (Exception e) {
            logMetacat.error((Object)("ReplicationService.run - " + METACAT_REPL_ERROR_MSG));
            logReplication.error((Object)("ReplicationService.run - error in file lock thread from MetacatReplication.run: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getServerNameForServerCode(int serverCode) {
        DBConnection dbConn = null;
        int serialNumber = -1;
        Statement pstmt = null;
        try {
            dbConn = DBConnectionPool.getDBConnection("MetacatReplication.getServer");
            serialNumber = dbConn.getCheckOutSerialNumber();
            String sql = new String("select server from xml_replication where serverid = ?");
            pstmt = dbConn.prepareStatement(sql);
            pstmt.setInt(1, serverCode);
            pstmt.execute();
            ResultSet rs = pstmt.getResultSet();
            boolean tablehasrows = rs.next();
            if (!tablehasrows) return null;
            String string = rs.getString(1);
            return string;
        }
        catch (Exception e) {
            logMetacat.error((Object)("ReplicationService.getServerNameForServerCode - " + METACAT_REPL_ERROR_MSG));
            logReplication.error((Object)("ReplicationService.getServerNameForServerCode - Error in MetacatReplication.getServer: " + e.getMessage()));
            return null;
        }
        finally {
            try {
                pstmt.close();
            }
            catch (SQLException ee) {
                logMetacat.error((Object)("ReplicationService.getServerNameForServerCode - " + METACAT_REPL_ERROR_MSG));
                logReplication.error((Object)("ReplicationService.getServerNameForServerCode - Error in MetacactReplication.getserver: " + ee.getMessage()));
            }
            finally {
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getServerCodeForServerName(String server) throws ServiceException {
        DBConnection dbConn = null;
        int serialNumber = -1;
        Statement pstmt = null;
        int serverCode = 0;
        try {
            dbConn = DBConnectionPool.getDBConnection("MetacatReplication.getServerCode");
            serialNumber = dbConn.getCheckOutSerialNumber();
            pstmt = dbConn.prepareStatement("SELECT serverid FROM xml_replication WHERE server LIKE ?");
            pstmt.setString(1, server);
            pstmt.execute();
            ResultSet rs = pstmt.getResultSet();
            boolean tablehasrows = rs.next();
            if (!tablehasrows) return serverCode;
            serverCode = rs.getInt(1);
            pstmt.close();
            int n = serverCode;
            return n;
        }
        catch (SQLException sqle) {
            throw new ServiceException("ReplicationService.getServerCodeForServerName - SQL error when getting server code: " + sqle.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            catch (Exception ee) {
                logMetacat.error((Object)("ReplicationService.getServerCodeForServerName - " + METACAT_REPL_ERROR_MSG));
                logReplication.error((Object)("ReplicationService.getServerNameForServerCode - Error in MetacatReplicatio.getServerCode: " + ee.getMessage()));
            }
            finally {
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<Integer, String> getServerCodes() throws ServiceException {
        DBConnection dbConn = null;
        int serialNumber = -1;
        Statement pstmt = null;
        HashMap<Integer, String> codes = new HashMap<Integer, String>();
        try {
            dbConn = DBConnectionPool.getDBConnection("MetacatReplication.getServerCodes");
            serialNumber = dbConn.getCheckOutSerialNumber();
            pstmt = dbConn.prepareStatement("SELECT serverid, server FROM xml_replication ");
            pstmt.execute();
            ResultSet rs = pstmt.getResultSet();
            while (rs.next()) {
                int serverCode = rs.getInt(1);
                String server = rs.getString(2);
                codes.put(serverCode, server);
            }
            pstmt.close();
            return codes;
        }
        catch (SQLException sqle) {
            throw new ServiceException("ReplicationService.getServerCodes - SQL error when getting server map: " + sqle.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            catch (Exception ee) {
                logMetacat.error((Object)("ReplicationService.getServerCodes - " + METACAT_REPL_ERROR_MSG));
                logReplication.error((Object)("ReplicationService.getServerCodes - Error in MetacatReplicatio.getServerCodes: " + ee.getMessage()));
            }
            finally {
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Hashtable<String, String> getHomeServerInfoForDocId(String docId) {
        Hashtable<String, String> sl = new Hashtable<String, String>();
        DBConnection dbConn = null;
        int serialNumber = -1;
        docId = DocumentUtil.getDocIdFromString(docId);
        Statement pstmt = null;
        try {
            dbConn = DBConnectionPool.getDBConnection("ReplicationHandler.getHomeServer");
            serialNumber = dbConn.getCheckOutSerialNumber();
            pstmt = dbConn.prepareStatement("select server_location from xml_documents where docid = ?");
            pstmt.setString(1, docId);
            pstmt.execute();
            ResultSet serverName = pstmt.getResultSet();
            if (!serverName.next()) {
                pstmt.close();
                Hashtable<String, String> hashtable = null;
                return hashtable;
            }
            int serverLocation = serverName.getInt(1);
            pstmt.close();
            pstmt = dbConn.prepareStatement("select server, last_checked, replicate from xml_replication where serverid = ?");
            dbConn.increaseUsageCount(1);
            pstmt.setInt(1, serverLocation);
            pstmt.execute();
            ResultSet rs = pstmt.getResultSet();
            boolean tableHasRows = rs.next();
            if (!tableHasRows) {
                pstmt.close();
                Hashtable<String, String> hashtable = null;
                return hashtable;
            }
            String server = rs.getString(1);
            String last_checked = rs.getString(2);
            if (!server.equals("localhost")) {
                sl.put(server, last_checked);
            }
            pstmt.close();
            return sl;
        }
        catch (Exception e) {
            logMetacat.error((Object)("ReplicationService.getHomeServerInfoForDocId - " + METACAT_REPL_ERROR_MSG));
            logReplication.error((Object)("ReplicationService.getHomeServerInfoForDocId - error in replicationHandler.getHomeServer(): " + e.getMessage()));
            return sl;
        }
        finally {
            try {
                pstmt.close();
            }
            catch (Exception ee) {
                logMetacat.error((Object)("ReplicationService.getHomeServerInfoForDocId - " + METACAT_REPL_ERROR_MSG));
                logReplication.error((Object)("ReplicationService.getHomeServerInfoForDocId - Eror irn rplicationHandler.getHomeServer() to close pstmt: " + ee.getMessage()));
            }
            finally {
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getHomeServerCodeForDocId(String accNum) throws ServiceException {
        DBConnection dbConn = null;
        int serialNumber = -1;
        Statement pstmt = null;
        int serverCode = 1;
        String docId = DocumentUtil.getDocIdFromString(accNum);
        try {
            dbConn = DBConnectionPool.getDBConnection("ReplicationHandler.getServerLocation");
            serialNumber = dbConn.getCheckOutSerialNumber();
            pstmt = dbConn.prepareStatement("SELECT server_location FROM xml_documents WHERE docid LIKE ? ");
            pstmt.setString(1, docId);
            pstmt.execute();
            ResultSet rs = pstmt.getResultSet();
            boolean tablehasrows = rs.next();
            if (tablehasrows) {
                serverCode = rs.getInt(1);
                pstmt.close();
                int n = serverCode;
                return n;
            }
            pstmt.close();
            int n = serverCode;
            return n;
        }
        catch (SQLException sqle) {
            throw new ServiceException("ReplicationService.getHomeServerCodeForDocId - SQL error when getting home server code for docid: " + docId + " : " + sqle.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            catch (SQLException sqle) {
                logMetacat.error((Object)("ReplicationService.getHomeServerCodeForDocId - " + METACAT_REPL_ERROR_MSG));
                logReplication.error((Object)("ReplicationService.getHomeServerCodeForDocId - ReplicationService.getHomeServerCodeForDocId - SQL error when getting home server code for docid: " + docId + " : " + sqle.getMessage()));
            }
            finally {
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getURLContent(URL u) throws Exception {
        InputStream input = null;
        String content = null;
        try {
            input = ReplicationService.getURLStream(u);
            logReplication.info((Object)("ReplicationService.getURLContent - After getting response from: " + u.toString()));
            content = IOUtils.toString((InputStream)input, (String)"UTF-8");
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
        return content;
    }

    public static InputStream getURLStream(URL u) throws Exception {
        logReplication.info((Object)("Getting url stream from " + u.toString()));
        logReplication.info((Object)("ReplicationService.getURLStream - Before sending request to: " + u.toString()));
        AutoCloseHttpClientInputStream input = null;
        try {
            RestClient client = ReplicationService.getSSLClient();
            HttpResponse response = client.doGetRequest(u.toString(), null);
            StatusLine statusLine = response.getStatusLine();
            HttpEntity entity = response.getEntity();
            logReplication.info((Object)("ReplicationService.getURLStream - After getting response from: " + u.toString()));
            if (statusLine.getStatusCode() >= 300) {
                throw new HttpResponseException(statusLine.getStatusCode(), "ReplicationService.getURLStream - " + statusLine.getReasonPhrase());
            }
            if (entity == null) {
                throw new ClientProtocolException("ReplicationService.getURLStream - Response contains no content");
            }
            input = new AutoCloseHttpClientInputStream(entity.getContent(), client.getHttpClient());
        }
        catch (Throwable t) {
            logReplication.error((Object)("Unexpected Throwable encountered.  Logging and moving on: " + t.getClass().getCanonicalName() + ": " + t.getMessage()));
            logReplication.error((Object)ExceptionUtils.getStackTrace((Throwable)t));
            throw new Exception(t);
        }
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getURLBytes(URL u) throws Exception {
        InputStream input = null;
        try {
            byte[] bytes;
            input = ReplicationService.getURLStream(u);
            byte[] byArray = bytes = IOUtils.toByteArray((InputStream)input);
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    private static RestClient getSSLClient() {
        RestClient sslClient = null;
        if (sslClient == null) {
            String subject = null;
            try {
                String certificateFile = PropertyService.getProperty("replication.certificate.file");
                String keyFile = PropertyService.getProperty("replication.privatekey.file");
                String keyPassword = PropertyService.getProperty("replication.privatekey.password");
                X509Certificate certificate = CertificateManager.getInstance().loadCertificateFromFile(certificateFile);
                PrivateKey privateKey = CertificateManager.getInstance().loadPrivateKeyFromFile(keyFile, keyPassword);
                subject = CertificateManager.getInstance().getSubjectDN(certificate);
                CertificateManager.getInstance().registerCertificate(subject, certificate, privateKey);
            }
            catch (Exception e) {
                logReplication.warn((Object)("Could not find server's client certificate/private key: " + e.getMessage()));
            }
            try {
                RequestConfig rc = RequestConfig.custom().setConnectionRequestTimeout(CLIENTTIMEOUT).setConnectTimeout(CLIENTTIMEOUT).setSocketTimeout(CLIENTTIMEOUT).build();
                Boolean monitorStaleConnections = false;
                CloseableHttpClient hc = HttpUtils.getHttpClientBuilder((X509Session)HttpUtils.selectSession((String)subject), (Boolean)monitorStaleConnections).setDefaultRequestConfig(rc).build();
                sslClient = new RestClient((HttpClient)hc);
            }
            catch (FileNotFoundException e) {
                logReplication.warn((Object)("Could not set up SSL connection for client - likely because the certificate could not be located: " + e.getMessage()));
            }
            catch (Exception e) {
                logReplication.error((Object)("Failed to set up SSL connection for client. Continuing. " + e.getClass() + ":: " + e.getMessage()), (Throwable)e);
            }
        }
        return sslClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean replToServer(String server) {
        DBConnection dbConn = null;
        int serialNumber = -1;
        Statement pstmt = null;
        try {
            dbConn = DBConnectionPool.getDBConnection("MetacatReplication.repltoServer");
            serialNumber = dbConn.getCheckOutSerialNumber();
            pstmt = dbConn.prepareStatement("select replicate from xml_replication where server like ? ");
            pstmt.setString(1, server);
            pstmt.execute();
            ResultSet rs = pstmt.getResultSet();
            boolean tablehasrows = rs.next();
            if (!tablehasrows) return false;
            int i = rs.getInt(1);
            if (i == 1) {
                pstmt.close();
                boolean bl = true;
                return bl;
            }
            pstmt.close();
            boolean bl = false;
            return bl;
        }
        catch (SQLException sqle) {
            logMetacat.error((Object)("ReplicationService.replToServer - " + METACAT_REPL_ERROR_MSG));
            logReplication.error((Object)("ReplicationService.replToServer - SQL error in MetacatReplication.replToServer: " + sqle.getMessage()));
            return false;
        }
        finally {
            try {
                pstmt.close();
            }
            catch (Exception ee) {
                logMetacat.error((Object)("ReplicationService.replToServer - " + METACAT_REPL_ERROR_MSG));
                logReplication.error((Object)("ReplicationService.replToServer - Error in MetacatReplication.replToServer: " + ee.getMessage()));
            }
            finally {
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            }
        }
    }

    static {
        String clientTimeout = null;
        try {
            clientTimeout = PropertyService.getProperty("replication.client.timeout");
            CLIENTTIMEOUT = Integer.parseInt(clientTimeout);
        }
        catch (Exception e) {
            logReplication.warn((Object)("No custom client timeout specified in configuration, using default." + e.getMessage()));
        }
        try {
            DATA_FILE_FLAG = PropertyService.getProperty("replication.datafileflag");
        }
        catch (PropertyNotFoundException e) {
            logReplication.error((Object)("No 'replication.datafileflag' specified in configuration." + e.getMessage()));
        }
    }
}

