/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.service;

import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.IOException;
import java.io.Reader;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLNamespaceParser
extends DefaultHandler {
    private Reader xml = null;
    private XMLReader parser = null;
    private boolean rootElement = true;
    private static Logger logMetacat = Logger.getLogger(XMLNamespaceParser.class);
    private String namespace = null;
    private String noNamespaceSchemaLocation = null;

    public XMLNamespaceParser(Reader xml) throws SAXException, PropertyNotFoundException {
        this.xml = xml;
        this.initParser();
    }

    private void initParser() throws SAXException, PropertyNotFoundException {
        String parserName = PropertyService.getProperty("xml.saxparser");
        this.parser = XMLReaderFactory.createXMLReader(parserName);
        this.parser.setContentHandler(this);
    }

    public void parse() throws SAXException, IOException {
        try {
            this.parser.parse(new InputSource(this.xml));
        }
        catch (ParsingEndException e) {
            logMetacat.debug((Object)"XMLNamespace.parse - The parsing process stopped.");
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        logMetacat.debug((Object)("XMLNamespace.startElement - uri: " + uri));
        logMetacat.debug((Object)("XMLNamespace.startElement - local name: " + localName));
        logMetacat.debug((Object)("XMLNamespace.startElement - qualified name: " + qName));
        if (!this.rootElement) {
            throw new ParsingEndException("We only parse the root elment. We got there and the parsing stopped.");
        }
        this.rootElement = false;
        if (uri != null && !uri.trim().equals("")) {
            this.namespace = uri;
        }
        logMetacat.debug((Object)("XMLNamespace.startElement - the namespace is: " + this.namespace));
        if (atts != null) {
            for (int i = 0; i < atts.getLength(); ++i) {
                if (atts.getURI(i) == null || !atts.getURI(i).equals("http://www.w3.org/2001/XMLSchema-instance") || atts.getLocalName(i) == null || !atts.getLocalName(i).equals("noNamespaceSchemaLocation")) continue;
                if (atts.getValue(i) != null && !atts.getValue(i).trim().equals("")) {
                    this.noNamespaceSchemaLocation = atts.getValue(i);
                }
                logMetacat.debug((Object)("XMLNamespace.startElement - we found the attribute of the noNamespaceSchemaLocation and its value is: " + this.noNamespaceSchemaLocation));
                break;
            }
        }
    }

    public String getNamespace() {
        logMetacat.debug((Object)("XMLNamespace.getNamespace - the namespace is: " + this.namespace));
        return this.namespace;
    }

    public String getNoNamespaceSchemaLocation() {
        logMetacat.debug((Object)("XMLNamespace.getNoNamespaceSchemaLocation - the NoNamespaceSchemaLocation is: " + this.noNamespaceSchemaLocation));
        return this.noNamespaceSchemaLocation;
    }

    class ParsingEndException
    extends RuntimeException {
        public ParsingEndException(String message) {
            super(message);
        }
    }
}

