/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.util;

import edu.ucsb.nceas.dbadapter.AbstractDatabase;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.properties.SkinPropertyService;
import edu.ucsb.nceas.metacat.service.ServiceService;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.metacat.shared.ServiceException;
import edu.ucsb.nceas.metacat.util.AuthUtil;
import edu.ucsb.nceas.metacat.util.DataONEConfigUtil;
import edu.ucsb.nceas.metacat.util.DatabaseUtil;
import edu.ucsb.nceas.metacat.util.GeoserverUtil;
import edu.ucsb.nceas.metacat.util.SkinUtil;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.FileUtil;
import edu.ucsb.nceas.utilities.GeneralPropertyException;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import org.apache.log4j.Logger;

public class ConfigurationUtil {
    public static AbstractDatabase dbAdapter;
    private static Logger logMetacat;

    public static boolean isMetacatConfigured() {
        boolean metacatConfigured = false;
        try {
            metacatConfigured = PropertyService.arePropertiesConfigured() && AuthUtil.isAuthConfigured() && SkinUtil.areSkinsConfigured() && DatabaseUtil.isDatabaseConfigured() && GeoserverUtil.isGeoserverConfigured() && ConfigurationUtil.isBackupDirConfigured() && DataONEConfigUtil.isDataOneConfigured() && ConfigurationUtil.isEZIDConfigured();
        }
        catch (MetacatUtilException ue) {
            logMetacat.error((Object)("Could not determine if metacat is configured due to utility exception: " + ue.getMessage()));
        }
        catch (GeneralPropertyException gpe) {
            logMetacat.error((Object)("Could not determine if metacat is configured due to property exception: " + gpe.getMessage()));
        }
        return metacatConfigured;
    }

    public static boolean isBackupDirConfigured() throws MetacatUtilException, PropertyNotFoundException {
        String backupDir = PropertyService.getProperty("application.backupDir");
        if (backupDir == null || backupDir.equals("")) {
            return false;
        }
        return FileUtil.getFileStatus((String)backupDir) >= FileUtil.EXISTS_READ_WRITABLE;
    }

    public static boolean isEZIDConfigured() throws MetacatUtilException {
        String ezidConfiguredString = "false";
        try {
            ezidConfiguredString = PropertyService.getProperty("configutil.ezidConfigured");
        }
        catch (PropertyNotFoundException pnfe) {
            throw new MetacatUtilException("Could not determine if the ezid service are configured: " + pnfe.getMessage());
        }
        return !ezidConfiguredString.equals("false");
    }

    public static boolean bypassConfiguration() throws MetacatUtilException, ServiceException {
        try {
            if (!PropertyService.doBypass()) {
                return false;
            }
            String ExternalBaseDir = SystemUtil.discoverExternalDir();
            if (ExternalBaseDir == null) {
                logMetacat.error((Object)"bypassConfiguration: Could not find backup directory.");
                return false;
            }
            String realContext = ServiceService.getRealApplicationContext();
            PropertyService.setRecommendedExternalDir(ExternalBaseDir);
            PropertyService.setProperty("application.backupDir", ExternalBaseDir + FileUtil.getFS() + "." + realContext);
            ServiceService.refreshService("PropertyService");
            ServiceService.refreshService("SkinPropertyService");
            PropertyService.bypassConfiguration();
            SkinPropertyService.bypassConfiguration();
            return true;
        }
        catch (GeneralPropertyException gpe) {
            throw new MetacatUtilException("Property error while discovering backup directory: " + gpe.getMessage());
        }
        catch (MetacatUtilException mue) {
            throw new MetacatUtilException("Utility error while discovering backup directory: " + mue.getMessage());
        }
    }

    static {
        logMetacat = Logger.getLogger(ConfigurationUtil.class);
    }
}

