/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client.v1.itk;

import java.io.IOException;
import java.net.URI;
import java.util.Date;
import org.apache.log4j.Logger;
import org.dataone.client.D1NodeFactory;
import org.dataone.client.NodeLocator;
import org.dataone.client.exception.ClientSideException;
import org.dataone.client.rest.DefaultHttpMultipartRestClient;
import org.dataone.client.rest.MultipartRestClient;
import org.dataone.client.types.ObsoletesChain;
import org.dataone.client.utils.ExceptionUtils;
import org.dataone.client.v1.CNode;
import org.dataone.client.v1.MNode;
import org.dataone.client.v1.impl.MultipartCNode;
import org.dataone.client.v1.impl.NodeListNodeLocator;
import org.dataone.client.v1.impl.SettingsContextNodeLocator;
import org.dataone.client.v1.itk.D1Object;
import org.dataone.service.cn.v1.CNCore;
import org.dataone.service.exceptions.IdentifierNotUnique;
import org.dataone.service.exceptions.InsufficientResources;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidSystemMetadata;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.exceptions.UnsupportedType;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.SystemMetadata;

public class D1Client {
    private static NodeLocator nodeLocator;
    private static long lastRefresh;
    private static long EXPIRATION_MILLIS;
    protected static MultipartRestClient multipartRestClient;
    static final Logger logger;

    protected static MultipartRestClient getMultipartRestClient() throws IOException, ClientSideException {
        try {
            return MultipartRestClientHelper.instance;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof IOException) {
                throw (IOException)re.getCause();
            }
            if (re.getCause() instanceof ClientSideException) {
                throw (ClientSideException)re.getCause();
            }
            ClientSideException cse = new ClientSideException("UnexpectedException thrown!");
            cse.initCause(re.getCause());
            throw cse;
        }
    }

    public static CNode getCN() throws ServiceFailure, NotImplemented {
        return D1Client.getCN((Session)null);
    }

    @Deprecated
    public static CNode getCN(Session session) throws ServiceFailure, NotImplemented {
        try {
            if (nodeLocator == null) {
                nodeLocator = new SettingsContextNodeLocator(D1Client.getMultipartRestClient());
                lastRefresh = new Date().getTime();
            }
            return (CNode)nodeLocator.getCNode();
        }
        catch (IOException | ClientSideException e) {
            logger.warn((Object)("problem getting nodelist from SettingsContextNL: " + e.getClass().getCanonicalName() + " : " + e.getMessage()));
            try {
                nodeLocator = new NodeListNodeLocator(null, D1Client.getMultipartRestClient());
            }
            catch (IOException | ClientSideException e1) {
                throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
            }
            throw ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
    }

    public static void setCN(String cnUrl) throws NotImplemented, ServiceFailure {
        if (cnUrl == null) {
            cnUrl = "";
        }
        try {
            CNCore cn = D1NodeFactory.buildNode(CNCore.class, D1Client.getMultipartRestClient(), URI.create(cnUrl));
            nodeLocator = new NodeListNodeLocator(cn.listNodes(), D1Client.getMultipartRestClient());
        }
        catch (IOException | ClientSideException e) {
            ExceptionUtils.recastClientSideExceptionToServiceFailure(e);
        }
    }

    public static MNode getMN(String mnBaseUrl) throws ServiceFailure {
        MNode mn = null;
        if (nodeLocator != null) {
            try {
                mn = (MNode)nodeLocator.getNode(mnBaseUrl);
            }
            catch (ClientSideException clientSideException) {
                // empty catch block
            }
        }
        if (mn == null) {
            try {
                mn = D1NodeFactory.buildNode(MNode.class, D1Client.getMultipartRestClient(), URI.create(mnBaseUrl));
            }
            catch (IOException | ClientSideException cse) {
                throw ExceptionUtils.recastClientSideExceptionToServiceFailure(cse);
            }
        }
        return mn;
    }

    public static CNode getCN(String cnBaseUrl) throws ServiceFailure {
        CNode cn = null;
        if (nodeLocator != null) {
            try {
                cn = (CNode)nodeLocator.getNode(cnBaseUrl);
            }
            catch (ClientSideException clientSideException) {
                // empty catch block
            }
        }
        if (cn == null) {
            try {
                cn = D1NodeFactory.buildNode(CNode.class, D1Client.getMultipartRestClient(), URI.create(cnBaseUrl));
            }
            catch (IOException | ClientSideException cse) {
                throw ExceptionUtils.recastClientSideExceptionToServiceFailure(cse);
            }
        }
        return cn;
    }

    public static MNode getMN(NodeReference nodeRef) throws ServiceFailure {
        MNode mn = null;
        try {
            D1Client.getCN();
            mn = (MNode)nodeLocator.getNode(nodeRef);
        }
        catch (ClientSideException e) {
            try {
                if (new Date().getTime() - lastRefresh > EXPIRATION_MILLIS) {
                    nodeLocator = new SettingsContextNodeLocator(D1Client.getMultipartRestClient());
                }
            }
            catch (IOException | ClientSideException | NotImplemented throwable) {
                // empty catch block
            }
            try {
                mn = (MNode)nodeLocator.getNode(nodeRef);
            }
            catch (ClientSideException e1) {
                throw new ServiceFailure("0000", "Node is not an MNode: " + nodeRef.getValue());
            }
        }
        catch (NotImplemented e) {
            throw new ServiceFailure("0000", "Got 'NotImplemented' from getCN(): " + e.getDescription());
        }
        if (mn == null) {
            throw new ServiceFailure("0000", "Failed to find baseUrl for node " + nodeRef.getValue() + " in the NodeList");
        }
        return mn;
    }

    public static Identifier create(Session session, D1Object d1object) throws InvalidToken, ServiceFailure, NotAuthorized, IdentifierNotUnique, UnsupportedType, InsufficientResources, InvalidSystemMetadata, NotImplemented, InvalidRequest {
        Identifier rGuid;
        SystemMetadata sysmeta = d1object.getSystemMetadata();
        if (sysmeta == null) {
            throw new InvalidRequest("Client Error", "systemMetadata of the D1Object cannot be null");
        }
        MNode mn = D1Client.getMN(sysmeta.getOriginMemberNode());
        try {
            rGuid = mn.create(session, sysmeta.getIdentifier(), d1object.getDataSource().getInputStream(), sysmeta);
        }
        catch (IOException e) {
            throw new ServiceFailure("000 Client Exception", "Could not open InputStream from the data: " + e.getMessage());
        }
        return rGuid;
    }

    public static Identifier update(Session session, D1Object d1object) throws InvalidToken, ServiceFailure, NotAuthorized, IdentifierNotUnique, UnsupportedType, InsufficientResources, InvalidSystemMetadata, NotImplemented, InvalidRequest, NotFound {
        Identifier rGuid;
        SystemMetadata sysmeta = d1object.getSystemMetadata();
        if (sysmeta == null) {
            throw new InvalidRequest("Client Error", "systemMetadata of the D1Object cannot be null");
        }
        MNode mn = D1Client.getMN(sysmeta.getOriginMemberNode());
        try {
            rGuid = mn.update(sysmeta.getObsoletes(), d1object.getDataSource().getInputStream(), sysmeta.getIdentifier(), sysmeta);
        }
        catch (IOException e) {
            throw new ServiceFailure("000 Client Exception", "Could not open InputStream from the data: " + e.getMessage());
        }
        return rGuid;
    }

    public static Identifier archive(Session session, D1Object d1object) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented, InvalidRequest {
        SystemMetadata sysmeta = d1object.getSystemMetadata();
        if (sysmeta == null) {
            throw new InvalidRequest("Client Error", "systemMetadata of the D1Object cannot be null");
        }
        MNode mn = D1Client.getMN(sysmeta.getAuthoritativeMemberNode());
        Identifier rGuid = mn.archive(d1object.getIdentifier());
        return rGuid;
    }

    public static ObsoletesChain listUpdateHistory(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented {
        Identifier startingPid = pid;
        ObsoletesChain chain = new ObsoletesChain(startingPid);
        SystemMetadata smd = null;
        try {
            smd = D1Client.getSysmeta(startingPid);
            chain.addObject(pid, smd.getDateUploaded(), smd.getObsoletes(), smd.getObsoletedBy(), smd.getArchived());
            Identifier fpid = smd.getObsoletedBy();
            Identifier bpid = smd.getObsoletes();
            while (fpid != null) {
                smd = D1Client.getSysmeta(fpid);
                chain.addObject(fpid, smd.getDateUploaded(), smd.getObsoletes(), smd.getObsoletedBy(), smd.getArchived());
                fpid = smd.getObsoletedBy();
            }
            while (bpid != null) {
                smd = D1Client.getSysmeta(bpid);
                chain.addObject(bpid, smd.getDateUploaded(), smd.getObsoletes(), smd.getObsoletedBy(), smd.getArchived());
                bpid = smd.getObsoletes();
            }
        }
        catch (NullPointerException npe) {
            ServiceFailure sf = new ServiceFailure("0000", "Likely Null value for required systemMetadata field for: " + smd.getIdentifier() + npe.getMessage());
            sf.setStackTrace(npe.getStackTrace());
            throw sf;
        }
        return chain;
    }

    private static SystemMetadata getSysmeta(Identifier pid) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented {
        if (D1Client.getCN() instanceof MultipartCNode) {
            return ((MultipartCNode)D1Client.getCN()).getSystemMetadata(pid);
        }
        return D1Client.getCN().getSystemMetadata(pid);
    }

    static {
        EXPIRATION_MILLIS = 5000L;
        logger = Logger.getLogger(D1Client.class);
    }

    private static class MultipartRestClientHelper {
        public static MultipartRestClient instance;

        private MultipartRestClientHelper() {
        }

        static {
            try {
                instance = new DefaultHttpMultipartRestClient();
            }
            catch (IOException | ClientSideException e) {
                RuntimeException re = new RuntimeException();
                re.initCause(e);
            }
        }
    }
}

