/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.dataone.exceptions.MarshallingException;
import org.dataone.service.exceptions.AuthenticationTimeout;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.IdentifierNotUnique;
import org.dataone.service.exceptions.InsufficientResources;
import org.dataone.service.exceptions.InvalidCredentials;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidSystemMetadata;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.exceptions.SynchronizationFailed;
import org.dataone.service.exceptions.UnsupportedMetadataType;
import org.dataone.service.exceptions.UnsupportedType;
import org.dataone.service.exceptions.VersionMismatch;
import org.dataone.service.util.TypeMarshaller;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ExceptionHandler {
    protected static Log log = LogFactory.getLog(ExceptionHandler.class);

    public static InputStream filterErrors(HttpResponse res) throws AuthenticationTimeout, IdentifierNotUnique, InsufficientResources, InvalidCredentials, InvalidRequest, InvalidSystemMetadata, InvalidToken, NotAuthorized, NotFound, NotImplemented, ServiceFailure, UnsupportedMetadataType, UnsupportedType, VersionMismatch, IllegalStateException, IOException, HttpException, SynchronizationFailed {
        return ExceptionHandler.filterErrors(res, false);
    }

    public static InputStream filterErrors(HttpResponse res, boolean allowRedirect) throws AuthenticationTimeout, IdentifierNotUnique, InsufficientResources, InvalidCredentials, InvalidRequest, InvalidSystemMetadata, InvalidToken, NotAuthorized, NotFound, NotImplemented, ServiceFailure, UnsupportedMetadataType, UnsupportedType, VersionMismatch, IllegalStateException, IOException, HttpException, SynchronizationFailed {
        int code = res.getStatusLine().getStatusCode();
        log.info((Object)("response httpCode: " + code));
        if (!(code == 200 || allowRedirect && code == 303)) {
            ExceptionHandler.deserializeAndThrowException(res);
        }
        return res.getEntity().getContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Header[] filterErrorsHeader(HttpResponse response, String httpMethod) throws AuthenticationTimeout, IdentifierNotUnique, InsufficientResources, InvalidCredentials, InvalidRequest, InvalidSystemMetadata, InvalidToken, NotAuthorized, NotFound, NotImplemented, ServiceFailure, UnsupportedMetadataType, UnsupportedType, VersionMismatch, IllegalStateException, IOException, HttpException, SynchronizationFailed {
        try {
            int code = response.getStatusLine().getStatusCode();
            log.info((Object)("response httpCode: " + code));
            if (code != 200) {
                if (httpMethod == "HEAD") {
                    ExceptionHandler.deserializeHeadersAndThrowException(code, response.getAllHeaders());
                } else {
                    ExceptionHandler.deserializeAndThrowException(response);
                }
            }
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        return response.getAllHeaders();
    }

    public static void deserializeHeadersAndThrowException(int code, Header[] headers) throws AuthenticationTimeout, IdentifierNotUnique, InsufficientResources, InvalidCredentials, InvalidRequest, InvalidSystemMetadata, InvalidToken, NotAuthorized, NotFound, NotImplemented, ServiceFailure, UnsupportedMetadataType, UnsupportedType, VersionMismatch, IllegalStateException, IOException, HttpException, SynchronizationFailed {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        for (Header header : headers) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("header: %s = %s", header.getName(), header.getValue()));
            }
            headersMap.put(header.getName(), header.getValue());
        }
        if (headersMap.containsKey("DataONE-Exception-Name")) {
            String d1ExceptionName = (String)headersMap.get("DataONE-Exception-Name");
            String detailCode = (String)headersMap.get("DataONE-Exception-DetailCode");
            String description = (String)headersMap.get("DataONE-Exception-Description");
            String pid = (String)headersMap.get("DataONE-Exception-PID");
            if ((d1ExceptionName = d1ExceptionName.replace("org.dataone.service.exceptions.", "")).equals("AuthenticationTimeout")) {
                throw new AuthenticationTimeout(detailCode, description, pid, null);
            }
            if (d1ExceptionName.equals("IdentifierNotUnique")) {
                throw new IdentifierNotUnique(detailCode, description, pid, null);
            }
            if (d1ExceptionName.equals("InsufficientResources")) {
                throw new InsufficientResources(detailCode, description, pid, null);
            }
            if (d1ExceptionName.equals("InvalidCredentials")) {
                throw new InvalidCredentials(detailCode, description, pid, null);
            }
            if (d1ExceptionName.equals("InvalidRequest")) {
                throw new InvalidRequest(detailCode, description, pid, null);
            }
            if (d1ExceptionName.equals("InvalidSystemMetadata")) {
                throw new InvalidSystemMetadata(detailCode, description, pid, null);
            }
            if (d1ExceptionName.equals("InvalidToken")) {
                throw new InvalidToken(detailCode, description, pid, null);
            }
            if (d1ExceptionName.equals("NotAuthorized")) {
                throw new NotAuthorized(detailCode, description, pid, null);
            }
            if (d1ExceptionName.equals("NotFound")) {
                throw new NotFound(detailCode, description, pid, null);
            }
            if (d1ExceptionName.equals("NotImplemented")) {
                throw new NotImplemented(detailCode, description, pid, null);
            }
            if (d1ExceptionName.equals("ServiceFailure")) {
                throw new ServiceFailure(detailCode, description, pid, null);
            }
            if (d1ExceptionName.equals("UnsupportedMetadataType")) {
                throw new UnsupportedMetadataType(detailCode, description, pid, null);
            }
            if (d1ExceptionName.equals("UnsupportedType")) {
                throw new UnsupportedType(detailCode, description, pid, null);
            }
            if (d1ExceptionName.equals("SynchronizationFailed")) {
                throw new SynchronizationFailed(detailCode, description, pid, null);
            }
            if (d1ExceptionName.equals("VersionMismatch")) {
                throw new VersionMismatch(detailCode, description, pid, null);
            }
            throw new ServiceFailure(detailCode, "status " + code + ": " + description, pid, null);
        }
        throw new ServiceFailure("0000: NON-D1-EXCEPTION", "status: " + code + " response headers: " + ExceptionHandler.serializeHeaderMap(headersMap));
    }

    private static String serializeHeaderMap(Map<String, String> headers) {
        StringBuffer sb = new StringBuffer();
        sb.append("\nheader = value");
        for (String key : headers.keySet()) {
            sb.append("\n" + key + " = " + headers.get(key));
        }
        return sb.toString();
    }

    public static InputStream filterErrors(InputStream is, boolean isException, String contentType) throws AuthenticationTimeout, IdentifierNotUnique, InsufficientResources, InvalidCredentials, InvalidRequest, InvalidSystemMetadata, InvalidToken, NotAuthorized, NotFound, NotImplemented, ServiceFailure, UnsupportedMetadataType, UnsupportedType, VersionMismatch, IllegalStateException, IOException, SynchronizationFailed {
        if (isException) {
            ExceptionHandler.deserializeAndThrowException(is, contentType, null, null);
        }
        return is;
    }

    public static void deserializeAndThrowException(HttpResponse response) throws NotFound, InvalidToken, ServiceFailure, NotAuthorized, NotFound, IdentifierNotUnique, UnsupportedType, InsufficientResources, InvalidSystemMetadata, NotImplemented, InvalidCredentials, InvalidRequest, IOException, AuthenticationTimeout, UnsupportedMetadataType, VersionMismatch, HttpException, SynchronizationFailed {
        Header[] h = response.getHeaders("content-type");
        String contentType = "unset";
        if (h.length == 1) {
            contentType = h[0].getValue();
        } else if (h.length > 1) {
            EntityUtils.consume((HttpEntity)response.getEntity());
            throw new IOException("Should not get more than one content-type returned");
        }
        Integer statusCode = null;
        String statusReason = null;
        InputStream responseStream = null;
        try {
            statusCode = new Integer(response.getStatusLine().getStatusCode());
            statusReason = response.getStatusLine().getReasonPhrase();
            if (response.getEntity() != null) {
                responseStream = response.getEntity().getContent();
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        ExceptionHandler.deserializeAndThrowException(responseStream, contentType, statusCode, statusReason);
    }

    public static void deserializeAndThrowException(InputStream errorStream, String contentType, Integer statusCode, String reason) throws AuthenticationTimeout, IdentifierNotUnique, InsufficientResources, InvalidCredentials, InvalidRequest, InvalidSystemMetadata, InvalidToken, NotAuthorized, NotFound, NotImplemented, ServiceFailure, UnsupportedMetadataType, UnsupportedType, SynchronizationFailed, VersionMismatch {
        String defaultMessage = "";
        if (contentType == null) {
            contentType = "unset";
        }
        if (statusCode != null) {
            defaultMessage = String.valueOf(statusCode) + ": ";
        }
        if (reason != null) {
            defaultMessage = defaultMessage + reason + ": ";
        }
        if (contentType.contains("xml")) {
            try {
                ExceptionHandler.deserializeXmlAndThrowException(errorStream, defaultMessage);
            }
            catch (SAXException e) {
                ExceptionHandler.deserializeAndThrowServiceFailure(errorStream, e, defaultMessage);
            }
            catch (IOException e) {
                ExceptionHandler.deserializeAndThrowServiceFailure(errorStream, e, defaultMessage);
            }
            catch (ParserConfigurationException e) {
                ExceptionHandler.deserializeAndThrowServiceFailure(errorStream, e, defaultMessage);
            }
        } else if (contentType.contains("html")) {
            ExceptionHandler.deserializeHtmlAndThrowException(errorStream, defaultMessage);
        } else if (contentType.contains("json")) {
            ExceptionHandler.deserializeJsonAndThrowException(errorStream, defaultMessage);
        } else if (contentType.contains("csv")) {
            ExceptionHandler.deserializeCsvAndThrowException(errorStream, defaultMessage);
        } else if (contentType.contains("text/plain")) {
            ExceptionHandler.deserializeTextPlainAndThrowException(errorStream, defaultMessage);
        } else if (contentType.equals("unset")) {
            ExceptionHandler.deserializeTextPlainAndThrowException(errorStream, defaultMessage);
        } else {
            ExceptionHandler.deserializeTextPlainAndThrowException(errorStream, defaultMessage);
        }
    }

    private static void deserializeAndThrowServiceFailure(InputStream errorStream, Exception e, String defaultMessage) throws ServiceFailure {
        TreeMap<String, String> stackTrace = new TreeMap<String, String>();
        StackTraceElement[] stackTraceElements = e.getStackTrace();
        for (int i = 0; i < stackTraceElements.length; ++i) {
            stackTrace.put(String.valueOf(stackTraceElements[i].getLineNumber()), stackTraceElements[i].toString());
        }
        try {
            try {
                throw new ServiceFailure("-1", defaultMessage + e.getMessage() + "\n" + IOUtils.toString((InputStream)errorStream), "", stackTrace);
            }
            catch (IOException e1) {
                throw new ServiceFailure("-1", defaultMessage + "errorStream could not be reset/reread" + e1.getMessage(), "", stackTrace);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)errorStream);
            throw throwable;
        }
    }

    private static void deserializeHtmlAndThrowException(InputStream errorStream, String defaultMessage) throws ServiceFailure {
        try {
            try {
                throw new ServiceFailure("-1", defaultMessage + "parser for deserializing HTML not written yet.  Providing message body:\n" + IOUtils.toString((InputStream)errorStream));
            }
            catch (IOException e1) {
                throw new ServiceFailure("-1", defaultMessage + "errorStream could not be reset/reread" + e1.getMessage());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)errorStream);
            throw throwable;
        }
    }

    private static void deserializeJsonAndThrowException(InputStream errorStream, String defaultMessage) throws ServiceFailure {
        try {
            try {
                throw new ServiceFailure("-1", defaultMessage + "parser for deserializing JSON not written yet.  Providing message body:\n" + IOUtils.toString((InputStream)errorStream));
            }
            catch (IOException e1) {
                throw new ServiceFailure("-1", defaultMessage + "errorStream could not be reset/reread" + e1.getMessage());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)errorStream);
            throw throwable;
        }
    }

    private static void deserializeCsvAndThrowException(InputStream errorStream, String defaultMessage) throws ServiceFailure {
        try {
            try {
                throw new ServiceFailure("-1", defaultMessage + "parser for deserializing CSV not written yet.  Providing message body:\n" + IOUtils.toString((InputStream)errorStream));
            }
            catch (IOException e1) {
                throw new ServiceFailure("-1", defaultMessage + "errorStream could not be reset/reread" + e1.getMessage());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)errorStream);
            throw throwable;
        }
    }

    private static void deserializeTextPlainAndThrowException(InputStream errorStream, String defaultMessage) throws ServiceFailure {
        try {
            try {
                throw new ServiceFailure("-1", defaultMessage + "Deserializing Text/Plain: Just providing message body:\n" + IOUtils.toString((InputStream)errorStream) + "\n{EndOfMessage}");
            }
            catch (IOException e1) {
                throw new ServiceFailure("-1", defaultMessage + "errorStream could not be reset/reread" + e1.getMessage());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)errorStream);
            throw throwable;
        }
    }

    private static void deserializeXmlAndThrowException(InputStream errorStream, String defaultMessage) throws ParserConfigurationException, SAXException, IOException, AuthenticationTimeout, IdentifierNotUnique, InsufficientResources, InvalidCredentials, InvalidRequest, InvalidSystemMetadata, InvalidToken, NotAuthorized, NotFound, NotImplemented, ServiceFailure, UnsupportedMetadataType, UnsupportedType, SynchronizationFailed, VersionMismatch {
        BaseException be = ExceptionHandler.deserializeXml(errorStream, defaultMessage);
        if (be instanceof AuthenticationTimeout) {
            throw (AuthenticationTimeout)be;
        }
        if (be instanceof IdentifierNotUnique) {
            throw (IdentifierNotUnique)be;
        }
        if (be instanceof InsufficientResources) {
            throw (InsufficientResources)be;
        }
        if (be instanceof InvalidCredentials) {
            throw (InvalidCredentials)be;
        }
        if (be instanceof InvalidRequest) {
            throw (InvalidRequest)be;
        }
        if (be instanceof InvalidSystemMetadata) {
            throw (InvalidSystemMetadata)be;
        }
        if (be instanceof InvalidToken) {
            throw (InvalidToken)be;
        }
        if (be instanceof NotAuthorized) {
            throw (NotAuthorized)be;
        }
        if (be instanceof NotFound) {
            throw (NotFound)be;
        }
        if (be instanceof NotImplemented) {
            throw (NotImplemented)be;
        }
        if (be instanceof ServiceFailure) {
            throw (ServiceFailure)be;
        }
        if (be instanceof UnsupportedMetadataType) {
            throw (UnsupportedMetadataType)be;
        }
        if (be instanceof UnsupportedType) {
            throw (UnsupportedType)be;
        }
        if (be instanceof SynchronizationFailed) {
            throw (SynchronizationFailed)be;
        }
        if (be instanceof VersionMismatch) {
            throw (VersionMismatch)be;
        }
    }

    public static <T> BaseException deserializeXml(InputStream errorStream, String defaultMessage) throws ParserConfigurationException, SAXException, IOException {
        TreeMap<String, String> trace_information = new TreeMap<String, String>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(errorStream);
        Element root = doc.getDocumentElement();
        root.normalize();
        String detailCode = "-1";
        String name = "";
        String pid = null;
        String nodeId = null;
        if (root.hasAttribute("detailCode")) {
            detailCode = root.getAttribute("detailCode");
        }
        if (root.hasAttribute("name")) {
            name = root.getAttribute("name");
        }
        if (root.hasAttribute("pid")) {
            pid = root.getAttribute("pid");
        }
        if (root.hasAttribute("nodeId")) {
            nodeId = root.getAttribute("nodeId");
        }
        ExceptionHandler.getTraceValue(root, trace_information);
        String description = ExceptionHandler.getDescriptionValue(root);
        if (name != null & !name.isEmpty()) {
            if (name.equals("AuthenticationTimeout")) {
                return new AuthenticationTimeout(detailCode, description, pid, nodeId, trace_information);
            }
            if (name.equals("IdentifierNotUnique")) {
                return new IdentifierNotUnique(detailCode, description, pid, nodeId, trace_information);
            }
            if (name.equals("InsufficientResources")) {
                return new InsufficientResources(detailCode, description, pid, nodeId, trace_information);
            }
            if (name.equals("InvalidCredentials")) {
                return new InvalidCredentials(detailCode, description, pid, nodeId, trace_information);
            }
            if (name.equals("InvalidRequest")) {
                return new InvalidRequest(detailCode, description, pid, nodeId, trace_information);
            }
            if (name.equals("InvalidSystemMetadata")) {
                return new InvalidSystemMetadata(detailCode, description, pid, nodeId, trace_information);
            }
            if (name.equals("InvalidToken")) {
                return new InvalidToken(detailCode, description, pid, nodeId, trace_information);
            }
            if (name.equals("NotAuthorized")) {
                return new NotAuthorized(detailCode, description, pid, nodeId, trace_information);
            }
            if (name.equals("NotFound")) {
                return new NotFound(detailCode, description, pid, nodeId, trace_information);
            }
            if (name.equals("NotImplemented")) {
                return new NotImplemented(detailCode, description, pid, nodeId, trace_information);
            }
            if (name.equals("ServiceFailure")) {
                return new ServiceFailure(detailCode, description, pid, nodeId, trace_information);
            }
            if (name.equals("UnsupportedMetadataType")) {
                return new UnsupportedMetadataType(detailCode, description, pid, nodeId, trace_information);
            }
            if (name.equals("UnsupportedType")) {
                return new UnsupportedType(detailCode, description, pid, nodeId, trace_information);
            }
            if (name.equals("SynchronizationFailed")) {
                return new SynchronizationFailed(detailCode, description, pid, nodeId, trace_information);
            }
            if (name.equals("VersionMismatch")) {
                return new VersionMismatch(detailCode, description, pid, nodeId, trace_information);
            }
            return new ServiceFailure(detailCode, defaultMessage + description, pid, nodeId, trace_information);
        }
        return new ServiceFailure(detailCode, defaultMessage + description, pid, nodeId, trace_information);
    }

    private static String getDescriptionValue(Element e) {
        Element el;
        String text = "";
        NodeList nl = e.getElementsByTagName("description");
        if (nl != null && nl.getLength() > 0 && (el = (Element)nl.item(0)).hasChildNodes() && (el.getFirstChild().getNodeType() == 3 || el.getFirstChild().getNodeType() == 4)) {
            text = el.getFirstChild().getNodeValue();
        }
        return text;
    }

    private static void getTraceValue(Element e, TreeMap<String, String> trace_information) {
        Element el;
        String text = "";
        NodeList nl = e.getElementsByTagName("traceInformation");
        if (nl != null && nl.getLength() > 0 && (el = (Element)nl.item(0)).hasChildNodes()) {
            NodeList traceValues = el.getChildNodes();
            if (el.hasChildNodes() && (el.getFirstChild().getNodeType() == 3 || el.getFirstChild().getNodeType() == 4)) {
                trace_information.put(el.getAttribute("key"), el.getFirstChild().getNodeValue());
            }
        }
    }

    private static String getTextAttribute(Element e, String attName) {
        if (e.hasAttribute(attName)) {
            String attText = e.getAttribute(attName);
            return attText;
        }
        return "";
    }

    protected static <T> T deserializeServiceType(Class<T> domainClass, InputStream is) throws ServiceFailure {
        try {
            return TypeMarshaller.unmarshalTypeFromStream(domainClass, is);
        }
        catch (MarshallingException e) {
            throw new ServiceFailure("0", "Could not deserialize the " + domainClass.getCanonicalName() + ": " + e.getMessage());
        }
        catch (IOException e) {
            throw new ServiceFailure("0", "Could not deserialize the " + domainClass.getCanonicalName() + ": " + e.getMessage());
        }
        catch (InstantiationException e) {
            throw new ServiceFailure("0", "Could not deserialize the " + domainClass.getCanonicalName() + ": " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ServiceFailure("0", "Could not deserialize the " + domainClass.getCanonicalName() + ": " + e.getMessage());
        }
    }
}

