/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.mgt;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.sparql.mgt.SystemInfoMBean;
import org.apache.jena.riot.system.IRIResolver;

public class SystemInfo
implements SystemInfoMBean {
    private final String name;
    private final Node iri;
    private final String version;
    private final String buildDate;

    public SystemInfo(String name, String version2, String buildDate) {
        this.name = name;
        this.iri = SystemInfo.createIRI(name);
        this.version = version2;
        this.buildDate = buildDate;
    }

    private static Node createIRI(String iriStr) {
        try {
            return NodeFactory.createURI((String)IRIResolver.resolveString(iriStr));
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    @Override
    public String getBuildDate() {
        return this.buildDate;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Node getIRI() {
        return NodeFactory.createURI((String)this.name);
    }
}

