/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.fst;

import java.util.Comparator;
import org.apache.lucene.search.suggest.BytesRefList;
import org.apache.lucene.search.suggest.fst.BytesRefSorter;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InMemorySorter
implements BytesRefSorter {
    private final BytesRefList buffer = new BytesRefList();
    private boolean closed = false;
    private final Comparator<BytesRef> comparator;

    public InMemorySorter(Comparator<BytesRef> comparator) {
        this.comparator = comparator;
    }

    @Override
    public void add(BytesRef utf8) {
        if (this.closed) {
            throw new IllegalStateException();
        }
        this.buffer.append(utf8);
    }

    @Override
    public BytesRefIterator iterator() {
        this.closed = true;
        return this.buffer.iterator(this.comparator);
    }

    @Override
    public Comparator<BytesRef> getComparator() {
        return this.comparator;
    }
}

