/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.FiresFormEvents;
import com.google.gwt.user.client.ui.FormHandler;
import com.google.gwt.user.client.ui.FormHandlerCollection;
import com.google.gwt.user.client.ui.NamedFrame;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.impl.FormPanelImpl;
import com.google.gwt.user.client.ui.impl.FormPanelImplHost;

public class FormPanel
extends SimplePanel
implements FiresFormEvents,
FormPanelImplHost {
    public static final String ENCODING_MULTIPART = "multipart/form-data";
    public static final String ENCODING_URLENCODED = "application/x-www-form-urlencoded";
    public static final String METHOD_GET = "get";
    public static final String METHOD_POST = "post";
    private static int formId = 0;
    private static FormPanelImpl impl = (FormPanelImpl)GWT.create(FormPanelImpl.class);
    private FormHandlerCollection formHandlers;
    private Element iframe;

    public FormPanel() {
        super(DOM.createForm());
        String formName = "FormPanel_" + ++formId;
        DOM.setAttribute(this.getElement(), "target", formName);
        DOM.setInnerHTML(this.getElement(), "<iframe name='" + formName + "'>");
        this.iframe = DOM.getFirstChild(this.getElement());
        DOM.setIntStyleAttribute(this.iframe, "width", 0);
        DOM.setIntStyleAttribute(this.iframe, "height", 0);
        DOM.setIntStyleAttribute(this.iframe, "border", 0);
        this.sinkEvents(32768);
    }

    public FormPanel(NamedFrame frameTarget) {
        this(frameTarget.getName());
    }

    public FormPanel(String target) {
        super(DOM.createForm());
        this.setTarget(target);
    }

    public void addFormHandler(FormHandler handler) {
        if (this.formHandlers == null) {
            this.formHandlers = new FormHandlerCollection();
        }
        this.formHandlers.add(handler);
    }

    public String getAction() {
        return DOM.getAttribute(this.getElement(), "action");
    }

    public String getEncoding() {
        return impl.getEncoding(this.getElement());
    }

    public String getMethod() {
        return DOM.getAttribute(this.getElement(), "method");
    }

    public String getTarget() {
        return DOM.getAttribute(this.getElement(), "target");
    }

    public boolean onFormSubmit() {
        if (this.formHandlers != null) {
            return !this.formHandlers.fireOnSubmit(this);
        }
        return true;
    }

    public void onFrameLoad() {
        if (this.formHandlers != null) {
            this.formHandlers.fireOnComplete(this, impl.getTextContents(this.iframe));
        }
    }

    public void removeFormHandler(FormHandler handler) {
        if (this.formHandlers != null) {
            this.formHandlers.remove(handler);
        }
    }

    public void setAction(String url) {
        DOM.setAttribute(this.getElement(), "action", url);
    }

    public void setEncoding(String encodingType) {
        impl.setEncoding(this.getElement(), encodingType);
    }

    public void setMethod(String method) {
        DOM.setAttribute(this.getElement(), "method", method);
    }

    public void submit() {
        if (this.formHandlers != null && this.formHandlers.fireOnSubmit(this)) {
            return;
        }
        impl.submit(this.getElement(), this.iframe);
    }

    protected void onAttach() {
        super.onAttach();
        impl.hookEvents(this.iframe, this.getElement(), this);
    }

    protected void onDetach() {
        super.onDetach();
        impl.unhookEvents(this.iframe, this.getElement());
    }

    private void setTarget(String target) {
        DOM.setAttribute(this.getElement(), "target", target);
    }
}

