/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.commandline;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import javax.xml.parsers.DocumentBuilderFactory;
import org.tigris.subversion.svnclientadapter.Annotations;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.StringUtils;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineException;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineXmlCommand;
import org.tigris.subversion.svnclientadapter.commandline.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CmdLineAnnotations
extends Annotations {
    private CmdLineAnnotations() {
    }

    public static CmdLineAnnotations createFromXml(byte[] byArray, InputStream inputStream) throws CmdLineException {
        CmdLineAnnotations cmdLineAnnotations = new CmdLineAnnotations();
        try {
            Object object;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            InputSource inputSource = new InputSource(new ByteArrayInputStream(byArray));
            Document document = documentBuilderFactory.newDocumentBuilder().parse(inputSource);
            NodeList nodeList = document.getElementsByTagName("entry");
            Annotations.Annotation[] annotationArray = new Annotations.Annotation[nodeList.getLength()];
            for (int i = 0; i < nodeList.getLength(); ++i) {
                object = nodeList.item(i);
                SVNRevision.Number number = SVNRevision.Number.INVALID_REVISION;
                String string = null;
                Date date = null;
                int n = Integer.parseInt(object.getAttributes().getNamedItem("line-number").getNodeValue());
                Element element = CmdLineXmlCommand.getFirstNamedElement((Node)object, "commit");
                if (element != null) {
                    Node node = element.getAttributes().getNamedItem("revision");
                    number = Helper.toRevNum(node.getNodeValue());
                    Element element2 = CmdLineXmlCommand.getFirstNamedElement(element, "author");
                    string = element2.getFirstChild().getNodeValue();
                    Element element3 = CmdLineXmlCommand.getNextNamedElement(element2, "date");
                    date = Helper.convertXMLDate(element3.getFirstChild().getNodeValue());
                }
                annotationArray[n - 1] = new Annotations.Annotation(number.getNumber(), string, date, null);
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            object = bufferedReader.readLine();
            int n = 0;
            while (object != null) {
                annotationArray[n].setLine((String)object);
                cmdLineAnnotations.addAnnotation(annotationArray[n]);
                object = bufferedReader.readLine();
                ++n;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            throw new CmdLineException(exception);
        }
        return cmdLineAnnotations;
    }

    public static CmdLineAnnotations createFromStdOut(String string, String string2) {
        CmdLineAnnotations cmdLineAnnotations = new CmdLineAnnotations();
        String[] stringArray = StringUtils.split(string, string2);
        for (int i = 0; i < stringArray.length; ++i) {
            Annotations.Annotation annotation = new Annotations.Annotation(CmdLineAnnotations.getRevisionFrom(stringArray[i]), CmdLineAnnotations.getAuthorFrom(stringArray[i]), CmdLineAnnotations.getChangedFrom(stringArray[i]), CmdLineAnnotations.getLineFrom(stringArray[i]));
            cmdLineAnnotations.addAnnotation(annotation);
        }
        return cmdLineAnnotations;
    }

    private static long getRevisionFrom(String string) {
        String string2 = string.substring(0, 6).trim();
        if (string2.equals("-")) {
            return -1L;
        }
        return Integer.parseInt(string2);
    }

    private static Date getChangedFrom(String string) {
        return null;
    }

    private static String getAuthorFrom(String string) {
        String string2 = StringUtils.stripStart(string.substring(7, 17), null);
        if (string2.equals("-")) {
            return null;
        }
        return string2;
    }

    private static String getLineFrom(String string) {
        return string.substring(18);
    }
}

