## MetacatUI: A client-side web interface for DataONE data repositories

- **Author**: Matthew B. Jones, Chris Jones, Ben Leinfelder, Lauren Walker, Bryce Mecum ([NCEAS](http://www.nceas.ucsb.edu))
- **License**: [Apache 2](http://opensource.org/licenses/Apache-2.0)
- [Package source code on Github](https://github.com/NCEAS/metacatUI)
- [**Submit Bugs and feature requests**](https://projects.ecoinformatics.org/ecoinfo/projects/metacatui/)
- Discussion list: metacat-dev@ecoinformatics.org

MetacatUI is a client-side web interface for querying Metacat servers and other servers that implement the DataONE REST API.  Currently, it is used as the basis for the [KNB Data Repository](http://knb.ecoinformatics.org), the [NSF Arctic Data Center](https://arcticdata.io/catalog/), the [DataONE federation](https://search.dataone.org), and other repositories.

MetacatUI is an open source, community project.  We welcome contributions in many forms, including code, graphics, documentation, bug reports, testing, etc.  Use the discussion list to discuss these contributions with project contributors.  

## License
```
Copyright [2013] [Regents of the University of California]

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```

## Screenshots

The main search screen, as configured for the KNB Repository:
![KNB Search](https://raw.githubusercontent.com/NCEAS/metacatui/master/screenshots/metacatui-knb-1200w.png)

A metadata view, as configured for the Arctic Data Center:
![Arctic Data Center Metadata View](https://raw.githubusercontent.com/NCEAS/metacatui/master/screenshots/metacatui-arctic-1200w.png)

## Acknowledgements
Work on this package was supported by:

- NSF-ABI grant #1262458 to C. Gries, M. B. Jones, and S. Collins.
- NSF-DATANET grant #1430508 to W. Michener, M. B. Jones, D. Vieglais, S. Allard and P. Cruse
- NSF DIBBS grant #1443062 to T. Habermann and M. B. Jones
- NSF-PLR grant #1546024 to M. B. Jones, S. Baker-Yeboah, J. Dozier, M. Schildhauer, and A. Budden

Additional support was provided for working group collaboration by the National Center for Ecological Analysis and Synthesis, a Center funded by the University of California, Santa Barbara, and the State of California.

[![nceas_footer](https://www.nceas.ucsb.edu/files/newLogo_0.png)](http://www.nceas.ucsb.edu)
