/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.InGroupableList;
import net.sourceforge.plantuml.sequencediagram.graphic.GroupingGraphicalElement;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;

class GroupingTail
extends GroupingGraphicalElement {
    private final double initY;
    private final Component body;
    private final Component tail;

    public GroupingTail(double d, double d2, Component component, Component component2, InGroupableList inGroupableList) {
        super(d, inGroupableList);
        if (d < d2) {
            throw new IllegalArgumentException("currentY=" + d + " initY=" + d2);
        }
        if (inGroupableList == null) {
            throw new IllegalArgumentException();
        }
        this.body = component;
        this.tail = component2;
        this.initY = d2;
    }

    protected void drawInternalU(UGraphic uGraphic, double d, Context2D context2D) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        double d2 = this.getInGroupableList().getMinX(stringBounder);
        double d3 = this.getInGroupableList().getMaxX(stringBounder);
        uGraphic.translate(d2, this.initY);
        Dimension2DDouble dimension2DDouble = new Dimension2DDouble(d3 - d2, this.getPreferredHeight(stringBounder));
        this.body.drawU(uGraphic, dimension2DDouble, context2D);
        this.tail.drawU(uGraphic, dimension2DDouble, context2D);
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getStartingY() - this.initY;
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        return 0.0;
    }
}

