/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.telnet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;

class AcceptTelnetClient
extends Thread {
    private final Socket clientSocket;
    private final BufferedReader br;
    private final OutputStream os;

    AcceptTelnetClient(Socket socket) throws Exception {
        this.clientSocket = socket;
        System.out.println("Client Connected ...");
        this.br = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
        this.os = this.clientSocket.getOutputStream();
        this.start();
    }

    public String runInternal() throws IOException {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        do {
            if ((string = this.br.readLine()) == null) {
                return stringBuilder.toString();
            }
            System.err.println("S=" + string);
            stringBuilder.append(string);
            stringBuilder.append('\n');
        } while (!string.equalsIgnoreCase("@enduml"));
        return stringBuilder.toString();
    }

    public void run() {
        try {
            String string = this.runInternal();
            System.err.println("UML=" + string);
            SourceStringReader sourceStringReader = new SourceStringReader(string);
            sourceStringReader.generateImage(this.os, new FileFormatOption(FileFormat.ATXT));
            this.os.close();
            this.br.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

