/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import net.sourceforge.plantuml.cucadiagram.Entity;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.graph.AbstractEntityImage;
import net.sourceforge.plantuml.graph.EntityImageActivity;
import net.sourceforge.plantuml.graph.EntityImageActivityBar;
import net.sourceforge.plantuml.graph.EntityImageActivityBranch;
import net.sourceforge.plantuml.graph.EntityImageActivityCircle;
import net.sourceforge.plantuml.graph.EntityImageActor;
import net.sourceforge.plantuml.graph.EntityImageCircleInterface;
import net.sourceforge.plantuml.graph.EntityImageClass;
import net.sourceforge.plantuml.graph.EntityImageComponent;
import net.sourceforge.plantuml.graph.EntityImageDefault;
import net.sourceforge.plantuml.graph.EntityImageNote;
import net.sourceforge.plantuml.graph.EntityImageUsecase;

public class EntityImageFactory {
    public AbstractEntityImage createEntityImage(Entity entity) {
        if (entity.getType() == EntityType.CLASS || entity.getType() == EntityType.ABSTRACT_CLASS || entity.getType() == EntityType.INTERFACE || entity.getType() == EntityType.ENUM) {
            return new EntityImageClass(entity);
        }
        if (entity.getType() == EntityType.ACTIVITY) {
            return new EntityImageActivity(entity);
        }
        if (entity.getType() == EntityType.NOTE) {
            return new EntityImageNote(entity);
        }
        if (entity.getType() == EntityType.POINT_FOR_ASSOCIATION) {
            return new EntityImageActivityCircle(entity, 4, 4);
        }
        if (entity.getType() == EntityType.CIRCLE_START) {
            return new EntityImageActivityCircle(entity, 18, 18);
        }
        if (entity.getType() == EntityType.CIRCLE_END) {
            return new EntityImageActivityCircle(entity, 18, 11);
        }
        if (entity.getType() == EntityType.BRANCH) {
            return new EntityImageActivityBranch(entity);
        }
        if (entity.getType() == EntityType.SYNCHRO_BAR) {
            return new EntityImageActivityBar(entity);
        }
        if (entity.getType() == EntityType.USECASE) {
            return new EntityImageUsecase(entity);
        }
        if (entity.getType() == EntityType.ACTOR) {
            return new EntityImageActor(entity);
        }
        if (entity.getType() == EntityType.CIRCLE_INTERFACE) {
            return new EntityImageCircleInterface(entity);
        }
        if (entity.getType() == EntityType.COMPONENT) {
            return new EntityImageComponent(entity);
        }
        return new EntityImageDefault(entity);
    }
}

