/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph2;

import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class GeomUtils {
    public static Point2D translate(Point2D point2D, double d, double d2) {
        return new Point2D.Double(point2D.getX() + d, point2D.getY() + d2);
    }

    public static boolean isHorizontal(Line2D.Double double_) {
        return double_.getP1().getY() == double_.getP2().getY();
    }

    public static boolean isVertical(Line2D.Double double_) {
        return double_.getP1().getX() == double_.getP2().getX();
    }

    public static double getMinX(Line2D.Double double_) {
        return Math.min(double_.x1, double_.x2);
    }

    public static double getMaxX(Line2D.Double double_) {
        return Math.max(double_.x1, double_.x2);
    }

    public static double getMinY(Line2D.Double double_) {
        return Math.min(double_.y1, double_.y2);
    }

    public static double getMaxY(Line2D.Double double_) {
        return Math.max(double_.y1, double_.y2);
    }

    public static Point2D.Double getPoint2D(Line2D.Double double_, double d) {
        double d2 = double_.x1 + d * (double_.x2 - double_.x1);
        double d3 = double_.y1 + d * (double_.y2 - double_.y1);
        return new Point2D.Double(d2, d3);
    }

    private static boolean isBetween(double d, double d2, double d3) {
        if (d2 < d3) {
            return d >= d2 && d <= d3;
        }
        assert (d3 <= d2);
        return d >= d3 && d <= d2;
    }

    static boolean isBetween(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        return GeomUtils.isBetween(point2D.getX(), point2D2.getX(), point2D3.getX()) && GeomUtils.isBetween(point2D.getY(), point2D2.getY(), point2D3.getY());
    }

    private static double getIntersectionVertical(Line2D.Double double_, double d) {
        double d2 = double_.x2 - double_.x1;
        if (d2 == 0.0) {
            return Double.NaN;
        }
        return (d - double_.x1) / d2;
    }

    private static double getIntersectionHorizontal(Line2D.Double double_, double d) {
        double d2 = double_.y2 - double_.y1;
        if (d2 == 0.0) {
            return Double.NaN;
        }
        return (d - double_.y1) / d2;
    }

    public static Point2D.Double getSegIntersection(Line2D.Double double_, Line2D.Double double_2) {
        double d;
        if (GeomUtils.isVertical(double_2)) {
            d = GeomUtils.getIntersectionVertical(double_, double_2.getP1().getX());
        } else if (GeomUtils.isHorizontal(double_2)) {
            d = GeomUtils.getIntersectionHorizontal(double_, double_2.getP1().getY());
        } else {
            throw new UnsupportedOperationException();
        }
        if (Double.isNaN(d) || d < 0.0 || d > 1.0) {
            return null;
        }
        Point2D.Double double_3 = GeomUtils.getPoint2D(double_, d);
        if (GeomUtils.isBetween(double_3, double_2.getP1(), double_2.getP2())) {
            return double_3;
        }
        return null;
    }

    public static String toString(Line2D line2D) {
        return GeomUtils.toString(line2D.getP1()) + "-" + GeomUtils.toString(line2D.getP2());
    }

    public static String toString(Point2D point2D) {
        return "[" + point2D.getX() + "," + point2D.getY() + "]";
    }

    public static Point2D.Double getCenter(Line2D.Double double_) {
        double d = (double_.getX1() + double_.getX2()) / 2.0;
        double d2 = (double_.getY1() + double_.getY2()) / 2.0;
        return new Point2D.Double(d, d2);
    }

    public static void fillPoint2D(Graphics2D graphics2D, Point2D point2D) {
        int n = (int)point2D.getX() - 1;
        int n2 = (int)point2D.getY() - 1;
        graphics2D.fillOval(n, n2, 3, 3);
    }
}

