/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Set;
import org.geotools.data.AbstractFeatureStore;
import org.geotools.data.DataSourceException;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureLock;
import org.geotools.data.FeatureLockException;
import org.geotools.data.FeatureLocking;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFeatureLocking
extends AbstractFeatureStore
implements FeatureLocking<SimpleFeatureType, SimpleFeature> {
    FeatureLock featureLock = FeatureLock.TRANSACTION;

    public AbstractFeatureLocking() {
    }

    public AbstractFeatureLocking(Set hints) {
        super(hints);
    }

    public void setFeatureLock(FeatureLock lock) {
        if (lock == null) {
            throw new NullPointerException("A FeatureLock is required - did you mean FeatureLock.TRANSACTION?");
        }
        this.featureLock = lock;
    }

    public int lockFeatures() throws IOException {
        return this.lockFeatures((Filter)Filter.INCLUDE);
    }

    public int lockFeatures(Filter filter) throws IOException {
        return this.lockFeatures(new DefaultQuery(((SimpleFeatureType)this.getSchema()).getTypeName(), filter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int lockFeatures(Query query) throws IOException {
        LockingManager lockingManager = this.getDataStore().getLockingManager();
        if (lockingManager == null) {
            throw new UnsupportedOperationException("DataStore not using lockingManager, must provide alternate implementation");
        }
        FeatureIterator reader = this.getFeatures(query).features();
        String typeName = query.getTypeName();
        int count = 0;
        try {
            while (reader.hasNext()) {
                try {
                    SimpleFeature feature = (SimpleFeature)reader.next();
                    lockingManager.lockFeatureID(typeName, feature.getID(), this.getTransaction(), this.featureLock);
                    ++count;
                }
                catch (FeatureLockException locked) {
                }
                catch (NoSuchElementException nosuch) {
                    throw new DataSourceException("Problem with " + query.getHandle() + " while locking", (Throwable)nosuch);
                    return count;
                }
            }
        }
        finally {
            reader.close();
        }
    }

    public void unLockFeatures() throws IOException {
        this.unLockFeatures((Filter)Filter.INCLUDE);
    }

    public void unLockFeatures(Filter filter) throws IOException {
        this.unLockFeatures(new DefaultQuery(((SimpleFeatureType)this.getSchema()).getTypeName(), filter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unLockFeatures(Query query) throws IOException {
        LockingManager lockingManager = this.getDataStore().getLockingManager();
        if (lockingManager == null) {
            throw new UnsupportedOperationException("DataStore not using lockingManager, must provide alternate implementation");
        }
        FeatureIterator reader = this.getFeatures(query).features();
        String typeName = query.getTypeName();
        try {
            while (reader.hasNext()) {
                try {
                    SimpleFeature feature = (SimpleFeature)reader.next();
                    lockingManager.unLockFeatureID(typeName, feature.getID(), this.getTransaction(), this.featureLock);
                }
                catch (NoSuchElementException nosuch) {
                    throw new DataSourceException("Problem with " + query.getHandle() + " while locking", (Throwable)nosuch);
                    return;
                }
            }
        }
        finally {
            reader.close();
        }
    }
}

