/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.TopologyException;
import java.util.ArrayList;
import org.geotools.gml.SubHandler;

public class SubHandlerLinearRing
extends SubHandler {
    private ArrayList coordinateList = new ArrayList();

    public void addCoordinate(Coordinate coordinate) {
        this.coordinateList.add(coordinate);
    }

    public boolean isComplete(String message) {
        if (this.coordinateList.size() > 1) {
            Coordinate firstCoordinate = (Coordinate)this.coordinateList.get(0);
            Coordinate lastCoordinate = (Coordinate)this.coordinateList.get(this.coordinateList.size() - 1);
            return lastCoordinate.equals2D(firstCoordinate);
        }
        return false;
    }

    public Geometry create(GeometryFactory geometryFactory) {
        try {
            Coordinate[] coords = this.coordinateList.toArray(new Coordinate[this.coordinateList.size()]);
            LinearRing ring = geometryFactory.createLinearRing(coords);
            ring.setUserData((Object)this.getSRS());
            ring.setSRID(this.getSRID());
            return ring;
        }
        catch (TopologyException e) {
            System.err.println("Caught Topology exception in GMLLinearRingHandler");
            return null;
        }
    }
}

