/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.util.AbstractSet;
import java.util.Iterator;
import org.geotools.resources.XArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LazySet<E>
extends AbstractSet<E> {
    private final Iterator<? extends E> iterator;
    private E[] elements;
    private int size;

    public LazySet(Iterator<? extends E> iterator) {
        this.iterator = iterator;
        this.elements = new Object[4];
    }

    private void addNext() {
        if (this.size >= this.elements.length) {
            this.elements = XArray.resize(this.elements, this.size * 2);
        }
        this.elements[this.size++] = this.iterator.next();
    }

    @Override
    public Iterator<E> iterator() {
        return new Iter();
    }

    @Override
    public int size() {
        while (this.iterator.hasNext()) {
            this.addNext();
        }
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0 && !this.iterator.hasNext();
    }

    final boolean exists(int index) {
        return index < this.size || this.iterator.hasNext();
    }

    public E get(int index) {
        while (index >= this.size) {
            if (!this.iterator.hasNext()) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            this.addNext();
        }
        return this.elements[index];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Iter
    implements Iterator<E> {
        private int cursor;

        private Iter() {
        }

        @Override
        public boolean hasNext() {
            return LazySet.this.exists(this.cursor);
        }

        @Override
        public E next() {
            return LazySet.this.get(this.cursor++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

