/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.index.processor;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.apache.log4j.Logger;
import org.dataone.client.v2.formats.ObjectFormatCache;
import org.dataone.cn.hazelcast.HazelcastClientFactory;
import org.dataone.cn.index.processor.IndexTaskProcessingStrategy;
import org.dataone.cn.index.task.IndexTask;
import org.dataone.cn.index.task.IndexTaskRepository;
import org.dataone.cn.index.task.ResourceMapIndexTask;
import org.dataone.cn.index.util.PerformanceLogger;
import org.dataone.cn.indexer.XmlDocumentUtility;
import org.dataone.cn.indexer.parser.utility.SeriesIdResolver;
import org.dataone.cn.indexer.resourcemap.ForesiteResourceMap;
import org.dataone.cn.indexer.resourcemap.ResourceMap;
import org.dataone.cn.indexer.resourcemap.ResourceMapFactory;
import org.dataone.cn.indexer.solrhttp.HTTPService;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.configuration.Settings;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.TypeFactory;
import org.dataone.service.types.v2.ObjectFormat;
import org.dataone.service.types.v2.SystemMetadata;
import org.dspace.foresite.OREParserException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate3.HibernateOptimisticLockingFailureException;
import org.w3c.dom.Document;

public class IndexTaskProcessor {
    private static Logger logger = Logger.getLogger((String)IndexTaskProcessor.class.getName());
    private static final String FORMAT_TYPE_DATA = "DATA";
    private static final String LOAD_LOGGER_NAME = "indexProcessorLoad";
    private static int NUMOFPROCESSOR = Settings.getConfiguration().getInt("dataone.indexing.multiThreads.processThreadPoolSize", 10);
    private static int MAXATTEMPTS = Settings.getConfiguration().getInt("dataone.indexing.multiThreads.resourceMapWait.maxAttempt", 10);
    private static ExecutorService executor = Executors.newFixedThreadPool(NUMOFPROCESSOR);
    private static final Lock lock = new ReentrantLock();
    private static Map<Future<Void>, IndexTask> futureMap = new HashMap<Future<Void>, IndexTask>();
    private static List<Future<Void>> futureQueue = new LinkedList<Future<Void>>();
    private static Set<IndexTask> preSubmittedTasks = new HashSet<IndexTask>();
    private static boolean inShutdownMode = false;
    private static ConcurrentHashMap<String, String> referencedIdsMap = new ConcurrentHashMap();
    private static ConcurrentSkipListSet<String> seriesIdsSet = new ConcurrentSkipListSet();
    @Autowired
    private IndexTaskRepository repo;
    @Autowired
    private IndexTaskProcessingStrategy deleteProcessor;
    @Autowired
    private IndexTaskProcessingStrategy updateProcessor;
    @Autowired
    private HTTPService httpService;
    @Autowired
    private String solrQueryUri;
    private PerformanceLogger perfLog = PerformanceLogger.getInstance();

    public void processIndexTaskQueue() {
        this.logProcessorLoad();
        List<IndexTask> queue = this.getIndexTaskQueue();
        IndexTask task = this.getNextIndexTask(queue);
        while (task != null) {
            this.processTaskOnThread(task);
            task = this.getNextIndexTask(queue);
        }
        this.processFailedIndexTaskQueue();
    }

    public void processIndexTaskQueue(List<IndexTask> queue) {
        IndexTask task = null;
        if (queue != null) {
            int size = queue.size();
            task = this.getNextIndexTask(queue);
            while (task != null) {
                this.processTaskOnThread(task);
                task = this.getNextIndexTask(queue);
            }
            logger.info((Object)("IndexTaskProcessor.processIndexTaskQueue - finish submitting the index task queue with the size " + size + " and current queue size is down to " + queue.size()));
        }
    }

    public void processFailedIndexTaskQueue() {
        List<IndexTask> retryQueue = this.getIndexTaskRetryQueue();
        if (retryQueue != null) {
            IndexTask task = this.getNextIndexTask(retryQueue);
            logger.info((Object)("IndexTaskProcessor.processFailedIndexTaskQueue with size " + retryQueue.size()));
            while (task != null) {
                this.processTaskOnThread(task);
                task = this.getNextIndexTask(retryQueue);
            }
        }
    }

    private void logProcessorLoad() {
        Logger loadLogger = Logger.getLogger((String)LOAD_LOGGER_NAME);
        try {
            Long newTasks = this.repo.countByStatus("NEW");
            Long failedTasks = this.repo.countByStatus("FAILED");
            loadLogger.info((Object)("new tasks:" + newTasks + ", tasks previously failed: " + failedTasks));
        }
        catch (Exception e) {
            logger.error((Object)"Unable to count NEW or FAILED tasks in task index repository.", (Throwable)e);
        }
    }

    private void processTaskOnThread(final IndexTask task) {
        logger.info((Object)("using multiple threads to process index and the size of the thread pool is " + NUMOFPROCESSOR));
        Runnable newThreadTask = new Runnable(){

            @Override
            public void run() {
                IndexTaskProcessor.this.processTask(task);
            }
        };
        Future<?> future = executor.submit(newThreadTask);
        preSubmittedTasks.remove(task);
        futureQueue.add(future);
        futureMap.put(future, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTask(IndexTask task) {
        long start = System.currentTimeMillis();
        try {
            this.checkReadinessProcessResourceMap(task);
            if (task.isDeleteTask()) {
                logger.info((Object)("+++++++++++++start to process delete index task for " + task.getPid() + " in thread " + Thread.currentThread().getId()));
                this.deleteProcessor.process(task);
                logger.info((Object)("+++++++++++++end to process delete index task for " + task.getPid() + " in thread " + Thread.currentThread().getId()));
            } else {
                logger.info((Object)("*********************start to process update index task for " + task.getPid() + " in thread " + Thread.currentThread().getId()));
                this.updateProcessor.process(task);
                logger.info((Object)("*********************end to process update index task for " + task.getPid() + " in thread " + Thread.currentThread().getId()));
            }
        }
        catch (InterruptedException interruptedE) {
            logger.warn((Object)("Task Interrupted before processing started. Resetting to NEW, for pid: " + task.getPid()));
            if (task != null) {
                task.markNew();
                this.repo.save((Object)task);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to process task for pid: " + task.getPid()), (Throwable)e);
            if (task != null) {
                this.repo.delete((Serializable)task.getId());
            }
            this.handleFailedTask(task);
            return;
        }
        finally {
            this.removeIdsFromResourceMapReferencedSetAndSeriesIdsSet(task);
        }
        if (task != null) {
            this.repo.delete((Serializable)task.getId());
        }
        logger.info((Object)("Indexing complete for pid: " + task.getPid()));
        this.perfLog.log("IndexTaskProcessor.processTasks process pid " + task.getPid(), System.currentTimeMillis() - start);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkReadinessProcessResourceMap(IndexTask task) throws InterruptedException, Exception {
        if (task != null && task instanceof ResourceMapIndexTask) {
            logger.debug((Object)("$$$$$$$$$$$$$$$$$ the index task " + task.getPid() + " is a resource map task in the the thread " + Thread.currentThread().getId()));
            lock.lock();
            try {
                ResourceMapIndexTask resourceMapTask = (ResourceMapIndexTask)task;
                List<String> referencedIds = resourceMapTask.getReferencedIds();
                if (referencedIds == null) return;
                for (String id : referencedIds) {
                    int i;
                    if (SeriesIdResolver.isSeriesId(TypeFactory.buildIdentifier((String)id))) {
                        boolean isClear = false;
                        for (i = 0; i < MAXATTEMPTS; ++i) {
                            if (!seriesIdsSet.contains(id)) {
                                isClear = true;
                                seriesIdsSet.add(id);
                                break;
                            }
                            System.out.println("###################Another index task is process the object with series id " + id + " as well. So the thread to process id " + task.getPid() + " has to wait 0.5 seconds.");
                            Thread.sleep(500L);
                        }
                        if (!isClear) {
                            this.removeIdsFromResourceMapReferencedSetAndSeriesIdsSet(task);
                            String message = "We waited for another thread to finish indexing a pid with series id " + id + " for a while. Now we quit and can't index id " + task.getPid();
                            logger.error((Object)message);
                            throw new Exception(message);
                        }
                    }
                    boolean clear = false;
                    for (i = 0; i < MAXATTEMPTS; ++i) {
                        if (id != null && !id.trim().equals("") && referencedIdsMap.containsKey(id)) {
                            if (resourceMapTask.getPid().equals(referencedIdsMap.get(id))) {
                                clear = true;
                                break;
                            }
                            logger.info((Object)("###################Another resource map is process the referenced id " + id + " as well. So the thread to process id " + resourceMapTask.getPid() + " has to wait 0.5 seconds."));
                            Thread.sleep(500L);
                            continue;
                        }
                        if (id == null || id.trim().equals("") || referencedIdsMap.containsKey(id)) continue;
                        referencedIdsMap.put(id, resourceMapTask.getPid());
                        clear = true;
                        break;
                    }
                    if (clear) continue;
                    this.removeIdsFromResourceMapReferencedSetAndSeriesIdsSet(resourceMapTask);
                    String message = "We waited for another thread to finish indexing a resource map which has the referenced id " + id + " for a while. Now we quited and can't index id " + resourceMapTask.getPid();
                    logger.error((Object)message);
                    throw new Exception(message);
                }
                return;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                lock.unlock();
            }
        } else {
            Identifier sid;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("xxxxxxxxxxxxxxxxxxxx the index task " + task.getPid() + " is NOT a resource map task in the the thread " + Thread.currentThread().getId()));
            }
            Identifier pid = new Identifier();
            pid.setValue(task.getPid());
            SystemMetadata smd = (SystemMetadata)HazelcastClientFactory.getSystemMetadataMap().get((Object)pid);
            if (smd == null || (sid = smd.getSeriesId()) == null || sid.getValue() == null || sid.getValue().trim().equals("")) return;
            lock.lock();
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("xxxxxxxxxxxxxxxxxxxx the index task " + task.getPid() + " has a sid " + sid.getValue() + " in the the thread " + Thread.currentThread().getId()));
                }
                boolean clear = false;
                for (int i = 0; i < MAXATTEMPTS; ++i) {
                    if (seriesIdsSet.contains(sid.getValue())) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("###################Another index task is process the object with series id " + sid.getValue() + " as well. So the thread to process id " + task.getPid() + " has to wait 0.5 seconds."));
                        }
                    } else {
                        clear = true;
                        seriesIdsSet.add(sid.getValue());
                        break;
                    }
                    Thread.sleep(500L);
                }
                if (clear) return;
                this.removeIdsFromResourceMapReferencedSetAndSeriesIdsSet(task);
                String message = "We waited for another thread to finish indexing a pid with series id " + sid.getValue() + " for a while. Now we quited and can't index id " + task.getPid();
                logger.error((Object)message);
                throw new Exception(message);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                lock.unlock();
            }
        }
    }

    private void removeIdsFromResourceMapReferencedSetAndSeriesIdsSet(IndexTask task) {
        if (task != null && task instanceof ResourceMapIndexTask) {
            ResourceMapIndexTask resourceMapTask = (ResourceMapIndexTask)task;
            List<String> referencedIds = resourceMapTask.getReferencedIds();
            if (referencedIds != null) {
                for (String id : referencedIds) {
                    if (id == null) continue;
                    referencedIdsMap.remove(id);
                    seriesIdsSet.remove(id);
                }
            }
        } else {
            Identifier id = new Identifier();
            id.setValue(task.getPid());
            SystemMetadata smd = (SystemMetadata)HazelcastClientFactory.getSystemMetadataMap().get((Object)id);
            logger.debug((Object)("remove the series id (if it has) for +++++ " + task.getPid()));
            if (smd != null && smd.getSeriesId() != null && smd.getSeriesId().getValue() != null) {
                logger.debug((Object)("remove the series id " + smd.getSeriesId().getValue() + " for +++++ " + task.getPid()));
                seriesIdsSet.remove(smd.getSeriesId().getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchCheckReadinessProcessResourceMap(List<IndexTask> tasks) throws Exception {
        lock.lock();
        try {
            if (tasks != null) {
                for (IndexTask task : tasks) {
                    this.checkReadinessProcessResourceMap(task);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void batchRemoveIdsFromResourceMapReferencedSet(List<IndexTask> tasks) {
        if (tasks != null) {
            for (IndexTask task : tasks) {
                this.removeIdsFromResourceMapReferencedSetAndSeriesIdsSet(task);
            }
        }
    }

    private void handleFailedTasks(List<IndexTask> tasks) {
        for (IndexTask task : tasks) {
            task.markFailed();
            this.saveTaskWithoutDuplication(task);
        }
    }

    private void handleFailedTask(IndexTask task) {
        if (task != null) {
            task.markFailed();
            this.saveTaskWithoutDuplication(task);
        }
    }

    private IndexTask getNextIndexTask(List<IndexTask> queue) {
        IndexTask task = null;
        while (task == null && !queue.isEmpty() && !inShutdownMode) {
            task = queue.remove(0);
            if (task == null) continue;
            task.markInProgress();
            task = this.saveTask(task);
            preSubmittedTasks.add(task);
            if (task == null) continue;
            logger.info((Object)("Start of indexing pid: " + task.getPid()));
            if (task.isDeleteTask()) {
                return task;
            }
            if (!this.isObjectPathReady(task)) {
                task.markNew();
                this.saveTaskWithoutDuplication(task);
                logger.info((Object)("Task for pid: " + task.getPid() + " not processed since the object path is not ready."));
                task = null;
                continue;
            }
            if (!this.representsResourceMap(task)) continue;
            boolean ready = true;
            ResourceMap rm = null;
            List<String> referencedIds = null;
            try {
                rm = ResourceMapFactory.buildResourceMap(task.getObjectPath());
                referencedIds = rm.getAllDocumentIDs();
                boolean found = referencedIds.remove(task.getPid());
                while (found) {
                    found = referencedIds.remove(task.getPid());
                }
                if (!this.areAllReferencedDocsIndexed(referencedIds)) {
                    logger.info((Object)("****************Not all map resource references indexed for map: " + task.getPid() + ".  Marking new and continuing..."));
                    ready = false;
                }
            }
            catch (OREParserException oreException) {
                ready = false;
                logger.error((Object)("Unable to parse ORE doc: " + task.getPid() + ".  Unrecoverable parse error: task will not be re-tried."));
                if (logger.isTraceEnabled()) {
                    oreException.printStackTrace();
                }
            }
            catch (Exception e) {
                ready = false;
                logger.error((Object)("unable to load resource for pid: " + task.getPid() + " at object path: " + task.getObjectPath() + ".  Marking new and continuing..."));
            }
            if (!ready) {
                task.markNew();
                this.saveTaskWithoutDuplication(task);
                logger.info((Object)("Task for resource map pid: " + task.getPid() + " not processed."));
                task = null;
                continue;
            }
            logger.info((Object)("the original index task - " + task.toString()));
            ResourceMapIndexTask resourceMapIndexTask = new ResourceMapIndexTask();
            resourceMapIndexTask.copy(task);
            resourceMapIndexTask.setReferencedIds(referencedIds);
            task = resourceMapIndexTask;
            if (task instanceof ResourceMapIndexTask) {
                logger.info((Object)"the new index task is a ResourceMapIndexTask");
                logger.info((Object)("the new index task - " + task.toString()));
                continue;
            }
            logger.error((Object)"Something is wrong to change the IndexTask object to the ResourceMapIndexTask object ");
        }
        return task;
    }

    private boolean areAllReferencedDocsIndexed(List<String> referencedIds) {
        if (referencedIds == null || referencedIds.size() == 0) {
            return true;
        }
        List<SolrDoc> updateDocuments = null;
        int numberOfIndexedOrRemovedReferences = 0;
        try {
            updateDocuments = this.httpService.getDocumentsById(this.solrQueryUri, referencedIds);
            numberOfIndexedOrRemovedReferences = 0;
            for (String id : referencedIds) {
                boolean foundId = false;
                for (SolrDoc solrDoc : updateDocuments) {
                    if (!solrDoc.getIdentifier().equals(id) && !id.equals(solrDoc.getSeriesId())) continue;
                    foundId = true;
                    ++numberOfIndexedOrRemovedReferences;
                    break;
                }
                if (foundId) continue;
                Identifier pid = new Identifier();
                pid.setValue(id);
                logger.info((Object)("Identifier " + id + " was not found in the referenced id list in the Solr search index."));
                SystemMetadata smd = (SystemMetadata)HazelcastClientFactory.getSystemMetadataMap().get((Object)pid);
                if (smd == null || !this.notVisibleInIndex(smd)) continue;
                ++numberOfIndexedOrRemovedReferences;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return referencedIds.size() == numberOfIndexedOrRemovedReferences;
    }

    private boolean notVisibleInIndex(SystemMetadata smd) {
        if (smd == null) {
            return false;
        }
        return !SolrDoc.visibleInIndex(smd);
    }

    private boolean representsResourceMap(IndexTask task) {
        return ForesiteResourceMap.representsResourceMap(task.getFormatId());
    }

    private boolean isObjectPathReady(IndexTask task) {
        if (this.isDataObject(task)) {
            return true;
        }
        boolean ready = false;
        String hzObjectPath = null;
        if (task.getObjectPath() != null) {
            if (new File(task.getObjectPath()).exists()) {
                ready = true;
            } else {
                hzObjectPath = this.retrieveHzObjectPath(task.getPid());
                if (hzObjectPath != null && new File(hzObjectPath).exists()) {
                    task.setObjectPath(hzObjectPath);
                    ready = true;
                }
            }
        } else {
            hzObjectPath = this.retrieveHzObjectPath(task.getPid());
            if (hzObjectPath != null && new File(hzObjectPath).exists()) {
                task.setObjectPath(hzObjectPath);
                ready = true;
            }
        }
        if (!ready) {
            logger.info((Object)("Valid Object Path could not be found for pid: " + task.getPid() + "  Checked path strings in the task [" + task.getObjectPath() + "] and Hazelcast [" + hzObjectPath + "]"));
        }
        return ready;
    }

    private boolean isDataObject(IndexTask task) {
        ObjectFormat format = null;
        try {
            ObjectFormatIdentifier formatId = new ObjectFormatIdentifier();
            formatId.setValue(task.getFormatId());
            format = ObjectFormatCache.getInstance().getFormat(formatId);
        }
        catch (BaseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return FORMAT_TYPE_DATA.equals(format.getFormatType());
    }

    private String retrieveHzObjectPath(String pidString) {
        Identifier pid = TypeFactory.buildIdentifier((String)pidString);
        String path = (String)HazelcastClientFactory.getObjectPathMap().get((Object)pid);
        if (path == null) {
            HazelcastClientFactory.getObjectPathMap().evict((Object)pid);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("did not find Object Path for pid: " + pidString + " cleaning up the map by evicting the pid."));
            }
        }
        return path;
    }

    private List<IndexTask> getIndexTaskQueue() {
        long getIndexTasksStart = System.currentTimeMillis();
        List indexTasks = this.repo.findByStatusOrderByPriorityAscTaskModifiedDateAsc("NEW");
        this.perfLog.log("IndexTaskProcessor.getIndexTaskQueue() fetching NEW IndexTasks from repo", System.currentTimeMillis() - getIndexTasksStart);
        return indexTasks;
    }

    private List<IndexTask> getIndexTaskRetryQueue() {
        return this.repo.findByStatusAndNextExecutionLessThan("FAILED", System.currentTimeMillis());
    }

    private IndexTask saveTask(IndexTask task) {
        try {
            task = (IndexTask)this.repo.save((Object)task);
            logger.info((Object)("IndexTaskProcess.saveTask save the index task " + task.getPid()));
        }
        catch (HibernateOptimisticLockingFailureException e) {
            logger.error((Object)("Unable to update index task for pid: " + task.getPid() + "."));
            task = null;
        }
        return task;
    }

    private void saveTaskWithoutDuplication(IndexTask task) {
        if (task != null && !this.newOrFailedIndexTaskExists(task.getPid())) {
            this.saveTask(task);
        }
    }

    private boolean newOrFailedIndexTaskExists(String id) {
        logger.info((Object)("IndexTaskProcess.newOrFailedIndexTaskExists for id " + id));
        boolean exist = false;
        if (id != null) {
            List itList = this.repo.findByPidAndStatus(id, "NEW");
            if (itList != null && !itList.isEmpty()) {
                logger.info((Object)("IndexTaskProcess.newOrFailedIndexTaskExists did find a new-status index task for id " + id));
                exist = true;
            }
            if (!exist && (itList = this.repo.findByPidAndStatus(id, "FAILED")) != null && !itList.isEmpty()) {
                logger.info((Object)("IndexTaskProcess.newOrFailedIndexTaskExists did find a failed-status index task for id " + id));
                exist = true;
            }
        }
        return exist;
    }

    private Document loadDocument(IndexTask task) {
        Document docObject = null;
        try {
            docObject = XmlDocumentUtility.loadDocument(task.getObjectPath());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (docObject == null) {
            logger.error((Object)("Could not load OBJECT file for ID,Path=" + task.getPid() + ", " + task.getObjectPath()));
        }
        return docObject;
    }

    public void setSolrQueryUri(String uri) {
        this.solrQueryUri = uri;
    }

    public ExecutorService getExecutorService() {
        return executor;
    }

    public Queue<Future> getFutureQueue() {
        return new CircularFifoQueue(futureQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownExecutor() {
        IndexTask t2;
        inShutdownMode = true;
        logger.warn((Object)("processor [" + this + "] Shutting down the ExecutorService.  Will allow active tasks to finish; " + "will cancel submitted tasks and return them to NEW status, wait for active tasks to finish, then " + "return any remaining task not yet submitted to NEW status...."));
        logger.warn((Object)"...1.) closing ExecutorService to new tasks...");
        this.getExecutorService().shutdown();
        logger.warn((Object)"...2.) cancelling cancellable futures...");
        logger.warn((Object)String.format("...number of futures: %d", futureQueue.size()));
        logger.warn((Object)("... number of tasks in futures map: " + futureMap.size()));
        int marked = 0;
        int noTaskMapping = 0;
        LinkedList<Future> uncancellable = new LinkedList<Future>();
        if (!futureQueue.isEmpty()) {
            for (int i = futureQueue.size() - 1; i > -1; --i) {
                Future f = futureQueue.get(i);
                if (f.cancel(false)) {
                    t2 = futureMap.get(f);
                    if (t2 != null) {
                        t2.markNew();
                        this.repo.save((Object)t2);
                        ++marked;
                        continue;
                    }
                    ++noTaskMapping;
                    continue;
                }
                uncancellable.add(f);
            }
            logger.warn((Object)String.format("...number of (cancellable) runnables/tasks reset to new: %d", marked));
            logger.warn((Object)String.format("...number of (cancellable) runnables not mapped to tasks: %d", noTaskMapping));
            logger.warn((Object)String.format("...number of uncancellable runnables: %d (completed or in process)", uncancellable.size()));
        }
        try {
            logger.warn((Object)"...3.) waiting (with timeout) for active futures to finish...");
            this.getExecutorService().awaitTermination(3L, TimeUnit.MINUTES);
            logger.warn((Object)"...4.) Reviewing remaining uncancellables to check for completion, returning incomplete ones to NEW status...");
            if (!uncancellable.isEmpty()) {
                for (Future f : uncancellable) {
                    if (f.isDone()) continue;
                    t2 = futureMap.get(f);
                    if (t2 != null) {
                        if ("IN PROCESS".equals(t2.getStatus())) {
                            t2.markNew();
                            this.repo.save((Object)t2);
                            logger.warn((Object)("...active future for pid " + t2.getPid() + " not done.  Resetting to NEW, to allow reprocessing next time..."));
                            continue;
                        }
                        logger.warn((Object)("...active future for pid " + t2.getPid() + "completed during wait period with status " + t2.getStatus()));
                        continue;
                    }
                    logger.error((Object)"...CANNOT requeue task. No task mapped to this future!!");
                }
            }
        }
        catch (InterruptedException e) {
            logger.warn((Object)"interrupt caught while waiting for executor service to finish executing uninterruptable tasks.");
        }
        finally {
            logger.warn((Object)"...5.) Calling shutdownNow on the executor service.");
            List<Runnable> stillWaiting = this.getExecutorService().shutdownNow();
            logger.warn((Object)("... .... number of runnables still waiting: " + stillWaiting.size()));
            logger.warn((Object)"...6.) returning preSubmitted tasks to NEW status...");
            logger.warn((Object)("... .... number of preSubmitted tasks: " + preSubmittedTasks.size()));
            for (IndexTask t2 : preSubmittedTasks) {
                try {
                    t2.markNew();
                    this.repo.save((Object)t2);
                    logger.warn((Object)("... preSubmittedTask for pid " + t2.getPid() + "returned to NEW status."));
                }
                catch (Throwable e) {
                    logger.error((Object)("....... Exception thrown trying to return task to NEW status for pid: " + t2.getPid()), e);
                }
            }
            logger.warn((Object)"...7.) DONE with shutdown.");
        }
    }
}

