/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.dbadapter;

import edu.ucsb.nceas.dbadapter.AbstractDatabase;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class OracleAdapter
extends AbstractDatabase {
    @Override
    public long getUniqueID(Connection conn, String tableName) throws SQLException {
        long uniqueid = 0L;
        Statement stmt = null;
        stmt = conn.createStatement();
        stmt.execute("SELECT " + tableName + "_id_seq.currval FROM dual");
        ResultSet rs = stmt.getResultSet();
        if (rs.next()) {
            uniqueid = rs.getLong(1);
        }
        stmt.close();
        return uniqueid;
    }

    @Override
    public String getDateTimeFunction() {
        return "sysdate";
    }

    @Override
    public String getIsNULLFunction() {
        return "nvl";
    }

    @Override
    public String getStringDelimiter() {
        return "'";
    }

    @Override
    public String getLeftJoinQuery(String selectFields, String tableA, String tableB, String joinCriteria, String nonJoinCriteria) {
        return "SELECT " + selectFields + " FROM " + tableA + " a, " + tableB + " b WHERE " + joinCriteria + "(+) " + " AND (" + nonJoinCriteria + ")";
    }

    @Override
    public String getReplicationDocumentListSQL() {
        String sql = "select a.docid, a.rev, a.doctype from xml_documents a, xml_revisions b where a.docid=b.docid(+) and  a.rev<=b.rev(+) and b.docid is null ";
        return sql;
    }

    @Override
    public String getPagedQuery(String queryWithOrderBy, Integer start, Integer count) {
        StringBuffer query = new StringBuffer("SELECT " + queryWithOrderBy);
        if (start != null) {
            query = new StringBuffer();
            query.append("SELECT * FROM ");
            query.append("( SELECT a.*, ROWNUM rnum FROM ");
            query.append("( " + queryWithOrderBy + " ) a ");
            if (count != null) {
                query.append(" WHERE ROWNUM <= " + count);
            }
            query.append(" ) ");
            query.append("WHERE rnum  >= " + start);
        }
        return query.toString();
    }
}

