/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.IndexingQueue;
import edu.ucsb.nceas.metacat.common.query.EnabledQueryEngines;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.database.DatabaseService;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.util.MetacatUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.TimerTask;
import java.util.Vector;
import org.apache.log4j.Logger;

public class IndexingTimerTask
extends TimerTask {
    private Logger logMetacat = Logger.getLogger(IndexingTimerTask.class);
    int count = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block13: {
            String nonJoinCriteria;
            int serialNumber;
            DBConnection dbConn;
            block12: {
                block11: {
                    if (!EnabledQueryEngines.getInstance().isEnabled("pathquery")) {
                        return;
                    }
                    dbConn = null;
                    serialNumber = 0;
                    this.logMetacat.warn((Object)"Running indexing timer task");
                    dbConn = DBConnectionPool.getDBConnection("IndexingThread");
                    serialNumber = dbConn.getCheckOutSerialNumber();
                    Vector<String> indexNamespaces = MetacatUtil.getOptionList(PropertyService.getProperty("xml.indexNamespaces"));
                    nonJoinCriteria = "b.docid is NULL";
                    boolean first = true;
                    if (indexNamespaces == null || indexNamespaces.isEmpty()) break block11;
                    Iterator<String> it = indexNamespaces.iterator();
                    while (it.hasNext()) {
                        if (first) {
                            nonJoinCriteria = nonJoinCriteria + " AND (";
                            nonJoinCriteria = nonJoinCriteria + " a.doctype like '" + it.next() + "'";
                            first = false;
                            continue;
                        }
                        nonJoinCriteria = nonJoinCriteria + " OR ";
                        nonJoinCriteria = nonJoinCriteria + " a.doctype like '" + it.next() + "'";
                    }
                    nonJoinCriteria = nonJoinCriteria + ")";
                    break block12;
                }
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
                return;
            }
            try {
                String xmlDocumentsCheck = DatabaseService.getInstance().getDBAdapter().getLeftJoinQuery("a.docid, a.rev", "xml_documents", "xml_index", "a.docid = b.docid", nonJoinCriteria);
                PreparedStatement xmlDocCheck = dbConn.prepareStatement(xmlDocumentsCheck);
                dbConn.increaseUsageCount(1);
                xmlDocCheck.execute();
                ResultSet rs = xmlDocCheck.getResultSet();
                boolean tableHasRows = rs.next();
                while (tableHasRows) {
                    String docid = rs.getString(1);
                    String rev = rs.getString(2);
                    IndexingQueue.getInstance().add(docid, rev);
                    tableHasRows = rs.next();
                }
                rs.close();
                xmlDocCheck.close();
            }
            catch (SQLException se) {
                se.printStackTrace();
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
                break block13;
            }
            catch (Exception e) {
                e.printStackTrace();
                {
                    catch (Throwable throwable) {
                        DBConnectionPool.returnDBConnection(dbConn, serialNumber);
                        throw throwable;
                    }
                }
                DBConnectionPool.returnDBConnection(dbConn, serialNumber);
            }
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
        }
        this.logMetacat.warn((Object)"Indexing timer task returning");
        ++this.count;
    }
}

