/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.QuerySpecification;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.DatatypeConverter;
import org.apache.log4j.Logger;

public class QueryTerm {
    private static Logger log = Logger.getLogger(QueryTerm.class);
    private boolean casesensitive = false;
    private String searchmode = null;
    private String value = null;
    private String pathexpr = null;
    private boolean percentageSymbol = false;
    private int countPercentageSearchItem = 0;
    private boolean inUnionGroup = false;
    public static final String CONTAINS = "contains";
    public static final String EQUALS = "equals";

    public QueryTerm(boolean casesensitive, String searchmode, String value) {
        this.casesensitive = casesensitive;
        this.searchmode = searchmode;
        this.value = value;
    }

    public QueryTerm(boolean casesensitive, String searchmode, String value, String pathexpr) {
        this(casesensitive, searchmode, value);
        this.pathexpr = pathexpr;
    }

    public boolean isCaseSensitive() {
        return this.casesensitive;
    }

    public String getSearchMode() {
        return this.searchmode;
    }

    public String getValue() {
        return this.value;
    }

    public String getPathExpression() {
        return this.pathexpr;
    }

    public int getPercentageSymbolCount() {
        return this.countPercentageSearchItem;
    }

    public void setInUnionGroup(boolean inUnionGroup) {
        this.inUnionGroup = inUnionGroup;
    }

    public boolean isInUnionGroup() {
        return this.inUnionGroup;
    }

    public String printSearchExprSQL(List<Object> parameterValues) {
        String casevalue = null;
        String nodedataterm = null;
        boolean notEqual = false;
        if (this.casesensitive) {
            nodedataterm = "nodedata";
            casevalue = this.value;
        } else {
            nodedataterm = "UPPER(nodedata)";
            casevalue = this.value.toUpperCase();
        }
        String searchexpr = null;
        if (this.searchmode.equals("starts-with")) {
            searchexpr = nodedataterm + " LIKE ? ";
            parameterValues.add(casevalue + "%");
        } else if (this.searchmode.equals("ends-with")) {
            searchexpr = nodedataterm + " LIKE ? ";
            parameterValues.add("%" + casevalue + "%");
        } else if (this.searchmode.equals(CONTAINS)) {
            if (!casevalue.equals("%")) {
                searchexpr = nodedataterm + " LIKE ? ";
                parameterValues.add("%" + casevalue + "%");
            } else {
                searchexpr = nodedataterm + " LIKE ? ";
                parameterValues.add(casevalue);
                this.percentageSymbol = true;
            }
        } else if (this.searchmode.equals("not-contains")) {
            notEqual = true;
            searchexpr = nodedataterm + " LIKE ? ";
            parameterValues.add("%" + casevalue + "%");
        } else if (this.searchmode.equals(EQUALS)) {
            searchexpr = nodedataterm + " = ? ";
            parameterValues.add(casevalue);
        } else if (this.searchmode.equals("isnot-equal")) {
            notEqual = true;
            searchexpr = nodedataterm + " = ? ";
            parameterValues.add(casevalue);
        } else {
            String oper = null;
            if (this.searchmode.equals("greater-than")) {
                oper = ">";
                nodedataterm = "nodedatanumerical";
            } else if (this.searchmode.equals("greater-than-equals")) {
                oper = ">=";
                nodedataterm = "nodedatanumerical";
            } else if (this.searchmode.equals("less-than")) {
                oper = "<";
                nodedataterm = "nodedatanumerical";
            } else if (this.searchmode.equals("less-than-equals")) {
                oper = "<=";
                nodedataterm = "nodedatanumerical";
            } else {
                System.out.println("NOT expected case. NOT recognized operator: " + this.searchmode);
                return null;
            }
            try {
                Double doubleVal = new Double(casevalue);
                searchexpr = nodedataterm + " " + oper + " ? ";
                parameterValues.add(doubleVal);
            }
            catch (NumberFormatException nfe) {
                try {
                    Calendar dataDateValue = DatatypeConverter.parseDateTime((String)casevalue);
                    nodedataterm = "nodedatadate";
                    searchexpr = nodedataterm + " " + oper + " ? ";
                    parameterValues.add(dataDateValue.getTime());
                }
                catch (Exception pe) {
                    searchexpr = nodedataterm + " " + oper + " ? ";
                    parameterValues.add(casevalue);
                }
            }
        }
        return searchexpr;
    }

    public boolean isNotEqualTerm() {
        boolean notEqual = false;
        if (this.searchmode.equals("not-contains")) {
            notEqual = true;
        } else if (this.searchmode.equals("isnot-equal")) {
            notEqual = true;
        }
        return notEqual;
    }

    public String printSQL(boolean useXMLIndex, List<Object> parameterValues) {
        StringBuffer self = new StringBuffer();
        boolean notEqual = this.isNotEqualTerm();
        ArrayList<Object> searchValues = new ArrayList<Object>();
        String searchexpr = this.printSearchExprSQL(searchValues);
        parameterValues.addAll(searchValues);
        boolean usePathIndex = false;
        if (this.pathexpr != null) {
            try {
                if (SystemUtil.getPathsForIndexing().contains(this.pathexpr)) {
                    usePathIndex = true;
                }
            }
            catch (MetacatUtilException ue) {
                log.warn((Object)("Could not get index paths: " + ue.getMessage()));
            }
        }
        if (usePathIndex) {
            if (notEqual) {
                if (!this.inUnionGroup) {
                    self.append("SELECT DISTINCT docid from xml_path_index WHERE");
                    self.append(" docid NOT IN (Select docid FROM xml_path_index WHERE ");
                    self.append(searchexpr);
                    self.append("AND path LIKE ? ) ");
                    parameterValues.add(this.pathexpr);
                } else {
                    self.append("(" + searchexpr);
                    self.append("AND path LIKE ?) ");
                    parameterValues.add(this.pathexpr);
                }
            } else if (!this.inUnionGroup) {
                self.append("SELECT DISTINCT docid FROM xml_path_index WHERE ");
                self.append(searchexpr);
                self.append("AND path LIKE ? ");
                parameterValues.add(this.pathexpr);
            } else {
                self.append("(" + searchexpr);
                self.append("AND path LIKE ?) ");
                parameterValues.add(this.pathexpr);
            }
        } else {
            if (notEqual) {
                self.append("SELECT DISTINCT docid from xml_nodes WHERE");
                self.append(" docid NOT IN (Select docid FROM xml_nodes WHERE ");
            } else {
                self.append("(SELECT DISTINCT docid FROM xml_nodes WHERE ");
            }
            self.append(searchexpr);
            if (this.pathexpr != null) {
                String path = this.pathexpr;
                if (useXMLIndex) {
                    if (!this.hasAttributeInPath(this.pathexpr)) {
                        self.append("AND parentnodeid IN ");
                        self.append("(SELECT nodeid FROM xml_index WHERE path LIKE ?) ");
                        parameterValues.add(path);
                    } else {
                        String attributeName = QuerySpecification.getAttributeName(this.pathexpr);
                        self.append("AND nodetype LIKE 'ATTRIBUTE' AND nodename LIKE ? ");
                        parameterValues.add(attributeName);
                        if (!(this.pathexpr.startsWith("@") || this.pathexpr.startsWith("./@") || this.pathexpr.startsWith("../@"))) {
                            self.append("AND parentnodeid IN ");
                            path = QuerySpecification.newPathExpressionWithOutAttribute(this.pathexpr);
                            self.append("(SELECT nodeid FROM xml_index WHERE path LIKE ?) ");
                            parameterValues.add(path);
                        }
                    }
                } else {
                    ArrayList<Object> nestedParameterValues = new ArrayList<Object>();
                    self.append("AND ");
                    String nested = QueryTerm.useNestedStatements(this.pathexpr, nestedParameterValues);
                    self.append(nested);
                    parameterValues.addAll(nestedParameterValues);
                }
            } else if (this.value.trim().equals("%")) {
                ++this.countPercentageSearchItem;
            }
            self.append(") ");
        }
        return self.toString();
    }

    private boolean hasAttributeInPath(String path) {
        return path.indexOf("@") != -1;
    }

    public static String useNestedStatements(String pathexpr, List<Object> parameterValues) {
        log.info((Object)"useNestedStatements()");
        log.info((Object)("pathexpr: " + pathexpr));
        String elementPrefix = " parentnodeid IN ";
        String attributePrefix = " nodeid IN ";
        boolean lastOneIsAttribute = false;
        StringBuffer nestedStmts = new StringBuffer();
        String path = pathexpr.trim();
        String sql = "";
        if (path.indexOf(47) == 0) {
            nestedStmts.append("AND parentnodeid = rootnodeid ");
            path = path.substring(1).trim();
        }
        do {
            String node;
            int inx = path.indexOf(47);
            int predicateStart = -1;
            Vector<String> predicates = new Vector<String>();
            predicateStart = path.indexOf(91, predicateStart + 1);
            if (inx != -1 && (predicateStart == -1 || predicateStart > inx)) {
                node = path.substring(0, inx).trim();
                path = path.substring(inx + 1).trim();
            } else if (predicateStart == -1) {
                node = path;
                if (node != null && node.indexOf("@") != -1) {
                    lastOneIsAttribute = true;
                    node = QueryTerm.removeAttributeSymbol(node);
                }
                path = "";
            } else {
                node = path.substring(0, predicateStart).trim();
                path = path.substring(predicateStart);
                predicateStart = 0;
                while (predicateStart == 0) {
                    int predicateEnd = path.indexOf(93, predicateStart);
                    if (predicateEnd == -1) {
                        log.warn((Object)"useNestedStatements(): ");
                        log.warn((Object)("    Invalid path: " + pathexpr));
                        return "";
                    }
                    predicates.add(path.substring(1, predicateEnd).trim());
                    path = path.substring(predicateEnd + 1).trim();
                    inx = path.indexOf(47);
                    predicateStart = path.indexOf(91);
                }
                if (inx == 0) {
                    path = path.substring(1).trim();
                } else if (!path.equals("")) {
                    log.warn((Object)"useNestedStatements(): ");
                    log.warn((Object)("    Invalid path: " + pathexpr));
                    return "";
                }
            }
            nestedStmts.insert(0, "(SELECT nodeid FROM xml_nodes WHERE nodename LIKE ? ");
            parameterValues.add(0, node);
            if (!path.equals("")) {
                nestedStmts.insert(0, "AND parentnodeid IN ");
            }
            if (predicates.size() > 0) {
                for (int n = 0; n < predicates.size(); ++n) {
                    ArrayList<Object> predicateParameterValues = new ArrayList<Object>();
                    String predSQL = QueryTerm.predicate2SQL((String)predicates.get(n), predicateParameterValues);
                    if (predSQL.equals("")) {
                        return "";
                    }
                    parameterValues.addAll(predicateParameterValues);
                    nestedStmts.append(predSQL).append(' ');
                }
            }
            nestedStmts.append(") ");
        } while (!path.equals(""));
        sql = lastOneIsAttribute ? attributePrefix + nestedStmts.toString() : elementPrefix + nestedStmts.toString();
        return sql;
    }

    private static String removeAttributeSymbol(String path) {
        String newPath = "";
        log.debug((Object)("Original string before removing @ is " + path));
        if (path != null) {
            int attribute = path.indexOf("@");
            if (attribute != -1) {
                try {
                    newPath = path.substring(attribute + 1).trim();
                }
                catch (Exception e) {
                    newPath = path;
                }
            } else {
                newPath = path;
            }
        } else {
            newPath = path;
        }
        log.debug((Object)("String after removing @ is " + newPath));
        return newPath;
    }

    public static String predicate2SQL(String predicate, List<Object> predicateParameterValues) {
        String path = predicate.trim();
        int equals = path.indexOf(61);
        String literal = null;
        if (equals != -1) {
            literal = path.substring(equals + 1).trim();
            path = path.substring(0, equals).trim();
            int sQuote = literal.indexOf(39);
            int dQuote = literal.indexOf(34);
            if (sQuote == -1 && dQuote == -1) {
                log.warn((Object)"predicate2SQL(): ");
                log.warn((Object)("  1  Invalid or unsupported predicate: " + predicate));
                return "";
            }
            if (sQuote == -1 && (dQuote != 0 || literal.indexOf(34, dQuote + 1) != literal.length() - 1)) {
                log.warn((Object)"predicate2SQL(): ");
                log.warn((Object)("  2  Invalid or unsupported predicate: " + predicate));
                return "";
            }
            if (sQuote != 0 || literal.indexOf(39, sQuote + 1) != literal.length() - 1) {
                log.warn((Object)"predicate2SQL(): ");
                log.warn((Object)("  3  Invalid or unsupported predicate: " + predicate));
                return "";
            }
        }
        StringBuffer sql = new StringBuffer();
        int attribute = path.indexOf(64);
        if (attribute == -1) {
            if (literal != null) {
                sql.append("AND nodeid IN (SELECT parentnodeid FROM xml_nodes WHERE nodetype = 'TEXT' AND nodedata LIKE ").append("?").append(")");
                literal = literal.substring(1, literal.length() - 1);
                predicateParameterValues.add(literal);
            }
        } else {
            sql.append("AND nodeid IN (SELECT parentnodeid FROM xml_nodes WHERE nodetype = 'ATTRIBUTE' AND nodename LIKE ? ");
            predicateParameterValues.add(path.substring(attribute + 1).trim());
            if (literal != null) {
                sql.append("AND nodedata LIKE ? ");
                literal = literal.substring(1, literal.length() - 1);
                predicateParameterValues.add(literal);
            }
            sql.append(")");
            path = path.substring(0, attribute).trim();
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1).trim();
            } else if (!path.equals("")) {
                log.warn((Object)"predicate2SQL(): ");
                log.warn((Object)("    Invalid or unsupported predicate: " + predicate));
                return "";
            }
        }
        while (!path.equals("")) {
            String node;
            int ndx = path.lastIndexOf(47);
            int predicateEnd = -1;
            if (ndx != -1) {
                node = path.substring(ndx + 1).trim();
                path = path.substring(0, ndx).trim();
            } else {
                node = path;
                path = "";
            }
            if (!node.equals("")) {
                sql.insert(0, "(SELECT parentnodeid FROM xml_nodes WHERE nodename LIKE ? ) ");
                predicateParameterValues.add(0, node);
            } else if (!path.equals("")) {
                log.warn((Object)"predicate2SQL(): ");
                log.warn((Object)("    Invalid or unsupported predicate: " + predicate));
                return "";
            }
            if (path.equals("")) {
                sql.insert(0, node.equals("") ? "AND rootnodeid IN " : "AND nodeid IN ");
                continue;
            }
            sql.append("AND nodeid IN ");
        }
        return sql.toString();
    }

    public String toString() {
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        return this.printSQL(true, parameterValues);
    }

    public boolean hasSameSearchValue(QueryTerm term) {
        String searchValue;
        boolean same = false;
        if (term != null && (searchValue = term.getValue()) != null && this.value != null && searchValue.equalsIgnoreCase(this.value) && this.getSearchMode().equals(term.getSearchMode())) {
            same = true;
        }
        return same;
    }
}

