/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.admin.upgrade;

import edu.ucsb.nceas.metacat.admin.AdminException;
import edu.ucsb.nceas.metacat.admin.upgrade.UpgradeUtilityInterface;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.utilities.SortedProperties;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpgradeNodeDataDatetime
implements UpgradeUtilityInterface {
    protected static Log log = LogFactory.getLog(UpgradeNodeDataDatetime.class);
    private String driver = null;
    private String url = null;
    private String user = null;
    private String password = null;

    @Override
    public boolean upgrade() throws AdminException {
        String[] tablesToUpdate = new String[]{"xml_nodes", "xml_nodes_revisions", "xml_path_index"};
        boolean success = true;
        try {
            for (String tableName : tablesToUpdate) {
                success = success && this.upgradeSingleTable(tableName);
            }
        }
        catch (Exception e) {
            AdminException ae = new AdminException("Error upgrading tables: " + e.getMessage());
            ae.initCause(e);
            throw ae;
        }
        return success;
    }

    private Connection getConnection() throws AdminException {
        Connection conn = null;
        try {
            this.driver = PropertyService.getProperty("database.driver");
            this.url = PropertyService.getProperty("database.connectionURI");
            this.user = PropertyService.getProperty("database.user");
            this.password = PropertyService.getProperty("database.password");
            Driver d = (Driver)Class.forName(this.driver).newInstance();
            DriverManager.registerDriver(d);
            conn = DriverManager.getConnection(this.url, this.user, this.password);
        }
        catch (Exception e) {
            String msg = "Could not get connection: " + e.getMessage();
            log.error((Object)msg);
            AdminException ae = new AdminException(msg);
            ae.initCause(e);
            throw ae;
        }
        return conn;
    }

    private Map<String, Timestamp> getDataValues(String tableName) throws AdminException {
        TreeMap<String, Timestamp> dataValues = new TreeMap<String, Timestamp>();
        try {
            Connection conn = this.getConnection();
            Statement sqlStatement = null;
            ResultSet rset = null;
            String nodeid = null;
            String nodedata = null;
            int count = 0;
            sqlStatement = conn.createStatement();
            rset = sqlStatement.executeQuery("SELECT DISTINCT NODEID, NODEDATA FROM " + tableName + " WHERE nodedata IS NOT NULL " + " AND nodedata LIKE '____-__-__%' ");
            count = 0;
            while (rset.next()) {
                nodeid = rset.getString(1);
                nodedata = rset.getString(2);
                if (nodedata.trim().equals("")) continue;
                try {
                    Calendar dataDateValue = DatatypeConverter.parseDateTime((String)nodedata);
                    Timestamp dataTimestamp = new Timestamp(dataDateValue.getTimeInMillis());
                    dataValues.put(nodeid, dataTimestamp);
                    log.debug((Object)("parsed: " + nodedata));
                    if (++count % 5 != 0) continue;
                    log.debug((Object)(count + "..."));
                }
                catch (Exception e) {}
            }
            log.warn((Object)("Converting table: " + tableName + " with " + count + " values found."));
            rset.close();
            sqlStatement.close();
            conn.close();
        }
        catch (Exception e) {
            String msg = "Error parsing date time node data: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new AdminException(msg);
        }
        return dataValues;
    }

    private boolean upgradeSingleTable(String tableName) throws Exception {
        Map<String, Timestamp> dataValues = this.getDataValues(tableName);
        Connection conn = this.getConnection();
        PreparedStatement pstmt = conn.prepareStatement("update " + tableName + " set nodedatadate = ? " + " where nodeid = ? ");
        for (String nodeid : dataValues.keySet()) {
            Timestamp dataTimestamp = dataValues.get(nodeid);
            pstmt.setTimestamp(1, dataTimestamp);
            pstmt.setInt(2, Integer.valueOf(nodeid));
            log.debug((Object)("Updating values: " + pstmt.toString()));
            try {
                pstmt.execute();
            }
            catch (SQLException sqle) {
                log.warn((Object)("DB error when updating date value, likely can ignore as some errors are to be expected. " + sqle.getMessage()));
            }
        }
        if (conn != null) {
            conn.close();
        }
        return true;
    }

    public static void main(String[] ags) {
        try {
            SortedProperties testProperties = new SortedProperties("test/test.properties");
            testProperties.load();
            String metacatContextDir = testProperties.getProperty("metacat.contextDir");
            PropertyService.getInstance(metacatContextDir + "/WEB-INF");
            UpgradeNodeDataDatetime upgrader = new UpgradeNodeDataDatetime();
            upgrader.upgrade();
        }
        catch (Exception ex) {
            System.out.println("Exception:" + ex.getMessage());
            ex.printStackTrace();
        }
    }
}

