/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.authentication;

import edu.ucsb.nceas.metacat.AuthInterface;
import edu.ucsb.nceas.metacat.AuthLdap;
import edu.ucsb.nceas.metacat.authentication.AuthFileHashInterface;
import edu.ucsb.nceas.metacat.authentication.AuthenticationException;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.Console;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ExpressionEngine;
import org.apache.commons.configuration.tree.xpath.XPathExpressionEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthFile
implements AuthInterface {
    private static final String ORGANIZATIONNAME = "Unknown";
    private static final String ORGANIZATION = "organization";
    private static final String NAME = "name";
    private static final String DN = "dn";
    private static final String DESCRIPTION = "description";
    private static final String PASSWORD = "password";
    private static final String SLASH = "/";
    private static final String AT = "@";
    private static final String SUBJECTS = "subjects";
    private static final String USERS = "users";
    private static final String USER = "user";
    private static final String GROUPS = "groups";
    private static final String GROUP = "group";
    private static final String EMAIL = "email";
    private static final String SURNAME = "surName";
    private static final String GIVENNAME = "givenName";
    private static final String MEMBEROF = "memberof";
    private static final String INITCONTENT = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<subjects>\n<users>\n</users>\n<groups>\n</groups>\n</subjects>\n";
    private static Log log = LogFactory.getLog(AuthFile.class);
    private static XMLConfiguration userpassword = null;
    private String authURI = null;
    private static String passwordFilePath = null;
    private static AuthFileHashInterface hashClass = null;
    private boolean readPathFromProperty = true;

    public AuthFile() throws AuthenticationException {
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AuthenticationException(e.getMessage());
        }
    }

    public AuthFile(String passwordFile) throws AuthenticationException {
        passwordFilePath = passwordFile;
        this.readPathFromProperty = false;
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AuthenticationException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws PropertyNotFoundException, IOException, ConfigurationException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (this.readPathFromProperty || passwordFilePath == null) {
            passwordFilePath = PropertyService.getProperty("auth.file.path");
        }
        File passwordFile = new File(passwordFilePath);
        this.authURI = SystemUtil.getContextURL();
        String hashClassName = PropertyService.getProperty("auth.file.hashClassName");
        Class<?> classDefinition = Class.forName(hashClassName);
        Object object = classDefinition.newInstance();
        hashClass = (AuthFileHashInterface)object;
        if (!passwordFile.exists()) {
            boolean success;
            File parent = passwordFile.getParentFile();
            if (!parent.exists()) {
                success = false;
                try {
                    success = parent.mkdirs();
                }
                catch (Exception e) {
                    throw new IOException("AuthFile.init - couldn't create the directory " + parent.getAbsolutePath() + " since " + e.getMessage());
                }
                if (!success) {
                    throw new IOException("AuthFile.init - couldn't create the directory " + parent.getAbsolutePath() + ", probably since the metacat doesn't have the write permission.");
                }
            }
            success = false;
            try {
                success = passwordFile.createNewFile();
            }
            catch (Exception e) {
                throw new IOException("AuthFile.init - couldn't create the file " + passwordFile.getAbsolutePath() + " since " + e.getMessage());
            }
            if (!success) {
                throw new IOException("AuthFile.init - couldn't create the file " + parent.getAbsolutePath() + ", probably since the metacat doesn't have the write permission.");
            }
            OutputStreamWriter writer = null;
            FileOutputStream output = null;
            try {
                output = new FileOutputStream(passwordFile);
                writer = new OutputStreamWriter((OutputStream)output, "UTF-8");
                writer.write(INITCONTENT);
            }
            finally {
                writer.close();
                output.close();
            }
        }
        userpassword = new XMLConfiguration(passwordFile);
        userpassword.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        userpassword.setAutoSave(true);
        userpassword.setDelimiterParsingDisabled(true);
        userpassword.setAttributeSplittingDisabled(true);
    }

    @Override
    public boolean authenticate(String user, String password) throws AuthenticationException {
        boolean match = false;
        String passwordRecord = userpassword.getString("users/user[@dn='" + user + "']" + SLASH + PASSWORD);
        if (passwordRecord != null) {
            try {
                match = hashClass.match(password, passwordRecord);
            }
            catch (Exception e) {
                throw new AuthenticationException(e.getMessage());
            }
        }
        return match;
    }

    @Override
    public String[][] getUsers(String user, String password) throws ConnectException {
        List users = userpassword.getList("users/user/@dn");
        if (users != null && users.size() > 0) {
            String[][] usersArray = new String[users.size()][5];
            for (int i = 0; i < users.size(); ++i) {
                String dn;
                usersArray[i][0] = dn = (String)users.get(i);
                String[] userInfo = this.getUserInfo(dn, password);
                usersArray[i][1] = userInfo[0];
                usersArray[i][2] = userInfo[1];
                usersArray[i][3] = null;
                usersArray[i][4] = userInfo[2];
            }
            return usersArray;
        }
        return null;
    }

    @Override
    public String[] getUserInfo(String user, String password) throws ConnectException {
        String[] userinfo = new String[3];
        User aUser = new User();
        aUser.setDN(user);
        String surname = null;
        List surNames = userpassword.getList("users/user[@dn='" + user + "']" + SLASH + SURNAME);
        if (surNames != null && !surNames.isEmpty()) {
            surname = (String)surNames.get(0);
        }
        aUser.setSurName(surname);
        String givenName = null;
        List givenNames = userpassword.getList("users/user[@dn='" + user + "']" + SLASH + GIVENNAME);
        if (givenNames != null && !givenNames.isEmpty()) {
            givenName = (String)givenNames.get(0);
        }
        aUser.setGivenName(givenName);
        userinfo[0] = aUser.getCn();
        String organization = null;
        List organizations = userpassword.getList("users/user[@dn='" + user + "']" + SLASH + ORGANIZATION);
        if (organizations != null && !organizations.isEmpty()) {
            organization = (String)organizations.get(0);
        }
        userinfo[1] = organization;
        aUser.setOrganization(organization);
        List emails = userpassword.getList("users/user[@dn='" + user + "']" + SLASH + EMAIL);
        String email = null;
        if (emails != null && !emails.isEmpty()) {
            email = (String)emails.get(0);
        }
        aUser.setEmail(email);
        userinfo[2] = email;
        return userinfo;
    }

    @Override
    public String[] getUsers(String user, String password, String group) throws ConnectException {
        List users = userpassword.getList("users/user[memberof='" + group + "']" + SLASH + AT + DN);
        if (users != null && users.size() > 0) {
            String[] usersArray = new String[users.size()];
            for (int i = 0; i < users.size(); ++i) {
                usersArray[i] = (String)users.get(i);
            }
            return usersArray;
        }
        return null;
    }

    @Override
    public String[][] getGroups(String user, String password) throws ConnectException {
        List groups = userpassword.getList("groups/group/@name");
        if (groups != null && groups.size() > 0) {
            String[][] groupsArray = new String[groups.size()][2];
            for (int i = 0; i < groups.size(); ++i) {
                String groupName;
                groupsArray[i][0] = groupName = (String)groups.get(i);
                String description = null;
                List descriptions = userpassword.getList("groups/group[@name='" + groupName + "']" + SLASH + DESCRIPTION);
                if (descriptions != null && !descriptions.isEmpty()) {
                    description = (String)descriptions.get(0);
                }
                groupsArray[i][1] = description;
            }
            return groupsArray;
        }
        return null;
    }

    @Override
    public String[][] getGroups(String user, String password, String foruser) throws ConnectException {
        List groups = userpassword.getList("users/user[@dn='" + foruser + "']" + SLASH + MEMBEROF);
        if (groups != null && groups.size() > 0) {
            String[][] groupsArray = new String[groups.size()][2];
            for (int i = 0; i < groups.size(); ++i) {
                String groupName;
                groupsArray[i][0] = groupName = (String)groups.get(i);
                String description = null;
                List descriptions = userpassword.getList("groups/group[@name='" + groupName + "']" + SLASH + DESCRIPTION);
                if (descriptions != null && !descriptions.isEmpty()) {
                    description = (String)descriptions.get(0);
                }
                groupsArray[i][1] = description;
            }
            return groupsArray;
        }
        return null;
    }

    @Override
    public HashMap<String, Vector<String>> getAttributes(String foruser) throws ConnectException {
        if (!this.userExists(foruser)) {
            throw new ConnectException("NameNotFoundException - the user " + foruser + " doesn't exist in the password file.");
        }
        return null;
    }

    @Override
    public HashMap<String, Vector<String>> getAttributes(String user, String password, String foruser) throws ConnectException {
        return null;
    }

    @Override
    public String getPrincipals(String user, String password) throws ConnectException {
        StringBuffer out = new StringBuffer();
        out.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        out.append("<principals>\n");
        out.append("  <authSystem URI=\"" + this.authURI + "\" organization=\"" + ORGANIZATIONNAME + "\">\n");
        String[][] groups = this.getGroups(user, password);
        String[][] users = this.getUsers(user, password);
        int userIndex = 0;
        if (groups != null && users != null && groups.length > 0) {
            for (int i = 0; i < groups.length; ++i) {
                String[] usersForGroup;
                out.append("    <group>\n");
                out.append("      <groupname>" + groups[i][0] + "</groupname>\n");
                if (groups[i].length > 1) {
                    out.append("      <description>" + groups[i][1] + "</description>\n");
                }
                if ((usersForGroup = this.getUsers(user, password, groups[i][0])) != null) {
                    for (int j = 0; j < usersForGroup.length; ++j) {
                        userIndex = AuthLdap.searchUser(usersForGroup[j], users);
                        out.append("      <user>\n");
                        if (userIndex < 0) {
                            out.append("        <username>" + usersForGroup[j] + "</username>\n");
                        } else {
                            out.append("        <username>" + users[userIndex][0] + "</username>\n");
                            if (users[userIndex][1] != null) {
                                out.append("        <name>" + users[userIndex][1] + "</name>\n");
                            }
                            if (users[userIndex][2] != null) {
                                out.append("        <organization>" + users[userIndex][2] + "</organization>\n");
                            }
                            if (users[userIndex][3] != null) {
                                out.append("      <organizationUnitName>" + users[userIndex][3] + "</organizationUnitName>\n");
                            }
                            if (users[userIndex][4] != null) {
                                out.append("        <email>" + users[userIndex][4] + "</email>\n");
                            }
                        }
                        out.append("      </user>\n");
                    }
                }
                out.append("    </group>\n");
            }
        }
        if (users != null) {
            for (int j = 0; j < users.length; ++j) {
                out.append("    <user>\n");
                out.append("      <username>" + users[j][0] + "</username>\n");
                if (users[j][1] != null) {
                    out.append("        <name>" + users[j][1] + "</name>\n");
                }
                if (users[j][2] != null) {
                    out.append("        <organization>" + users[j][2] + "</organization>\n");
                }
                if (users[j][3] != null) {
                    out.append("      <organizationUnitName>" + users[j][3] + "</organizationUnitName>\n");
                }
                if (users[j][4] != null) {
                    out.append("        <email>" + users[j][4] + "</email>\n");
                }
                out.append("    </user>\n");
            }
        }
        out.append("  </authSystem>\n");
        out.append("</principals>");
        return out.toString();
    }

    public void addUser(String dn, String[] groups, String plainPass, String hashedPass, String email, String surName, String givenName, String organization) throws AuthenticationException {
        User user = new User();
        user.setDN(dn);
        user.setGroups(groups);
        user.setPlainPass(plainPass);
        user.setHashedPass(hashedPass);
        user.setEmail(email);
        user.setSurName(surName);
        user.setGivenName(givenName);
        user.setOrganization(organization);
        user.serialize();
    }

    public void addGroup(String groupName, String description) throws AuthenticationException {
        if (groupName == null || groupName.trim().equals("")) {
            throw new AuthenticationException("AuthFile.addGroup - can't add a group whose name is null or blank.");
        }
        if (!this.groupExists(groupName)) {
            if (userpassword != null) {
                userpassword.addProperty("groups group@name", (Object)groupName);
                if (description != null && !description.trim().equals("")) {
                    userpassword.addProperty("groups/group[@name='" + groupName + "']" + " " + DESCRIPTION, (Object)description);
                }
            }
        } else {
            throw new AuthenticationException("AuthFile.addGroup - can't add the group " + groupName + " since it already exists.");
        }
    }

    public void modifyPassWithHash(String userName, String newHashPassword) throws AuthenticationException {
        User user = new User();
        user.setDN(userName);
        user.modifyHashPass(newHashPassword);
    }

    public void modifyPassWithPlain(String userName, String newPlainPassword) throws AuthenticationException {
        User user = new User();
        user.setDN(userName);
        user.modifyPlainPass(newPlainPassword);
    }

    public void addUserToGroup(String userName, String group) throws AuthenticationException {
        User user = new User();
        user.setDN(userName);
        user.addToGroup(group);
    }

    public void removeUserFromGroup(String userName, String group) throws AuthenticationException {
        User user = new User();
        user.setDN(userName);
        user.removeFromGroup(group);
    }

    private synchronized boolean userExists(String userName) throws AuthenticationException {
        if (userName == null || userName.trim().equals("")) {
            throw new AuthenticationException("AuthFile.userExist - can't judge if a user exists when its name is null or blank.");
        }
        List users = userpassword.getList("users/user/@dn");
        return users != null && users.contains(userName);
    }

    private synchronized boolean groupExists(String groupName) throws AuthenticationException {
        if (groupName == null || groupName.trim().equals("")) {
            throw new AuthenticationException("AuthFile.groupExist - can't judge if a group exists when its name is null or blank.");
        }
        List groups = userpassword.getList("groups/group/@name");
        return groups != null && groups.contains(groupName);
    }

    private static String encrypt(String plain) {
        return hashClass.hash(plain);
    }

    public static void main(String[] argus) throws Exception {
        String USERADD = "useradd";
        String USERMOD = "usermod";
        String GROUPADD = "groupadd";
        String USAGE = "usage";
        if (argus == null || argus.length == 0) {
            System.out.println("Please make sure that there are two arguments - \"$BASE_WEB_INF\" and\" $@\" after the class name edu.ucsb.nceas.metacat.authentication.AuthFile in the script file.");
            System.exit(1);
        } else if (argus.length == 1) {
            AuthFile.printUsage();
            System.exit(1);
        }
        PropertyService.getInstance(argus[0]);
        AuthFile authFile = new AuthFile();
        if (argus[1] != null && argus[1].equals(GROUPADD)) {
            AuthFile.handleGroupAdd(authFile, argus);
        } else if (argus[1] != null && argus[1].equals(USERADD)) {
            AuthFile.handleUserAdd(authFile, argus);
        } else if (argus[1] != null && argus[1].equals(USERMOD)) {
            AuthFile.handleUserMod(authFile, argus);
        } else if (argus[1] != null && argus[1].equals(USAGE)) {
            AuthFile.printUsage();
        } else {
            System.out.print("Error: the unknown action " + argus[1]);
        }
    }

    private static void handleGroupAdd(AuthFile authFile, String[] argus) throws AuthenticationException {
        HashMap<String, String> map = null;
        String G = "-g";
        String D = "-d";
        Vector<String> pairedOptions = new Vector<String>();
        pairedOptions.add(G);
        pairedOptions.add(D);
        int startIndex = 2;
        try {
            map = AuthFile.parseArgus(startIndex, argus, pairedOptions, null);
        }
        catch (Exception e) {
            System.out.println("Error in the groupadd command: " + e.getMessage());
            System.exit(1);
        }
        String groupName = null;
        String description = null;
        if (map.keySet().size() == 0) {
            System.out.println("Error in the groupadd command: the \"" + G + " group-name\" is required.");
            System.exit(1);
        } else if (map.keySet().size() == 1 || map.keySet().size() == 2) {
            groupName = map.get(G);
            if (groupName == null || groupName.trim().equals("")) {
                System.out.println("Error in the groupadd command : the \"" + G + " group-name\" is required.");
                System.exit(1);
            }
            description = map.get(D);
            authFile.addGroup(groupName, description);
            System.out.println("Successfully added a group \"" + groupName + "\" to the file authentication system");
        } else {
            AuthFile.printError(argus);
            System.exit(1);
        }
    }

    private static void handleUserAdd(AuthFile authFile, String[] argus) throws UnsupportedEncodingException, AuthenticationException {
        String I = "-i";
        String H = "-h";
        String DN = "-dn";
        String G = "-g";
        String E = "-e";
        String S = "-s";
        String F = "-f";
        String O = "-o";
        Vector<String> pairedOptions = new Vector<String>();
        pairedOptions.add(H);
        pairedOptions.add(DN);
        pairedOptions.add(G);
        pairedOptions.add(E);
        pairedOptions.add(S);
        pairedOptions.add(F);
        pairedOptions.add(O);
        Vector<String> singleOptions = new Vector<String>();
        singleOptions.add(I);
        HashMap<Object, Object> map = new HashMap();
        int startIndex = 2;
        try {
            map = AuthFile.parseArgus(startIndex, argus, pairedOptions, singleOptions);
        }
        catch (Exception e) {
            System.out.println("Error in the useradd command: " + e.getMessage());
            System.exit(1);
        }
        String dn = (String)map.get(DN);
        if (dn == null || dn.trim().equals("")) {
            System.out.println("The \"-dn user-distinguish-name\" is requried in the useradd command .");
            System.exit(1);
        }
        String plainPassword = null;
        String hashedPassword = null;
        String input = (String)map.get(I);
        String passHash = (String)map.get(H);
        if (input != null && passHash != null) {
            System.out.println("Error in the useradd command: you only can choose either \"-i\" (input a password) or \"-h hashed-password\" (pass through a hashed passwword).");
            System.exit(1);
        } else if (input == null && passHash == null) {
            System.out.println("Error in the useradd command: you must choose either \"-i\" (input a password) or \"-h hashed-password\" (pass through a hashed password).");
            System.exit(1);
        } else if (input != null) {
            plainPassword = AuthFile.inputPassword();
        } else if (passHash != null) {
            hashedPassword = passHash;
        }
        String group = (String)map.get(G);
        String[] groups = null;
        if (group != null && !group.trim().equals("")) {
            groups = new String[]{group};
        }
        String email = (String)map.get(E);
        String surname = (String)map.get(S);
        String givenname = (String)map.get(F);
        String organization = (String)map.get(O);
        authFile.addUser(dn, groups, plainPassword, hashedPassword, email, surname, givenname, organization);
        System.out.println("Successfully added a user \"" + dn + "\" to the file authentication system ");
    }

    private static void handleUserMod(AuthFile authFile, String[] argus) throws AuthenticationException, UnsupportedEncodingException {
        String PASSWORD = "-password";
        String GROUP = "-group";
        if (argus.length < 3) {
            System.out.println("Error: the sub action \"-password\" or \"-group\" should follow the action \"usermod\"");
            System.exit(1);
        } else if (argus[2] != null && argus[2].equals(PASSWORD)) {
            AuthFile.handleModifyPass(authFile, argus);
        } else if (argus[2] != null && argus[2].equals(GROUP)) {
            AuthFile.handleModifyGroup(authFile, argus);
        } else {
            System.out.println("Error: the sub action \"" + argus[2] + "\" is unkown in the action \"usermod\"");
            System.exit(1);
        }
    }

    private static void handleModifyPass(AuthFile authFile, String[] argus) throws UnsupportedEncodingException, AuthenticationException {
        String DN = "-dn";
        String I = "-i";
        String H = "-h";
        Vector<String> pairedOptions = new Vector<String>();
        pairedOptions.add(H);
        pairedOptions.add(DN);
        Vector<String> singleOptions = new Vector<String>();
        singleOptions.add(I);
        HashMap<Object, Object> map = new HashMap();
        int startIndex = 3;
        try {
            map = AuthFile.parseArgus(startIndex, argus, pairedOptions, singleOptions);
        }
        catch (Exception e) {
            System.out.println("Error in the usermod -password command: " + e.getMessage());
            System.exit(1);
        }
        String dn = (String)map.get(DN);
        if (dn == null || dn.trim().equals("")) {
            System.out.println("Error in the usermod -password command: The \"-dn user-distinguish-name\" is requried.");
            System.exit(1);
        }
        String plainPassword = null;
        String hashedPassword = null;
        String input = (String)map.get(I);
        String passHash = (String)map.get(H);
        if (input != null && passHash != null) {
            System.out.println("Error in the usermod -password command: you only can choose either \"-i\" (input a password) or \"-h hashed-password\" (pass through a hashed password).");
            System.exit(1);
        } else if (input == null && passHash == null) {
            System.out.println("Error in the usermod -password command: you must choose either \"-i\" (input a password) or \"-h hashed-password\" (pass through a hashed password).");
            System.exit(1);
        } else if (input != null) {
            plainPassword = AuthFile.inputPassword();
            authFile.modifyPassWithPlain(dn, plainPassword);
            System.out.println("Successfully modified the password for the user \"" + dn + "\".");
        } else if (passHash != null) {
            hashedPassword = passHash;
            authFile.modifyPassWithHash(dn, hashedPassword);
            System.out.println("Successfully modified the password for the user " + dn + "\".");
        }
    }

    private static void handleModifyGroup(AuthFile authFile, String[] argus) throws AuthenticationException {
        String DN = "-dn";
        String A = "-a";
        String R = "-r";
        String G = "-g";
        Vector<String> pairedOptions = new Vector<String>();
        pairedOptions.add(G);
        pairedOptions.add(DN);
        Vector<String> singleOptions = new Vector<String>();
        singleOptions.add(A);
        singleOptions.add(R);
        HashMap<Object, Object> map = new HashMap();
        int startIndex = 3;
        try {
            map = AuthFile.parseArgus(startIndex, argus, pairedOptions, singleOptions);
        }
        catch (Exception e) {
            System.out.println("Error in the usermod -group command: " + e.getMessage());
            System.exit(1);
        }
        String add = (String)map.get(A);
        String remove = (String)map.get(R);
        String group = (String)map.get(G);
        String dn = (String)map.get(DN);
        if (dn == null || dn.trim().equals("")) {
            System.out.println("Error in the usermod -group command: the \"-dn user-distinguish-name\" is required.");
            System.exit(1);
        }
        if (group == null || group.trim().equals("")) {
            System.out.println("Error in the usermod -group command: the \"-g group-name\" is required.");
            System.exit(1);
        }
        if (add != null && remove != null) {
            System.out.println("Error in the usermod -group command: You can only choose either \"-a\" (add the user to the group) or \"-r\" (remove the user from the group).");
            System.exit(1);
        } else if (add == null && remove == null) {
            System.out.println("Error in the usermod -group command: You must choose either \"-a\" (add the user to the group) or \"-r\" (remove the user from the group).");
            System.exit(1);
        } else if (remove != null) {
            authFile.removeUserFromGroup(dn, group);
            System.out.println("Successfully removed the user " + dn + " from the group \"" + group + "\".");
        } else {
            authFile.addUserToGroup(dn, group);
            System.out.println("Successfully added the user " + dn + " to the group \"" + group + "\".");
        }
    }

    private static HashMap<String, String> parseArgus(int startIndex, String[] argus, Vector<String> pairedOptions, Vector<String> singleOptions) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        if (argus != null) {
            for (int i = startIndex; i < argus.length; ++i) {
                String arg = argus[i];
                if (map.containsKey(arg)) {
                    throw new Exception("The command line can't have duplicate options \"" + arg + "\".");
                }
                if (singleOptions != null && singleOptions.contains(arg)) {
                    if (i == argus.length - 1) {
                        map.put(arg, arg);
                        continue;
                    }
                    if (i >= argus.length - 1) continue;
                    if (pairedOptions != null && pairedOptions.contains(argus[i + 1]) || singleOptions.contains(argus[i + 1])) {
                        map.put(arg, arg);
                        continue;
                    }
                    throw new Exception("The option \"" + arg + "\" shouldn't be followed any value, e.g. " + argus[i + 1] + ".");
                }
                if (pairedOptions != null && pairedOptions.contains(arg)) {
                    if (i == argus.length - 1) {
                        throw new Exception("The option \"" + arg + "\" must be followed by a value");
                    }
                    if (!(pairedOptions.contains(argus[i + 1]) || singleOptions != null && singleOptions.contains(argus[i + 1]))) {
                        map.put(arg, argus[i + 1]);
                        continue;
                    }
                    throw new Exception("The option \"" + arg + "\" shouldn't be followed the option \"" + argus[i + 1] + "\". It should be followed by a value.");
                }
                if (pairedOptions != null && pairedOptions.contains(argus[i - 1])) continue;
                throw new Exception("The \"" + arg + "\" is an illegal argument");
            }
        }
        return map;
    }

    private static String inputPassword() throws UnsupportedEncodingException {
        String password1;
        String password = null;
        String quit = "q";
        Console console = System.console();
        if (console == null) {
            System.out.println("Sorry, we can't fetch the console from the system. You can't use the option \"-i\" to input a password. You have to use the option \"-h hashed-password\" to pass through a hashed passwprd in the useradd command. ");
            System.exit(1);
        }
        while (true) {
            System.out.print("Enter your new password (input 'q' to quit): ");
            password1 = new String(console.readPassword());
            if (password1 == null || password1.trim().equals("")) {
                System.out.println("Error: the password can't be blank or null. Please try again.");
                continue;
            }
            if (password1.equals(quit)) {
                System.exit(0);
            }
            System.out.print("Confirm your new password (input 'q' to quit): ");
            String password2 = new String(console.readPassword());
            if (password2 == null || password2.trim().equals("")) {
                System.out.println("Error: the password can't be blank or null. Please try again.");
                continue;
            }
            if (password2.equals(quit)) {
                System.exit(0);
            }
            if (password1.equals(password2)) break;
            System.out.println("Error: The second password does't match the first one. Please try again.");
        }
        password = password1;
        return password;
    }

    private static void printUsage() {
        System.out.println("Usage:\n./authFileManager.sh useradd -i -dn <user-distinguish-name> [-g <group-name> -e <email-address> -s <surname> -f <given-name> -o <organizationName>]\n./authFileManager.sh useradd -h <hashed-password> -dn <user-distinguish-name> [-g <group-name> -e <email-address> -s <surname> -f <given-name> -o <organizationName>]\n./authFileManager.sh groupadd -g group-name [-d description]\n./authFileManager.sh usermod -password -dn <user-distinguish-name> -i\n./authFileManager.sh usermod -password -dn <user-distinguish-name> -h <new-hashed-password>\n./authFileManager.sh usermod -group -a -dn <user-distinguish-name> -g <added-group-name>\n./authFileManager.sh usermod -group -r -dn <user-distinguish-name> -g <removed-group-name>\nNote:\n1. Metacat currently uses Bcrypt algorithm to hash the password. The hashed password following the \"-h\" should be generated by a Bcrypt algorithm.\n  The hash string usually has $ signs which can interfere with the command line arguments. You should use two SINGLE quotes to wrap the entire hashed string.\n2. The user-distinguish-name must look like \"uid=john,o=something,dc=something,dc=something\" and the group-name must look like \"cn=dev,o=something,dc=something,dc=something\".\n3. if a value of an option has spaces, the value should be enclosed by the double quotes.\n  For example: ./authFileManager.sh groupadd -g cn=dev,o=something,dc=something,dc=something -d \"Developers at NCEAS\"\n4. \"-d description\" in the \"groupadd\" command is optional; \"-g groupname -e email-address -s surname -f given-name -o organizationName\" in the \"useradd\" command are optional as well.");
    }

    private static void printError(String[] argus) {
        if (argus != null) {
            System.out.println("Error: it is an illegal command (probably with some illegal options): ");
            for (int i = 0; i < argus.length; ++i) {
                if (i == 0) continue;
                System.out.print(argus[i] + " ");
            }
            System.out.println("");
        }
    }

    private class User {
        private String dn = null;
        private String plainPass = null;
        private String hashedPass = null;
        private String email = null;
        private String surName = null;
        private String givenName = null;
        private String cn = null;
        private String[] groups = null;
        private String organization = null;

        private User() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public void setOrganization(String organization) {
            this.organization = organization;
        }

        public String getDN() {
            return this.dn;
        }

        public void setDN(String dn) {
            this.dn = dn;
        }

        public String getPlainPass() {
            return this.plainPass;
        }

        public void setPlainPass(String plainPass) {
            this.plainPass = plainPass;
        }

        public String getHashedPass() {
            return this.hashedPass;
        }

        public void setHashedPass(String hashedPass) {
            this.hashedPass = hashedPass;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getSurName() {
            return this.surName;
        }

        public void setSurName(String surName) {
            this.surName = surName;
        }

        public String getGivenName() {
            return this.givenName;
        }

        public void setGivenName(String givenName) {
            this.givenName = givenName;
        }

        public String getCn() {
            if (this.cn != null) {
                return this.cn;
            }
            if (this.givenName != null && this.surName != null) {
                return this.givenName + " " + this.surName;
            }
            if (this.givenName != null) {
                return this.givenName;
            }
            if (this.surName != null) {
                return this.surName;
            }
            return null;
        }

        public void setCn(String cn) {
            this.cn = cn;
        }

        public String[] getGroups() {
            return this.groups;
        }

        public void setGroups(String[] groups) {
            this.groups = groups;
        }

        public void addToGroup(String group) throws AuthenticationException {
            if (group == null || group.trim().equals("")) {
                throw new IllegalArgumentException("AuthFile.User.addToGroup - the group can't be null or blank");
            }
            if (!AuthFile.this.userExists(this.dn)) {
                throw new AuthenticationException("AuthFile.User.addUserToGroup - the user " + this.dn + " doesn't exist.");
            }
            if (!AuthFile.this.groupExists(group)) {
                throw new AuthenticationException("AuthFile.User.addUserToGroup - the group " + group + " doesn't exist.");
            }
            List existingGroups = userpassword.getList("users/user[@dn='" + this.dn + "']" + AuthFile.SLASH + AuthFile.MEMBEROF);
            if (existingGroups != null && existingGroups.contains(group)) {
                throw new AuthenticationException("AuthFile.User.addUserToGroup - the user " + this.dn + " already is the memember of the group " + group);
            }
            userpassword.addProperty("users/user[@dn='" + this.dn + "']" + " " + AuthFile.MEMBEROF, (Object)group);
            if (this.groups == null) {
                if (existingGroups == null || existingGroups.isEmpty()) {
                    this.groups = new String[1];
                    this.groups[0] = group;
                } else {
                    this.groups = new String[existingGroups.size() + 1];
                    for (int i = 0; i < existingGroups.size(); ++i) {
                        this.groups[i] = (String)existingGroups.get(i);
                    }
                    this.groups[existingGroups.size()] = group;
                }
            } else {
                String[] oldGroups = this.groups;
                this.groups = new String[oldGroups.length + 1];
                for (int i = 0; i < oldGroups.length; ++i) {
                    this.groups[i] = oldGroups[i];
                }
                this.groups[oldGroups.length] = group;
            }
        }

        public void removeFromGroup(String group) throws AuthenticationException {
            if (!AuthFile.this.userExists(this.dn)) {
                throw new AuthenticationException("AuthFile.User.removeUserFromGroup - the user " + this.dn + " doesn't exist.");
            }
            if (!AuthFile.this.groupExists(group)) {
                throw new AuthenticationException("AuthFile.User.removeUserFromGroup - the group " + group + " doesn't exist.");
            }
            String key = "users/user[@dn='" + this.dn + "']" + AuthFile.SLASH + AuthFile.MEMBEROF;
            List existingGroups = userpassword.getList(key);
            if (!existingGroups.contains(group)) {
                throw new AuthenticationException("AuthFile.User.removeUserFromGroup - the user " + this.dn + " isn't the memember of the group " + group);
            }
            userpassword.clearProperty(key + "[.='" + group + "']");
            if (this.groups != null) {
                boolean contains = false;
                for (int i = 0; i < this.groups.length; ++i) {
                    if (!this.groups[i].equals(group)) continue;
                    contains = true;
                    break;
                }
                String[] newGroups = new String[this.groups.length - 1];
                int k = 0;
                for (int i = 0; i < this.groups.length; ++i) {
                    if (this.groups[i].equals(group)) continue;
                    newGroups[k] = this.groups[i];
                    ++k;
                }
                this.groups = newGroups;
            }
        }

        public void modifyHashPass(String hashPass) throws AuthenticationException {
            if (hashPass == null || hashPass.trim().equals("")) {
                throw new AuthenticationException("AuthFile.User.modifyHashPass - can't change the password to the null or blank.");
            }
            if (!AuthFile.this.userExists(this.dn)) {
                throw new AuthenticationException("AuthFile.User.modifyHashPass - can't change the password for the user " + this.dn + " since it doesn't eixt.");
            }
            userpassword.setProperty("users/user[@dn='" + this.dn + "']" + AuthFile.SLASH + AuthFile.PASSWORD, (Object)hashPass);
            this.setHashedPass(hashPass);
        }

        public void modifyPlainPass(String plainPass) throws AuthenticationException {
            if (plainPass == null || plainPass.trim().equals("")) {
                throw new AuthenticationException("AuthFile.User.modifyPlainPass - can't change the password to the null or blank.");
            }
            if (!AuthFile.this.userExists(this.dn)) {
                throw new AuthenticationException("AuthFile.User.modifyPlainPass - can't change the password for the user " + this.dn + " since it doesn't eixt.");
            }
            String hashPassword = null;
            try {
                hashPassword = AuthFile.encrypt(plainPass);
            }
            catch (Exception e) {
                throw new AuthenticationException("AuthFile.User.modifyPlainPass - can't encript the password since " + e.getMessage());
            }
            userpassword.setProperty("users/user[@dn='" + this.dn + "']" + AuthFile.SLASH + AuthFile.PASSWORD, (Object)hashPassword);
            this.setPlainPass(plainPass);
        }

        public void serialize() throws AuthenticationException {
            String group;
            int i;
            if (this.dn == null || this.dn.trim().equals("")) {
                throw new AuthenticationException("AuthFile.User.serialize - can't add a user whose name is null or blank.");
            }
            if (this.hashedPass == null || this.hashedPass.trim().equals("")) {
                if (this.plainPass == null || this.plainPass.trim().equals("")) {
                    throw new AuthenticationException("AuthFile.User.serialize - can't add a user whose password is null or blank.");
                }
                try {
                    this.hashedPass = AuthFile.encrypt(this.plainPass);
                }
                catch (Exception e) {
                    throw new AuthenticationException("AuthFile.User.serialize - can't encript the password since " + e.getMessage());
                }
            }
            if (this.groups != null) {
                for (i = 0; i < this.groups.length; ++i) {
                    group = this.groups[i];
                    if (group == null || group.trim().equals("") || AuthFile.this.groupExists(group)) continue;
                    throw new AuthenticationException("AuthFile.User.serialize - can't put the user into a non-existing group " + group);
                }
            }
            if (!AuthFile.this.userExists(this.dn)) {
                if (userpassword != null) {
                    userpassword.addProperty("users user@dn", (Object)this.dn);
                    userpassword.addProperty("users/user[@dn='" + this.dn + "']" + " " + AuthFile.PASSWORD, (Object)this.hashedPass);
                    if (this.email != null && !this.email.trim().equals("")) {
                        userpassword.addProperty("users/user[@dn='" + this.dn + "']" + " " + AuthFile.EMAIL, (Object)this.email);
                    }
                    if (this.surName != null && !this.surName.trim().equals("")) {
                        userpassword.addProperty("users/user[@dn='" + this.dn + "']" + " " + AuthFile.SURNAME, (Object)this.surName);
                    }
                    if (this.givenName != null && !this.givenName.trim().equals("")) {
                        userpassword.addProperty("users/user[@dn='" + this.dn + "']" + " " + AuthFile.GIVENNAME, (Object)this.givenName);
                    }
                    if (this.organization != null && !this.organization.trim().equals("")) {
                        userpassword.addProperty("users/user[@dn='" + this.dn + "']" + " " + AuthFile.ORGANIZATION, (Object)this.organization);
                    }
                    if (this.groups != null) {
                        for (i = 0; i < this.groups.length; ++i) {
                            group = this.groups[i];
                            if (group == null || group.trim().equals("") || !AuthFile.this.groupExists(group)) continue;
                            userpassword.addProperty("users/user[@dn='" + this.dn + "']" + " " + AuthFile.MEMBEROF, (Object)group);
                        }
                    }
                }
            } else {
                throw new AuthenticationException("AuthFile.User.serialize - can't add the user " + this.dn + " since it already exists.");
            }
        }
    }
}

