/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.index;

import edu.ucsb.nceas.metacat.DBTransform;
import edu.ucsb.nceas.metacat.EventLog;
import edu.ucsb.nceas.metacat.common.index.IndexTask;
import edu.ucsb.nceas.metacat.common.query.SolrQueryService;
import edu.ucsb.nceas.metacat.common.query.SolrQueryServiceController;
import edu.ucsb.nceas.metacat.common.query.stream.ContentTypeByteArrayInputStream;
import edu.ucsb.nceas.metacat.dataone.hazelcast.HazelcastService;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.MultiMapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.servlet.SolrRequestParsers;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.UnsupportedType;
import org.dataone.service.types.v1.Event;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v2.SystemMetadata;
import org.xml.sax.SAXException;

public class MetacatSolrIndex {
    private static Log log = LogFactory.getLog(MetacatSolrIndex.class);
    private static MetacatSolrIndex solrIndex = null;

    public static MetacatSolrIndex getInstance() throws Exception {
        if (solrIndex == null) {
            solrIndex = new MetacatSolrIndex();
        }
        return solrIndex;
    }

    private MetacatSolrIndex() throws Exception {
    }

    public InputStream query(String query, Set<Subject> authorizedSubjects) throws SolrServerException, IOException, PropertyNotFoundException, SQLException, ClassNotFoundException, ParserConfigurationException, SAXException, NotImplemented, NotFound, UnsupportedType {
        if (authorizedSubjects == null || authorizedSubjects.isEmpty()) {
            throw new SolrServerException("MetacatSolrIndex.query - There is no any authorized subjects(even the public user) in this query session.");
        }
        InputStream inputStream = null;
        MultiMapSolrParams solrParams = SolrRequestParsers.parseQueryString((String)(query = query.replaceAll("\\+", "%2B")));
        String wt = solrParams.get("wt");
        if (SolrQueryService.isSupportedWT((String)wt)) {
            inputStream = SolrQueryServiceController.getInstance().query((SolrParams)solrParams, authorizedSubjects);
        } else {
            String qformat = wt;
            wt = "xml";
            ModifiableSolrParams msp = new ModifiableSolrParams((SolrParams)solrParams);
            msp.set("wt", new String[]{wt});
            inputStream = SolrQueryServiceController.getInstance().query((SolrParams)msp, authorizedSubjects);
            DBTransform transformer = new DBTransform();
            String documentContent = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
            String sourceType = "solr";
            String targetType = "-//W3C//HTML//EN";
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, "UTF-8");
            Hashtable<String, String[]> params = new Hashtable<String, String[]>();
            params.put("qformat", new String[]{qformat});
            transformer.transformXMLDocument(documentContent, sourceType, targetType, qformat, writer, params, null);
            inputStream = new ContentTypeByteArrayInputStream(baos.toByteArray());
            ((ContentTypeByteArrayInputStream)inputStream).setContentType("text/html");
        }
        return inputStream;
    }

    public void submit(Identifier pid, SystemMetadata systemMetadata, Map<String, List<Object>> fields, boolean followRevisions) {
        IndexTask task = new IndexTask();
        task.setSystemMetadata(systemMetadata);
        task.setFields(fields);
        if (pid != null) {
            log.debug((Object)("MetacatSolrIndex.submit - will put the pid " + pid.getValue() + " into the index queue on hazelcast service."));
        }
        HazelcastService.getInstance().getIndexQueue().put((Object)pid, (Object)task);
        if (pid != null) {
            log.info((Object)("MetacatSolrIndex.submit - put the pid " + pid.getValue() + " into the index queue on hazelcast service successfully."));
        }
        if (followRevisions && systemMetadata != null && systemMetadata.getObsoletes() != null) {
            Identifier obsoletedPid = systemMetadata.getObsoletes();
            SystemMetadata obsoletedSysMeta = (SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)obsoletedPid);
            Map<String, List<Object>> obsoletedFields = EventLog.getInstance().getIndexFields(obsoletedPid, Event.READ.xmlValue());
            if (obsoletedPid != null && pid != null) {
                log.debug((Object)("MetacatSolrIndex.submit - We will index the old version  " + obsoletedPid.getValue() + " of the object " + pid.getValue() + " as well. So we put " + obsoletedPid.getValue() + " into the index queue on hazelcast service."));
            }
            this.submit(obsoletedPid, obsoletedSysMeta, obsoletedFields, followRevisions);
        }
    }
}

