/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.scheduler;

import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.scheduler.ScheduledJobParamDAO;
import edu.ucsb.nceas.metacat.shared.AccessException;
import edu.ucsb.nceas.metacat.shared.BaseAccess;
import edu.ucsb.nceas.utilities.StatusUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ScheduledJobParamAccess
extends BaseAccess {
    private Logger logMetacat = Logger.getLogger(ScheduledJobParamAccess.class);

    protected void createJobParams(Long jobId, HashMap<String, String> jobParams) throws AccessException {
        for (String paramKey : jobParams.keySet()) {
            ScheduledJobParamDAO jobParamsDAO = new ScheduledJobParamDAO();
            jobParamsDAO.setStatus(StatusUtil.ACTIVE);
            jobParamsDAO.setJobId(jobId);
            jobParamsDAO.setKey(paramKey);
            jobParamsDAO.setValue(jobParams.get(paramKey));
            PreparedStatement pstmt = null;
            DBConnection conn = null;
            int serialNumber = -1;
            try {
                conn = DBConnectionPool.getDBConnection("ScheduledJobParamAccess.createJobParams");
                serialNumber = conn.getCheckOutSerialNumber();
                String sql = "INSERT INTO scheduled_job_params (date_created, date_updated, status, job_id, key, value) VALUES(now(), now(), ?, ?, ?, ?)";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, jobParamsDAO.getStatus());
                pstmt.setLong(2, jobParamsDAO.getJobId());
                pstmt.setString(3, jobParamsDAO.getKey());
                pstmt.setString(4, jobParamsDAO.getValue());
                this.logMetacat.info((Object)("SQL createJobParams - " + sql));
                this.logMetacat.info((Object)("SQL params:  [" + jobParamsDAO.getStatus() + "," + jobParamsDAO.getJobId() + "," + jobParamsDAO.getKey() + "," + jobParamsDAO.getValue().toString() + "]"));
                pstmt.execute();
            }
            catch (SQLException sqle) {
                try {
                    throw new AccessException("ScheduledJobParamsAccess.createJobParams - SQL error when creating scheduled job parameter : " + sqle.getMessage());
                }
                catch (Throwable throwable) {
                    this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
                    throw throwable;
                }
            }
            this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
        }
    }

    protected void deleteJobParams(Long jobId) throws AccessException {
        PreparedStatement pstmt = null;
        DBConnection conn = null;
        int serialNumber = -1;
        try {
            conn = DBConnectionPool.getDBConnection("ScheduledJobParamAccess.deleteJobParams");
            serialNumber = conn.getCheckOutSerialNumber();
            String sql = "UPDATE scheduled_job_params SET status = ? WHERE jobId = ?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, StatusUtil.DELETED);
            pstmt.setLong(1, jobId);
            this.logMetacat.info((Object)("ScheduledJobParamsAccess.deleteJobParams - SQL: " + sql));
            pstmt.execute();
        }
        catch (SQLException sqle) {
            try {
                throw new AccessException("ScheduledJobParamsAccess.deleteJobParams - SQL error when deleting scheduled job params for job" + jobId + " : " + sqle.getMessage());
            }
            catch (Throwable throwable) {
                this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
                throw throwable;
            }
        }
        this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
    }

    protected Vector<ScheduledJobParamDAO> getJobParamsForJobId(Long jobId) throws AccessException {
        Vector<ScheduledJobParamDAO> vector;
        Vector<ScheduledJobParamDAO> jobParamList = new Vector<ScheduledJobParamDAO>();
        PreparedStatement pstmt = null;
        DBConnection conn = null;
        int serialNumber = -1;
        ScheduledJobParamDAO jobParamDAO = null;
        try {
            conn = DBConnectionPool.getDBConnection("ScheduledJobParamAccess.getJobParamsForJobId");
            serialNumber = conn.getCheckOutSerialNumber();
            String sql = "SELECT * FROM scheduled_job_params WHERE job_id = ? AND status != 'deleted'";
            pstmt = conn.prepareStatement(sql);
            pstmt.setLong(1, jobId);
            this.logMetacat.info((Object)("SQL getJobParamsForJobId - " + sql));
            this.logMetacat.info((Object)("SQL params: [" + jobId + "]"));
            pstmt.execute();
            ResultSet resultSet = pstmt.getResultSet();
            while (resultSet.next()) {
                jobParamDAO = this.populateDAO(resultSet);
                jobParamList.add(jobParamDAO);
            }
            vector = jobParamList;
        }
        catch (SQLException sqle) {
            try {
                throw new AccessException("ScheduledJobAccess.getJobParamsForJobId - SQL error when getting scheduled job parameter for job id: " + jobId + " : " + sqle.getMessage());
            }
            catch (Throwable throwable) {
                this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
                throw throwable;
            }
        }
        this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
        return vector;
    }

    protected Vector<ScheduledJobParamDAO> getAllJobParams() throws AccessException {
        Vector<ScheduledJobParamDAO> vector;
        Vector<ScheduledJobParamDAO> jobParamList = new Vector<ScheduledJobParamDAO>();
        PreparedStatement pstmt = null;
        DBConnection conn = null;
        int serialNumber = -1;
        ScheduledJobParamDAO jobParamDAO = null;
        try {
            conn = DBConnectionPool.getDBConnection("ScheduledJobParamAccess.getAllJobParams");
            serialNumber = conn.getCheckOutSerialNumber();
            String sql = "SELECT * FROM scheduled_job_params WHERE status != 'deleted'";
            pstmt = conn.prepareStatement(sql);
            this.logMetacat.info((Object)("SQL getAllJobParams - " + sql));
            pstmt.execute();
            ResultSet resultSet = pstmt.getResultSet();
            while (resultSet.next()) {
                jobParamDAO = this.populateDAO(resultSet);
                jobParamList.add(jobParamDAO);
            }
            vector = jobParamList;
        }
        catch (SQLException sqle) {
            try {
                throw new AccessException("ScheduledJobParamAccess.getAllJobParams - SQL error when getting scheduled job parameters : " + sqle.getMessage());
            }
            catch (Throwable throwable) {
                this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
                throw throwable;
            }
        }
        this.closeDBObjects(pstmt, conn, serialNumber, this.logMetacat);
        return vector;
    }

    @Override
    protected ScheduledJobParamDAO populateDAO(ResultSet resultSet) throws SQLException {
        ScheduledJobParamDAO jobParamDAO = new ScheduledJobParamDAO();
        jobParamDAO.setId(resultSet.getLong("id"));
        jobParamDAO.setCreateTime(resultSet.getTimestamp("date_created"));
        jobParamDAO.setModTime(resultSet.getTimestamp("date_updated"));
        jobParamDAO.setStatus(resultSet.getString("status"));
        jobParamDAO.setJobId(resultSet.getLong("job_id"));
        jobParamDAO.setKey(resultSet.getString("key"));
        jobParamDAO.setValue(resultSet.getString("value"));
        return jobParamDAO;
    }
}

